/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupUtils;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NodeGroupService
extends StatefulService {
    public static final String STAT_NAME_JOIN_RETRY_COUNT = "joinRetryCount";
    public static final String PROPERTY_NAME_PEER_REQUEST_TIMEOUT_MICROS = "xenon.NodeGroupService.peerRequestTimeoutMicros";
    public static final long PEER_REQUEST_TIMEOUT_MICROS = Long.getLong("xenon.NodeGroupService.peerRequestTimeoutMicros", ServiceHost.ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS / 3L);
    public static final int MIN_PEER_GOSSIP_COUNT = 10;
    public static final String STAT_NAME_RESTARTING_SERVICES_COUNT = "restartingServicesCount";
    public static final String STAT_NAME_RESTARTING_SERVICES_FAILURE_COUNT = "restartingServicesFailureCount";

    public NodeGroupService() {
        super(NodeGroupState.class);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
    }

    @Override
    public void handleStart(Operation startPost) {
        NodeGroupState initState = null;
        initState = startPost.hasBody() ? startPost.getBody(NodeGroupState.class) : new NodeGroupState();
        initState.documentOwner = this.getHost().getId();
        if (initState.config == null) {
            initState.config = new NodeGroupConfig();
        }
        NodeState self = initState.nodes.get(this.getHost().getId());
        self = this.buildLocalNodeState(self);
        if (!this.validateNodeOptions(startPost, self.options)) {
            return;
        }
        initState.nodes.put(self.id, self);
        startPost.setBody(initState).complete();
    }

    @Override
    public void handleGet(Operation get) {
        NodeGroupState state = (NodeGroupState)this.getState(get);
        get.setBody(state).complete();
    }

    @Override
    public void handlePatch(Operation patch) {
        NodeGroupState body = this.getStateFromBody(patch);
        if (body == null) {
            patch.fail(new IllegalArgumentException("body of type NodeGroupState is required"));
            return;
        }
        NodeGroupState localState = (NodeGroupState)this.getState(patch);
        if (localState == null || localState.nodes == null) {
            this.logWarning("Invalid local state", new Object[0]);
            patch.fail(400);
            return;
        }
        if (body.config == null && body.nodes.isEmpty()) {
            UpdateQuorumRequest bd = patch.getBody(UpdateQuorumRequest.class);
            if (UpdateQuorumRequest.KIND.equals(bd.kind)) {
                this.handleUpdateQuorumPatch(patch, localState);
                return;
            }
            patch.fail(new IllegalArgumentException("nodes or config are required"));
            return;
        }
        if (body.config != null && body.nodes.isEmpty()) {
            localState.config = body.config;
            patch.complete();
            return;
        }
        EnumSet<NodeGroupChange> changes = EnumSet.noneOf(NodeGroupChange.class);
        this.mergeRemoteAndLocalMembership(localState, body, changes);
        patch.setNotificationDisabled(changes.isEmpty());
        localState.documentOwner = this.getHost().getId();
        NodeState localNodeState = localState.nodes.get(this.getHost().getId());
        localNodeState.groupReference = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink());
        patch.setBody(localState).complete();
        if (!this.isAvailable()) {
            boolean isAvailable = NodeGroupUtils.isNodeGroupAvailable(this.getHost(), localState);
            this.setAvailable(isAvailable);
        }
        if (localNodeState.status == NodeState.NodeStatus.AVAILABLE) {
            return;
        }
        localNodeState.status = NodeState.NodeStatus.AVAILABLE;
        this.sendAvailableSelfPatch(localNodeState);
    }

    private void handleUpdateQuorumPatch(Operation patch, NodeGroupState localState) {
        UpdateQuorumRequest bd = patch.getBody(UpdateQuorumRequest.class);
        NodeState self = localState.nodes.get(this.getHost().getId());
        if (bd.membershipQuorum != null) {
            self.membershipQuorum = Math.max(1, bd.membershipQuorum);
        }
        ++self.documentVersion;
        localState.membershipUpdateTimeMicros = self.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        localState.localMembershipUpdateTimeMicros = self.documentUpdateTimeMicros;
        if (!bd.isGroupUpdate) {
            patch.setBodyNoCloning(localState).complete();
            return;
        }
        bd.isGroupUpdate = false;
        int failureThreshold = (localState.nodes.size() - 1) / 2;
        AtomicInteger pending = new AtomicInteger(localState.nodes.size());
        AtomicInteger failures = new AtomicInteger();
        Operation.CompletionHandler c = (o, e) -> {
            int p;
            if (e != null) {
                this.logWarning("Node %s failed quorum update: %s", o.getUri(), e.toString());
                failures.incrementAndGet();
            }
            if ((p = pending.decrementAndGet()) != 0) {
                return;
            }
            if (failures.get() > failureThreshold) {
                patch.fail(new IllegalStateException("Majority of nodes failed request"));
            } else {
                patch.setBodyNoCloning(localState).complete();
            }
        };
        for (NodeState node : localState.nodes.values()) {
            if (!NodeState.isAvailable(node, this.getHost().getId(), true)) {
                c.handle(null, null);
                continue;
            }
            if (bd.membershipQuorum != null) {
                node.membershipQuorum = bd.membershipQuorum;
            }
            Operation p = Operation.createPatch(node.groupReference).setBody(bd).setCompletion(c);
            this.sendRequest(p);
        }
    }

    @Override
    public void handlePost(Operation post) {
        if (!post.hasBody()) {
            post.fail(new IllegalArgumentException("body is required"));
            return;
        }
        NodeGroupState localState = (NodeGroupState)this.getState(post);
        if (localState == null || localState.nodes == null) {
            this.logWarning("invalid local state", new Object[0]);
            post.fail(400);
            return;
        }
        JoinPeerRequest joinBody = post.getBody(JoinPeerRequest.class);
        if (joinBody != null && joinBody.memberGroupReference != null) {
            long joinTimeOutMicrosUtc = Utils.fromNowMicrosUtc(Math.max(TimeUnit.SECONDS.toMicros(1L), this.getHost().getOperationTimeoutMicros() / 10L));
            this.handleJoinPost(joinBody, post, joinTimeOutMicrosUtc, (NodeGroupState)this.getState(post), null);
            return;
        }
        NodeState body = post.getBody(NodeState.class);
        if (body.id == null) {
            post.fail(new IllegalArgumentException("id is required"));
            return;
        }
        boolean isLocalNode = body.id.equals(this.getHost().getId());
        if (body.groupReference == null) {
            post.fail(new IllegalArgumentException("groupReference is required"));
            return;
        }
        if (isLocalNode) {
            this.buildLocalNodeState(body);
        } else {
            body.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), body.id);
        }
        localState.nodes.put(body.id, body);
        post.setBody(localState).complete();
    }

    private void handleJoinPost(JoinPeerRequest joinBody, Operation joinOp, long expirationMicros, NodeGroupState localState, NodeGroupState remotePeerState) {
        if (UriUtils.isHostEqual(this.getHost(), joinBody.memberGroupReference)) {
            this.logInfo("Skipping self join", new Object[0]);
            joinOp.complete();
            return;
        }
        NodeState self = localState.nodes.get(this.getHost().getId());
        if (joinOp != null) {
            self.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
            ++self.documentVersion;
            if (joinBody.membershipQuorum != null) {
                if (joinBody.membershipQuorum.equals(self.membershipQuorum)) {
                    this.logInfo("Quorum changed from %d to %d", self.membershipQuorum, joinBody.membershipQuorum);
                }
                self.membershipQuorum = joinBody.membershipQuorum;
            }
            if (joinBody.localNodeOptions != null) {
                if (!this.validateNodeOptions(joinOp, joinBody.localNodeOptions)) {
                    return;
                }
                self.options = joinBody.localNodeOptions;
            }
            localState.membershipUpdateTimeMicros = self.documentUpdateTimeMicros;
            joinOp.complete();
        }
        if (remotePeerState == null) {
            this.sendRequest(Operation.createGet(joinBody.memberGroupReference).setCompletion((o, e) -> {
                if (e != null) {
                    this.handleJoinFailure(e, joinBody, localState, expirationMicros);
                    return;
                }
                NodeGroupState remoteState = this.getStateFromBody(o);
                this.handleJoinPost(joinBody, null, expirationMicros, localState, remoteState);
            }));
            return;
        }
        this.sendRequest(Operation.createPatch(this.getUri()).setBody(remotePeerState));
        this.logInfo("Sending POST to %s to insert self: %s", joinBody.memberGroupReference, Utils.toJson(self));
        Operation insertSelfToPeer = Operation.createPost(joinBody.memberGroupReference).setBody(self).setCompletion((o, e) -> {
            if (e != null) {
                this.logSevere("Insert POST to %s failed", o.getUri());
            }
        });
        this.sendRequest(insertSelfToPeer);
    }

    private void handleJoinFailure(Throwable e, JoinPeerRequest joinBody, NodeGroupState localState, long expirationMicros) {
        if (Utils.beforeNow(expirationMicros)) {
            this.logSevere("Failure joining peer %s due to %s, attempt expired, will not retry", joinBody.memberGroupReference, e.toString());
            return;
        }
        if (this.getHost().isStopping()) {
            return;
        }
        this.getHost().schedule(() -> {
            this.logWarning("Retrying GET to %s, due to %s", joinBody.memberGroupReference, e.toString());
            this.handleJoinPost(joinBody, null, expirationMicros, localState, null);
            this.adjustStat(STAT_NAME_JOIN_RETRY_COUNT, 1.0);
        }, this.getHost().getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
    }

    private boolean validateNodeOptions(Operation joinOp, EnumSet<NodeState.NodeOption> options) {
        if (options.isEmpty()) {
            joinOp.fail(new IllegalArgumentException("at least one option must be specified"));
            return false;
        }
        if (options.contains((Object)NodeState.NodeOption.OBSERVER) && options.contains((Object)NodeState.NodeOption.PEER)) {
            joinOp.fail(new IllegalArgumentException(String.format("%s and %s are mutually exclusive", new Object[]{NodeState.NodeOption.OBSERVER, NodeState.NodeOption.PEER})));
            return false;
        }
        return true;
    }

    private void sendAvailableSelfPatch(NodeState local) {
        NodeGroupState body = new NodeGroupState();
        body.config = null;
        body.documentOwner = this.getHost().getId();
        body.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), body.documentOwner);
        local.status = NodeState.NodeStatus.AVAILABLE;
        body.nodes.put(local.id, local);
        this.sendRequest(Operation.createPatch(this.getUri()).setBody(body));
    }

    private NodeState buildLocalNodeState(NodeState body) {
        if (body == null) {
            body = new NodeState();
        }
        body.id = this.getHost().getId();
        body.status = NodeState.NodeStatus.SYNCHRONIZING;
        Integer q = Integer.getInteger("xenon.NodeState.membershipQuorum");
        if (q != null) {
            body.membershipQuorum = q;
        } else {
            int total = this.getHost().getInitialPeerHosts().size() + 1;
            int quorum = total / 2 + 1;
            body.membershipQuorum = Math.max(1, quorum);
        }
        if (this.getHost().getLocation() != null) {
            this.logInfo("Setting node %s location to %s", body.id, this.getHost().getLocation());
            body.customProperties.put("xenon.NodeState.location", this.getHost().getLocation());
        }
        body.groupReference = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink());
        body.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), body.id);
        body.documentKind = Utils.buildKind(NodeState.class);
        body.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        return body;
    }

    @Override
    public void handleMaintenance(Operation op) {
        this.sendRequest(Operation.createGet(this.getUri()).setCompletion((o, e) -> this.performGroupMaintenance(op, o, e)));
    }

    private void performGroupMaintenance(Operation maint, Operation get, Throwable getEx) {
        if (getEx != null) {
            this.logWarning("Failure getting state: %s", getEx.toString());
            maint.complete();
            return;
        }
        if (!get.hasBody()) {
            maint.complete();
            return;
        }
        NodeGroupState localState = get.getBody(NodeGroupState.class);
        if (localState == null || localState.nodes == null) {
            maint.complete();
            return;
        }
        if (localState.nodes.size() <= 1) {
            if (!this.isAvailable()) {
                this.sendRequest(Operation.createPatch(this.getUri()).setBodyNoCloning(localState).setCompletion((o, e) -> maint.complete()));
            } else {
                maint.complete();
            }
            return;
        }
        if (this.getHost().isStopping()) {
            maint.complete();
            return;
        }
        int peersToProbe = (int)Math.log10(localState.nodes.size() - 1);
        peersToProbe = Math.max(peersToProbe, 10);
        peersToProbe = Math.min(localState.nodes.size() - 1, peersToProbe);
        AtomicInteger remaining = new AtomicInteger(peersToProbe);
        NodeState[] randomizedPeers = this.shuffleGroupMembers(localState);
        NodeState localNode = localState.nodes.get(this.getHost().getId());
        localNode.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        localNode.groupReference = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink());
        localState.documentOwner = this.getHost().getId();
        NodeGroupState patchBody = new NodeGroupState();
        patchBody.documentOwner = this.getHost().getId();
        patchBody.documentUpdateTimeMicros = localNode.documentUpdateTimeMicros;
        int probeCount = 0;
        for (NodeState peer : randomizedPeers) {
            if (peer == null || peer.id.equals(this.getHost().getId())) continue;
            NodeState remotePeer = peer;
            URI peerUri = peer.groupReference;
            Operation.CompletionHandler ch = (o, e) -> this.handleGossipPatchCompletion(maint, o, e, localState, patchBody, remaining, remotePeer);
            Operation patch = Operation.createPatch(peerUri).setBody(localState).setRetryCount(0).setConnectionTag("xn-cnx-tag-gossip").setExpiration(Utils.fromNowMicrosUtc(localState.config.peerRequestTimeoutMicros)).forceRemote().setCompletion(ch);
            if (peer.groupReference.equals(localNode.groupReference) && peer.status != NodeState.NodeStatus.REPLACED) {
                peer.status = NodeState.NodeStatus.REPLACED;
                peer.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
                ++peer.documentVersion;
                ch.handle(null, null);
            } else {
                this.sendRequest(patch);
            }
            if (++probeCount >= peersToProbe) break;
        }
        if (probeCount == 0) {
            maint.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleGossipPatchCompletion(Operation maint, Operation patch, Throwable e, NodeGroupState localState, NodeGroupState patchBody, AtomicInteger remaining, NodeState remotePeer) {
        try {
            if (patch == null) {
                return;
            }
            long updateTime = localState.membershipUpdateTimeMicros;
            if (e != null) {
                long l = updateTime = remotePeer.status != NodeState.NodeStatus.UNAVAILABLE ? Utils.getNowMicrosUtc() : updateTime;
                if (remotePeer.status != NodeState.NodeStatus.UNAVAILABLE) {
                    remotePeer.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
                    ++remotePeer.documentVersion;
                }
                remotePeer.status = NodeState.NodeStatus.UNAVAILABLE;
            } else {
                NodeGroupState peerState = this.getStateFromBody(patch);
                if (peerState.documentOwner.equals(remotePeer.id)) {
                    NodeState remotePeerStateFromRsp = peerState.nodes.get(remotePeer.id);
                    if (remotePeerStateFromRsp.documentVersion > remotePeer.documentVersion) {
                        remotePeer = remotePeerStateFromRsp;
                    }
                } else if (remotePeer.status != NodeState.NodeStatus.REPLACED) {
                    this.logWarning("Peer address %s has changed to id %s from %s", patch.getUri(), peerState.documentOwner, remotePeer.id);
                    remotePeer.status = NodeState.NodeStatus.REPLACED;
                    ++remotePeer.documentVersion;
                    updateTime = Utils.getNowMicrosUtc();
                }
                updateTime = Math.max(updateTime, peerState.membershipUpdateTimeMicros);
            }
            NodeGroupState nodeGroupState = patchBody;
            synchronized (nodeGroupState) {
                patchBody.nodes.put(remotePeer.id, remotePeer);
                patchBody.membershipUpdateTimeMicros = Math.max(updateTime, patchBody.membershipUpdateTimeMicros);
            }
        }
        finally {
            int r = remaining.decrementAndGet();
            if (r != 0) {
                return;
            }
            this.sendRequest(Operation.createPatch(this.getUri()).setBody(patchBody));
            maint.complete();
        }
    }

    private void mergeRemoteAndLocalMembership(NodeGroupState localState, NodeGroupState remotePeerState, EnumSet<NodeGroupChange> changes) {
        if (localState == null) {
            return;
        }
        boolean isSelfPatch = remotePeerState.documentOwner.equals(this.getHost().getId());
        long now = Utils.getNowMicrosUtc();
        NodeState selfEntry = localState.nodes.get(this.getHost().getId());
        for (NodeState nodeState : remotePeerState.nodes.values()) {
            boolean needsUpdate;
            NodeState currentEntry = localState.nodes.get(nodeState.id);
            boolean isLocalNode = nodeState.id.equals(this.getHost().getId());
            if (!isSelfPatch && isLocalNode) {
                if (nodeState.status == currentEntry.status) continue;
                this.logWarning("Peer %s is reporting us as %s, current status: %s", new Object[]{remotePeerState.documentOwner, nodeState.status, currentEntry.status});
                if (nodeState.documentVersion <= currentEntry.documentVersion) continue;
                currentEntry.documentVersion = nodeState.documentVersion;
                currentEntry.documentUpdateTimeMicros = now;
                changes.add(NodeGroupChange.SELF_CHANGE);
                continue;
            }
            if (currentEntry == null) {
                boolean hasExpired = nodeState.documentExpirationTimeMicros > 0L && nodeState.documentExpirationTimeMicros < now;
                if (hasExpired || NodeState.isUnAvailable(nodeState, null)) continue;
                if (!isLocalNode) {
                    this.logInfo("Adding new peer %s (%s), status %s", new Object[]{nodeState.id, nodeState.groupReference, nodeState.status});
                }
                localState.nodes.put(nodeState.id, nodeState);
                changes.add(NodeGroupChange.PEER_ADDED);
                continue;
            }
            boolean bl = needsUpdate = currentEntry.status != nodeState.status || currentEntry.membershipQuorum != nodeState.membershipQuorum;
            if (needsUpdate) {
                changes.add(NodeGroupChange.PEER_STATUS_CHANGE);
            }
            if (isSelfPatch && isLocalNode && needsUpdate) {
                currentEntry.documentVersion = Math.max(nodeState.documentVersion, currentEntry.documentVersion) + 1L;
                currentEntry.documentUpdateTimeMicros = Math.max(nodeState.documentUpdateTimeMicros, now);
                currentEntry.status = nodeState.status;
                currentEntry.options = nodeState.options;
                continue;
            }
            if (nodeState.documentVersion < currentEntry.documentVersion) {
                this.logInfo("v:%d - q:%d, v:%d - q:%d , %s - %s (local:%s %d)", currentEntry.documentVersion, currentEntry.membershipQuorum, nodeState.documentVersion, nodeState.membershipQuorum, currentEntry.id, remotePeerState.documentOwner, this.getHost().getId(), selfEntry.documentVersion);
                continue;
            }
            if (nodeState.documentVersion == currentEntry.documentVersion && needsUpdate && nodeState.documentUpdateTimeMicros < currentEntry.documentUpdateTimeMicros) {
                this.logWarning("Ignoring update for %s from peer %s. Local status: %s, remote status: %s", new Object[]{nodeState.id, remotePeerState.documentOwner, currentEntry.status, nodeState.status});
                continue;
            }
            if (nodeState.status == NodeState.NodeStatus.UNAVAILABLE && currentEntry.documentExpirationTimeMicros == 0L && nodeState.documentExpirationTimeMicros == 0L) {
                nodeState.documentExpirationTimeMicros = Utils.fromNowMicrosUtc(localState.config.nodeRemovalDelayMicros);
                this.logInfo("Set expiration at %d for unavailable node %s(%s)", nodeState.documentExpirationTimeMicros, nodeState.id, nodeState.groupReference);
                changes.add(NodeGroupChange.PEER_STATUS_CHANGE);
                needsUpdate = true;
            }
            if (nodeState.status == NodeState.NodeStatus.UNAVAILABLE && needsUpdate) {
                ++nodeState.documentVersion;
            }
            localState.nodes.put(nodeState.id, nodeState);
        }
        ArrayList<String> missingNodes = new ArrayList<String>();
        for (NodeState l : localState.nodes.values()) {
            NodeState r = remotePeerState.nodes.get(l.id);
            if (!NodeState.isUnAvailable(l, null) || l.id.equals(this.getHost().getId())) continue;
            long expirationMicros = l.documentExpirationTimeMicros;
            if (r != null) {
                expirationMicros = Math.max(l.documentExpirationTimeMicros, r.documentExpirationTimeMicros);
            }
            if (expirationMicros <= 0L || now <= expirationMicros) continue;
            changes.add(NodeGroupChange.PEER_STATUS_CHANGE);
            this.logInfo("Removing expired unavailable node %s(%s)", l.id, l.groupReference);
            missingNodes.add(l.id);
        }
        for (String id : missingNodes) {
            localState.nodes.remove(id);
        }
        boolean bl = !changes.isEmpty();
        localState.membershipUpdateTimeMicros = Math.max(remotePeerState.membershipUpdateTimeMicros, bl ? now : localState.membershipUpdateTimeMicros);
        if (bl) {
            this.logInfo("State updated, merge with %s, self %s, %d", remotePeerState.documentOwner, localState.documentOwner, localState.membershipUpdateTimeMicros);
            localState.localMembershipUpdateTimeMicros = now;
        }
    }

    public NodeState[] shuffleGroupMembers(NodeGroupState localState) {
        NodeState[] randomizedPeers = new NodeState[localState.nodes.size()];
        localState.nodes.values().toArray(randomizedPeers);
        Random random = new Random();
        for (int i = randomizedPeers.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            NodeState t = randomizedPeers[index];
            randomizedPeers[index] = randomizedPeers[i];
            randomizedPeers[i] = t;
        }
        return randomizedPeers;
    }

    private NodeGroupState getStateFromBody(Operation o) {
        if (!o.hasBody()) {
            return new NodeGroupState();
        }
        NodeGroupState rsp = o.getBody(NodeGroupState.class);
        if (rsp != null && rsp.nodes == null) {
            rsp.nodes = new HashMap<String, NodeState>();
        }
        return rsp;
    }

    public static class NodeGroupState
    extends ServiceDocument {
        public NodeGroupConfig config;
        public Map<String, NodeState> nodes = new ConcurrentSkipListMap<String, NodeState>();
        public long membershipUpdateTimeMicros;
        public long localMembershipUpdateTimeMicros;
    }

    public static class NodeGroupConfig {
        public static final long DEFAULT_NODE_REMOVAL_DELAY_MICROS = TimeUnit.MINUTES.toMicros(5L);
        public long nodeRemovalDelayMicros = DEFAULT_NODE_REMOVAL_DELAY_MICROS;
        public long stableGroupMaintenanceIntervalCount = 5L;
        public long peerRequestTimeoutMicros = PEER_REQUEST_TIMEOUT_MICROS;
    }

    public static class UpdateQuorumRequest {
        public static final String KIND = Utils.buildKind(UpdateQuorumRequest.class);
        public boolean isGroupUpdate;
        public Integer membershipQuorum;
        public String kind;

        public static UpdateQuorumRequest create(boolean isGroupUpdate) {
            UpdateQuorumRequest r = new UpdateQuorumRequest();
            r.isGroupUpdate = isGroupUpdate;
            r.kind = KIND;
            return r;
        }

        public UpdateQuorumRequest setMembershipQuorum(int count) {
            this.membershipQuorum = count;
            return this;
        }
    }

    public static class JoinPeerRequest {
        public static final String KIND = Utils.buildKind(JoinPeerRequest.class);
        public URI memberGroupReference;
        public EnumSet<NodeState.NodeOption> localNodeOptions;
        public Integer membershipQuorum;
        public String kind;

        public static JoinPeerRequest create(URI peerToJoin, Integer quorum) {
            JoinPeerRequest r = new JoinPeerRequest();
            r.memberGroupReference = peerToJoin;
            r.membershipQuorum = quorum;
            r.kind = KIND;
            return r;
        }
    }

    private static enum NodeGroupChange {
        PEER_ADDED,
        PEER_STATUS_CHANGE,
        SELF_CHANGE;

    }
}

