/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.vmware.xenon.common.ByteBufferInputStream;
import com.vmware.xenon.common.MurmurHash3;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStateCollectionUpdateRequest;
import com.vmware.xenon.common.StringBuilderThreadLocal;
import com.vmware.xenon.common.SystemHostInfo;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.logging.StackAwareLogRecord;
import com.vmware.xenon.common.serialization.JsonMapper;
import com.vmware.xenon.common.serialization.KryoSerializers;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public final class Utils {
    private static final String CHARSET_UTF_8 = "UTF-8";
    public static final String PROPERTY_NAME_PREFIX = "xenon.";
    public static final String CHARSET = "UTF-8";
    public static final String UI_DIRECTORY_NAME = "ui";
    public static final String PROPERTY_NAME_TIME_COMPARISON = "timeComparisonEpsilonMicros";
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    public static final int DEFAULT_IO_THREAD_COUNT = Math.min(2, Runtime.getRuntime().availableProcessors());
    public static final int DEFAULT_THREAD_COUNT = Math.max(4, Runtime.getRuntime().availableProcessors());
    public static final long DEFAULT_TIME_DRIFT_THRESHOLD_MICROS = TimeUnit.SECONDS.toMicros(1L);
    private static final long PING_LAUNCH_TOLERANCE_MS = 50L;
    private static final AtomicLong previousTimeValue = new AtomicLong();
    private static long timeComparisonEpsilon = Utils.initializeTimeEpsilon();
    private static long timeDriftThresholdMicros = DEFAULT_TIME_DRIFT_THRESHOLD_MICROS;
    private static final JsonMapper JSON = new JsonMapper();
    private static final ConcurrentMap<Class<?>, JsonMapper> CUSTOM_JSON = new ConcurrentSkipListMap<Class, JsonMapper>(Comparator.comparing(Object::hashCode));
    private static final ConcurrentMap<String, String> KINDS = new ConcurrentSkipListMap<String, String>();
    private static final StringBuilderThreadLocal builderPerThread = new StringBuilderThreadLocal();

    private Utils() {
    }

    private static JsonMapper getJsonMapperFor(Type type) {
        if (type instanceof Class) {
            return Utils.getJsonMapperFor((Class)type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return Utils.getJsonMapperFor(rawType);
        }
        return JSON;
    }

    private static JsonMapper getJsonMapperFor(Object instance) {
        if (instance == null) {
            return JSON;
        }
        return Utils.getJsonMapperFor(instance.getClass());
    }

    private static JsonMapper getJsonMapperFor(Class<?> type) {
        if (type.isArray() && type != byte[].class) {
            type = type.getComponentType();
        }
        return CUSTOM_JSON.getOrDefault(type, JSON);
    }

    public static void registerCustomJsonMapper(Class<?> clazz, JsonMapper mapper) {
        CUSTOM_JSON.putIfAbsent(clazz, mapper);
    }

    public static void registerCustomKryoSerializer(ThreadLocal<Kryo> kryoThreadLocal, boolean isDocumentSerializer) {
        KryoSerializers.register(kryoThreadLocal, isDocumentSerializer);
    }

    public static <T> T clone(T t) {
        return KryoSerializers.clone(t);
    }

    public static <T> T cloneObject(T t) {
        return KryoSerializers.cloneObject(t);
    }

    public static String computeSignature(ServiceDocument s, ServiceDocumentDescription description) {
        if (description == null) {
            throw new IllegalArgumentException("description is required");
        }
        byte[] buffer = Utils.getBuffer(description.serializedStateSizeLimit);
        int position = 0;
        for (ServiceDocumentDescription.PropertyDescription pd : description.propertyDescriptions.values()) {
            if (pd.indexingOptions != null && pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.EXCLUDE_FROM_SIGNATURE)) continue;
            Object fieldValue = ReflectionUtils.getPropertyValue(pd, s);
            if (pd.typeName == ServiceDocumentDescription.TypeName.COLLECTION || pd.typeName == ServiceDocumentDescription.TypeName.MAP || pd.typeName == ServiceDocumentDescription.TypeName.PODO) {
                String content = Utils.toJson(fieldValue);
                position = Utils.toBytes(content, buffer, position);
                continue;
            }
            if (fieldValue == null) continue;
            position = Utils.toBytes(fieldValue, buffer, position);
        }
        return Utils.computeHash(buffer, 0, position);
    }

    public static byte[] getBuffer(int capacity) {
        return KryoSerializers.getBuffer(capacity);
    }

    public static int toBytes(Object o, byte[] buffer, int position) {
        return KryoSerializers.serializeObject(o, buffer, position);
    }

    public static Object fromBytes(byte[] bytes) {
        return KryoSerializers.deserializeObject(bytes, 0, bytes.length);
    }

    public static Object fromBytes(byte[] bytes, int position, int length) {
        return KryoSerializers.deserializeObject(bytes, position, length);
    }

    public static void performMaintenance() {
    }

    public static String computeHash(String content) {
        byte[] source = content.getBytes(Charset.forName("UTF-8"));
        return Utils.computeHash(source, 0, source.length);
    }

    private static String computeHash(byte[] content, int offset, int length) {
        return Integer.toHexString(MurmurHash3.murmurhash3_x86_32(content, offset, length, 0));
    }

    public static String toJson(Object body) {
        if (body instanceof String) {
            return (String)body;
        }
        StringBuilder content = Utils.getBuilder();
        JsonMapper mapper = Utils.getJsonMapperFor(body);
        mapper.toJson(body, content);
        return content.toString();
    }

    public static String toJsonHtml(Object body) {
        if (body instanceof String) {
            return (String)body;
        }
        StringBuilder content = Utils.getBuilder();
        JsonMapper mapper = Utils.getJsonMapperFor(body);
        mapper.toJsonHtml(body, content);
        return content.toString();
    }

    public static String toJson(boolean hideSensitiveFields, boolean useHtmlFormatting, Object body) throws IllegalArgumentException {
        if (body instanceof String) {
            if (hideSensitiveFields) {
                throw new IllegalArgumentException("Body is already a string, sensitive fields cannot be discovered");
            }
            return (String)body;
        }
        StringBuilder content = Utils.getBuilder();
        JsonMapper mapper = Utils.getJsonMapperFor(body);
        mapper.toJson(hideSensitiveFields, useHtmlFormatting, body, content);
        return content.toString();
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return Utils.getJsonMapperFor(clazz).fromJson((Object)json, clazz);
    }

    public static <T> T fromJson(Object json, Class<T> clazz) {
        return Utils.getJsonMapperFor(clazz).fromJson(json, clazz);
    }

    public static <T> T fromJson(Object json, Type type) {
        return Utils.getJsonMapperFor(type).fromJson(json, type);
    }

    public static <T> T getJsonMapValue(Object json, String key, Class<T> valueClazz) {
        Map runtimeMap = (Map)Utils.fromJson(json, new TypeToken<Map<String, JsonElement>>(){}.getType());
        return Utils.fromJson(runtimeMap.get(key), valueClazz);
    }

    public static <T> T getJsonMapValue(Object json, String key, Type valueType) {
        Map runtimeMap = (Map)Utils.fromJson(json, new TypeToken<Map<String, JsonElement>>(){}.getType());
        return Utils.fromJson(runtimeMap.get(key), valueType);
    }

    public static String toString(Throwable t) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printer = new PrintWriter(writer);){
            t.printStackTrace(printer);
        }
        return writer.toString();
    }

    public static String toString(Map<?, Throwable> exceptions) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printer = new PrintWriter(writer);){
            for (Throwable t : exceptions.values()) {
                t.printStackTrace(printer);
            }
        }
        return writer.toString();
    }

    public static String getCurrentFileDirectory() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().warning(Utils.toString(e));
            return null;
        }
    }

    public static void log(Class<?> type, String classOrUri, Level level, String fmt, Object ... args) {
        Logger lg = Logger.getLogger(type.getName());
        Utils.log(lg, 3, classOrUri, level, () -> String.format(fmt, args));
    }

    public static void log(Class<?> type, String classOrUri, Level level, Supplier<String> messageSupplier) {
        Logger lg = Logger.getLogger(type.getName());
        Utils.log(lg, 3, classOrUri, level, messageSupplier);
    }

    public static void log(Logger lg, Integer nestingLevel, String classOrUri, Level level, String fmt, Object ... args) {
        Utils.log(lg, nestingLevel, classOrUri, level, () -> String.format(fmt, args));
    }

    public static void log(Logger lg, Integer nestingLevel, String classOrUri, Level level, Supplier<String> messageSupplier) {
        if (nestingLevel == null) {
            nestingLevel = 2;
        }
        if (!lg.isLoggable(level)) {
            return;
        }
        String message = messageSupplier.get();
        StackAwareLogRecord lr = new StackAwareLogRecord(level, message);
        Exception e = new Exception();
        StackTraceElement[] stacks = e.getStackTrace();
        if (stacks.length > nestingLevel) {
            StackTraceElement stack = stacks[nestingLevel];
            lr.setStackElement(stack);
            lr.setSourceMethodName(stack.getMethodName());
        }
        lr.setSourceClassName(classOrUri);
        lr.setLoggerName(lg.getName());
        lg.log(lr);
    }

    public static void logWarning(String fmt, Object ... args) {
        Logger.getAnonymousLogger().warning(String.format(fmt, args));
    }

    public static String toDocumentKind(Class<?> type) {
        String name = type.getCanonicalName();
        String kind = name.replace(".", ":");
        return kind;
    }

    public static String registerKind(Class<?> type, String kind) {
        return KINDS.put(type.getCanonicalName(), kind);
    }

    public static String buildKind(Class<?> type) {
        String kind = KINDS.computeIfAbsent(type.getCanonicalName(), name -> Utils.toDocumentKind(type));
        return kind;
    }

    public static ServiceErrorResponse toServiceErrorResponse(Throwable e) {
        return ServiceErrorResponse.create(e, 400);
    }

    public static String toServiceErrorResponseJson(Throwable e) {
        return Utils.toJson(Utils.toServiceErrorResponse(e));
    }

    public static ServiceErrorResponse toValidationErrorResponse(Throwable t) {
        ServiceErrorResponse rsp = new ServiceErrorResponse();
        rsp.message = t.getLocalizedMessage();
        return rsp;
    }

    public static boolean isValidationError(Throwable e) {
        return e instanceof IllegalArgumentException;
    }

    public static String toHexString(byte[] data) {
        char[] sb = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int v = data[i] & 0xFF;
            sb[2 * i] = HEX_CHARS[v >>> 4];
            sb[2 * i + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(sb);
    }

    public static String buildServicePath(Class<? extends Service> klass) {
        return klass.getName().replace('.', '/');
    }

    public static String buildUiResourceUriPrefixPath(Class<? extends Service> klass) {
        return UriUtils.buildUriPath("/user-interface/resources", Utils.buildServicePath(klass));
    }

    public static String buildUiResourceUriPrefixPath(Service service) {
        return Utils.buildUiResourceUriPrefixPath(service.getClass());
    }

    public static String buildCustomUiResourceUriPrefixPath(Service service) {
        return UriUtils.buildUriPath("/user-interface/resources", service.getDocumentTemplate().documentDescription.userInterfaceResourcePath);
    }

    public static Object setJsonProperty(Object body, String fieldName, String fieldValue) {
        JsonObject jo = body instanceof JsonObject ? (JsonObject)body : new JsonParser().parse((String)body).getAsJsonObject();
        jo.remove(fieldName);
        if (fieldValue != null) {
            jo.addProperty(fieldName, fieldValue);
        }
        return jo;
    }

    public static String validateServiceOption(EnumSet<Service.ServiceOption> options, Service.ServiceOption option) {
        Object error;
        EnumSet<Service.ServiceOption> reqs = null;
        EnumSet<Service.ServiceOption> antiReqs = null;
        switch (option) {
            case CONCURRENT_UPDATE_HANDLING: {
                antiReqs = EnumSet.of(Service.ServiceOption.OWNER_SELECTION, Service.ServiceOption.STRICT_UPDATE_CHECKING);
                break;
            }
            case OWNER_SELECTION: {
                reqs = EnumSet.of(Service.ServiceOption.REPLICATION);
                antiReqs = EnumSet.of(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING);
                break;
            }
            case STRICT_UPDATE_CHECKING: {
                antiReqs = EnumSet.of(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING);
                break;
            }
            case URI_NAMESPACE_OWNER: {
                antiReqs = EnumSet.of(Service.ServiceOption.PERSISTENCE, Service.ServiceOption.REPLICATION);
                break;
            }
            case PERIODIC_MAINTENANCE: {
                antiReqs = EnumSet.of(Service.ServiceOption.ON_DEMAND_LOAD, Service.ServiceOption.IMMUTABLE);
                break;
            }
            case PERSISTENCE: {
                break;
            }
            case REPLICATION: {
                break;
            }
            case DOCUMENT_OWNER: {
                break;
            }
            case IDEMPOTENT_POST: {
                break;
            }
            case FACTORY: {
                break;
            }
            case FACTORY_ITEM: {
                break;
            }
            case HTML_USER_INTERFACE: {
                break;
            }
            case INSTRUMENTATION: {
                antiReqs = EnumSet.of(Service.ServiceOption.IMMUTABLE);
                break;
            }
            case LIFO_QUEUE: {
                break;
            }
            case NONE: {
                break;
            }
            case UTILITY: {
                break;
            }
            case ON_DEMAND_LOAD: {
                if (!options.contains((Object)Service.ServiceOption.FACTORY)) {
                    reqs = EnumSet.of(Service.ServiceOption.PERSISTENCE);
                }
                antiReqs = EnumSet.of(Service.ServiceOption.PERIODIC_MAINTENANCE);
                break;
            }
            case IMMUTABLE: {
                reqs = EnumSet.of(Service.ServiceOption.ON_DEMAND_LOAD, Service.ServiceOption.PERSISTENCE);
                antiReqs = EnumSet.of(Service.ServiceOption.PERIODIC_MAINTENANCE, Service.ServiceOption.INSTRUMENTATION);
                break;
            }
            case TRANSACTION_PENDING: {
                break;
            }
            case STATELESS: {
                antiReqs = EnumSet.of(Service.ServiceOption.PERSISTENCE, Service.ServiceOption.REPLICATION, Service.ServiceOption.OWNER_SELECTION, Service.ServiceOption.STRICT_UPDATE_CHECKING);
                break;
            }
        }
        if (!options.contains((Object)option)) {
            return null;
        }
        if (reqs == null && antiReqs == null) {
            return null;
        }
        if (reqs != null) {
            EnumSet<Service.ServiceOption> missingReqs = EnumSet.noneOf(Service.ServiceOption.class);
            for (Service.ServiceOption r : reqs) {
                if (options.contains((Object)r)) continue;
                missingReqs.add(r);
            }
            if (!missingReqs.isEmpty()) {
                error = String.format("%s missing required options: %s", new Object[]{option, missingReqs});
                return error;
            }
        }
        EnumSet<Service.ServiceOption> conflictReqs = EnumSet.noneOf(Service.ServiceOption.class);
        for (Service.ServiceOption r : antiReqs) {
            if (!options.contains((Object)r)) continue;
            conflictReqs.add(r);
        }
        if (!conflictReqs.isEmpty()) {
            error = String.format("%s conflicts with options: %s", new Object[]{option, conflictReqs});
            return error;
        }
        return null;
    }

    static boolean validateServiceOptions(ServiceHost host, Service service, Operation post) {
        for (Service.ServiceOption o : service.getOptions()) {
            String error = Utils.validateServiceOption(service.getOptions(), o);
            if (error == null) continue;
            host.log(Level.WARNING, error, new Object[0]);
            post.fail(new IllegalArgumentException(error));
            return false;
        }
        if (service.getMaintenanceIntervalMicros() > 0L && service.getMaintenanceIntervalMicros() < host.getMaintenanceIntervalMicros()) {
            host.log(Level.WARNING, "Service maint. interval %d is less than host interval %d, reducing host interval", service.getMaintenanceIntervalMicros(), host.getMaintenanceIntervalMicros());
            host.setMaintenanceIntervalMicros(service.getMaintenanceIntervalMicros());
        }
        return true;
    }

    public static String getOsName(SystemHostInfo systemInfo) {
        return systemInfo.properties.get("os.name");
    }

    public static SystemHostInfo.OsFamily determineOsFamily(String osName) {
        String string = osName = osName == null ? "" : osName.toLowerCase(Locale.ENGLISH);
        if (osName.contains("mac")) {
            return SystemHostInfo.OsFamily.MACOS;
        }
        if (osName.contains("win")) {
            return SystemHostInfo.OsFamily.WINDOWS;
        }
        if (osName.contains("nux")) {
            return SystemHostInfo.OsFamily.LINUX;
        }
        return SystemHostInfo.OsFamily.OTHER;
    }

    public static boolean isReachable(SystemHostInfo systemInfo, InetAddress addr, long timeoutMs) throws IOException {
        if (systemInfo.osFamily == SystemHostInfo.OsFamily.WINDOWS) {
            return Utils.isReachableByPing(systemInfo, addr, timeoutMs);
        }
        return addr.isReachable((int)timeoutMs);
    }

    public static boolean isReachableByPing(SystemHostInfo systemInfo, InetAddress addr, long timeoutMs) throws IOException {
        try {
            Process process = new ProcessBuilder("ping", "-n", "1", "-w", Long.toString(timeoutMs), Utils.getNormalizedHostAddress(systemInfo, addr)).start();
            boolean completed = process.waitFor(50L + timeoutMs, TimeUnit.MILLISECONDS);
            return completed && process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static String getNormalizedHostAddress(SystemHostInfo systemInfo, InetAddress addr) {
        String addrStr = addr.getHostAddress();
        if (systemInfo.osFamily == SystemHostInfo.OsFamily.WINDOWS && addr instanceof Inet6Address && addr.isLinkLocalAddress()) {
            Inet6Address ip6Addr = (Inet6Address)addr;
            int pct = addrStr.lastIndexOf(37);
            if (pct > -1) {
                addrStr = addrStr.substring(0, pct) + '%' + ip6Addr.getScopeId();
            }
        }
        return addrStr;
    }

    public static void encodeAndTransferLinkedStateToBody(Operation source, Operation target, boolean useBinary) {
        if (useBinary && source.getAction() != Service.Action.POST) {
            try {
                byte[] encodedBody = Utils.encodeBody(source, source.getLinkedState(), "application/kryo-octet-stream");
                source.linkSerializedState(encodedBody);
            }
            catch (Throwable e2) {
                Utils.logWarning("Failure binary serializing, will fallback to JSON: %s", Utils.toString(e2));
            }
        }
        if (!source.hasLinkedSerializedState()) {
            target.setContentType("application/json");
            target.setBodyNoCloning(Utils.toJson(source.getLinkedState()));
        } else {
            target.setContentType("application/kryo-octet-stream");
            target.setBodyNoCloning(source.getLinkedSerializedState());
        }
    }

    public static byte[] encodeBody(Operation op) throws Throwable {
        return Utils.encodeBody(op, op.getBodyRaw(), op.getContentType());
    }

    public static byte[] encodeBody(Operation op, Object body, String contentType) throws Throwable {
        byte[] data = null;
        if (body == null) {
            op.setContentLength(0L);
            return null;
        }
        if (body instanceof String) {
            data = ((String)body).getBytes("UTF-8");
            op.setContentLength(data.length);
        } else if (body instanceof byte[]) {
            data = (byte[])body;
            if (contentType == null) {
                op.setContentType("application/octet-stream");
            }
            if (op.getContentLength() == 0L || op.getContentLength() > (long)data.length) {
                op.setContentLength(data.length);
            }
        } else if ("application/kryo-octet-stream".equals(contentType)) {
            Output o = KryoSerializers.serializeAsDocument(body, ServiceClient.MAX_BINARY_SERIALIZED_BODY_LIMIT);
            data = o.toBytes();
            op.setContentLength(data.length);
        }
        if (data == null) {
            String encodedBody;
            if (op.getAction() == Service.Action.GET) {
                encodedBody = Utils.toJsonHtml(body);
            } else {
                encodedBody = Utils.toJson(body);
                if (contentType == null) {
                    op.setContentType("application/json");
                }
            }
            data = encodedBody.getBytes("UTF-8");
            op.setContentLength(data.length);
        }
        return data;
    }

    public static void decodeBody(Operation op, ByteBuffer buffer) {
        boolean isRequest = false;
        String contentEncodingHeader = op.getResponseHeader("content-encoding");
        if (contentEncodingHeader == null) {
            contentEncodingHeader = op.getRequestHeader("content-encoding");
            isRequest = true;
        }
        boolean compressed = false;
        if (contentEncodingHeader != null) {
            compressed = "gzip".equals(contentEncodingHeader);
        }
        Utils.decodeBody(op, buffer, isRequest, compressed);
    }

    public static void decodeBody(Operation op, ByteBuffer buffer, boolean isRequest, boolean compressed) {
        if (op.getContentLength() == 0L) {
            op.setContentType("application/json").complete();
            return;
        }
        try {
            String contentType;
            Object body;
            if (compressed) {
                buffer = Utils.decompressGZip(buffer);
                if (isRequest) {
                    op.getRequestHeaders().remove("content-encoding");
                } else {
                    op.getResponseHeaders().remove("content-encoding");
                }
            }
            if ((body = Utils.decodeIfText(buffer, contentType = op.getContentType())) != null) {
                op.setBodyNoCloning(body).complete();
                return;
            }
            byte[] data = new byte[(int)op.getContentLength()];
            buffer.get(data);
            if ("application/kryo-octet-stream".equals(contentType)) {
                body = KryoSerializers.deserializeDocument(data, 0, data.length);
                if (op.isFromReplication()) {
                    op.linkSerializedState(data);
                }
            } else {
                body = data;
            }
            op.setBodyNoCloning(body).complete();
        }
        catch (Throwable e) {
            op.fail(e);
        }
    }

    public static String decodeIfText(ByteBuffer buffer, String contentType) throws CharacterCodingException {
        String body = null;
        if (contentType == null) {
            return null;
        }
        if (Utils.isContentTypeText(contentType)) {
            body = Charset.forName("UTF-8").newDecoder().decode(buffer).toString();
        } else if (contentType.contains("application/x-www-form-urlencoded")) {
            body = Charset.forName("UTF-8").newDecoder().decode(buffer).toString();
            try {
                body = URLDecoder.decode(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer decompressGZip(ByteBuffer bb) throws Exception {
        GZIPInputStream zis = new GZIPInputStream(new ByteBufferInputStream(bb));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = Utils.getBuffer(1024);
            while ((len = zis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            zis.close();
            out.close();
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    private static boolean isContentTypeText(String contentType) {
        return "application/json".equals(contentType) || contentType.contains("application/json") || contentType.contains("text") || contentType.contains("css") || contentType.contains("script") || contentType.contains("html") || contentType.contains("xml") || contentType.contains("yaml") || contentType.contains("yml");
    }

    public static Path getServiceUiResourcePath(Service s) {
        ServiceDocument sd = s.getDocumentTemplate();
        ServiceDocumentDescription sdd = sd.documentDescription;
        if (sdd != null && sdd.userInterfaceResourcePath != null) {
            String resourcePath = sdd.userInterfaceResourcePath;
            if (!resourcePath.isEmpty()) {
                return Paths.get(resourcePath, new String[0]);
            }
        } else {
            String servicePath = Utils.buildServicePath(s.getClass());
            return Paths.get(UI_DIRECTORY_NAME, servicePath);
        }
        Utils.log(Utils.class, Utils.class.getSimpleName(), Level.SEVERE, "UserInterface resource path field empty for service document %s", s.getClass().getSimpleName());
        return null;
    }

    public static <K, V> V atomicGetOrCreate(ConcurrentMap<K, V> map, K key, Callable<V> ctor) {
        Object value = map.get(key);
        if (value == null) {
            try {
                value = ctor.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Element constructor should now throw an exception", e);
            }
            V existing = map.putIfAbsent(key, value);
            if (existing != null) {
                return existing;
            }
        }
        return value;
    }

    public static <T extends ServiceDocument> boolean mergeWithState(ServiceDocumentDescription desc, T source, T patch) {
        Class<?> clazz = source.getClass();
        if (!patch.getClass().equals(clazz)) {
            throw new IllegalArgumentException("Source object and patch object types mismatch");
        }
        boolean modified = false;
        for (ServiceDocumentDescription.PropertyDescription prop : desc.propertyDescriptions.values()) {
            Object o;
            if (prop.usageOptions == null || !prop.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL) || (o = ReflectionUtils.getPropertyValue(prop, patch)) == null) continue;
            if (prop.typeName == ServiceDocumentDescription.TypeName.COLLECTION && !o.getClass().isArray() || prop.typeName == ServiceDocumentDescription.TypeName.MAP) {
                modified |= ReflectionUtils.setOrUpdatePropertyValue(prop, source, o);
                continue;
            }
            if (o.equals(ReflectionUtils.getPropertyValue(prop, source))) continue;
            ReflectionUtils.setPropertyValue(prop, source, o);
            modified = true;
        }
        return modified;
    }

    public static <T extends ServiceDocument> boolean mergeWithState(T currentState, Operation op) throws NoSuchFieldException, IllegalAccessException {
        ServiceStateCollectionUpdateRequest requestBody = op.getBody(ServiceStateCollectionUpdateRequest.class);
        if (ServiceStateCollectionUpdateRequest.KIND.equals(requestBody.kind)) {
            Utils.updateCollections(currentState, requestBody);
            return true;
        }
        return false;
    }

    public static <T extends ServiceDocument> EnumSet<MergeResult> mergeWithStateAdvanced(ServiceDocumentDescription desc, T currentState, Class<T> type, Operation op) throws NoSuchFieldException, IllegalAccessException {
        EnumSet<MergeResult> result = EnumSet.noneOf(MergeResult.class);
        ServiceStateCollectionUpdateRequest requestBody = op.getBody(ServiceStateCollectionUpdateRequest.class);
        if (ServiceStateCollectionUpdateRequest.KIND.equals(requestBody.kind)) {
            result.add(MergeResult.SPECIAL_MERGE);
            if (Utils.updateCollections(currentState, requestBody)) {
                result.add(MergeResult.STATE_CHANGED);
            }
        } else {
            ServiceDocument patchState = (ServiceDocument)op.getBody(type);
            if (Utils.mergeWithState(desc, currentState, patchState)) {
                result.add(MergeResult.STATE_CHANGED);
            }
        }
        return result;
    }

    public static <T extends ServiceDocument> void validateState(ServiceDocumentDescription desc, T state) {
        for (ServiceDocumentDescription.PropertyDescription prop : desc.propertyDescriptions.values()) {
            Object o;
            if (prop.usageOptions == null || !prop.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.REQUIRED) || (o = ReflectionUtils.getPropertyValue(prop, state)) != null) continue;
            if (prop.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.ID)) {
                ReflectionUtils.setPropertyValue(prop, state, UUID.randomUUID().toString());
                continue;
            }
            throw new IllegalArgumentException(prop.accessor.getName() + " is required.");
        }
    }

    private static long initializeTimeEpsilon() {
        Long l = Long.getLong("xenon.timeComparisonEpsilonMicros", ServiceHost.ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS);
        return l;
    }

    public static long fromNowMicrosUtc(long deltaMicros) {
        return Utils.getSystemNowMicrosUtc() + deltaMicros;
    }

    public static boolean beforeNow(long microsUtc) {
        return Utils.getSystemNowMicrosUtc() >= microsUtc;
    }

    public static long getSystemNowMicrosUtc() {
        return System.currentTimeMillis() * 1000L;
    }

    public static long getNowMicrosUtc() {
        long time;
        long now = System.currentTimeMillis() * 1000L;
        if (now > (time = previousTimeValue.getAndIncrement())) {
            previousTimeValue.compareAndSet(time + 1L, now);
            return previousTimeValue.getAndIncrement();
        }
        if (time - now > timeDriftThresholdMicros) {
            throw new IllegalStateException("Time drift is " + (time - now));
        }
        return time;
    }

    public static void setTimeDriftThreshold(long micros) {
        timeDriftThresholdMicros = micros;
        previousTimeValue.set(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()));
    }

    public static void resetTimeComparisonEpsilonMicros() {
        timeComparisonEpsilon = Utils.initializeTimeEpsilon();
    }

    public static void setTimeComparisonEpsilonMicros(long micros) {
        timeComparisonEpsilon = micros;
    }

    public static long getTimeComparisonEpsilonMicros() {
        return timeComparisonEpsilon;
    }

    public static boolean isWithinTimeComparisonEpsilon(long timeMicros) {
        long now = Utils.getSystemNowMicrosUtc();
        return Math.abs(timeMicros - now) < timeComparisonEpsilon;
    }

    private static StringBuilder getBuilder() {
        return builderPerThread.get();
    }

    public static <T extends ServiceDocument> boolean updateCollections(T currentState, ServiceStateCollectionUpdateRequest patchBody) throws NoSuchFieldException, IllegalAccessException {
        boolean hasChanged = false;
        if (patchBody.itemsToRemove != null) {
            for (Map.Entry<String, Collection<Object>> collectionItem : patchBody.itemsToRemove.entrySet()) {
                hasChanged |= Utils.processCollection(collectionItem.getValue(), collectionItem.getKey(), currentState, CollectionOperation.REMOVE);
            }
        }
        if (patchBody.itemsToAdd != null) {
            for (Map.Entry<String, Collection<Object>> collectionItem : patchBody.itemsToAdd.entrySet()) {
                hasChanged |= Utils.processCollection(collectionItem.getValue(), collectionItem.getKey(), currentState, CollectionOperation.ADD);
            }
        }
        return hasChanged;
    }

    private static <T extends ServiceDocument> boolean processCollection(Collection<Object> inputCollection, String collectionName, T currentState, CollectionOperation operation) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz;
        Field field;
        boolean hasChanged = false;
        if (inputCollection != null && !inputCollection.isEmpty() && (field = (clazz = currentState.getClass()).getField(collectionName)) != null && Collection.class.isAssignableFrom(field.getType())) {
            Collection collObj = (Collection)field.get(currentState);
            switch (operation) {
                case ADD: {
                    if (collObj == null) {
                        field.set(currentState, inputCollection);
                        hasChanged = true;
                        break;
                    }
                    hasChanged = collObj.addAll(inputCollection);
                    break;
                }
                case REMOVE: {
                    if (collObj == null) break;
                    hasChanged = collObj.removeAll(inputCollection);
                    break;
                }
            }
        }
        return hasChanged;
    }

    public static String buildUUID(String id) {
        return Utils.getBuilder().append(id).append(Long.toHexString(Utils.getNowMicrosUtc())).toString();
    }

    private static enum CollectionOperation {
        ADD,
        REMOVE;

    }

    public static enum MergeResult {
        SPECIAL_MERGE,
        STATE_CHANGED;

    }
}

