/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.ColorLogFormatter;
import com.vmware.xenon.common.CommandLineArgumentParser;
import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.LogFormatter;
import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.NodeSelectorState;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.OperationTracker;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceConfigUpdateRequest;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.ServiceMaintenanceTracker;
import com.vmware.xenon.common.ServiceRequestListener;
import com.vmware.xenon.common.ServiceRequestSender;
import com.vmware.xenon.common.ServiceResourceTracker;
import com.vmware.xenon.common.ServiceSubscriptionState;
import com.vmware.xenon.common.ServiceSynchronizationTracker;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.SynchronizationTaskService;
import com.vmware.xenon.common.SystemHostInfo;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.WebSocketService;
import com.vmware.xenon.common.http.netty.NettyHttpListener;
import com.vmware.xenon.common.http.netty.NettyHttpServiceClient;
import com.vmware.xenon.common.jwt.JWTUtils;
import com.vmware.xenon.common.jwt.Signer;
import com.vmware.xenon.common.jwt.Verifier;
import com.vmware.xenon.services.common.AuthCredentialsService;
import com.vmware.xenon.services.common.AuthorizationContextService;
import com.vmware.xenon.services.common.ConsistentHashingNodeSelectorService;
import com.vmware.xenon.services.common.FileContentService;
import com.vmware.xenon.services.common.GraphQueryTaskService;
import com.vmware.xenon.services.common.GuestUserService;
import com.vmware.xenon.services.common.LocalQueryTaskFactoryService;
import com.vmware.xenon.services.common.LuceneBlobIndexService;
import com.vmware.xenon.services.common.LuceneDocumentIndexService;
import com.vmware.xenon.services.common.NodeGroupFactoryService;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeGroupUtils;
import com.vmware.xenon.services.common.ODataQueryService;
import com.vmware.xenon.services.common.OperationIndexService;
import com.vmware.xenon.services.common.ProcessFactoryService;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.QueryTaskFactoryService;
import com.vmware.xenon.services.common.ReliableSubscriptionService;
import com.vmware.xenon.services.common.ResourceGroupService;
import com.vmware.xenon.services.common.RoleService;
import com.vmware.xenon.services.common.ServiceContextIndexService;
import com.vmware.xenon.services.common.ServiceHostLogService;
import com.vmware.xenon.services.common.ServiceHostManagementService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.SystemUserService;
import com.vmware.xenon.services.common.TaskFactoryService;
import com.vmware.xenon.services.common.TenantService;
import com.vmware.xenon.services.common.TransactionFactoryService;
import com.vmware.xenon.services.common.UpdateIndexRequest;
import com.vmware.xenon.services.common.UserGroupService;
import com.vmware.xenon.services.common.UserService;
import com.vmware.xenon.services.common.authn.BasicAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class ServiceHost
implements ServiceRequestSender {
    public static final String UI_DIRECTORY_NAME = "ui";
    protected static final LogFormatter LOG_FORMATTER = new LogFormatter();
    protected static final LogFormatter COLOR_LOG_FORMATTER = new ColorLogFormatter();
    public static final String SERVICE_HOST_STATE_FILE = "serviceHostState.json";
    public static final Double DEFAULT_PCT_MEMORY_LIMIT = 0.49;
    public static final Double DEFAULT_PCT_MEMORY_LIMIT_DOCUMENT_INDEX = 0.3;
    public static final Double DEFAULT_PCT_MEMORY_LIMIT_BLOB_INDEX = 0.1;
    public static final Double DEFAULT_PCT_MEMORY_LIMIT_SERVICE_CONTEXT_INDEX = 0.1;
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final String LOOPBACK_ADDRESS = "127.0.0.1";
    public static final String DEFAULT_BIND_ADDRESS = "127.0.0.1";
    public static final int PORT_VALUE_HTTP_DEFAULT = 8000;
    public static final int PORT_VALUE_LISTENER_DISABLED = -1;
    public static final int DEFAULT_PORT = 8000;
    public static final String ALL_INTERFACES = "0.0.0.0";
    public static final String ROOT_PATH = "";
    public static final String SERVICE_URI_SUFFIX_STATS = "/stats";
    public static final String SERVICE_URI_SUFFIX_SUBSCRIPTIONS = "/subscriptions";
    public static final String SERVICE_URI_SUFFIX_AVAILABLE = "/available";
    public static final String SERVICE_URI_SUFFIX_CONFIG = "/config";
    public static final String SERVICE_URI_SUFFIX_TEMPLATE = "/template";
    public static final String SERVICE_URI_SUFFIX_UI = "/ui";
    public static final String SERVICE_URI_SUFFIX_REPLICATION = "/replication";
    public static final String DCP_ENVIRONMENT_VAR_PREFIX = "XENON_";
    public static final String GIT_COMMIT_PROPERTIES_RESOURCE_NAME = "xenon.git.properties";
    public static final String GIT_COMMIT_SOURCE_PROPERTY_PREFIX = "git.commit";
    public static final String GIT_COMMIT_SOURCE_PROPERTY_COMMIT_ID = "git.commit.id";
    public static final String GIT_COMMIT_SOURCE_PROPERTY_COMMIT_TIME = "git.commit.time";
    public static final String[] RESERVED_SERVICE_URI_PATHS = new String[]{"/available", "/replication", "/stats", "/subscriptions", "/ui", "/config", "/template"};
    static final Path DEFAULT_TMPDIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    static final Path DEFAULT_SANDBOX = DEFAULT_TMPDIR.resolve("xenon");
    static final Path DEFAULT_RESOURCE_SANDBOX_DIR = Paths.get("resources", new String[0]);
    public static final int DEFAULT_SERVICE_STATE_COST_BYTES = 4096;
    public static final int DEFAULT_SERVICE_INSTANCE_COST_BYTES = 4096;
    private static final long ONE_MINUTE_IN_MICROS = TimeUnit.MINUTES.toMicros(1L);
    private static final String PROPERTY_NAME_APPEND_PORT_TO_SANDBOX = "xenon.ServiceHost.APPEND_PORT_TO_SANDBOX";
    public static final boolean APPEND_PORT_TO_SANDBOX = System.getProperty("xenon.ServiceHost.APPEND_PORT_TO_SANDBOX") == null || Boolean.getBoolean("xenon.ServiceHost.APPEND_PORT_TO_SANDBOX");
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private FileHandler handler;
    private Map<String, Operation.AuthorizationContext> authorizationContextCache = new ConcurrentHashMap<String, Operation.AuthorizationContext>();
    private Map<String, Set<String>> userLinktoTokenMap = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, ServiceDocumentDescription> descriptionCache = new HashMap<String, ServiceDocumentDescription>();
    private final ServiceDocumentDescription.Builder descriptionBuilder = ServiceDocumentDescription.Builder.create();
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private final ConcurrentSkipListMap<String, Service> attachedServices = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, Service> attachedNamespaceServices = new ConcurrentSkipListMap();
    private final ConcurrentSkipListSet<String> coreServices = new ConcurrentSkipListSet();
    private ConcurrentSkipListMap<String, Class<? extends Service>> privilegedServiceTypes = new ConcurrentSkipListMap();
    private final Set<String> pendingServiceDeletions = Collections.synchronizedSet(new HashSet());
    private final Map<String, Service> pendingPauseServices = new ConcurrentSkipListMap<String, Service>();
    private ServiceHostState state;
    private Service documentIndexService;
    private Service authorizationService;
    private Service transactionService;
    private Service managementService;
    private SystemHostInfo info = new SystemHostInfo();
    private ServiceClient client;
    private ServiceRequestListener httpListener;
    private ServiceRequestListener httpsListener;
    private URI documentIndexServiceUri;
    private URI authorizationServiceUri;
    private URI transactionServiceUri;
    private URI managementServiceUri;
    private ScheduledFuture<?> maintenanceTask;
    private final ServiceSynchronizationTracker serviceSynchTracker = ServiceSynchronizationTracker.create(this);
    private final ServiceMaintenanceTracker serviceMaintTracker = ServiceMaintenanceTracker.create(this);
    private final ServiceResourceTracker serviceResourceTracker = ServiceResourceTracker.create(this, this.attachedServices, this.pendingPauseServices);
    private final OperationTracker operationTracker = OperationTracker.create(this);
    private String hashedId;
    private String logPrefix;
    private URI cachedUri;
    private Signer tokenSigner;
    private Verifier tokenVerifier;
    private Operation.AuthorizationContext systemAuthorizationContext;
    private Operation.AuthorizationContext guestAuthorizationContext;

    protected ServiceHost() {
        this.state = new ServiceHostState();
        this.state.id = UUID.randomUUID().toString();
    }

    public ServiceHost initialize(String[] args) throws Throwable {
        Arguments hostArgs = new Arguments();
        this.initialize(args, hostArgs);
        return this;
    }

    protected ServiceHost initialize(String[] args, Arguments hostArgs) throws Throwable {
        CommandLineArgumentParser.parse(hostArgs, args);
        CommandLineArgumentParser.parse(COLOR_LOG_FORMATTER, args);
        this.initialize(hostArgs);
        this.setProcessOwner(true);
        return this;
    }

    public ServiceHost initialize(Arguments args) throws Throwable {
        URI u;
        this.setSystemProperties();
        if (args.port == -1 && args.securePort == -1) {
            throw new IllegalArgumentException("both http and https are disabled");
        }
        if (args.port != -1 && args.port < 0) {
            throw new IllegalArgumentException("port: negative values not allowed");
        }
        if (args.securePort != -1 && args.securePort < 0) {
            throw new IllegalArgumentException("securePort: negative values not allowed");
        }
        Path sandbox = args.sandbox;
        if (APPEND_PORT_TO_SANDBOX) {
            int sandboxPort = args.port == -1 ? args.securePort : args.port;
            sandbox = sandbox.resolve(Integer.toString(sandboxPort));
        }
        URI storageSandbox = sandbox.toFile().toURI();
        if (!Files.exists(sandbox, new LinkOption[0])) {
            Files.createDirectories(sandbox, new FileAttribute[0]);
        }
        if (args.publicUri != null && (!(u = new URI(args.publicUri)).isAbsolute() || u.getHost() == null || u.getHost().isEmpty())) {
            throw new IllegalArgumentException("publicUri should be a non empty absolute URI");
        }
        if (args.bindAddress != null && args.bindAddress.equals(ROOT_PATH)) {
            throw new IllegalArgumentException("bindAddress should be a non empty valid IP address");
        }
        if (this.state == null) {
            throw new IllegalStateException();
        }
        File s = new File(storageSandbox);
        if (!s.exists()) {
            throw new IllegalArgumentException("storageSandbox directory does not exist: " + storageSandbox);
        }
        this.state.storageSandboxFileReference = storageSandbox;
        this.loadState(storageSandbox, s);
        this.initializeStateFromArguments(s, args);
        LuceneDocumentIndexService documentIndexService = new LuceneDocumentIndexService();
        this.setDocumentIndexingService(documentIndexService);
        ServiceHostManagementService managementService = new ServiceHostManagementService();
        this.setManagementService(managementService);
        this.state.codeProperties = FileUtils.readPropertiesFromResource(this.getClass(), GIT_COMMIT_PROPERTIES_RESOURCE_NAME);
        this.updateSystemInfo(false);
        if (this.getServiceMemoryLimitMB(ROOT_PATH, ServiceHostState.MemoryLimitType.EXACT) == null) {
            this.setServiceMemoryLimit(ROOT_PATH, DEFAULT_PCT_MEMORY_LIMIT);
        }
        if (this.getServiceMemoryLimitMB("/core/document-index", ServiceHostState.MemoryLimitType.EXACT) == null) {
            this.setServiceMemoryLimit("/core/document-index", DEFAULT_PCT_MEMORY_LIMIT_DOCUMENT_INDEX);
        }
        if (this.getServiceMemoryLimitMB(ServiceUriPaths.CORE_BLOB_INDEX, ServiceHostState.MemoryLimitType.EXACT) == null) {
            this.setServiceMemoryLimit(ServiceUriPaths.CORE_BLOB_INDEX, DEFAULT_PCT_MEMORY_LIMIT_BLOB_INDEX);
        }
        if (this.getServiceMemoryLimitMB("/core/service-context-index", ServiceHostState.MemoryLimitType.EXACT) == null) {
            this.setServiceMemoryLimit("/core/service-context-index", DEFAULT_PCT_MEMORY_LIMIT_SERVICE_CONTEXT_INDEX);
        }
        this.allocateExecutors();
        return this;
    }

    private void allocateExecutors() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
        this.executor = Executors.newWorkStealingPool(Utils.DEFAULT_THREAD_COUNT);
        this.scheduledExecutor = Executors.newScheduledThreadPool(Utils.DEFAULT_THREAD_COUNT, r -> new Thread(r, this.getUri().toString() + "/scheduled/" + this.state.id));
    }

    protected byte[] getJWTSecret() throws IOException {
        URI privateKeyFileUri = this.state.privateKeyFileReference;
        String privateKeyPassphrase = this.state.privateKeyPassphrase;
        return JWTUtils.getJWTSecret(privateKeyFileUri, privateKeyPassphrase, this.isAuthorizationEnabled());
    }

    private void initializeStateFromArguments(File s, Arguments args) throws URISyntaxException {
        if (args.resourceSandbox != null) {
            File resDir = args.resourceSandbox.toFile();
            if (resDir.exists()) {
                this.state.resourceSandboxFileReference = resDir.toURI();
            } else {
                this.log(Level.WARNING, "Resource sandbox does not exist: %s", args.resourceSandbox);
            }
        }
        this.state.httpPort = args.port;
        this.state.httpsPort = args.securePort;
        this.state.sslClientAuthMode = args.sslClientAuthMode;
        if (args.keyFile != null) {
            this.state.privateKeyFileReference = args.keyFile.toUri();
            this.state.privateKeyPassphrase = args.keyPassphrase;
        }
        if (args.certificateFile != null) {
            this.state.certificateFileReference = args.certificateFile.toUri();
        }
        if (args.id != null) {
            this.state.id = args.id;
        }
        this.hashedId = Utils.computeHash(this.state.id);
        this.state.peerSynchronizationTimeLimitSeconds = args.perFactoryPeerSynchronizationLimitSeconds;
        this.state.isPeerSynchronizationEnabled = args.isPeerSynchronizationEnabled;
        this.state.isAuthorizationEnabled = args.isAuthorizationEnabled;
        File hostStateFile = new File(s, SERVICE_HOST_STATE_FILE);
        String errorFmt = hostStateFile.getPath() + " conflicts with command line argument %s. Argument: %s, in file: %s";
        String argumentName = "bindAddress";
        if (args.bindAddress != null && this.state.bindAddress != null && !args.bindAddress.equals(this.state.bindAddress)) {
            this.log(Level.WARNING, errorFmt, argumentName, args.bindAddress, this.state.bindAddress);
        }
        this.setBindAddress(args.bindAddress);
        if (args.publicUri != null) {
            this.setPublicUri(new URI(args.publicUri));
        }
        this.state.initialPeerNodes = args.peerNodes;
        this.state.location = args.location;
    }

    public String getLocation() {
        return this.state.location;
    }

    public void setLocation(String location) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.state.location = location;
    }

    protected void configureLogging(File storageSandboxDir) throws IOException {
        String logConfigFile = System.getProperty("java.util.logging.config.file");
        String logConfigClass = System.getProperty("java.util.logging.config.class");
        if (logConfigFile == null && logConfigClass == null) {
            File logFile = new File(storageSandboxDir, this.getClass().getSimpleName() + "." + this.getPort() + ".%g.log");
            this.handler = new FileHandler(logFile.getAbsolutePath(), 0xA00000, 1);
            this.handler.setFormatter(LOG_FORMATTER);
            this.logger.getParent().addHandler(this.handler);
            String path = logFile.toString().replace("%g", "0");
            ServiceHostLogService.setProcessLogFile(path);
        }
        this.configureLoggerFormatter(this.logger);
        this.logPrefix = this.getClass().getSimpleName() + ":" + this.getPort();
    }

    protected void configureLoggerFormatter(Logger logger) {
        for (Handler h : logger.getParent().getHandlers()) {
            if (h instanceof ConsoleHandler) {
                h.setFormatter(COLOR_LOG_FORMATTER);
                continue;
            }
            h.setFormatter(LOG_FORMATTER);
        }
    }

    protected void removeLogging() {
        if (this.handler != null) {
            this.logger.getParent().removeHandler(this.handler);
            this.handler.close();
            this.handler = null;
        }
    }

    private void loadState(URI storageSandbox, File s) throws IOException, InterruptedException {
        File hostStateFile = new File(s, SERVICE_HOST_STATE_FILE);
        if (hostStateFile.exists()) {
            CountDownLatch l = new CountDownLatch(1);
            FileUtils.readFileAndComplete(Operation.createGet(null).setCompletion((o, e) -> {
                if (e != null) {
                    this.log(Level.WARNING, "Failure loading state from %s: %s", hostStateFile, Utils.toString(e));
                    l.countDown();
                    return;
                }
                try {
                    ServiceHostState fileState = o.getBody(ServiceHostState.class);
                    if (fileState.id == null) {
                        this.log(Level.WARNING, "Invalid state from %s: %s", hostStateFile, Utils.toJsonHtml(fileState));
                        l.countDown();
                        return;
                    }
                    fileState.isStarted = this.state.isStarted;
                    fileState.isStopping = this.state.isStopping;
                    if (fileState.maintenanceIntervalMicros < Service.MIN_MAINTENANCE_INTERVAL_MICROS) {
                        fileState.maintenanceIntervalMicros = Service.MIN_MAINTENANCE_INTERVAL_MICROS;
                    }
                    this.state = fileState;
                    l.countDown();
                }
                catch (Throwable ex) {
                    this.log(Level.WARNING, "Invalid state from %s: %s", hostStateFile, Utils.toJsonHtml(o.getBodyRaw()));
                    l.countDown();
                    return;
                }
            }), hostStateFile);
            l.await();
        }
    }

    private void saveState() throws IOException, InterruptedException {
        this.saveState(new File(this.state.storageSandboxFileReference));
    }

    private void saveState(File sandboxDir) throws IOException, InterruptedException {
        File hostStateFile = new File(sandboxDir, SERVICE_HOST_STATE_FILE);
        this.state.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        byte[] serializedState = Utils.toJsonHtml(this.state).getBytes("UTF-8");
        Files.write(hostStateFile.toPath(), serializedState, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public String toString() {
        return String.format("[%n isStarted: %s%n httpPort: %d%n httpsPort: %d%n id: %s%n attached services: %d%n]", this.isStarted(), this.state.httpPort, this.state.httpsPort, this.state.id, this.attachedServices.size());
    }

    public boolean isStarted() {
        return this.state.isStarted;
    }

    public boolean isStopping() {
        return this.state.isStopping;
    }

    public boolean isServiceStateCaching() {
        return this.state.isServiceStateCaching;
    }

    public ServiceHost setServiceStateCaching(boolean enable) {
        this.state.isServiceStateCaching = enable;
        this.serviceResourceTracker.setServiceStateCaching(enable);
        return this;
    }

    public int getPort() {
        return this.state.httpPort;
    }

    public ServiceHost setPort(int port) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.state.httpPort = port;
        if (this.httpListener != null) {
            try {
                this.httpListener.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.httpListener = null;
        }
        return this;
    }

    public boolean isAuthorizationEnabled() {
        return this.state.isAuthorizationEnabled;
    }

    public void setAuthorizationEnabled(boolean isAuthorizationEnabled) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.state.isAuthorizationEnabled = isAuthorizationEnabled;
    }

    public boolean isPeerSynchronizationEnabled() {
        return this.state.isPeerSynchronizationEnabled;
    }

    public void setPeerSynchronizationEnabled(boolean enabled) {
        this.state.isPeerSynchronizationEnabled = enabled;
    }

    public int getPeerSynchronizationTimeLimitSeconds() {
        return this.state.peerSynchronizationTimeLimitSeconds;
    }

    public void setPeerSynchronizationTimeLimitSeconds(int seconds) {
        this.state.peerSynchronizationTimeLimitSeconds = seconds;
    }

    public int getSecurePort() {
        return this.state.httpsPort;
    }

    public ServiceHost setSecurePort(int port) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.state.httpsPort = port;
        if (this.httpsListener != null) {
            try {
                this.httpsListener.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.httpsListener = null;
        }
        return this;
    }

    public ServiceHost setPrivateKeyFileReference(URI fileReference) {
        this.state.privateKeyFileReference = fileReference;
        return this;
    }

    public ServiceHost setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.state.privateKeyPassphrase = privateKeyPassphrase;
        return this;
    }

    public ServiceHost setCertificateFileReference(URI fileReference) {
        this.state.certificateFileReference = fileReference;
        return this;
    }

    public ServiceHost setBindAddress(String address) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        if (address == null) {
            throw new IllegalArgumentException("address is required");
        }
        this.state.bindAddress = address;
        if (this.info.ipAddresses.isEmpty() || !this.info.ipAddresses.get(0).equals(address)) {
            this.info.ipAddresses.clear();
            this.getSystemInfo();
        }
        this.clearUriAndLogPrefix();
        return this;
    }

    public ServiceHost setPublicUri(URI publicUri) {
        this.state.publicUri = publicUri;
        this.clearUriAndLogPrefix();
        return this;
    }

    public URI getStorageSandbox() {
        return this.state.storageSandboxFileReference;
    }

    public ServiceHost setMaintenanceIntervalMicros(long micros) {
        if (micros <= 0L) {
            throw new IllegalArgumentException("micros: zero or negative value not allowed");
        }
        if (micros < Service.MIN_MAINTENANCE_INTERVAL_MICROS) {
            this.log(Level.WARNING, "Maintenance interval %d is less than the minimum interval %d, reducing to min interval", micros, Service.MIN_MAINTENANCE_INTERVAL_MICROS);
            micros = Service.MIN_MAINTENANCE_INTERVAL_MICROS;
        }
        for (Service s : this.attachedServices.values()) {
            if (s.getProcessingStage() == Service.ProcessingStage.STOPPED || s.getMaintenanceIntervalMicros() == 0L || s.getMaintenanceIntervalMicros() >= micros) continue;
            String error = String.format("Service %s has a small maintenance interval %d than new interval %d", s.getSelfLink(), s.getMaintenanceIntervalMicros(), micros);
            this.log(Level.WARNING, error, new Object[0]);
        }
        this.state.maintenanceIntervalMicros = micros;
        ScheduledFuture<?> task = this.maintenanceTask;
        if (task == null) {
            return this;
        }
        task.cancel(true);
        this.scheduleMaintenance();
        return this;
    }

    public String getId() {
        return this.state.id;
    }

    public String getIdHash() {
        return this.hashedId;
    }

    public long getOperationTimeoutMicros() {
        return this.state.operationTimeoutMicros;
    }

    public ServiceHostState getState() {
        ServiceHostState s = Utils.clone(this.state);
        s.systemInfo = this.getSystemInfo();
        return s;
    }

    ServiceHostState getStateNoCloning() {
        return this.state;
    }

    Service getDocumentIndexService() {
        return this.documentIndexService;
    }

    public URI getDocumentIndexServiceUri() {
        if (this.documentIndexService == null) {
            return null;
        }
        if (this.documentIndexServiceUri != null) {
            return this.documentIndexServiceUri;
        }
        this.documentIndexServiceUri = this.documentIndexService.getUri();
        return this.documentIndexServiceUri;
    }

    public URI getAuthorizationServiceUri() {
        if (this.authorizationService == null) {
            return null;
        }
        if (this.authorizationServiceUri != null) {
            return this.authorizationServiceUri;
        }
        this.authorizationServiceUri = this.authorizationService.getUri();
        return this.authorizationServiceUri;
    }

    public URI getTransactionServiceUri() {
        if (this.transactionService == null) {
            return null;
        }
        if (this.transactionServiceUri != null) {
            return this.transactionServiceUri;
        }
        this.transactionServiceUri = this.transactionService.getUri();
        return this.transactionServiceUri;
    }

    public URI getManagementServiceUri() {
        if (this.managementService == null) {
            return null;
        }
        if (this.managementServiceUri != null) {
            return this.managementServiceUri;
        }
        this.managementServiceUri = this.managementService.getUri();
        return this.managementServiceUri;
    }

    public ServiceHost setDocumentIndexingService(Service service) {
        if (this.state.isStarted) {
            throw new IllegalStateException("Host is started");
        }
        this.documentIndexService = service;
        return this;
    }

    public ServiceHost setAuthorizationService(Service service) {
        if (this.state.isStarted) {
            throw new IllegalStateException("Host is started");
        }
        this.authorizationService = service;
        return this;
    }

    public ServiceHost setTransactionService(Service service) {
        this.transactionService = service;
        return this;
    }

    public ServiceHost setManagementService(Service service) {
        if (this.state.isStarted) {
            throw new IllegalStateException("Host is started");
        }
        this.managementService = service;
        return this;
    }

    Service getManagementService() {
        return this.managementService;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ExecutorService allocateExecutor(Service s) {
        return this.allocateExecutor(s, Utils.DEFAULT_THREAD_COUNT);
    }

    public ExecutorService allocateExecutor(final Service s, int threadCount) {
        return Executors.newFixedThreadPool(threadCount, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, s.getUri() + "/" + Utils.getSystemNowMicrosUtc());
            }
        });
    }

    public ServiceHost start() throws Throwable {
        return this.startImpl();
    }

    private void setSystemProperties() throws Throwable {
        Properties props = System.getProperties();
        String preferIPv4 = "java.net.preferIPv4Stack";
        if (props.getProperty("java.net.preferIPv4Stack") == null) {
            props.setProperty("java.net.preferIPv4Stack", "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceHost startImpl() throws Throwable {
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            if (this.isStarted()) {
                return this;
            }
            this.state.isStarted = true;
            this.state.isStopping = false;
        }
        if (this.executor == null || this.scheduledExecutor == null) {
            this.allocateExecutors();
        }
        if (this.isAuthorizationEnabled() && this.authorizationService == null) {
            this.authorizationService = new AuthorizationContextService();
        }
        byte[] secret = this.getJWTSecret();
        this.tokenSigner = new Signer(secret);
        this.tokenVerifier = new Verifier(secret);
        if (this.getPort() != -1) {
            if (this.httpListener == null) {
                this.httpListener = new NettyHttpListener(this);
            }
            if (this.state.responsePayloadSizeLimit > 0) {
                this.httpListener.setResponsePayloadSizeLimit(this.state.responsePayloadSizeLimit);
            }
            this.httpListener.start(this.getPort(), this.state.bindAddress);
        }
        if (this.getSecurePort() != -1) {
            if (this.httpsListener == null) {
                if (this.state.certificateFileReference == null && this.state.privateKeyFileReference == null) {
                    this.log(Level.WARNING, "certificate and private key are missing", new Object[0]);
                } else {
                    this.httpsListener = new NettyHttpListener(this);
                }
            }
            if (this.httpsListener != null) {
                if (!this.httpsListener.isSSLConfigured()) {
                    this.httpsListener.setSSLContextFiles(this.state.certificateFileReference, this.state.privateKeyFileReference, this.state.privateKeyPassphrase);
                }
                if (this.state.responsePayloadSizeLimit > 0) {
                    this.httpsListener.setResponsePayloadSizeLimit(this.state.responsePayloadSizeLimit);
                }
                this.httpsListener.start(this.getSecurePort(), this.state.bindAddress);
            }
        }
        if (this.state.httpPort == 0) {
            this.state.httpPort = this.httpListener.getPort();
        }
        if (this.state.httpsPort == 0 && this.httpsListener != null) {
            this.state.httpsPort = this.httpsListener.getPort();
        }
        this.serviceResourceTracker.setServiceStateCaching(this.state.isServiceStateCaching);
        this.saveState();
        this.documentIndexServiceUri = UriUtils.updateUriPort(this.documentIndexServiceUri, this.state.httpPort);
        this.authorizationServiceUri = UriUtils.updateUriPort(this.authorizationServiceUri, this.state.httpPort);
        this.transactionServiceUri = UriUtils.updateUriPort(this.transactionServiceUri, this.state.httpPort);
        this.configureLogging(new File(this.getStorageSandbox()));
        String commitID = (String)this.state.codeProperties.get(GIT_COMMIT_SOURCE_PROPERTY_COMMIT_ID);
        if (commitID == null) {
            throw new IllegalStateException("CommitID code property not found!");
        }
        commitID = commitID.substring(0, 8);
        String userAgent = ServiceHost.class.getSimpleName() + "/" + commitID;
        if (this.client == null) {
            this.client = NettyHttpServiceClient.create(userAgent, null, this.scheduledExecutor, this);
            SSLContext clientContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            clientContext.init(null, trustManagerFactory.getTrustManagers(), null);
            this.client.setSSLContext(clientContext);
        }
        if (this.state.requestPayloadSizeLimit > 0) {
            this.client.setRequestPayloadSizeLimit(this.state.requestPayloadSizeLimit);
        }
        Operation.AuthorizationContext ctx = OperationContext.getAuthorizationContext();
        OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
        this.client.start();
        OperationContext.setAuthorizationContext(ctx);
        this.scheduleMaintenance();
        this.clearUriAndLogPrefix();
        this.log(Level.INFO, "%s listening on %s", userAgent, this.getPublicUri());
        return this;
    }

    public void startDefaultCoreServicesSynchronously() throws Throwable {
        if (this.findService(ServiceHostManagementService.SELF_LINK) != null) {
            throw new IllegalStateException("Already started");
        }
        this.addPrivilegedService(this.managementService.getClass());
        this.addPrivilegedService(OperationIndexService.class);
        this.addPrivilegedService(LuceneBlobIndexService.class);
        this.addPrivilegedService(BasicAuthenticationService.class);
        Operation.AuthorizationContext ctx = OperationContext.getAuthorizationContext();
        OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
        if (this.authorizationService != null) {
            this.addPrivilegedService(this.authorizationService.getClass());
            this.startCoreServicesSynchronously(this.authorizationService);
        }
        List<URI> peers = this.getInitialPeerHosts();
        this.startDefaultReplicationAndNodeGroupServices();
        if (this.documentIndexService != null) {
            this.addPrivilegedService(this.documentIndexService.getClass());
            if (this.documentIndexService instanceof LuceneDocumentIndexService) {
                Service[] queryServiceArray = new Service[]{this.documentIndexService, new LuceneBlobIndexService(), new ServiceContextIndexService(), new QueryTaskFactoryService(), new LocalQueryTaskFactoryService(), TaskFactoryService.create(GraphQueryTaskService.class, new Service.ServiceOption[0]), TaskFactoryService.create(SynchronizationTaskService.class, new Service.ServiceOption[0])};
                this.startCoreServicesSynchronously(queryServiceArray);
            }
        }
        ArrayList<Service> coreServices = new ArrayList<Service>();
        coreServices.add(this.managementService);
        coreServices.add(new ProcessFactoryService());
        coreServices.add(new ODataQueryService());
        coreServices.add(AuthCredentialsService.createFactory());
        Service userGroupFactory = UserGroupService.createFactory();
        this.addPrivilegedService(userGroupFactory.getClass());
        this.addPrivilegedService(UserGroupService.class);
        coreServices.add(userGroupFactory);
        this.addPrivilegedService(ResourceGroupService.class);
        coreServices.add(ResourceGroupService.createFactory());
        Service roleFactory = RoleService.createFactory();
        this.addPrivilegedService(RoleService.class);
        this.addPrivilegedService(roleFactory.getClass());
        coreServices.add(roleFactory);
        this.addPrivilegedService(UserService.class);
        coreServices.add(UserService.createFactory());
        coreServices.add(TenantService.createFactory());
        coreServices.add(new SystemUserService());
        coreServices.add(new GuestUserService());
        coreServices.add(new BasicAuthenticationService());
        TransactionFactoryService transactionFactoryService = new TransactionFactoryService();
        coreServices.add(transactionFactoryService);
        Service[] coreServiceArray = new Service[coreServices.size()];
        coreServices.toArray(coreServiceArray);
        this.startCoreServicesSynchronously(coreServiceArray);
        this.setTransactionService(transactionFactoryService);
        this.startService(Operation.createPost(UriUtils.buildUri(this, "/core/management/process-log")), new ServiceHostLogService(ServiceHostLogService.getDefaultProcessLogName()));
        this.startService(Operation.createPost(UriUtils.buildUri(this, "/core/management/go-dcp-process-log")), new ServiceHostLogService(ServiceHostLogService.getDefaultGoDcpProcessLogName()));
        this.startService(Operation.createPost(UriUtils.buildUri(this, "/core/management/system-log")), new ServiceHostLogService(ServiceHostLogService.DEFAULT_SYSTEM_LOG_NAME));
        WebSocketService webSocketService = new WebSocketService(null, null);
        webSocketService.setHost(this);
        this.startUiFileContentServices(webSocketService);
        OperationContext.setAuthorizationContext(ctx);
        this.schedule(() -> this.joinPeers(peers, "/core/node-groups/default"), this.state.maintenanceIntervalMicros, TimeUnit.MICROSECONDS);
    }

    public List<URI> getInitialPeerHosts() {
        return this.normalizePeerNodeList(this.state.initialPeerNodes);
    }

    public Path copyResourceToSandbox(URL url, Path resourcePath) throws URISyntaxException {
        File sandbox = new File(this.getStorageSandbox());
        Path outputPath = sandbox.toPath().resolve(DEFAULT_RESOURCE_SANDBOX_DIR).resolve(resourcePath);
        if (url.getProtocol().equals("file")) {
            this.log(Level.FINE, "Using resource %s", url.getPath());
            URI uri = url.toURI();
            return Paths.get(uri);
        }
        try {
            this.log(Level.FINE, "Copying resource %s to %s", url, outputPath);
            Path parent = outputPath.getParent();
            if (parent == null) {
                throw new IOException("No parent for output path: " + outputPath);
            }
            Files.createDirectories(parent, new FileAttribute[0]);
            InputStream is = url.openStream();
            Files.copy(is, outputPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.log(Level.WARNING, "Unable to copy resource %s to %s: %s", url, outputPath, e.toString());
            return null;
        }
        return outputPath;
    }

    private void startUiFileContentServices(Service s) throws Throwable {
        if (!s.hasOption(Service.ServiceOption.HTML_USER_INTERFACE)) {
            return;
        }
        Map<Object, Object> pathToURIPath = new HashMap();
        ServiceDocumentDescription sdd = s.getDocumentTemplate().documentDescription;
        try {
            if (sdd != null && sdd.userInterfaceResourcePath != null) {
                String customPathResources = s.getDocumentTemplate().documentDescription.userInterfaceResourcePath;
                pathToURIPath = this.discoverUiResources(Paths.get(customPathResources, new String[0]), s, true);
            } else {
                Path baseResourcePath = Utils.getServiceUiResourcePath(s);
                pathToURIPath = this.discoverUiResources(baseResourcePath, s, false);
            }
        }
        catch (Throwable e) {
            this.log(Level.WARNING, "Error enumerating UI resources for %s: %s", s.getSelfLink(), Utils.toString(e));
        }
        if (pathToURIPath.isEmpty()) {
            this.log(Level.WARNING, "No custom UI resources found for %s", s.getClass().getName());
            return;
        }
        for (Map.Entry<Object, Object> e : pathToURIPath.entrySet()) {
            Operation post = Operation.createPost(UriUtils.buildUri(this, (String)e.getValue())).setAuthorizationContext(this.getSystemAuthorizationContext());
            FileContentService fcs = new FileContentService(((Path)e.getKey()).toFile());
            this.startService(post, fcs);
        }
    }

    private Map<Path, String> discoverUiResources(Path path, Service s, boolean hasCustomResources) throws Throwable {
        HashMap<Path, String> pathToURIPath = new HashMap<Path, String>();
        Path baseUriPath = !hasCustomResources ? Paths.get("/user-interface/resources", Utils.buildServicePath(s.getClass())) : Paths.get("/user-interface/resources", path.toString());
        String prefix = path.toString().replace('\\', '/');
        if (this.state.resourceSandboxFileReference != null) {
            this.discoverFileResources(s, pathToURIPath, baseUriPath, prefix);
        }
        if (pathToURIPath.isEmpty()) {
            this.discoverJarResources(path, s, pathToURIPath, baseUriPath, prefix);
        }
        return pathToURIPath;
    }

    private void discoverJarResources(Path path, Service s, Map<Path, String> pathToURIPath, Path baseUriPath, String prefix) throws URISyntaxException, IOException {
        for (FileUtils.ResourceEntry entry : FileUtils.findResources(s.getClass(), prefix)) {
            Path resourcePath = path.resolve(entry.suffix);
            Path uriPath = baseUriPath.resolve(entry.suffix);
            Path outputPath = this.copyResourceToSandbox(entry.url, resourcePath);
            if (outputPath == null) {
                s.toggleOption(Service.ServiceOption.HTML_USER_INTERFACE, false);
                continue;
            }
            pathToURIPath.put(outputPath, uriPath.toString().replace('\\', '/'));
        }
    }

    private void discoverFileResources(Service s, Map<Path, String> pathToURIPath, Path baseUriPath, String prefix) {
        File rootDir = new File(new File(this.state.resourceSandboxFileReference), prefix);
        if (!rootDir.exists()) {
            this.log(Level.INFO, "Resource directory not found: %s", rootDir.toString());
            return;
        }
        String basePath = baseUriPath.toString();
        String serviceName = s.getClass().getSimpleName();
        List<File> resources = FileUtils.findFiles(rootDir.toPath(), new HashSet<String>(), false);
        for (File f : resources) {
            String subPath = f.getAbsolutePath();
            subPath = subPath.substring(subPath.indexOf(serviceName));
            subPath = subPath.replace(serviceName, ROOT_PATH);
            Path uriPath = Paths.get(basePath, subPath);
            pathToURIPath.put(f.toPath(), uriPath.toString().replace('\\', '/'));
        }
        if (pathToURIPath.isEmpty()) {
            this.log(Level.INFO, "No resources found in directory: %s", rootDir.toString());
        }
    }

    private void startDefaultReplicationAndNodeGroupServices() throws Throwable {
        this.startCoreServicesSynchronously(new NodeGroupFactoryService());
        Throwable[] error = new Throwable[1];
        CountDownLatch c = new CountDownLatch(1);
        Operation.CompletionHandler comp = (o, e) -> {
            if (e != null) {
                error[0] = e;
                this.log(Level.SEVERE, "Node group failed start: %s:", e.toString());
                this.stop();
                c.countDown();
                return;
            }
            this.log(Level.FINE, "started %s", o.getUri().getPath());
            this.coreServices.add(o.getUri().getPath());
            c.countDown();
        };
        this.log(Level.FINE, "starting %s", "/core/node-groups/default");
        this.registerForServiceAvailability(comp, "/core/node-groups/default");
        Operation post = NodeGroupFactoryService.createNodeGroupPostOp(this, "default").setReferer(UriUtils.buildUri(this, ROOT_PATH));
        post.setAuthorizationContext(this.getSystemAuthorizationContext());
        this.sendRequest(post);
        if (!c.await(this.getState().operationTimeoutMicros, TimeUnit.MICROSECONDS)) {
            throw new TimeoutException();
        }
        if (error[0] != null) {
            throw error[0];
        }
        ArrayList<Operation> startNodeSelectorPosts = new ArrayList<Operation>();
        ArrayList<Service> nodeSelectorServices = new ArrayList<Service>();
        Operation startPost = Operation.createPost(UriUtils.buildUri(this, "/core/node-selectors/default"));
        startNodeSelectorPosts.add(startPost);
        nodeSelectorServices.add(new ConsistentHashingNodeSelectorService());
        this.createCustomNodeSelectorService(startNodeSelectorPosts, nodeSelectorServices, "/core/node-selectors/default-1x", 1L);
        this.createCustomNodeSelectorService(startNodeSelectorPosts, nodeSelectorServices, "/core/node-selectors/default-3x", 3L);
        this.startCoreServicesSynchronously(startNodeSelectorPosts, nodeSelectorServices);
    }

    void createCustomNodeSelectorService(List<Operation> startNodeSelectorPosts, List<Service> nodeSelectorServices, String link, long factor) {
        Operation startPost = Operation.createPost(UriUtils.buildUri(this, link));
        NodeSelectorState initialState = new NodeSelectorState();
        initialState.nodeGroupLink = "/core/node-groups/default";
        initialState.replicationFactor = factor;
        startPost.setBody(initialState);
        startNodeSelectorPosts.add(startPost);
        nodeSelectorServices.add(new ConsistentHashingNodeSelectorService());
    }

    public void joinPeers(List<URI> peers, String nodeGroupUriPath) {
        if (peers == null) {
            return;
        }
        try {
            for (URI peerNodeBaseUri : peers) {
                URI localNodeGroupUri = UriUtils.buildUri(this, nodeGroupUriPath);
                NodeGroupService.JoinPeerRequest joinBody = NodeGroupService.JoinPeerRequest.create(UriUtils.extendUri(peerNodeBaseUri, nodeGroupUriPath), null);
                this.sendJoinPeerRequest(joinBody, localNodeGroupUri);
            }
        }
        catch (Throwable e) {
            this.log(Level.WARNING, "%s", Utils.toString(e));
        }
    }

    private List<URI> normalizePeerNodeList(String[] peers) {
        ArrayList<URI> peerList = new ArrayList<URI>();
        if (peers == null || peers.length == 0) {
            return peerList;
        }
        for (String peer : peers) {
            URI peerNodeBaseUri;
            if (!peer.startsWith("http")) {
                peerNodeBaseUri = UriUtils.buildUri(peer, 8000, ROOT_PATH, null);
            } else {
                try {
                    peerNodeBaseUri = new URI(peer);
                }
                catch (URISyntaxException e) {
                    this.log(Level.SEVERE, "Invalid peer uri:%s", peer);
                    continue;
                }
            }
            int selfPort = this.getPort();
            if ("https".equals(peerNodeBaseUri.getScheme())) {
                selfPort = this.getSecurePort();
            }
            if (this.checkAndSetPreferredAddress(peerNodeBaseUri.getHost()) && peerNodeBaseUri.getPort() == selfPort) {
                this.log(Level.INFO, "Skipping peer %s, its us", peerNodeBaseUri);
                continue;
            }
            peerList.add(peerNodeBaseUri);
        }
        return peerList;
    }

    private void sendJoinPeerRequest(NodeGroupService.JoinPeerRequest joinBody, URI localNodeGroupUri) {
        Operation peerRequestOp = Operation.createPost(localNodeGroupUri).setReferer(UriUtils.buildUri(this, ROOT_PATH)).setBody(joinBody).setCompletion((o, e) -> {
            if (e == null) {
                return;
            }
            if (e != null) {
                this.log(Level.WARNING, "Failure from local node group for join to: %s: %s", joinBody.memberGroupReference, e.toString());
            }
        });
        peerRequestOp.setAuthorizationContext(this.getSystemAuthorizationContext());
        this.sendRequest(peerRequestOp);
    }

    public void startFactoryServicesSynchronously(Service ... services) throws Throwable {
        ArrayList<Operation> posts = new ArrayList<Operation>();
        for (Service s : services) {
            if (!(s instanceof FactoryService)) {
                String message = String.format("Service %s is not a FactoryService", s.getClass().getSimpleName());
                throw new IllegalArgumentException(message);
            }
            URI u = null;
            if (ReflectionUtils.hasField(s.getClass(), "SELF_LINK")) {
                u = UriUtils.buildUri(this, s.getClass());
            } else {
                Class<?> childClass = ((FactoryService)s).createServiceInstance().getClass();
                if (ReflectionUtils.hasField(childClass, "FACTORY_LINK")) {
                    u = UriUtils.buildFactoryUri(this, childClass);
                }
                if (u == null) {
                    String message = String.format("%s field not found in class %s and %s field not found in class %s", "SELF_LINK", s.getClass().getSimpleName(), "FACTORY_LINK", childClass.getSimpleName());
                    throw new IllegalArgumentException(message);
                }
            }
            Operation startPost = Operation.createPost(u);
            posts.add(startPost);
        }
        this.startCoreServicesSynchronously(posts, Arrays.asList(services));
    }

    protected void startCoreServicesSynchronously(Service ... services) throws Throwable {
        ArrayList<Operation> posts = new ArrayList<Operation>();
        for (Service s : services) {
            URI u = null;
            if (ReflectionUtils.hasField(s.getClass(), "SELF_LINK")) {
                u = UriUtils.buildUri(this, s.getClass());
            } else if (s instanceof FactoryService) {
                u = UriUtils.buildFactoryUri(this, ((FactoryService)s).createServiceInstance().getClass());
            } else {
                throw new IllegalStateException("field SELF_LINK or FACTORY_LINK is required");
            }
            Operation startPost = Operation.createPost(u);
            posts.add(startPost);
        }
        this.startCoreServicesSynchronously(posts, Arrays.asList(services));
    }

    protected void startCoreServicesSynchronously(List<Operation> startPosts, List<Service> services) throws Throwable {
        CountDownLatch l = new CountDownLatch(services.size());
        Throwable[] failure = new Throwable[1];
        StringBuilder sb = new StringBuilder();
        Operation.CompletionHandler h = (o, e) -> {
            try {
                if (e != null) {
                    failure[0] = e;
                    this.log(Level.SEVERE, "Service %s failed start: %s", o.getUri(), e);
                    return;
                }
                this.log(Level.FINE, "started %s", o.getUri().getPath());
                this.coreServices.add(o.getUri().getPath());
            }
            finally {
                l.countDown();
            }
        };
        int index = 0;
        Operation.AuthorizationContext originalContext = OperationContext.getAuthorizationContext();
        OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
        for (Service s : services) {
            Operation startPost = startPosts.get(index++);
            startPost.setCompletion(h);
            startPost.setAuthorizationContext(this.getSystemAuthorizationContext());
            sb.append(startPost.getUri().toString()).append("\r\n");
            this.log(Level.FINE, "starting %s", startPost.getUri());
            this.startService(startPost, s);
        }
        if (!l.await(this.state.operationTimeoutMicros, TimeUnit.MICROSECONDS)) {
            this.log(Level.SEVERE, "One of the core services failed start: %s", sb.toString(), new TimeoutException());
        }
        OperationContext.setAuthorizationContext(originalContext);
        if (failure[0] != null) {
            throw failure[0];
        }
    }

    protected void setAuthorizationContext(Operation.AuthorizationContext context) {
        OperationContext.setAuthorizationContext(context);
    }

    public URI startSubscriptionService(Operation subscribe, Consumer<Operation> notificationConsumer) {
        return this.startSubscriptionService(subscribe, notificationConsumer, ServiceSubscriptionState.ServiceSubscriber.create(false));
    }

    public URI startReliableSubscriptionService(Operation subscribe, Consumer<Operation> notificationConsumer) {
        ServiceSubscriptionState.ServiceSubscriber sr = ServiceSubscriptionState.ServiceSubscriber.create(false).setUsePublicUri(true);
        ReliableSubscriptionService notificationTarget = ReliableSubscriptionService.create(subscribe, sr, notificationConsumer);
        return this.startSubscriptionService(subscribe, notificationTarget, sr);
    }

    public URI startSubscriptionService(Operation subscribe, final Consumer<Operation> notificationConsumer, ServiceSubscriptionState.ServiceSubscriber request) {
        if (subscribe == null) {
            throw new IllegalArgumentException("subscribe operation is required");
        }
        if (notificationConsumer == null) {
            subscribe.fail(new IllegalArgumentException("notificationConsumer is required"));
            return null;
        }
        if (request.notificationLimit != null && request.notificationLimit.compareTo(0L) <= 0) {
            subscribe.fail(new IllegalArgumentException("notificationCount must be greater than zero"));
            return null;
        }
        StatelessService notificationTarget = new StatelessService(){

            @Override
            public void authorizeRequest(Operation op) {
                op.complete();
            }

            @Override
            public void handleRequest(Operation op) {
                if (!op.isNotification()) {
                    super.handleRequest(op);
                    return;
                }
                notificationConsumer.accept(op);
            }
        };
        return this.startSubscriptionService(subscribe, notificationTarget, request);
    }

    public URI startSubscriptionService(Operation subscribe, Service notificationTarget, ServiceSubscriptionState.ServiceSubscriber request) {
        URI subscriptionUri;
        if (subscribe == null) {
            throw new IllegalArgumentException("subscribe operation is required");
        }
        if (subscribe.getUri() == null) {
            subscribe.fail(new IllegalArgumentException("subscribe URI is required"));
            return null;
        }
        if (!subscribe.getUri().getPath().endsWith(SERVICE_URI_SUFFIX_SUBSCRIPTIONS)) {
            subscribe.setUri(UriUtils.extendUri(subscribe.getUri(), SERVICE_URI_SUFFIX_SUBSCRIPTIONS));
        }
        if (notificationTarget.getProcessingStage().ordinal() > Service.ProcessingStage.AVAILABLE.ordinal()) {
            subscribe.fail(new IllegalArgumentException("subscription notification target cannot be reused"));
            return null;
        }
        String notificationTargetSelfLink = notificationTarget.getSelfLink();
        if (notificationTarget.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
            subscriptionUri = request.usePublicUri ? UriUtils.buildPublicUri(notificationTarget.getHost(), notificationTargetSelfLink) : notificationTarget.getUri();
        } else {
            if (notificationTargetSelfLink == null) {
                notificationTargetSelfLink = UUID.randomUUID().toString();
            }
            subscriptionUri = request.usePublicUri ? UriUtils.buildPublicUri(this, notificationTargetSelfLink) : UriUtils.buildUri(this, notificationTargetSelfLink);
        }
        if (request.documentExpirationTimeMicros != 0L) {
            long delta = request.documentExpirationTimeMicros - Utils.getSystemNowMicrosUtc();
            if (delta <= 0L) {
                this.log(Level.WARNING, "Expiration time is in the past: %d", request.documentExpirationTimeMicros);
                subscribe.fail(new CancellationException("Subscription has already expired"));
                return null;
            }
            this.schedule(() -> this.sendRequest(Operation.createDelete(UriUtils.buildUri(this, notificationTarget.getSelfLink()))), delta, TimeUnit.MICROSECONDS);
        }
        request.reference = subscriptionUri;
        subscribe.setBody(request);
        Operation post = Operation.createPost(subscriptionUri).setAuthorizationContext(this.getSystemAuthorizationContext()).setCompletion((o, e) -> {
            if (e != null) {
                subscribe.fail(e);
                return;
            }
            this.sendRequest(subscribe);
        });
        if (notificationTarget.getProcessingStage() == Service.ProcessingStage.CREATED) {
            this.startService(post, notificationTarget);
        } else {
            post.complete();
        }
        return subscriptionUri;
    }

    public void stopSubscriptionService(Operation unsubscribe, URI notificationTarget) {
        if (unsubscribe == null) {
            throw new IllegalArgumentException("unsubscribe operation is required");
        }
        if (unsubscribe.getUri() == null) {
            unsubscribe.fail(new IllegalArgumentException("unsubscribe URI is required"));
            return;
        }
        if (!unsubscribe.getUri().getPath().endsWith(SERVICE_URI_SUFFIX_SUBSCRIPTIONS)) {
            unsubscribe.setUri(UriUtils.extendUri(unsubscribe.getUri(), SERVICE_URI_SUFFIX_SUBSCRIPTIONS));
        }
        unsubscribe.setAction(Service.Action.DELETE);
        ServiceSubscriptionState.ServiceSubscriber unSubscribeBody = new ServiceSubscriptionState.ServiceSubscriber();
        unSubscribeBody.reference = notificationTarget;
        this.sendRequest(unsubscribe.setBody(unSubscribeBody).nestCompletion((deleteOp, deleteEx) -> {
            if (deleteEx != null) {
                unsubscribe.fail(new IllegalStateException("Deletion of notification callback failed"));
                return;
            }
            unsubscribe.complete();
        }));
        this.sendRequest(Operation.createDelete(notificationTarget).transferRefererFrom(unsubscribe).setCompletion((deleteOp, deleteEx) -> {
            if (deleteEx != null) {
                this.log(Level.WARNING, "Deletion of notification subscriber failed", new Object[0]);
            }
        }));
    }

    public static boolean isServiceStartingOrAvailable(Service.ProcessingStage stage) {
        return stage.ordinal() >= Service.ProcessingStage.INITIALIZING.ordinal() && stage.ordinal() <= Service.ProcessingStage.AVAILABLE.ordinal();
    }

    public static boolean isServiceStarting(Service.ProcessingStage stage) {
        return stage.ordinal() >= Service.ProcessingStage.CREATED.ordinal() && stage.ordinal() < Service.ProcessingStage.AVAILABLE.ordinal();
    }

    boolean isServiceStarting(Service service, String path) {
        if (service != null) {
            return ServiceHost.isServiceStarting(service.getProcessingStage());
        }
        if (path != null) {
            return false;
        }
        throw new IllegalArgumentException("service or path is required");
    }

    public ServiceHost startService(Service service) {
        Operation post = Operation.createPost(UriUtils.buildUri(this, service.getClass()));
        return this.startService(post, service);
    }

    public ServiceHost startService(Operation post, Service service) {
        if (service == null) {
            throw new IllegalArgumentException("service is required");
        }
        if (this.isStopping()) {
            post.fail(new IllegalStateException("ServiceHost not started"));
            return this;
        }
        Service.ProcessingStage stage = service.getProcessingStage();
        if (ServiceHost.isServiceStartingOrAvailable(stage)) {
            post.complete();
            return this;
        }
        if (service.getProcessingStage() == Service.ProcessingStage.STOPPED) {
            this.log(Level.INFO, "Restarting service %s (%s)", service.getClass().getSimpleName(), post.getUri());
        }
        if (post.getUri() == null) {
            post.setUri(UriUtils.buildUri(this, service.getClass()));
        }
        if (!post.hasReferer()) {
            post.setReferer(post.getUri());
        }
        service.setHost(this);
        URI serviceUri = post.getUri().normalize();
        String servicePath = UriUtils.normalizeUriPath(serviceUri.getPath());
        if (service.getSelfLink() == null) {
            service.setSelfLink(servicePath);
        }
        if (post.getExpirationMicrosUtc() == 0L) {
            post.setExpiration(Utils.fromNowMicrosUtc(this.state.operationTimeoutMicros));
        }
        if (ServiceHost.isHelperServicePath(servicePath)) {
            if (!service.hasOption(Service.ServiceOption.UTILITY)) {
                String errorMsg = "Service is using an utility URI path but has not enabled " + (Object)((Object)Service.ServiceOption.UTILITY);
                this.log(Level.WARNING, errorMsg, new Object[0]);
                post.fail(new IllegalStateException(errorMsg));
                return this;
            }
        } else if (this.checkIfServiceExistsAndAttach(service, servicePath, post)) {
            return this;
        }
        service.setProcessingStage(Service.ProcessingStage.CREATED);
        post.nestCompletion((o, e) -> {
            this.operationTracker.removeStartOperation(post);
            if (e == null) {
                post.complete();
                return;
            }
            this.stopService(service);
            this.serviceSynchTracker.failStartServiceOrSynchronize(service, post, o, e);
        });
        this.operationTracker.trackStartOperation(post);
        if (!Utils.validateServiceOptions(this, service, post)) {
            return this;
        }
        if (this.isAuthorizationEnabled() && post.getAuthorizationContext() == null) {
            this.populateAuthorizationContext(post);
        }
        this.processServiceStart(Service.ProcessingStage.INITIALIZING, service, post, post.hasBody());
        return this;
    }

    public ServiceHost startFactory(Service instanceService) {
        Class<?> serviceClass = instanceService.getClass();
        return this.startFactory(serviceClass, () -> FactoryService.create((Class<? extends Service>)serviceClass, instanceService.getStateType(), new Service.ServiceOption[0]));
    }

    public ServiceHost startFactory(Class<? extends Service> instServiceClass, Supplier<FactoryService> factoryCreator) {
        URI factoryUri = UriUtils.buildFactoryUri(this, instServiceClass);
        return this.startFactory(factoryCreator, factoryUri.getPath());
    }

    public ServiceHost startFactory(Supplier<FactoryService> factoryCreator, String servicePath) {
        Operation post = Operation.createPost(UriUtils.buildUri(this, servicePath));
        FactoryService factoryService = factoryCreator.get();
        return this.startService(post, factoryService);
    }

    public ServiceHost startIdempotentFactory(Service instanceService) {
        Class<?> serviceClass = instanceService.getClass();
        return this.startFactory(serviceClass, () -> FactoryService.createIdempotent(serviceClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingServiceAvailableOperations(Service s, Throwable e, boolean logFailure) {
        if (logFailure && !this.isStopping() && e != null) {
            this.log(Level.WARNING, "Service %s failed start: %s", s.getSelfLink(), e.toString());
        }
        SortedSet<Operation> ops = null;
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            ops = this.operationTracker.removeServiceAvailableCompletions(s.getSelfLink());
            if (ops == null || ops.isEmpty()) {
                return;
            }
        }
        if (e != null && logFailure) {
            this.log(Level.INFO, "Retrying %d operations waiting on failed start for %s", ops.size(), s.getSelfLink());
        }
        for (Operation op : ops) {
            this.run(() -> {
                if (op.getUri() == null) {
                    op.setUri(s.getUri());
                }
                if (e != null && op.hasPragmaDirective("xn-post-to-put")) {
                    this.restoreActionOnChildServiceToPostOnFactory(s.getSelfLink(), op);
                }
                op.complete();
            });
        }
    }

    private void restoreActionOnChildServiceToPostOnFactory(String link, Operation op) {
        this.log(Level.FINE, "Changing URI for (id:%d) %s from %s to factory", new Object[]{op.getId(), op.getAction(), link});
        op.removePragmaDirective("xn-post-to-put");
        String factoryPath = UriUtils.getParentPath(link);
        op.setUri(UriUtils.buildUri(this, factoryPath));
        op.setAction(Service.Action.POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfServiceExistsAndAttach(Service service, String servicePath, Operation post) {
        boolean isCreateOrSynchRequest = post.hasPragmaDirective("xn-created") || post.isSynchronize();
        Service existing = null;
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            existing = this.attachedServices.get(servicePath);
            if (existing != null && isCreateOrSynchRequest && existing.getProcessingStage() == Service.ProcessingStage.STOPPED) {
                existing = null;
            }
            if (existing == null) {
                this.attachedServices.put(servicePath, service);
                if (service.hasOption(Service.ServiceOption.URI_NAMESPACE_OWNER)) {
                    this.attachedNamespaceServices.put(servicePath, service);
                }
                if (service.hasOption(Service.ServiceOption.REPLICATION) && service.hasOption(Service.ServiceOption.FACTORY)) {
                    this.serviceSynchTracker.addService(servicePath, 0L);
                }
                ++this.state.serviceCount;
                return false;
            }
        }
        boolean isIdempotent = service.hasOption(Service.ServiceOption.IDEMPOTENT_POST);
        if (!isIdempotent) {
            Service parent = this.findService(UriUtils.getParentPath(servicePath));
            boolean bl = isIdempotent = parent != null && parent.hasOption(Service.ServiceOption.IDEMPOTENT_POST);
        }
        if (!isIdempotent && !post.isSynchronize()) {
            if (ServiceHost.isServiceStarting(existing.getProcessingStage())) {
                this.log(Level.INFO, "Retrying (%d) startService() POST to %s in stage %s", new Object[]{post.getId(), servicePath, existing.getProcessingStage()});
                this.schedule(() -> this.startService(post, service), this.getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
                return true;
            }
            this.failRequestServiceAlreadyStarted(servicePath, service, post);
            return true;
        }
        if (!isCreateOrSynchRequest) {
            post.complete();
            return true;
        }
        if (existing.getProcessingStage() != Service.ProcessingStage.AVAILABLE) {
            this.restoreActionOnChildServiceToPostOnFactory(servicePath, post);
            this.log(Level.FINE, "Retrying (%d) POST to idempotent %s in stage %s", new Object[]{post.getId(), servicePath, existing.getProcessingStage()});
            this.schedule(() -> this.handleRequest(null, post), this.getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
            return true;
        }
        this.log(Level.FINE, "Converting (%d) POST to PUT for idempotent %s in stage %s", new Object[]{post.getId(), servicePath, existing.getProcessingStage()});
        post.setAction(Service.Action.PUT);
        post.addPragmaDirective("xn-post-to-put");
        this.handleRequest(null, post);
        return true;
    }

    public static boolean isServiceIndexed(Service s) {
        return s.hasOption(Service.ServiceOption.PERSISTENCE);
    }

    public static boolean isServiceOnDemandLoad(Service s) {
        return s.hasOption(Service.ServiceOption.ON_DEMAND_LOAD);
    }

    public static boolean isServiceImmutable(Service s) {
        return s.hasOption(Service.ServiceOption.IMMUTABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processServiceStart(Service.ProcessingStage next, Service s, Operation post, boolean hasClientSuppliedInitialState) {
        if (next == s.getProcessingStage()) {
            post.complete();
            return;
        }
        if (this.isStopping()) {
            post.fail(new CancellationException());
            return;
        }
        if (s.getProcessingStage() == Service.ProcessingStage.STOPPED) {
            post.fail(new CancellationException());
            return;
        }
        try {
            s.setProcessingStage(next);
            switch (next) {
                case INITIALIZING: {
                    Service.ProcessingStage nextStage = ServiceHost.isServiceIndexed(s) ? Service.ProcessingStage.LOADING_INITIAL_STATE : Service.ProcessingStage.SYNCHRONIZING;
                    this.buildDocumentDescription(s);
                    if (post.hasBody()) {
                        ServiceDocument d = post.getBody(s.getStateType());
                        d.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
                    }
                    if (this.isAuthorizationEnabled() && this.authorizationService != null && this.authorizationService.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
                        post.nestCompletion(op -> this.processServiceStart(nextStage, s, post, hasClientSuppliedInitialState));
                        this.queueOrScheduleRequest(this.authorizationService, post);
                        break;
                    }
                    this.processServiceStart(nextStage, s, post, hasClientSuppliedInitialState);
                    break;
                }
                case LOADING_INITIAL_STATE: {
                    boolean isImmutableStart;
                    boolean bl = isImmutableStart = ServiceHost.isServiceCreate(post) && ServiceHost.isServiceImmutable(s);
                    if (!isImmutableStart && ServiceHost.isServiceIndexed(s) && !post.isFromReplication()) {
                        this.loadInitialServiceState(s, post, Service.ProcessingStage.SYNCHRONIZING, hasClientSuppliedInitialState);
                        break;
                    }
                    this.processServiceStart(Service.ProcessingStage.SYNCHRONIZING, s, post, hasClientSuppliedInitialState);
                    break;
                }
                case SYNCHRONIZING: {
                    Service.ProcessingStage nxt;
                    Service.ProcessingStage processingStage = nxt = ServiceHost.isServiceCreate(post) ? Service.ProcessingStage.EXECUTING_CREATE_HANDLER : Service.ProcessingStage.EXECUTING_START_HANDLER;
                    if (s.hasOption(Service.ServiceOption.FACTORY) || !s.hasOption(Service.ServiceOption.REPLICATION)) {
                        this.processServiceStart(nxt, s, post, hasClientSuppliedInitialState);
                        break;
                    }
                    post.nestCompletion(o -> {
                        boolean hasInitialState = hasClientSuppliedInitialState;
                        if (!hasInitialState && o.getLinkedState() != null) {
                            hasInitialState = true;
                        }
                        this.processServiceStart(nxt, s, post, hasInitialState);
                    });
                    boolean isFactorySync = !ServiceHost.isServiceCreate(post);
                    this.selectServiceOwnerAndSynchState(s, post, isFactorySync);
                    break;
                }
                case EXECUTING_CREATE_HANDLER: {
                    post.nestCompletion(o -> this.processServiceStart(Service.ProcessingStage.EXECUTING_START_HANDLER, s, post, hasClientSuppliedInitialState));
                    if (!this.isDocumentOwner(s)) {
                        post.complete();
                        break;
                    }
                    if (post.isFromReplication()) {
                        post.complete();
                        break;
                    }
                    OperationContext opCtx = this.extractAndApplyContext(post);
                    try {
                        s.adjustStat("createCount", 1.0);
                        s.handleCreate(post);
                        break;
                    }
                    catch (Throwable e) {
                        this.handleUncaughtException(s, post, e);
                        return;
                    }
                    finally {
                        OperationContext.restoreOperationContext(opCtx);
                    }
                }
                case EXECUTING_START_HANDLER: {
                    ServiceDocument stateFromDocumentStore;
                    Long version = null;
                    if (post.hasBody() && (stateFromDocumentStore = post.getLinkedState()) != null) {
                        version = stateFromDocumentStore.documentVersion;
                        post.linkState(null);
                    }
                    Long finalVersion = version;
                    post.nestCompletion(o -> {
                        ServiceDocument document = null;
                        this.normalizeInitialServiceState(s, post, finalVersion);
                        if (post.hasBody()) {
                            document = post.getBody(s.getStateType());
                        } else {
                            document = new ServiceDocument();
                            document.documentSelfLink = s.getSelfLink();
                        }
                        if (!this.isAuthorized(s, document, post)) {
                            post.fail(403);
                            return;
                        }
                        this.processServiceStart(Service.ProcessingStage.INDEXING_INITIAL_STATE, s, post, hasClientSuppliedInitialState);
                    });
                    if (!this.isDocumentOwner(s)) {
                        post.complete();
                        break;
                    }
                    if (!post.hasBody() && ServiceHost.isServiceOnDemandLoad(s) && post.hasPragmaDirective("xn-check-index")) {
                        post.complete();
                        return;
                    }
                    OperationContext opCtx = this.extractAndApplyContext(post);
                    try {
                        s.handleStart(post);
                        break;
                    }
                    catch (Throwable e) {
                        this.handleUncaughtException(s, post, e);
                        return;
                    }
                    finally {
                        OperationContext.restoreOperationContext(opCtx);
                    }
                }
                case INDEXING_INITIAL_STATE: {
                    ServiceDocument state;
                    boolean needsIndexing = false;
                    if (ServiceHost.isServiceIndexed(s) && !s.hasOption(Service.ServiceOption.FACTORY) && (post.isSynchronizePeer() || hasClientSuppliedInitialState)) {
                        needsIndexing = true;
                    }
                    post.nestCompletion(o -> this.processServiceStart(Service.ProcessingStage.REPLICATE_STATE, s, post, hasClientSuppliedInitialState));
                    if (post.hasBody()) {
                        state = (ServiceDocument)post.getBodyRaw();
                        if (state != null && state.documentKind == null) {
                            this.log(Level.WARNING, "documentKind is null for %s", s.getSelfLink());
                            state.documentKind = Utils.buildKind(s.getStateType());
                        }
                        this.serviceResourceTracker.updateCachedServiceState(s, state, post);
                    }
                    if (!post.hasBody() || !needsIndexing) {
                        post.complete();
                        break;
                    }
                    if (post.isFromReplication()) {
                        post.linkSerializedState(null);
                    }
                    state = (ServiceDocument)post.getBodyRaw();
                    this.saveServiceState(s, post, state);
                    break;
                }
                case REPLICATE_STATE: {
                    boolean shouldReplicate;
                    boolean bl = shouldReplicate = ServiceHost.isServiceCreate(post) && post.getAction() == Service.Action.POST && s.hasOption(Service.ServiceOption.REPLICATION) && !post.isFromReplication() && !post.isReplicationDisabled();
                    if (!shouldReplicate) {
                        this.processServiceStart(Service.ProcessingStage.AVAILABLE, s, post, hasClientSuppliedInitialState);
                        return;
                    }
                    String factoryPath = post.getRequestHeader("x-xenon-rpl-parent");
                    post.setUri(UriUtils.buildUri(this, factoryPath));
                    ServiceDocument initialState = post.getBody(s.getStateType());
                    ServiceDocument clonedInitState = Utils.clone(initialState);
                    String originalLink = clonedInitState.documentSelfLink;
                    clonedInitState.documentSelfLink = originalLink.replace(factoryPath, ROOT_PATH);
                    post.nestCompletion(replicatedOp -> {
                        clonedInitState.documentSelfLink = originalLink;
                        post.setBodyNoCloning(clonedInitState);
                        this.processServiceStart(Service.ProcessingStage.AVAILABLE, s, post, hasClientSuppliedInitialState);
                    });
                    post.linkState(clonedInitState);
                    this.replicateRequest(s.getOptions(), clonedInitState, s.getPeerNodeSelectorPath(), originalLink, post);
                    break;
                }
                case AVAILABLE: {
                    if (s.getProcessingStage() == Service.ProcessingStage.STOPPED) {
                        post.complete();
                        return;
                    }
                    s.setProcessingStage(Service.ProcessingStage.AVAILABLE);
                    if (!ServiceHost.isServiceImmutable(s)) {
                        this.startUiFileContentServices(s);
                        this.scheduleServiceMaintenance(s);
                        this.log(Level.FINEST, "Started %s", s.getSelfLink());
                    }
                    post.complete();
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "Unhandled error: %s", Utils.toString(e));
            post.fail(e);
        }
    }

    private OperationContext extractAndApplyContext(Operation op) {
        OperationContext opCtx = OperationContext.getOperationContext();
        OperationContext.setFrom(op);
        return opCtx;
    }

    boolean isDocumentOwner(Service s) {
        return !s.hasOption(Service.ServiceOption.OWNER_SELECTION) || s.hasOption(Service.ServiceOption.DOCUMENT_OWNER);
    }

    void normalizeInitialServiceState(Service s, Operation post, Long finalVersion) {
        if (!post.hasBody()) {
            return;
        }
        Object body = post.getBodyRaw();
        if (!body.getClass().equals(s.getStateType())) {
            body = Utils.toJson(body);
        }
        ServiceDocument initialState = s.setInitialState(body, finalVersion);
        initialState.documentSelfLink = s.getSelfLink();
        initialState.documentKind = Utils.buildKind(initialState.getClass());
        String string = initialState.documentAuthPrincipalLink = post.getAuthorizationContext() != null ? post.getAuthorizationContext().getClaims().getSubject() : null;
        if (!ServiceHost.isServiceImmutable(s)) {
            initialState = Utils.clone(initialState);
        }
        post.setBodyNoCloning(initialState);
    }

    public void scheduleNodeGroupChangeMaintenance(String nodeSelectorPath) {
        this.serviceSynchTracker.scheduleNodeGroupChangeMaintenance(nodeSelectorPath);
    }

    void loadServiceState(Service s, Operation op) {
        ServiceDocument state = this.serviceResourceTracker.getCachedServiceState(s, op);
        if (state != null && !s.hasOption(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING)) {
            state = Utils.clone(state);
        }
        if (state != null && state.documentKind == null) {
            this.log(Level.WARNING, "documentKind is null for %s", s.getSelfLink());
            state.documentKind = Utils.buildKind(s.getStateType());
        }
        if (state != null || !ServiceHost.isServiceIndexed(s)) {
            if (!this.isAuthorized(s, state, op)) {
                op.fail(403);
                return;
            }
            if (state != null) {
                op.linkState(state);
            }
            op.complete();
            return;
        }
        if (s.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            s.adjustStat("stateCacheMissCount", 1.0);
        }
        Operation getOp = Operation.createGet(op.getUri()).addPragmaDirective("xn-check-index").transferRefererFrom(op).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            if (!o.hasBody()) {
                this.failRequestServiceNotFound(op);
                return;
            }
            ServiceDocument st = o.getBody(s.getStateType());
            if (!this.isAuthorized(s, st, op)) {
                op.fail(403);
                return;
            }
            op.linkState(st).complete();
        });
        Service indexService = this.documentIndexService;
        if (indexService == null) {
            op.fail(new CancellationException());
            return;
        }
        indexService.handleRequest(getOp);
    }

    public boolean isAuthorized(Service service, ServiceDocument document, Operation op) {
        if (!this.isAuthorizationEnabled()) {
            return true;
        }
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            return false;
        }
        if (ctx.isSystemUser()) {
            return true;
        }
        if (document == null) {
            Class<? extends ServiceDocument> clazz = service.getStateType();
            try {
                document = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.log(Level.SEVERE, "Unable to instantiate %s: %s", clazz.toString(), e.toString());
                return false;
            }
            document.documentSelfLink = service.getSelfLink();
            document.documentKind = Utils.buildKind(clazz);
        }
        ServiceDocumentDescription documentDescription = this.buildDocumentDescription(service);
        QueryFilter queryFilter = ctx.getResourceQueryFilter(op.getAction());
        return queryFilter != null && queryFilter.evaluate(document, documentDescription);
    }

    void loadInitialServiceState(Service s, Operation serviceStartPost, Service.ProcessingStage next, boolean hasClientSuppliedState) {
        Service indexService = this.documentIndexService;
        if (indexService == null) {
            serviceStartPost.fail(new CancellationException());
            return;
        }
        Operation getLatestState = Operation.createGet(serviceStartPost.getUri()).addPragmaDirective("xn-check-index").transferRefererFrom(serviceStartPost);
        getLatestState.setCompletion((indexQueryOperation, e) -> this.handleLoadInitialStateCompletion(s, serviceStartPost, next, hasClientSuppliedState, indexQueryOperation, e));
        indexService.handleRequest(getLatestState);
    }

    void cacheServiceState(Service s, ServiceDocument st, Operation op) {
        Object rsp;
        if (op != null && op.hasBody() && (rsp = op.getBodyRaw()).getClass().equals(st.getClass())) {
            ServiceDocument r = (ServiceDocument)rsp;
            st.copyTo(r);
        }
        if (op != null && op.getAction() == Service.Action.DELETE) {
            return;
        }
        if (st != null && st.documentKind == null) {
            this.log(Level.WARNING, "documentKind is null for %s", s.getSelfLink());
            st.documentKind = Utils.buildKind(s.getStateType());
        }
        this.serviceResourceTracker.updateCachedServiceState(s, st, op);
    }

    void clearTransactionalCachedServiceState(Service s, String transactionId) {
        this.serviceResourceTracker.clearTransactionalCachedServiceState(s.getSelfLink(), transactionId);
    }

    private void handleLoadInitialStateCompletion(Service s, Operation serviceStartPost, Service.ProcessingStage next, boolean hasClientSuppliedState, Operation indexQueryOperation, Throwable e) {
        if (e != null) {
            if (!this.isStopping()) {
                this.log(Level.SEVERE, "Error loading state for service %s: %s", serviceStartPost.getUri(), Utils.toString(e));
            }
            serviceStartPost.fail(e);
            return;
        }
        ServiceDocument stateFromStore = null;
        if (indexQueryOperation.hasBody()) {
            stateFromStore = indexQueryOperation.getBody(s.getStateType());
            serviceStartPost.linkState(stateFromStore);
        }
        if (!this.checkServiceExistsOrDeleted(s, stateFromStore, serviceStartPost)) {
            return;
        }
        if (hasClientSuppliedState && stateFromStore != null) {
            ++stateFromStore.documentVersion;
        } else if (stateFromStore != null && stateFromStore.documentSelfLink != null) {
            serviceStartPost.setBody(stateFromStore);
        }
        this.processServiceStart(next, s, serviceStartPost, hasClientSuppliedState);
    }

    private boolean checkServiceExistsOrDeleted(Service s, ServiceDocument stateFromStore, Operation serviceStartPost) {
        boolean isDeleted;
        if (!serviceStartPost.hasPragmaDirective("xn-check-version")) {
            return true;
        }
        if (serviceStartPost.hasPragmaDirective("xn-force-index-update")) {
            return true;
        }
        if (stateFromStore == null) {
            return true;
        }
        boolean bl = isDeleted = ServiceDocument.isDeleted(stateFromStore) || this.pendingServiceDeletions.contains(s.getSelfLink());
        if (!serviceStartPost.hasBody()) {
            if (isDeleted) {
                this.failRequestServiceMarkedDeleted(stateFromStore, serviceStartPost);
                return false;
            }
            return true;
        }
        ServiceDocument initState = (ServiceDocument)serviceStartPost.getBodyRaw();
        if (isDeleted) {
            if (stateFromStore.documentVersion < initState.documentVersion) {
                return true;
            }
            this.log(Level.WARNING, " (%d) Attempt to start deleted service %s.Version: %d, in body: %d (%s)", serviceStartPost.getId(), stateFromStore.documentSelfLink, stateFromStore.documentVersion, initState.documentVersion, serviceStartPost.getRequestHeader("pragma"));
            this.failRequestServiceMarkedDeleted(stateFromStore, serviceStartPost);
            return false;
        }
        if (!s.hasOption(Service.ServiceOption.IDEMPOTENT_POST)) {
            this.log(Level.WARNING, "Attempt to start existing service %s.Version: %d, in body: %d", stateFromStore.documentSelfLink, stateFromStore.documentVersion, initState.documentVersion);
            this.failRequestServiceAlreadyStarted(s.getSelfLink(), s, serviceStartPost);
            return false;
        }
        return true;
    }

    void markAsPendingDelete(Service service) {
        if (ServiceHost.isServiceIndexed(service)) {
            this.pendingServiceDeletions.add(service.getSelfLink());
        }
    }

    void unmarkAsPendingDelete(Service service) {
        if (ServiceHost.isServiceIndexed(service)) {
            this.pendingServiceDeletions.remove(service.getSelfLink());
        }
    }

    public void stopService(Service service) {
        if (service == null) {
            throw new IllegalArgumentException("service is required");
        }
        this.stopService(service.getSelfLink());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopService(String path) {
        EnumSet<Service.ServiceOption> options = null;
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            Service existing = this.attachedServices.remove(path);
            if (existing == null) {
                path = UriUtils.normalizeUriPath(path);
                existing = this.attachedServices.remove(path);
            }
            if (existing != null) {
                options = existing.getOptions();
                existing.setProcessingStage(Service.ProcessingStage.STOPPED);
                if (existing.hasOption(Service.ServiceOption.URI_NAMESPACE_OWNER)) {
                    this.attachedNamespaceServices.remove(path);
                }
            }
            this.serviceSynchTracker.removeService(path);
            this.serviceResourceTracker.clearCachedServiceState(existing, path, null);
            this.pendingPauseServices.remove(path);
            --this.state.serviceCount;
        }
        if (options == null || this.managementService == null) {
            return;
        }
        if (options.contains((Object)Service.ServiceOption.ON_DEMAND_LOAD)) {
            this.managementService.adjustStat("onDemandLoadStopCount", 1.0);
        }
    }

    protected Service findService(String uriPath) {
        return this.findService(uriPath, true);
    }

    protected Service findService(String uriPath, boolean doExactMatch) {
        Service s = this.attachedServices.get(uriPath);
        if (s != null) {
            return s;
        }
        s = this.attachedServices.get(UriUtils.normalizeUriPath(uriPath));
        if (s != null) {
            return s;
        }
        if (ServiceHost.isHelperServicePath(uriPath)) {
            return this.findHelperService(uriPath);
        }
        if (!doExactMatch) {
            s = this.findNamespaceOwnerService(uriPath);
        }
        return s;
    }

    private Service findNamespaceOwnerService(String uriPath) {
        int charsNotMatched = Integer.MAX_VALUE;
        int uriPathLength = uriPath.length();
        Service candidate = null;
        for (Map.Entry e : this.attachedNamespaceServices.headMap((Object)uriPath, true).entrySet()) {
            int notMatchedCount;
            if (!uriPath.startsWith((String)e.getKey()) || (notMatchedCount = uriPathLength - ((String)e.getKey()).length()) >= charsNotMatched) continue;
            candidate = (Service)e.getValue();
            charsNotMatched = notMatchedCount;
        }
        return candidate;
    }

    Service findHelperService(String uriPath) {
        int i = uriPath.indexOf("/ui/");
        String subPath = i > 0 ? uriPath.substring(0, i) : uriPath.substring(0, uriPath.lastIndexOf("/"));
        Service s = this.attachedServices.get(subPath);
        if (s == null) {
            return null;
        }
        return s.getUtilityService(uriPath);
    }

    public boolean handleRequest(Operation inboundOp) {
        return this.handleRequest(null, inboundOp);
    }

    public boolean handleRequest(Service service, Operation inboundOp) {
        if (inboundOp == null && service != null) {
            inboundOp = service.dequeueRequest();
        }
        if (inboundOp == null) {
            return true;
        }
        if (inboundOp.getUri().getPort() != this.state.httpPort && inboundOp.getUri().getPort() != this.state.httpsPort) {
            return false;
        }
        if (!"127.0.0.1".equals(inboundOp.getUri().getHost()) && !UriUtils.isHostEqual(this, inboundOp.getUri())) {
            return false;
        }
        if (!this.state.isStarted) {
            this.failRequestServiceNotFound(inboundOp);
            return true;
        }
        if (this.isAuthorizationEnabled()) {
            if (inboundOp.getAuthorizationContext() == null) {
                this.populateAuthorizationContext(inboundOp);
            }
            if (this.authorizationService != null) {
                inboundOp.nestCompletion(op -> this.handleRequestWithAuthContext(null, (Operation)op));
                this.queueOrScheduleRequest(this.authorizationService, inboundOp);
                return true;
            }
        }
        this.handleRequestWithAuthContext(service, inboundOp);
        return true;
    }

    private void handleRequestWithAuthContext(Service service, Operation inboundOp) {
        String path;
        if (service == null) {
            path = inboundOp.getUri().getPath();
            if (path == null) {
                this.failRequestServiceNotFound(inboundOp);
                return;
            }
            service = this.findService(path, false);
        } else {
            path = service.getSelfLink();
        }
        Service pendingStopService = this.pendingPauseServices.remove(path);
        if (pendingStopService != null) {
            service = pendingStopService;
        }
        if (this.queueRequestUntilServiceAvailable(inboundOp, service, path)) {
            return;
        }
        if (this.queueOrForwardRequest(service, path, inboundOp)) {
            return;
        }
        if (service == null) {
            this.failRequestServiceNotFound(inboundOp);
            return;
        }
        this.traceOperation(inboundOp);
        if (this.isAuthorizationEnabled()) {
            Service sFinal = service;
            inboundOp.nestCompletion(o -> this.queueOrScheduleRequest(sFinal, inboundOp));
            service.authorizeRequest(inboundOp);
            return;
        }
        this.queueOrScheduleRequest(service, inboundOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Operation.AuthorizationContext getAuthorizationContext(Operation op) {
        String token = op.getRequestHeader("x-xenon-auth-token");
        if (token == null) {
            Map<String, String> cookies = op.getCookies();
            if (cookies == null) {
                return null;
            }
            token = cookies.get("xenon-auth-cookie");
        }
        if (token == null) {
            return null;
        }
        Operation.AuthorizationContext ctx = this.authorizationContextCache.get(token);
        try {
            Claims claims = null;
            claims = ctx == null ? this.getTokenVerifier().verify(token, Claims.class) : ctx.getClaims();
            if (claims == null) {
                this.log(Level.INFO, "Request to %s has no claims found with token: %s", op.getUri().getPath(), token);
                return null;
            }
            Long expirationTime = claims.getExpirationTime();
            if (expirationTime != null && expirationTime <= Utils.getSystemNowMicrosUtc()) {
                ServiceHostState serviceHostState = this.state;
                synchronized (serviceHostState) {
                    this.authorizationContextCache.remove(token);
                    this.userLinktoTokenMap.remove(claims.getSubject());
                }
                return null;
            }
            if (ctx != null) {
                return ctx;
            }
            Operation.AuthorizationContext.Builder b = Operation.AuthorizationContext.Builder.create();
            b.setClaims(claims);
            b.setToken(token);
            ctx = b.getResult();
            ServiceHostState serviceHostState = this.state;
            synchronized (serviceHostState) {
                this.authorizationContextCache.put(token, ctx);
                this.addUserToken(this.userLinktoTokenMap, claims.getSubject(), token);
            }
            return ctx;
        }
        catch (Verifier.TokenException | GeneralSecurityException e) {
            this.log(Level.INFO, "Error verifying token: %s", e);
            return null;
        }
    }

    private void addUserToken(Map<String, Set<String>> userLinktoTokenMap, String userServiceLink, String token) {
        Set<String> tokenSet = userLinktoTokenMap.get(userServiceLink);
        if (tokenSet == null) {
            tokenSet = new HashSet<String>();
        }
        tokenSet.add(token);
        userLinktoTokenMap.put(userServiceLink, tokenSet);
    }

    void failRequestServiceNotFound(Operation inboundOp) {
        this.failRequestServiceNotFound(inboundOp, Integer.MIN_VALUE);
    }

    void failRequestServiceNotFound(Operation inboundOp, int errorCode) {
        ServiceHost.failRequest(inboundOp, 404, errorCode, new ServiceNotFoundException(inboundOp.getUri().toString()));
    }

    private void failRequestServiceMarkedDeleted(ServiceDocument stateFromStore, Operation serviceStartPost) {
        ServiceHost.failRequest(serviceStartPost, 409, -2147483646, new IllegalStateException("Service marked deleted: " + stateFromStore.documentSelfLink));
    }

    void failRequestServiceAlreadyStarted(String path, Service s, Operation post) {
        Service.ProcessingStage st = Service.ProcessingStage.AVAILABLE;
        if (s != null) {
            st = s.getProcessingStage();
        }
        ServiceAlreadyStartedException e = new ServiceAlreadyStartedException(path, st);
        ServiceHost.failRequest(post, 409, -2147483645, e);
    }

    private boolean queueOrForwardRequest(Service s, String path, Operation op) {
        if (s == null && op.isFromReplication()) {
            if (op.getAction() == Service.Action.DELETE) {
                op.complete();
            } else {
                this.failRequestServiceNotFound(op);
            }
            return true;
        }
        Service parent = null;
        EnumSet<Service.ServiceOption> options = null;
        if (s != null) {
            options = s.getOptions();
            if (options == null) {
                return false;
            }
            if (options.contains((Object)Service.ServiceOption.UTILITY)) {
                parent = this.findService(path = UriUtils.getParentPath(path));
                if (parent == null) {
                    if (op.getRetryCount() == 0) {
                        op.setRetryCount(1);
                    }
                    if (op.decrementRetriesRemaining() >= 0) {
                        this.log(Level.WARNING, "Parent for %s missing, retrying", op.getUri().getPath());
                        this.retryPauseOrOnDemandLoadConflict(op, false);
                        return true;
                    }
                    this.failRequestServiceNotFound(op);
                    return true;
                }
                options = parent.getOptions();
            }
            if (options == null || !options.contains((Object)Service.ServiceOption.OWNER_SELECTION) || options.contains((Object)Service.ServiceOption.FACTORY)) {
                return false;
            }
        } else {
            String factoryPath;
            if (ServiceHost.isHelperServicePath(path)) {
                path = UriUtils.getParentPath(path);
            }
            if ((factoryPath = UriUtils.getParentPath(path)) == null) {
                this.failRequestServiceNotFound(op);
                return true;
            }
            parent = this.findService(factoryPath);
            if (parent == null) {
                this.failRequestServiceNotFound(op);
                return true;
            }
            options = parent.getOptions();
            if (options == null || !options.contains((Object)Service.ServiceOption.FACTORY) || !options.contains((Object)Service.ServiceOption.REPLICATION)) {
                return false;
            }
        }
        if (op.isForwardingDisabled()) {
            return false;
        }
        if (options.contains((Object)Service.ServiceOption.ON_DEMAND_LOAD) && op.getAction() == Service.Action.DELETE && op.hasPragmaDirective("xn-no-index-update")) {
            if (s == null) {
                op.complete();
                return true;
            }
            return false;
        }
        String nodeSelectorPath = parent != null ? parent.getPeerNodeSelectorPath() : s.getPeerNodeSelectorPath();
        op.setStatusCode(200);
        String servicePath = path;
        Operation.CompletionHandler ch = (o, e) -> {
            if (e != null) {
                this.log(Level.SEVERE, "Owner selection failed for service %s, op %d. Error: %s", op.getUri().getPath(), op.getId(), e.toString());
                op.setRetryCount(0).fail(e);
                this.run(() -> this.handleRequest(s, null));
                return;
            }
            NodeSelectorService.SelectOwnerResponse rsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            if (op.isFromReplication()) {
                ServiceDocument body = op.getBody(s.getStateType());
                if (rsp.isLocalHostOwner) {
                    this.failRequestOwnerMismatch(op, rsp.ownerNodeId, body);
                    return;
                }
                this.queueOrScheduleRequest(s, op);
                return;
            }
            Operation.CompletionHandler fc = (fo, fe) -> {
                if (fe != null) {
                    this.retryOrFailRequest(op, fo, fe);
                    return;
                }
                op.setStatusCode(fo.getStatusCode());
                if (fo.hasBody()) {
                    op.setBodyNoCloning(fo.getBodyRaw());
                }
                op.transferResponseHeadersFrom(fo);
                op.complete();
            };
            Operation forwardOp = op.clone().setCompletion(fc);
            if (rsp.isLocalHostOwner) {
                if (s == null) {
                    this.queueOrFailRequestForServiceNotFoundOnOwner(servicePath, op);
                    return;
                }
                this.queueOrScheduleRequest(s, forwardOp);
                return;
            }
            if (op.hasPragmaDirective("xn-fwd")) {
                this.failRequestOwnerMismatch(op, op.getUri().getPath(), null);
                return;
            }
            forwardOp.setExpiration(Utils.fromNowMicrosUtc(this.state.operationTimeoutMicros / 10L));
            forwardOp.setUri(NodeSelectorService.SelectOwnerResponse.buildUriToOwner(rsp, op)).addPragmaDirective("xn-fwd");
            forwardOp.setConnectionTag("xn-cnx-tag-p2p-fwd");
            forwardOp.toggleOption(NodeSelectorService.FORWARDING_OPERATION_OPTION, true);
            this.sendRequest(forwardOp);
        };
        Operation selectOwnerOp = Operation.createPost(null).setExpiration(op.getExpirationMicrosUtc()).setCompletion(ch);
        this.selectOwner(nodeSelectorPath, path, selectOwnerOp);
        return true;
    }

    private void queueOrFailRequestForServiceNotFoundOnOwner(String path, Operation op) {
        if (this.serviceResourceTracker.checkAndResumeService(op)) {
            return;
        }
        if (op.getAction() == Service.Action.DELETE) {
            op.complete();
            return;
        }
        this.checkPragmaAndRegisterForAvailability(path, op);
    }

    void checkPragmaAndRegisterForAvailability(String path, Operation op) {
        if (!op.hasPragmaDirective("xn-queue")) {
            this.failRequestServiceNotFound(op);
            return;
        }
        this.log(Level.INFO, "(%d) Registering for %s to become available on owner %s", op.getId(), path, this.getId());
        op.nestCompletion(avop -> this.handleRequest(null, op));
        this.registerForServiceAvailability(op, path);
    }

    void failRequestOwnerMismatch(Operation op, String id, ServiceDocument body) {
        String owner = body != null ? body.documentOwner : ROOT_PATH;
        op.setStatusCode(409);
        IllegalStateException e = new IllegalStateException(String.format("Owner in body: %s, computed locally: %s", owner, id));
        ServiceErrorResponse rsp = ServiceErrorResponse.create(e, op.getStatusCode(), EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY));
        rsp.setInternalErrorCode(-2147483643);
        op.fail(e, rsp);
    }

    public void failRequestActionNotSupported(Operation request) {
        request.setStatusCode(405).fail(new IllegalArgumentException("Action not supported: " + (Object)((Object)request.getAction())));
    }

    public void failRequestLimitExceeded(Operation request) {
        request.addResponseHeader("retry-after", "1");
        request.setStatusCode(503).fail(new CancellationException("queue limit exceeded"));
    }

    private void failForwardRequest(Operation op, Operation fo, Throwable fe) {
        op.setStatusCode(fo.getStatusCode());
        op.setBodyNoCloning(fo.getBodyRaw()).fail(fe);
    }

    void retryPauseOrOnDemandLoadConflict(Operation op, boolean isOdlConflict) {
        this.serviceResourceTracker.retryPauseOrOnDemandLoadConflict(op, isOdlConflict);
    }

    private void retryOrFailRequest(Operation op, Operation fo, Throwable fe) {
        ServiceErrorResponse rsp;
        boolean shouldRetry = false;
        if (fo.hasBody() && (rsp = fo.clone().getBody(ServiceErrorResponse.class)) != null && rsp.details != null) {
            shouldRetry = rsp.details.contains((Object)ServiceErrorResponse.ErrorDetail.SHOULD_RETRY);
        }
        if (fo.getStatusCode() == 408) {
            shouldRetry = true;
        }
        if (op.hasPragmaDirective("xn-fwd")) {
            shouldRetry = false;
        }
        if (op.getExpirationMicrosUtc() < Utils.getSystemNowMicrosUtc()) {
            op.setBodyNoCloning(fo.getBodyRaw()).fail(new CancellationException("Expired at " + op.getExpirationMicrosUtc()));
            return;
        }
        if (!shouldRetry) {
            this.failForwardRequest(op, fo, fe);
            return;
        }
        this.operationTracker.trackOperationForRetry(Utils.getNowMicrosUtc(), fe, op);
    }

    boolean queueRequestUntilServiceAvailable(Operation inboundOp, Service s, String path) {
        Service parentService;
        if (s != null && s.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
            return false;
        }
        if (ServiceHost.isHelperServicePath(path)) {
            path = UriUtils.getParentPath(path);
        }
        boolean waitForService = this.isServiceStarting(s, path);
        String parentPath = UriUtils.getParentPath(path);
        if (parentPath != null && !waitForService && (parentService = this.findService(parentPath)) != null) {
            if (parentService.hasOption(Service.ServiceOption.FACTORY)) {
                waitForService = this.isServiceStarting(parentService, parentPath);
                FactoryService parent = (FactoryService)parentService;
                if (!inboundOp.isFromReplication() && parent.hasChildOption(Service.ServiceOption.OWNER_SELECTION)) {
                    return false;
                }
            }
            if (parentService.hasOption(Service.ServiceOption.PERSISTENCE) && this.serviceResourceTracker.checkAndResumeService(inboundOp)) {
                return true;
            }
        }
        if (inboundOp.isFromReplication() && !ServiceHost.isServiceAvailable(s) && inboundOp.isUpdate()) {
            this.log(Level.WARNING, "Service %s is not available. Failing replication request", inboundOp.getUri().getPath());
            IllegalStateException ex = new IllegalStateException("Service not found on replica");
            ServiceHost.failRequest(inboundOp, 404, -2147483644, ex);
            return true;
        }
        if (inboundOp.hasPragmaDirective("xn-queue")) {
            waitForService = true;
        }
        if (waitForService || inboundOp.isFromReplication()) {
            if (inboundOp.getAction() == Service.Action.DELETE) {
                return false;
            }
            if (this.isStopping()) {
                return false;
            }
            inboundOp.nestCompletion(o -> {
                inboundOp.setTargetReplicated(false);
                this.handleRequest(null, inboundOp);
            });
            this.registerForServiceAvailability(inboundOp, path);
            return true;
        }
        return false;
    }

    private static void failRequest(Operation request, int statusCode, int errorCode, Throwable e) {
        request.setStatusCode(statusCode);
        ServiceErrorResponse r = Utils.toServiceErrorResponse(e);
        r.statusCode = statusCode;
        r.errorCode = errorCode;
        if (e instanceof ServiceNotFoundException) {
            r.stackTrace = null;
        }
        request.setContentType("application/json").fail(e, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueOrScheduleRequest(Service s, Operation op) {
        boolean processRequest = true;
        try {
            if (this.applyRequestRateLimit(op)) {
                processRequest = false;
                return;
            }
            Service.ProcessingStage stage = s.getProcessingStage();
            if (stage == Service.ProcessingStage.AVAILABLE) {
                return;
            }
            if (op.getAction() == Service.Action.DELETE) {
                return;
            }
            processRequest = false;
            if (stage == Service.ProcessingStage.STOPPED) {
                if (op.hasPragmaDirective("xn-post-to-put")) {
                    this.restoreActionOnChildServiceToPostOnFactory(s.getSelfLink(), op);
                    this.handleRequest(null, op);
                    return;
                }
                if (s.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
                    this.retryPauseOrOnDemandLoadConflict(op, true);
                    return;
                }
                op.setStatusCode(404);
            } else if (stage == Service.ProcessingStage.PAUSED) {
                this.retryPauseOrOnDemandLoadConflict(op, false);
                return;
            }
            op.fail(new CancellationException("Service not available, in stage:" + (Object)((Object)stage)));
        }
        finally {
            if (!processRequest) {
                return;
            }
            if (!s.queueRequest(op)) {
                Runnable r = () -> {
                    OperationContext opCtx = this.extractAndApplyContext(op);
                    try {
                        s.handleRequest(op);
                    }
                    catch (Throwable e) {
                        this.handleUncaughtException(s, op, e);
                    }
                    finally {
                        OperationContext.setFrom(opCtx);
                    }
                };
                this.executor.execute(r);
            }
        }
    }

    private boolean applyRequestRateLimit(Operation op) {
        if (this.state.requestRateLimits.isEmpty()) {
            return false;
        }
        Operation.AuthorizationContext authCtx = op.getAuthorizationContext();
        if (authCtx == null) {
            return false;
        }
        Claims claims = authCtx.getClaims();
        if (claims == null) {
            return false;
        }
        String subject = claims.getSubject();
        if (subject == null) {
            return false;
        }
        RequestRateInfo rateInfo = this.state.requestRateLimits.get(subject);
        if (rateInfo == null) {
            return false;
        }
        double count = rateInfo.count.incrementAndGet();
        long now = Utils.getSystemNowMicrosUtc();
        long delta = now - rateInfo.startTimeMicros;
        double deltaInSeconds = (double)delta / 1000000.0;
        if (delta < this.getMaintenanceIntervalMicros()) {
            return false;
        }
        double requestsPerSec = count / deltaInSeconds;
        if (requestsPerSec > rateInfo.limit) {
            this.failRequestLimitExceeded(op);
            return true;
        }
        return false;
    }

    private void handleUncaughtException(Service s, Operation op, Throwable e) {
        if (!Utils.isValidationError(e)) {
            this.log(Level.SEVERE, "Uncaught exception in service %s: %s", s.getUri(), Utils.toString(e));
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "Validation Error in service %s: %s", s.getUri(), Utils.toString(e));
        }
        op.fail(e);
    }

    @Override
    public void sendRequest(Operation op) {
        this.prepareRequest(op);
        this.traceOperation(op);
        if (this.isStopping()) {
            op.fail(new CancellationException("host is stopping"));
            return;
        }
        ServiceClient c = this.client;
        if (c == null) {
            op.fail(new CancellationException("host is stopped"));
            return;
        }
        c.send(op);
    }

    private void traceOperation(Operation op) {
        if (this.getOperationTracingLevel().intValue() == Level.OFF.intValue()) {
            return;
        }
        if (this.state.operationTracingLinkExclusionList.contains(op.getUri().getPath())) {
            return;
        }
        for (String excludedPath : this.state.operationTracingLinkExclusionList) {
            if (!op.getUri().getPath().startsWith(excludedPath)) continue;
            return;
        }
        Operation.SerializedOperation tracingOp = Operation.SerializedOperation.create(op);
        this.sendRequest(Operation.createPost(UriUtils.buildUri(this, OperationIndexService.class)).setReferer(this.getUri()).setBodyNoCloning(tracingOp));
    }

    private void prepareRequest(Operation op) {
        if (op.getUri() == null) {
            throw new IllegalArgumentException("URI is required");
        }
        if (op.getUri().getPort() != this.state.httpPort && op.getUri().getPort() != this.state.httpsPort) {
            op.forceRemote();
        }
        if (op.getExpirationMicrosUtc() == 0L) {
            long expirationMicros = Utils.fromNowMicrosUtc(this.state.operationTimeoutMicros);
            op.setExpiration(expirationMicros);
        }
        if (op.getCompletion() == null) {
            op.setCompletion((o, e) -> {
                if (e == null) {
                    return;
                }
                if (op.isFailureLoggingDisabled()) {
                    return;
                }
                this.log(Level.WARNING, "%s (ctx id:%s) to %s, from %s failed: %s", new Object[]{o.getAction(), o.getContextId(), o.getUri(), o.getReferer(), e.getMessage()});
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashSet<Service> servicesToClose = null;
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            if (!this.state.isStarted || this.state.isStopping) {
                return;
            }
            this.state.isStopping = true;
            servicesToClose = new HashSet<Service>(this.attachedServices.values());
        }
        this.serviceResourceTracker.close();
        this.serviceMaintTracker.close();
        this.operationTracker.close();
        this.serviceSynchTracker.close();
        ScheduledFuture<?> task = this.maintenanceTask;
        if (task != null) {
            task.cancel(false);
            this.maintenanceTask = null;
        }
        List<Service> privilegedServiceInstances = this.stopServices(servicesToClose);
        this.stopPrivilegedServices(privilegedServiceInstances);
        this.stopCoreServices();
        this.attachedServices.clear();
        this.attachedNamespaceServices.clear();
        this.pendingServiceDeletions.clear();
        this.state.isStarted = false;
        this.removeLogging();
        try {
            this.client.stop();
            this.client = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.httpListener.stop();
            this.httpListener = null;
            if (this.httpsListener != null) {
                this.httpsListener.stop();
                this.httpsListener = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor = null;
    }

    private List<Service> stopServices(Set<Service> servicesToClose) {
        int servicesToCloseCount = servicesToClose.size() - this.coreServices.size();
        CountDownLatch latch = new CountDownLatch(servicesToCloseCount);
        Operation.CompletionHandler removeServiceCompletion = (o, e) -> {
            this.attachedServices.remove(o.getUri().getPath());
            latch.countDown();
        };
        this.setAuthorizationContext(this.getSystemAuthorizationContext());
        ArrayList<Service> privilegedServiceInstances = new ArrayList<Service>();
        for (Service s : servicesToClose) {
            if (this.coreServices.contains(s.getSelfLink())) continue;
            if (this.privilegedServiceTypes.containsKey(s.getClass().getName())) {
                privilegedServiceInstances.add(s);
                removeServiceCompletion.handle(Operation.createDelete(s.getUri()), null);
                continue;
            }
            this.sendServiceStop(removeServiceCompletion, s);
        }
        this.log(Level.INFO, "Waiting for DELETE from %d services", servicesToCloseCount);
        this.waitForServiceStop(latch);
        this.log(Level.INFO, "All non core services stopped", servicesToCloseCount);
        return privilegedServiceInstances;
    }

    private void stopPrivilegedServices(List<Service> privilegedServiceInstances) {
        if (privilegedServiceInstances.size() == 0) {
            return;
        }
        int servicesToCloseCount = privilegedServiceInstances.size();
        CountDownLatch pLatch = new CountDownLatch(servicesToCloseCount);
        Operation.CompletionHandler pc = (o, e) -> pLatch.countDown();
        for (Service p : privilegedServiceInstances) {
            this.sendServiceStop(pc, p);
        }
        this.log(Level.INFO, "Waiting for DELETE from %d privileged services", servicesToCloseCount);
        this.waitForServiceStop(pLatch);
        this.log(Level.INFO, "All privileged services stopped", new Object[0]);
    }

    private void stopCoreServices() {
        int coreServiceCount = this.coreServices.size();
        CountDownLatch cLatch = new CountDownLatch(coreServiceCount);
        Operation.CompletionHandler c = (o, e) -> cLatch.countDown();
        for (String coreServiceLink : this.coreServices) {
            Service coreService = this.attachedServices.get(coreServiceLink);
            if (coreService == null || coreService instanceof ServiceHostManagementService) {
                c.handle(null, null);
                continue;
            }
            this.sendServiceStop(c, coreService);
        }
        this.log(Level.INFO, "Waiting for DELETE from %d core services", coreServiceCount);
        this.coreServices.clear();
        this.waitForServiceStop(cLatch);
        this.log(Level.INFO, "All core services stopped", new Object[0]);
    }

    private void waitForServiceStop(CountDownLatch latch) {
        try {
            boolean isTimeout;
            boolean bl = isTimeout = !latch.await(this.state.maintenanceIntervalMicros * 5L, TimeUnit.MICROSECONDS);
            if (isTimeout) {
                this.log(Level.INFO, "Timeout waiting for service stop", new Object[0]);
                for (String l : this.attachedServices.keySet()) {
                    if (this.coreServices.contains(l)) continue;
                    this.log(Level.WARNING, "%s did not complete DELETE", l);
                }
            }
        }
        catch (Throwable e) {
            this.log(Level.INFO, "%s", e.toString());
        }
    }

    private void sendServiceStop(Operation.CompletionHandler removeServiceCompletion, Service s) {
        Operation delete = Operation.createDelete(s.getUri()).addPragmaDirective("xn-no-index-update").setReplicationDisabled(true).setCompletion(removeServiceCompletion).setReferer(UriUtils.buildUri(this, ROOT_PATH));
        try {
            this.queueOrScheduleRequest(s, delete);
        }
        catch (Throwable e) {
            this.log(Level.WARNING, Utils.toString(e), new Object[0]);
            removeServiceCompletion.handle(delete, e);
        }
    }

    public static boolean isServiceCreate(Operation op) {
        return op.getAction() == Service.Action.POST && op.hasPragmaDirective("xn-created");
    }

    public static boolean isServiceStop(Operation op) {
        return op.getAction() == Service.Action.DELETE && op.hasPragmaDirective("xn-no-index-update");
    }

    public static boolean isServiceDeleteAndStop(Operation op) {
        return op.getAction() == Service.Action.DELETE && !op.hasPragmaDirective("xn-no-index-update");
    }

    public static boolean isServiceAvailable(Service s) {
        return s != null && s.getProcessingStage() == Service.ProcessingStage.AVAILABLE;
    }

    public static boolean isForServiceNamespace(Service s, Operation op) {
        return s.hasOption(Service.ServiceOption.URI_NAMESPACE_OWNER) && !op.getUri().getPath().equals(s.getSelfLink());
    }

    public static boolean isHelperServicePath(String serviceUriPath) {
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_REPLICATION)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_STATS)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_CONFIG)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_SUBSCRIPTIONS)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_TEMPLATE)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_UI)) {
            return true;
        }
        if (!serviceUriPath.startsWith("/user-interface/resources") && !serviceUriPath.startsWith("/core/ui") && serviceUriPath.indexOf("/ui/") > 0) {
            return true;
        }
        return serviceUriPath.endsWith(SERVICE_URI_SUFFIX_AVAILABLE);
    }

    public ServiceHost toggleDebuggingMode(boolean enable) {
        Level newLevel = enable ? Level.FINE : Level.INFO;
        this.setLoggingLevel(newLevel);
        this.setOperationTimeOutMicros(enable ? TimeUnit.MINUTES.toMicros(10L) : ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS);
        return this;
    }

    public ServiceHost setLoggingLevel(Level newLevel) {
        this.logger.setLevel(newLevel);
        for (Handler h : this.logger.getParent().getHandlers()) {
            h.setLevel(newLevel);
        }
        return this;
    }

    public ServiceHost setOperationTracingLevel(Level newLevel) {
        this.state.operationTracingLevel = newLevel.toString();
        return this;
    }

    public Level getOperationTracingLevel() {
        return this.state.operationTracingLevel == null ? Level.OFF : Level.parse(this.state.operationTracingLevel);
    }

    public void log(Level level, String fmt, Object ... args) {
        this.log(level, 3, () -> String.format(fmt, args));
    }

    public void log(Level level, Supplier<String> messageSupplier) {
        this.log(level, 3, messageSupplier);
    }

    protected void log(Level level, Integer nestingLevel, String fmt, Object ... args) {
        if (this.logPrefix == null) {
            this.logPrefix = this.getPublicUri().toString();
        }
        Utils.log(this.logger, nestingLevel, this.logPrefix, level, () -> String.format(fmt, args));
    }

    protected void log(Level level, Integer nestingLevel, Supplier<String> messageSupplier) {
        if (this.logPrefix == null) {
            this.logPrefix = this.getPublicUri().toString();
        }
        Utils.log(this.logger, nestingLevel, this.logPrefix, level, messageSupplier);
    }

    public void registerForServiceAvailability(Operation.CompletionHandler completion, String ... servicePaths) {
        this.registerForServiceAvailability(completion, "/core/node-selectors/default", false, servicePaths);
    }

    public void registerForServiceAvailability(Operation.CompletionHandler completion, boolean checkReplica, String ... servicePaths) {
        this.registerForServiceAvailability(completion, "/core/node-selectors/default", checkReplica, servicePaths);
    }

    public void registerForServiceAvailability(Operation.CompletionHandler completion, String nodeSelectorPath, boolean checkReplica, String ... servicePaths) {
        if (servicePaths == null || servicePaths.length == 0) {
            throw new IllegalArgumentException("selfLinks are required");
        }
        Operation op = Operation.createPost(null).setCompletion(completion).setExpiration(Utils.fromNowMicrosUtc(this.getOperationTimeoutMicros()));
        this.registerForServiceAvailability(op, checkReplica, nodeSelectorPath, servicePaths);
    }

    void registerForServiceAvailability(Operation opTemplate, String ... servicePaths) {
        this.registerForServiceAvailability(opTemplate, false, "/core/node-selectors/default", servicePaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForServiceAvailability(Operation opTemplate, boolean checkReplica, String nodeSelectorPath, String ... servicePaths) {
        boolean doOpClone = servicePaths.length > 1;
        String[] clonedLinks = Arrays.copyOf(servicePaths, servicePaths.length);
        ArrayList<String> replicatedServiceLinks = new ArrayList<String>();
        String[] stringArray = this.state;
        synchronized (this.state) {
            for (int i = 0; i < clonedLinks.length; ++i) {
                String link = clonedLinks[i];
                Service s = this.findService(link);
                if (s != null) {
                    if (checkReplica && s.hasOption(Service.ServiceOption.FACTORY) && s.hasOption(Service.ServiceOption.REPLICATION)) {
                        clonedLinks[i] = null;
                        replicatedServiceLinks.add(link);
                        continue;
                    }
                    if (s.getProcessingStage() == Service.ProcessingStage.AVAILABLE) continue;
                    this.operationTracker.trackServiceAvailableCompletion(link, opTemplate, doOpClone);
                } else {
                    Operation opTemplateClone = this.getOperationForServiceAvailability(opTemplate, link, doOpClone);
                    if (checkReplica) {
                        opTemplateClone.nestCompletion(op -> {
                            Service service = this.findService(op.getUri().getPath());
                            if (service != null && service.hasOption(Service.ServiceOption.FACTORY) && service.hasOption(Service.ServiceOption.REPLICATION)) {
                                this.run(() -> NodeGroupUtils.registerForReplicatedServiceAvailability(this, opTemplateClone, link, nodeSelectorPath));
                            } else {
                                opTemplateClone.complete();
                            }
                        });
                    }
                    this.operationTracker.trackServiceAvailableCompletion(link, opTemplateClone, false);
                }
                clonedLinks[i] = null;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            for (String link : clonedLinks) {
                if (link == null) continue;
                this.log(Level.INFO, "%s in stage %s, completing %d (%s)", new Object[]{link, this.getServiceStage(link), opTemplate.getId(), opTemplate.getContextId()});
                Operation opFinal = opTemplate;
                this.run(() -> {
                    Operation o = this.getOperationForServiceAvailability(opFinal, link, doOpClone);
                    o.complete();
                });
            }
            for (String link : replicatedServiceLinks) {
                Operation o = this.getOperationForServiceAvailability(opTemplate, link, doOpClone);
                this.run(() -> NodeGroupUtils.registerForReplicatedServiceAvailability(this, o, link, nodeSelectorPath));
            }
            return;
        }
    }

    private Operation getOperationForServiceAvailability(Operation op, String link, boolean doClone) {
        Operation o = op;
        if (doClone) {
            o = op.clone().setUri(UriUtils.buildUri(this, link));
        }
        if (o.getUri() == null) {
            o.setUri(UriUtils.buildUri(this, link));
        }
        return o;
    }

    boolean hasPendingServiceAvailableCompletions(String selfLink) {
        return this.operationTracker.hasPendingServiceAvailableCompletions(selfLink);
    }

    public ServiceHost setRequestRateLimit(String key, double operationsPerSecond) {
        RequestRateInfo ri = new RequestRateInfo();
        ri.limit = operationsPerSecond;
        ri.startTimeMicros = Utils.getSystemNowMicrosUtc();
        this.state.requestRateLimits.put(key, ri);
        return this;
    }

    public ServiceHost setServiceMemoryLimit(String servicePath, double percentOfTotal) {
        if (servicePath == null) {
            throw new IllegalArgumentException("servicePath is required");
        }
        if (!servicePath.equals(ROOT_PATH) && this.isStarted()) {
            throw new IllegalStateException("Service memory limit can only be changed before host start");
        }
        if (percentOfTotal >= 1.0 || percentOfTotal <= 0.0) {
            throw new IllegalArgumentException("percentOfTotal must be within 0.0 and 1.0 exclusive");
        }
        double total = percentOfTotal;
        for (Map.Entry<String, Double> e : this.state.relativeMemoryLimits.entrySet()) {
            if (e.getKey().equals(servicePath)) continue;
            total += e.getValue().doubleValue();
        }
        if (total >= 1.0) {
            throw new IllegalStateException("Total memory limit, across all services exceeds 1.0: " + Utils.toJsonHtml(this.state.relativeMemoryLimits));
        }
        this.state.relativeMemoryLimits.put(servicePath, percentOfTotal);
        return this;
    }

    public Long getServiceMemoryLimitMB(String servicePath, ServiceHostState.MemoryLimitType limitType) {
        Double limitAsPercentTotalMemory = this.state.relativeMemoryLimits.get(servicePath);
        if (limitAsPercentTotalMemory == null) {
            return null;
        }
        long maxMemoryMB = Runtime.getRuntime().maxMemory();
        long exactLimitMB = (long)((double)(maxMemoryMB /= 0x100000L) * limitAsPercentTotalMemory);
        switch (limitType) {
            case LOW_WATERMARK: {
                return exactLimitMB / 4L;
            }
            case HIGH_WATERMARK: {
                return exactLimitMB * 3L / 4L;
            }
        }
        return exactLimitMB;
    }

    public Service.ProcessingStage getServiceStage(String servicePath) {
        Service s = this.findService(servicePath);
        if (s == null) {
            return null;
        }
        return s.getProcessingStage();
    }

    public boolean checkServiceAvailable(String servicePath) {
        Service s = this.findService(servicePath, true);
        if (s == null) {
            return false;
        }
        return s.getProcessingStage() == Service.ProcessingStage.AVAILABLE;
    }

    public void checkReplicatedServiceAvailable(Operation.CompletionHandler ch, String servicePath) {
        this.checkReplicatedServiceAvailable(ch, servicePath, "/core/node-selectors/default");
    }

    public void checkReplicatedServiceAvailable(Operation.CompletionHandler ch, String servicePath, String nodeSelectorPath) {
        Service s = this.findService(servicePath, true);
        if (s == null) {
            ch.handle(null, new IllegalStateException("service not found"));
            return;
        }
        NodeGroupUtils.checkServiceAvailability(ch, s.getHost(), s.getSelfLink(), nodeSelectorPath);
    }

    public SystemHostInfo getSystemInfo() {
        if (!this.info.properties.isEmpty() && !this.info.ipAddresses.isEmpty()) {
            return Utils.clone(this.info);
        }
        return this.updateSystemInfo(true);
    }

    public SystemHostInfo updateSystemInfo(boolean enumerateNetworkInterfaces) {
        Runtime r = Runtime.getRuntime();
        this.info.availableProcessorCount = r.availableProcessors();
        this.info.freeMemoryByteCount = r.freeMemory();
        this.info.totalMemoryByteCount = r.totalMemory();
        this.info.maxMemoryByteCount = r.maxMemory();
        this.info.osName = Utils.getOsName(this.info);
        this.info.osFamily = Utils.determineOsFamily(this.info.osName);
        try {
            URI sandbox = this.getStorageSandbox();
            if (sandbox == null) {
                throw new RuntimeException("Sandbox not set");
            }
            File file = new File(sandbox);
            this.info.freeDiskByteCount = file.getFreeSpace();
            this.info.usableDiskByteCount = file.getUsableSpace();
            this.info.totalDiskByteCount = file.getTotalSpace();
        }
        catch (Throwable e) {
            this.log(Level.WARNING, "Exception getting disk usage: %s", Utils.toString(e));
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String k = entry.getKey().toString();
            String v = entry.getValue().toString();
            this.info.properties.put(k, v);
        }
        for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
            this.info.environmentVariables.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (!enumerateNetworkInterfaces) {
            return Utils.clone(this.info);
        }
        ArrayList<String> ipAddresses = new ArrayList<String>();
        ipAddresses.add("127.0.0.1");
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface ni = enumeration.nextElement();
                if (ni.isLoopback() || ni.isPointToPoint() || !ni.isUp()) continue;
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress addr = e.nextElement();
                    String host = Utils.getNormalizedHostAddress(this.info, addr);
                    ipAddresses.add(host);
                }
            }
            Collections.reverse(ipAddresses);
            if (this.state.bindAddress != null && !ALL_INTERFACES.equals(this.state.bindAddress)) {
                ipAddresses.remove(this.state.bindAddress);
                ipAddresses.add(0, this.state.bindAddress);
            }
            this.info.ipAddresses = ipAddresses;
        }
        catch (Throwable throwable) {
            this.log(Level.SEVERE, "Failure: %s", Utils.toString(throwable));
        }
        if (this.info.ipAddresses.isEmpty()) {
            this.log(Level.WARNING, "No IP or network interfaces detected. Adding loopback address", new Object[0]);
            this.info.ipAddresses.add("127.0.0.1");
        }
        return Utils.clone(this.info);
    }

    private boolean checkAndSetPreferredAddress(String address) {
        address = this.normalizeAddress(address);
        ArrayList<String> ipAddresses = new ArrayList<String>(this.info.ipAddresses);
        for (int i = 0; i < ipAddresses.size(); ++i) {
            if (!address.equals(ipAddresses.get(i))) continue;
            if (i == 0) break;
            String oldPreferred = (String)ipAddresses.get(0);
            ipAddresses.set(i, oldPreferred);
            ipAddresses.set(0, address);
            this.log(Level.INFO, "Swapped preferred address to %s from %s", address, oldPreferred);
            this.info.ipAddresses = ipAddresses;
            this.clearUriAndLogPrefix();
            return true;
        }
        return address.equals(ipAddresses.get(0));
    }

    private void clearUriAndLogPrefix() {
        this.cachedUri = null;
        this.logPrefix = null;
    }

    private String normalizeAddress(String address) {
        if (address.length() > 2 && address.startsWith("[") && address.endsWith("]")) {
            return address.substring(1, address.length() - 1);
        }
        return address;
    }

    public void run(Runnable task) {
        if (this.executor.isShutdown()) {
            throw new IllegalStateException("Stopped");
        }
        OperationContext origContext = OperationContext.getOperationContext();
        this.executor.execute(() -> {
            OperationContext.setFrom(origContext);
            this.executeRunnableSafe(task);
        });
    }

    public void run(ExecutorService executor, Runnable task) {
        if (executor == null || task == null) {
            throw new IllegalStateException("Valid executor/task must be provided");
        }
        if (executor.isShutdown()) {
            throw new IllegalStateException("Stopped");
        }
        OperationContext origContext = OperationContext.getOperationContext();
        executor.execute(() -> {
            OperationContext.setFrom(origContext);
            this.executeRunnableSafe(task);
        });
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        if (this.isStopping()) {
            throw new IllegalStateException("Stopped");
        }
        if (this.scheduledExecutor.isShutdown()) {
            throw new IllegalStateException("Stopped");
        }
        OperationContext origContext = OperationContext.getOperationContext();
        return this.scheduledExecutor.schedule(() -> {
            OperationContext.setFrom(origContext);
            this.executeRunnableSafe(task);
        }, delay, unit);
    }

    private void executeRunnableSafe(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "Unhandled exception executing task: %s", Utils.toString(e));
        }
    }

    private void scheduleMaintenance() {
        Runnable r = () -> {
            OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
            this.state.lastMaintenanceTimeUtcMicros = Utils.getSystemNowMicrosUtc();
            long deadline = this.state.lastMaintenanceTimeUtcMicros + this.state.maintenanceIntervalMicros;
            this.performMaintenanceStage(Operation.createPost(this.getUri()), MaintenanceStage.UTILS, deadline);
        };
        this.maintenanceTask = this.schedule(r, this.getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
    }

    void scheduleServiceMaintenance(Service s) {
        if (!s.hasOption(Service.ServiceOption.PERIODIC_MAINTENANCE)) {
            return;
        }
        this.serviceMaintTracker.schedule(s, Utils.getSystemNowMicrosUtc());
    }

    void performMaintenanceStage(Operation post, MaintenanceStage stage, long deadline) {
        try {
            long now = Utils.getSystemNowMicrosUtc();
            switch (stage) {
                case UTILS: {
                    Utils.performMaintenance();
                    stage = MaintenanceStage.MEMORY;
                    break;
                }
                case MEMORY: {
                    this.serviceResourceTracker.performMaintenance(now, deadline);
                    stage = MaintenanceStage.IO;
                    break;
                }
                case IO: {
                    this.performIOMaintenance(post, now, MaintenanceStage.NODE_SELECTORS, deadline);
                    return;
                }
                case NODE_SELECTORS: {
                    this.performNodeSelectorChangeMaintenance(post, now, MaintenanceStage.SERVICE, true, deadline);
                    return;
                }
                case SERVICE: {
                    this.serviceMaintTracker.performMaintenance(post, deadline);
                    stage = null;
                    break;
                }
                default: {
                    stage = null;
                }
            }
            if (stage == null) {
                this.managementService.adjustStat("hostMaintenanceCount", 1.0);
                post.complete();
                this.scheduleMaintenance();
                return;
            }
            this.performMaintenanceStage(post, stage, deadline);
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "Uncaught exception: %s", e.toString());
            post.fail(e);
        }
    }

    private void performNodeSelectorChangeMaintenance(Operation post, long now, MaintenanceStage nextStage, boolean isCheckRequired, long deadline) {
        this.serviceSynchTracker.performNodeSelectorChangeMaintenance(post, now, nextStage, isCheckRequired, deadline);
    }

    private void performIOMaintenance(Operation post, long now, MaintenanceStage nextStage, long deadline) {
        try {
            ServiceRequestListener sl;
            ServiceRequestListener l;
            this.performPendingOperationMaintenance();
            for (RequestRateInfo rri : this.state.requestRateLimits.values()) {
                if (now - rri.startTimeMicros < ONE_MINUTE_IN_MICROS) {
                    return;
                }
                rri.startTimeMicros = now;
                rri.count.set(0);
            }
            int expected = 0;
            ServiceClient c = this.getClient();
            if (c != null) {
                ++expected;
            }
            if ((l = this.getListener()) != null) {
                ++expected;
            }
            if ((sl = this.getSecureListener()) != null) {
                ++expected;
            }
            AtomicInteger pending = new AtomicInteger(expected);
            Operation.CompletionHandler ch = (o, e) -> {
                int r = pending.decrementAndGet();
                if (r != 0) {
                    return;
                }
                this.performMaintenanceStage(post, nextStage, deadline);
            };
            if (c != null) {
                c.handleMaintenance(Operation.createPost(null).setCompletion(ch));
            }
            if (l != null) {
                l.handleMaintenance(Operation.createPost(null).setCompletion(ch));
            }
            if (sl != null) {
                sl.handleMaintenance(Operation.createPost(null).setCompletion(ch));
            }
        }
        catch (Throwable e2) {
            this.log(Level.WARNING, "Exception: %s", Utils.toString(e2));
            this.performMaintenanceStage(post, nextStage, deadline);
        }
    }

    private void performPendingOperationMaintenance() {
        long now = Utils.getSystemNowMicrosUtc();
        this.operationTracker.performMaintenance(now);
    }

    public void resumeService(String path, Service resumedService) {
        this.serviceResourceTracker.resumeService(path, resumedService);
    }

    public ServiceHost setOperationTimeOutMicros(long timeoutMicros) {
        this.state.operationTimeoutMicros = timeoutMicros;
        return this;
    }

    public ServiceHost setServiceCacheClearDelayMicros(long delayMicros) {
        this.state.serviceCacheClearDelayMicros = delayMicros;
        return this;
    }

    public long getServiceCacheClearDelayMicros() {
        return this.state.serviceCacheClearDelayMicros;
    }

    public ServiceHost setProcessOwner(boolean isOwner) {
        this.state.isProcessOwner = isOwner;
        return this;
    }

    public boolean isProcessOwner() {
        return this.state.isProcessOwner;
    }

    public void setListener(ServiceRequestListener listener) {
        if (this.isStarted() || this.httpListener != null) {
            throw new IllegalStateException("Already started");
        }
        this.httpListener = listener;
    }

    public ServiceRequestListener getSecureListener() {
        return this.httpsListener;
    }

    public void setSecureListener(ServiceRequestListener listener) {
        if (this.isStarted() || this.httpsListener != null) {
            throw new IllegalStateException("Already started");
        }
        this.httpsListener = listener;
    }

    public ServiceRequestListener getListener() {
        return this.httpListener;
    }

    public ServiceClient getClient() {
        return this.client;
    }

    public void setClient(ServiceClient client) {
        this.client = client;
    }

    public long getMaintenanceIntervalMicros() {
        return this.state.maintenanceIntervalMicros;
    }

    void saveServiceState(Service s, Operation op, ServiceDocument state) {
        if (!op.isFromReplication()) {
            String string = state.documentAuthPrincipalLink = op.getAuthorizationContext() != null ? op.getAuthorizationContext().getClaims().getSubject() : null;
        }
        if (this.transactionService != null) {
            state.documentTransactionId = op.getTransactionId();
        }
        state.documentUpdateAction = op.getAction().name();
        if (!ServiceHost.isServiceIndexed(s)) {
            this.cacheServiceState(s, state, op);
            op.complete();
            return;
        }
        Service indexService = this.documentIndexService;
        UpdateIndexRequest body = new UpdateIndexRequest();
        body.document = state;
        body.description = this.buildDocumentDescription(s);
        body.serializedDocument = op.getLinkedSerializedState();
        op.linkSerializedState(null);
        if (!op.isFromReplication()) {
            this.cacheServiceState(s, state, op);
        }
        Operation post = Operation.createPost(indexService.getUri()).setBodyNoCloning(body).setCompletion((o, e) -> {
            if (op.getAction() == Service.Action.DELETE) {
                this.unmarkAsPendingDelete(s);
            }
            if (e != null) {
                this.serviceResourceTracker.clearCachedServiceState(s, null, op);
                op.fail(e);
                return;
            }
            op.complete();
        });
        indexService.handleRequest(post);
    }

    void selectServiceOwnerAndSynchState(Service s, Operation op, boolean isFactorySync) {
        this.serviceSynchTracker.selectServiceOwnerAndSynchState(s, op, isFactorySync);
    }

    NodeSelectorService findNodeSelectorService(String path, Operation request) {
        Service s;
        if (path == null) {
            path = "/core/node-selectors/default";
        }
        if ((s = this.findService(path)) == null) {
            request.fail(new ServiceNotFoundException());
            return null;
        }
        if (!(s instanceof NodeSelectorService)) {
            String msg = String.format("path '%s' (%s) is not a node selector service", path, s.getClass().getName());
            request.fail(new IllegalArgumentException(msg));
            return null;
        }
        return (NodeSelectorService)s;
    }

    public void broadcastRequest(String selectorPath, boolean excludeThisHost, Operation request) {
        this.broadcastRequest(selectorPath, null, excludeThisHost, request);
    }

    public void broadcastRequest(String selectorPath, String key, boolean excludeThisHost, Operation request) {
        if (this.isStopping()) {
            request.fail(new CancellationException());
            return;
        }
        if (selectorPath == null) {
            throw new IllegalArgumentException("selectorPath is required");
        }
        if (request == null) {
            throw new IllegalArgumentException("request is required");
        }
        this.prepareRequest(request);
        NodeSelectorService nss = this.findNodeSelectorService(selectorPath, request);
        if (nss == null) {
            return;
        }
        NodeSelectorService.SelectAndForwardRequest req = new NodeSelectorService.SelectAndForwardRequest();
        req.options = EnumSet.of(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.BROADCAST);
        if (excludeThisHost) {
            req.options.add(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.EXCLUDE_ENTRY_NODE);
        }
        req.key = key;
        req.targetPath = request.getUri().getPath();
        req.targetQuery = request.getUri().getQuery();
        nss.selectAndForward(request, req);
    }

    public void selectOwner(String selectorPath, String key, Operation op) {
        if (this.isStopping()) {
            op.fail(new CancellationException());
            return;
        }
        NodeSelectorService.SelectAndForwardRequest body = new NodeSelectorService.SelectAndForwardRequest();
        body.key = key;
        NodeSelectorService nss = this.findNodeSelectorService(selectorPath, op);
        if (nss == null) {
            return;
        }
        nss.selectAndForward(op, body);
    }

    public void forwardRequest(String groupPath, Operation request) {
        this.forwardRequest(groupPath, null, request);
    }

    public void forwardRequest(String selectorPath, String key, Operation request) {
        if (this.isStopping()) {
            request.fail(new CancellationException());
            return;
        }
        NodeSelectorService nss = this.findNodeSelectorService(selectorPath, request);
        if (nss == null) {
            return;
        }
        this.prepareRequest(request);
        NodeSelectorService.SelectAndForwardRequest body = new NodeSelectorService.SelectAndForwardRequest();
        body.targetPath = request.getUri().getPath();
        body.targetQuery = request.getUri().getQuery();
        body.key = key;
        body.options = EnumSet.of(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.UNICAST);
        nss.selectAndForward(request, body);
    }

    public void replicateRequest(EnumSet<Service.ServiceOption> serviceOptions, ServiceDocument state, String selectorPath, String selectionKey, Operation op) {
        if (this.isStopping()) {
            op.fail(new CancellationException());
            return;
        }
        if (state == null) {
            op.fail(new IllegalStateException("state is required"));
            return;
        }
        NodeSelectorService nss = this.findNodeSelectorService(selectorPath, op);
        if (nss == null) {
            return;
        }
        state.documentOwner = this.getId();
        NodeSelectorService.SelectAndForwardRequest req = new NodeSelectorService.SelectAndForwardRequest();
        req.key = selectionKey;
        req.targetPath = op.getUri().getPath();
        req.targetQuery = op.getUri().getQuery();
        req.options = EnumSet.of(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.BROADCAST, NodeSelectorService.SelectAndForwardRequest.ForwardingOption.REPLICATE);
        req.serviceOptions = serviceOptions;
        nss.selectAndForward(op, req);
    }

    public void queryServiceUris(String servicePath, Operation get) {
        ServiceDocumentQueryResult r = new ServiceDocumentQueryResult();
        boolean doPrefixMatch = servicePath.endsWith("*");
        servicePath = servicePath.replace("*", ROOT_PATH);
        for (Service s : this.attachedServices.values()) {
            if (s.getProcessingStage() != Service.ProcessingStage.AVAILABLE || s.hasOption(Service.ServiceOption.UTILITY)) continue;
            String path = s.getSelfLink();
            if (doPrefixMatch ? !path.startsWith(servicePath) : !path.equals(servicePath)) continue;
            r.documentLinks.add(path);
        }
        r.documentOwner = this.getId();
        get.setBodyNoCloning(r).complete();
    }

    public void queryServiceUris(EnumSet<Service.ServiceOption> options, boolean matchAllOptions, Operation get) {
        this.queryServiceUris(options, matchAllOptions, get, null);
    }

    public void queryServiceUris(EnumSet<Service.ServiceOption> options, boolean matchAllOptions, Operation get, EnumSet<Service.ServiceOption> exclusionOptions) {
        ServiceDocumentQueryResult r = new ServiceDocumentQueryResult();
        block0: for (Service s : this.attachedServices.values()) {
            if (s.getProcessingStage() != Service.ProcessingStage.AVAILABLE || s.hasOption(Service.ServiceOption.UTILITY)) continue;
            if (exclusionOptions != null) {
                for (Service.ServiceOption exOp : exclusionOptions) {
                    if (!s.hasOption(exOp)) continue;
                    continue block0;
                }
            }
            String servicePath = s.getSelfLink();
            if (matchAllOptions) {
                boolean hasAllOptions = true;
                for (Service.ServiceOption option : options) {
                    if (option == null || s.hasOption(option)) continue;
                    hasAllOptions = false;
                    break;
                }
                if (!hasAllOptions) continue;
                r.documentLinks.add(servicePath);
                continue;
            }
            for (Service.ServiceOption option : options) {
                if (option == null || !s.hasOption(option)) continue;
                r.documentLinks.add(servicePath);
                continue block0;
            }
        }
        r.documentOwner = this.getId();
        get.setBodyNoCloning(r).complete();
    }

    ServiceDocumentDescription buildDocumentDescription(String servicePath) {
        Service s = this.findService(servicePath);
        if (s == null) {
            return null;
        }
        return this.buildDocumentDescription(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceDocumentDescription buildDocumentDescription(Service s) {
        Class<? extends ServiceDocument> serviceStateClass = s.getStateType();
        if (serviceStateClass == null) {
            return null;
        }
        String serviceTypeName = s.getClass().getCanonicalName();
        Map<String, ServiceDocumentDescription> map = this.descriptionCache;
        synchronized (map) {
            ServiceDocumentDescription desc = this.descriptionCache.get(serviceTypeName);
            if (desc != null) {
                return desc;
            }
            desc = this.descriptionBuilder.buildDescription(serviceStateClass, s.getOptions(), RequestRouter.findRequestRouter(s.getOperationProcessingChain()));
            if (s.getOptions().contains((Object)Service.ServiceOption.IMMUTABLE)) {
                if (desc.versionRetentionLimit > 1000L) {
                    this.log(Level.WARNING, "Service %s has option %s, forcing retention limit", new Object[]{s.getSelfLink(), Service.ServiceOption.IMMUTABLE});
                }
                desc.versionRetentionLimit = Long.MIN_VALUE;
            }
            this.descriptionCache.put(serviceTypeName, desc);
            ServiceDocumentDescription augmentedDesc = s.getDocumentTemplate().documentDescription;
            if (augmentedDesc != null) {
                desc = augmentedDesc;
            }
            this.descriptionCache.put(serviceTypeName, desc);
            return desc;
        }
    }

    public URI getPublicUri() {
        if (this.state.publicUri == null) {
            return this.getUri();
        }
        return this.state.publicUri;
    }

    public URI getUri() {
        if (this.cachedUri == null) {
            boolean isSecureConnectionOnly = this.getCurrentHttpScheme() == HttpScheme.HTTPS_ONLY;
            String scheme = isSecureConnectionOnly ? "https" : "http";
            int port = isSecureConnectionOnly ? this.getSecurePort() : this.getPort();
            this.cachedUri = UriUtils.buildUri(scheme, this.getPreferredAddress(), port, ROOT_PATH, null);
        }
        return this.cachedUri;
    }

    public URI getSecureUri() {
        return UriUtils.buildUri("https", this.getUri().getHost(), this.getSecurePort(), ROOT_PATH, null);
    }

    public String getPreferredAddress() {
        if (this.info == null || this.info.ipAddresses == null || this.info.ipAddresses.isEmpty()) {
            return this.state.bindAddress == null ? "127.0.0.1" : this.state.bindAddress;
        }
        return this.info.ipAddresses.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestPayloadSizeLimit(int limit) {
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            if (this.isStarted()) {
                throw new IllegalStateException("Already started");
            }
            this.state.requestPayloadSizeLimit = limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponsePayloadSizeLimit(int limit) {
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            if (this.isStarted()) {
                throw new IllegalStateException("Already started");
            }
            this.state.responsePayloadSizeLimit = limit;
        }
    }

    protected Signer getTokenSigner() {
        return this.tokenSigner;
    }

    protected Verifier getTokenVerifier() {
        return this.tokenVerifier;
    }

    public void cacheAuthorizationContext(Service s, Operation.AuthorizationContext ctx) {
        this.cacheAuthorizationContext(s, ctx.getToken(), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheAuthorizationContext(Service s, String token, Operation.AuthorizationContext ctx) {
        if (!this.isPrivilegedService(s)) {
            throw new RuntimeException("Service not allowed to cache authorization token");
        }
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            this.authorizationContextCache.put(token, ctx);
            this.addUserToken(this.userLinktoTokenMap, ctx.getClaims().getSubject(), token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAuthorizationContext(Service s, String userLink) {
        if (!this.isPrivilegedService(s)) {
            throw new RuntimeException("Service not allowed to clear authorization token");
        }
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            Set<String> tokenSet = this.userLinktoTokenMap.remove(userLink);
            if (tokenSet != null) {
                for (String token : tokenSet) {
                    this.authorizationContextCache.remove(token);
                }
            }
        }
    }

    public Operation.AuthorizationContext getAuthorizationContext(Service s, String token) {
        if (!this.isPrivilegedService(s)) {
            throw new RuntimeException("Service not allowed to retrieve authorization token");
        }
        return this.authorizationContextCache.get(token);
    }

    private void populateAuthorizationContext(Operation op) {
        Operation.AuthorizationContext ctx = this.getAuthorizationContext(op);
        if (ctx == null) {
            ctx = this.getGuestAuthorizationContext();
        }
        op.setAuthorizationContext(ctx);
    }

    private Operation.AuthorizationContext createAuthorizationContext(String userLink) {
        String token;
        Claims.Builder cb = new Claims.Builder();
        cb.setIssuer("xn");
        cb.setSubject(userLink);
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        cb.setExpirationTime(TimeUnit.MILLISECONDS.toMicros(cal.getTimeInMillis()));
        Claims claims = (Claims)cb.getResult();
        try {
            token = this.getTokenSigner().sign(claims);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        Operation.AuthorizationContext.Builder ab = Operation.AuthorizationContext.Builder.create();
        ab.setClaims(claims);
        ab.setToken(token);
        ab.setPropagateToClient(false);
        return ab.getResult();
    }

    protected Operation.AuthorizationContext getSystemAuthorizationContext() {
        Operation.AuthorizationContext ctx = this.systemAuthorizationContext;
        if (ctx == null) {
            this.systemAuthorizationContext = ctx = this.createAuthorizationContext(SystemUserService.SELF_LINK);
        }
        return ctx;
    }

    protected Operation.AuthorizationContext getGuestAuthorizationContext() {
        Operation.AuthorizationContext ctx = this.guestAuthorizationContext;
        if (ctx == null) {
            this.guestAuthorizationContext = ctx = this.createAuthorizationContext(GuestUserService.SELF_LINK);
        }
        return ctx;
    }

    protected void addPrivilegedService(Class<? extends Service> serviceType) {
        this.privilegedServiceTypes.put(serviceType.getName(), serviceType);
    }

    protected boolean isPrivilegedService(Service service) {
        boolean result = false;
        for (Class<? extends Service> privilegedService : this.privilegedServiceTypes.values()) {
            if (!service.getClass().equals(privilegedService)) continue;
            result = true;
            break;
        }
        return result;
    }

    void scheduleServiceOptionToggleMaintenance(String path, EnumSet<Service.ServiceOption> newOptions, EnumSet<Service.ServiceOption> removedOptions) {
        Service s = this.findService(path);
        if (s == null || s.getProcessingStage() == Service.ProcessingStage.STOPPED) {
            return;
        }
        ServiceMaintenanceRequest body = ServiceMaintenanceRequest.create();
        body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.SERVICE_OPTION_TOGGLE);
        if (newOptions != null && newOptions.contains((Object)Service.ServiceOption.DOCUMENT_OWNER)) {
            body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE);
            s.adjustStat("maintenanceDocumentOwnerToggleOnCount", 1.0);
        }
        if (removedOptions != null && removedOptions.contains((Object)Service.ServiceOption.DOCUMENT_OWNER)) {
            body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE);
            s.adjustStat("maintenanceDocumentOwnerToggleOffCount", 1.0);
        }
        if (body.reasons.contains((Object)ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE)) {
            s.adjustStat("maintenanceForNodeGroupChangeCount", 1.0);
        }
        body.configUpdate = new ServiceConfigUpdateRequest();
        body.configUpdate.addOptions = newOptions;
        body.configUpdate.removeOptions = removedOptions;
        this.run(() -> {
            OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
            s.handleMaintenance(Operation.createPost(s.getUri()).setBody(body));
        });
    }

    protected HttpScheme getCurrentHttpScheme() {
        boolean isListeningHttps;
        boolean isListeningHttp = this.httpListener != null && this.httpListener.isListening();
        boolean bl = isListeningHttps = this.httpsListener != null && this.httpsListener.isListening();
        if (!isListeningHttp && !isListeningHttps) {
            return HttpScheme.NONE;
        }
        if (isListeningHttp && isListeningHttps) {
            return HttpScheme.HTTP_AND_HTTPS;
        }
        return isListeningHttp ? HttpScheme.HTTP_ONLY : HttpScheme.HTTPS_ONLY;
    }

    static enum MaintenanceStage {
        UTILS,
        MEMORY,
        IO,
        NODE_SELECTORS,
        SERVICE;

    }

    public static enum HttpScheme {
        HTTP_ONLY,
        HTTPS_ONLY,
        HTTP_AND_HTTPS,
        NONE;

    }

    public static class ServiceHostState
    extends ServiceDocument {
        public static final long DEFAULT_MAINTENANCE_INTERVAL_MICROS = TimeUnit.SECONDS.toMicros(1L);
        public static final long DEFAULT_OPERATION_TIMEOUT_MICROS = TimeUnit.SECONDS.toMicros(60L);
        public String bindAddress;
        public int httpPort;
        public int httpsPort;
        public URI publicUri;
        public long maintenanceIntervalMicros = DEFAULT_MAINTENANCE_INTERVAL_MICROS;
        public long operationTimeoutMicros = DEFAULT_OPERATION_TIMEOUT_MICROS;
        public long serviceCacheClearDelayMicros = DEFAULT_OPERATION_TIMEOUT_MICROS;
        public String operationTracingLevel;
        public SslClientAuthMode sslClientAuthMode;
        public int responsePayloadSizeLimit;
        public int requestPayloadSizeLimit;
        public URI storageSandboxFileReference;
        public URI resourceSandboxFileReference;
        public URI privateKeyFileReference;
        public String privateKeyPassphrase;
        public URI certificateFileReference;
        public URI documentIndexReference;
        public URI authorizationServiceReference;
        public URI transactionServiceReference;
        public String id;
        public boolean isPeerSynchronizationEnabled;
        public int peerSynchronizationTimeLimitSeconds;
        public boolean isAuthorizationEnabled;
        public transient boolean isStarted;
        public transient boolean isStopping;
        public SystemHostInfo systemInfo;
        public long lastMaintenanceTimeUtcMicros;
        public boolean isProcessOwner;
        public boolean isServiceStateCaching = true;
        public Properties codeProperties;
        public long serviceCount;
        public String location;
        public Map<String, Double> relativeMemoryLimits = new ConcurrentSkipListMap<String, Double>();
        public Map<String, RequestRateInfo> requestRateLimits = new ConcurrentSkipListMap<String, RequestRateInfo>();
        private transient TreeSet<String> operationTracingLinkExclusionList = new TreeSet<String>(Arrays.asList("/core/node-groups", "/core/ui/default", "/core/node-groups/default", "/core/node-selectors/default", "/core/document-index", "/core/operation-index", ServiceUriPaths.CORE_LOCAL_QUERY_TASKS, ServiceUriPaths.CORE_QUERY_TASKS));
        public String[] initialPeerNodes;

        public static enum SslClientAuthMode {
            NONE,
            WANT,
            NEED;

        }

        public static enum MemoryLimitType {
            LOW_WATERMARK,
            HIGH_WATERMARK,
            EXACT;

        }
    }

    public static class RequestRateInfo {
        public double limit;
        public AtomicInteger count = new AtomicInteger();
        public long startTimeMicros;
    }

    public static class Arguments {
        public int port = 8000;
        public int securePort = -1;
        public ServiceHostState.SslClientAuthMode sslClientAuthMode = ServiceHostState.SslClientAuthMode.NONE;
        public Path keyFile;
        public String keyPassphrase;
        public Path certificateFile;
        public Path sandbox = DEFAULT_SANDBOX;
        public String bindAddress = "127.0.0.1";
        public String publicUri;
        public String[] peerNodes;
        public String id;
        public int perFactoryPeerSynchronizationLimitSeconds = (int)TimeUnit.MINUTES.toSeconds(10L);
        public boolean isPeerSynchronizationEnabled = true;
        public boolean isAuthorizationEnabled = false;
        public Path resourceSandbox;
        public String location;
    }

    public static class ServiceNotFoundException
    extends IllegalStateException {
        private static final long serialVersionUID = 663670123267539178L;

        public ServiceNotFoundException() {
        }

        public ServiceNotFoundException(String servicePath) {
            super("Service not found: " + servicePath);
        }
    }

    public static class ServiceAlreadyStartedException
    extends IllegalStateException {
        private static final long serialVersionUID = -1444810129515584386L;

        public ServiceAlreadyStartedException(String servicePath) {
            super("Service already started: " + servicePath);
        }

        public ServiceAlreadyStartedException(String servicePath, Service.ProcessingStage stage) {
            super("Service already started: " + servicePath + " stage: " + (Object)((Object)stage));
        }
    }
}

