/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ODataFactoryQueryResult;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;

public final class QueryResultsProcessor {
    private final QueryTask task;
    private final ServiceDocumentQueryResult results;

    private QueryResultsProcessor(QueryTask task, ServiceDocumentQueryResult results) {
        this.task = task;
        this.results = results;
    }

    public static QueryResultsProcessor create(QueryTask task) {
        return new QueryResultsProcessor(task, task.results);
    }

    public static QueryResultsProcessor create(ServiceDocumentQueryResult results) {
        return new QueryResultsProcessor(null, results);
    }

    public static QueryResultsProcessor create(Operation op) {
        QueryTask task = op.getBody(QueryTask.class);
        if (Objects.equals(task.documentKind, QueryTask.KIND)) {
            ServiceDocumentQueryResult r = op.getBody(ServiceDocumentQueryResult.class);
            if (Objects.equals(task.documentKind, ODataFactoryQueryResult.KIND) || Objects.equals(task.documentKind, ServiceDocumentQueryResult.KIND)) {
                return new QueryResultsProcessor(null, r);
            }
            throw new IllegalArgumentException("Cannot create QueryResultsProcessor from a " + r.documentKind + " document");
        }
        return new QueryResultsProcessor(task, task.results);
    }

    public QueryTask getQueryTask() {
        return this.task;
    }

    public ServiceDocumentQueryResult getQueryResult() {
        return this.results;
    }

    public <T extends ServiceDocument> T selectedDocument(String selfLink, Class<T> type) {
        if (this.results == null || this.results.selectedDocuments == null) {
            return null;
        }
        Object o = this.results.selectedDocuments.get(selfLink);
        return this.convert(type, o);
    }

    public <T extends ServiceDocument> T document(String selfLink, Class<T> type) {
        if (this.results == null || this.results.documents == null) {
            return null;
        }
        Object o = this.results.documents.get(selfLink);
        return this.convert(type, o);
    }

    public <T extends ServiceDocument> Iterable<T> selectedDocuments(Class<T> type) {
        if (this.results == null || this.results.selectedDocuments == null) {
            return Collections.emptyList();
        }
        Stream<ServiceDocument> stream = this.results.selectedDocuments.values().stream().map(o -> this.convert(type, o));
        return stream::iterator;
    }

    public Iterable<String> selectedLinks() {
        if (this.results == null || this.results.selectedLinks == null) {
            return Collections.emptyList();
        }
        return this.results.selectedLinks;
    }

    public Iterable<String> documentLinks() {
        if (this.results == null || this.results.documentLinks == null) {
            return Collections.emptyList();
        }
        return this.results.documentLinks;
    }

    public <T extends ServiceDocument> Iterable<T> documents(Class<T> type) {
        if (this.results == null || this.results.documents == null) {
            return Collections.emptyList();
        }
        Stream<ServiceDocument> stream = this.results.documents.values().stream().map(o -> this.convert(type, o));
        return stream::iterator;
    }

    private <T extends ServiceDocument> T convert(Class<T> type, Object o) {
        if (o == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return (T)((ServiceDocument)type.cast(o));
        }
        if (o instanceof String) {
            return (T)((ServiceDocument)Utils.fromJson((String)o, type));
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to %s", o.getClass().getName(), type.getName()));
    }
}

