/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.QueryTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class QueryTaskUtils {
    private static final int MAX_NEST_LEVEL_EXPAND_PROPERTY = 2;

    private static ServiceDocumentQueryResult mergeCountQueries(List<ServiceDocumentQueryResult> dataSources, ServiceDocumentQueryResult result) {
        long highestCount = 0L;
        for (int i = 0; i < dataSources.size(); ++i) {
            ServiceDocumentQueryResult dataSource = dataSources.get(i);
            if (dataSource.documentLinks != null && !dataSource.documentLinks.isEmpty() || dataSource.documents != null && !dataSource.documents.isEmpty() || dataSource.documentCount == null || dataSource.documentCount <= 0L || highestCount >= dataSource.documentCount) continue;
            highestCount = dataSource.documentCount;
        }
        result.documentCount = highestCount;
        result.documentLinks = Collections.emptyList();
        return result;
    }

    public static ServiceDocumentQueryResult mergeQueryResults(List<ServiceDocumentQueryResult> dataSources, boolean isAscOrder) {
        return QueryTaskUtils.mergeQueryResults(dataSources, isAscOrder, EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class));
    }

    public static ServiceDocumentQueryResult mergeQueryResults(List<ServiceDocumentQueryResult> dataSources, boolean isAscOrder, EnumSet<QueryTask.QuerySpecification.QueryOption> queryOptions) {
        ServiceDocumentQueryResult result = new ServiceDocumentQueryResult();
        result.documents = new HashMap<String, Object>();
        result.documentCount = 0L;
        if (queryOptions != null && queryOptions.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
            return QueryTaskUtils.mergeCountQueries(dataSources, result);
        }
        int[] indices = new int[dataSources.size()];
        block0: while (true) {
            String documentLinkPicked = null;
            ArrayList<Integer> sourcesPicked = new ArrayList<Integer>();
            for (int i = 0; i < dataSources.size(); ++i) {
                if ((long)indices[i] >= dataSources.get((int)i).documentCount || dataSources.get((int)i).documentLinks.isEmpty()) continue;
                String documentLink = dataSources.get((int)i).documentLinks.get(indices[i]);
                if (documentLinkPicked == null) {
                    documentLinkPicked = documentLink;
                    sourcesPicked.add(i);
                    continue;
                }
                if (isAscOrder && documentLink.compareTo(documentLinkPicked) < 0 || !isAscOrder && documentLink.compareTo(documentLinkPicked) > 0) {
                    documentLinkPicked = documentLink;
                    sourcesPicked.clear();
                    sourcesPicked.add(i);
                    continue;
                }
                if (!documentLink.equals(documentLinkPicked)) continue;
                sourcesPicked.add(i);
            }
            if (documentLinkPicked == null) break;
            result.documentLinks.add(documentLinkPicked);
            ServiceDocumentQueryResult partialResult = dataSources.get((Integer)sourcesPicked.get(0));
            if (partialResult.documents != null) {
                result.documents.put(documentLinkPicked, partialResult.documents.get(documentLinkPicked));
            }
            Object object = result;
            Long l = ((ServiceDocumentQueryResult)object).documentCount;
            Long l2 = ((ServiceDocumentQueryResult)object).documentCount = Long.valueOf(((ServiceDocumentQueryResult)object).documentCount + 1L);
            object = sourcesPicked.iterator();
            while (true) {
                int i;
                if (!object.hasNext()) continue block0;
                int n = i = ((Integer)object.next()).intValue();
                indices[n] = indices[n] + 1;
            }
            break;
        }
        return result;
    }

    public static void expandLinks(ServiceHost host, QueryTask task, Operation op) {
        ServiceDocumentQueryResult result = task.results;
        if (!task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_LINKS) || result == null || result.selectedLinksPerDocument == null || result.selectedLinksPerDocument.isEmpty()) {
            op.setBodyNoCloning(task).complete();
            return;
        }
        ConcurrentSkipListMap<String, String> uniqueLinkToState = new ConcurrentSkipListMap<String, String>();
        for (Map<String, String> selectedLinksPerDocument : result.selectedLinksPerDocument.values()) {
            for (Map.Entry<String, String> en : selectedLinksPerDocument.entrySet()) {
                uniqueLinkToState.put(en.getValue(), "");
            }
        }
        if (uniqueLinkToState.isEmpty()) {
            op.setBodyNoCloning(task).complete();
            return;
        }
        AtomicInteger remaining = new AtomicInteger(uniqueLinkToState.size());
        Operation.CompletionHandler c = (o, e) -> {
            String link = o.getUri().getPath();
            if (e != null) {
                host.log(Level.WARNING, "Failure retrieving link %s: %s", link, e.toString());
            }
            Object body = o.getBodyRaw();
            uniqueLinkToState.put(link, (String)body);
            int r = remaining.decrementAndGet();
            if (r != 0) {
                return;
            }
            result.selectedDocuments = uniqueLinkToState;
            op.setBodyNoCloning(task).complete();
        };
        for (String link : uniqueLinkToState.keySet()) {
            Operation get = Operation.createGet(UriUtils.buildUri(op.getUri(), link)).setCompletion(c).transferRefererFrom(op);
            host.sendRequest(get);
        }
    }

    public static Set<String> getExpandedQueryPropertyNames(ServiceDocumentDescription description) {
        if (description == null) {
            throw new IllegalArgumentException("description is required");
        }
        return QueryTaskUtils.getExpandedQueryPropertyNames(description.propertyDescriptions, 2);
    }

    private static Set<String> getExpandedQueryPropertyNames(Map<String, ServiceDocumentDescription.PropertyDescription> propertyDescriptions, int complexFieldNestLevel) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, ServiceDocumentDescription.PropertyDescription> entry : propertyDescriptions.entrySet()) {
            result.addAll(QueryTaskUtils.getExpandedQueryPropertyNames(entry.getKey(), entry.getValue(), complexFieldNestLevel));
        }
        return result;
    }

    private static Set<String> getExpandedQueryPropertyNames(String propertyName, ServiceDocumentDescription.PropertyDescription pd, int complexFieldNestLevel) {
        if (pd.indexingOptions != null && pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.STORE_ONLY) || pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.INFRASTRUCTURE)) {
            return Collections.emptySet();
        }
        if (pd.typeName == ServiceDocumentDescription.TypeName.PODO && pd.fieldDescriptions != null) {
            if (complexFieldNestLevel > 0) {
                Set<String> innerPropertyNames = QueryTaskUtils.getExpandedQueryPropertyNames(pd.fieldDescriptions, complexFieldNestLevel - 1);
                return innerPropertyNames.stream().map(p -> QueryTask.QuerySpecification.buildCompositeFieldName(propertyName, p)).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
        if (pd.typeName == ServiceDocumentDescription.TypeName.COLLECTION) {
            if (complexFieldNestLevel > 0) {
                Set<String> innerPropertyNames = QueryTaskUtils.getExpandedQueryPropertyNames("item", pd.elementDescription, complexFieldNestLevel - 1);
                return innerPropertyNames.stream().map(p -> QueryTask.QuerySpecification.buildCompositeFieldName(propertyName, p)).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
        return Collections.singleton(propertyName);
    }
}

