/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.QueryFilterUtils;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.RoundRobinOperationQueue;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.serialization.KryoSerializers;
import com.vmware.xenon.services.common.LuceneQueryConverter;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.QueryPageService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.SystemUserService;
import com.vmware.xenon.services.common.UpdateIndexRequest;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexUpgrader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.GroupingSearch;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.Version;

public class LuceneDocumentIndexService
extends StatelessService {
    public static String SELF_LINK = "/core/document-index";
    public static final String FILE_PATH_LUCENE = "lucene";
    public static final int DEFAULT_INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH = 10000;
    public static final int DEFAULT_INDEX_SEARCHER_COUNT_THRESHOLD = 200;
    private String indexDirectory;
    private static int EXPIRED_DOCUMENT_SEARCH_THRESHOLD = 1000;
    private static int INDEX_SEARCHER_COUNT_THRESHOLD = 200;
    private static int INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH = 10000;
    private static final String LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE = "binarySerializedState";
    private static final String LUCENE_FIELD_NAME_JSON_SERIALIZED_STATE = "jsonSerializedState";
    public static final String STAT_NAME_ACTIVE_QUERY_FILTERS = "activeQueryFilterCount";
    public static final String STAT_NAME_ACTIVE_PAGINATED_QUERIES = "activePaginatedQueryCount";
    public static final String STAT_NAME_COMMIT_COUNT = "commitCount";
    public static final String STAT_NAME_INDEX_LOAD_RETRY_COUNT = "indexLoadRetryCount";
    public static final String STAT_NAME_COMMIT_DURATION_MICROS = "commitDurationMicros";
    public static final String STAT_NAME_GROUP_QUERY_COUNT = "groupQueryCount";
    public static final String STAT_NAME_QUERY_DURATION_MICROS = "queryDurationMicros";
    public static final String STAT_NAME_GROUP_QUERY_DURATION_MICROS = "groupQueryDurationMicros";
    public static final String STAT_NAME_QUERY_SINGLE_DURATION_MICROS = "querySingleDurationMicros";
    public static final String STAT_NAME_QUERY_ALL_VERSIONS_DURATION_MICROS = "queryAllVersionsDurationMicros";
    public static final String STAT_NAME_RESULT_PROCESSING_DURATION_MICROS = "resultProcessingDurationMicros";
    public static final String STAT_NAME_INDEXED_FIELD_COUNT = "indexedFieldCount";
    public static final String STAT_NAME_INDEXED_DOCUMENT_COUNT = "indexedDocumentCount";
    public static final String STAT_NAME_FIELD_COUNT_PER_DOCUMENT = "fieldCountPerDocument";
    public static final String STAT_NAME_INDEXING_DURATION_MICROS = "indexingDurationMicros";
    public static final String STAT_NAME_SEARCHER_UPDATE_COUNT = "indexSearcherUpdateCount";
    private static final String STAT_NAME_WRITER_ALREADY_CLOSED_EXCEPTION_COUNT = "indexWriterAlreadyClosedFailureCount";
    public static final String STAT_NAME_SERVICE_DELETE_COUNT = "serviceDeleteCount";
    public static final String STAT_NAME_DOCUMENT_EXPIRATION_COUNT = "expiredDocumentCount";
    public static final String STAT_NAME_DOCUMENT_EXPIRATION_FORCED_MAINTENANCE_COUNT = "expiredDocumentForcedMaintenanceCount";
    static final String[] TIME_SERIES_ENABLED_STATS = new String[]{"activeQueryFilterCount", "activePaginatedQueryCount", "commitCount", "commitDurationMicros", "groupQueryCount", "queryDurationMicros", "groupQueryDurationMicros", "querySingleDurationMicros", "queryAllVersionsDurationMicros", "resultProcessingDurationMicros", "indexedFieldCount", "indexedDocumentCount", "indexingDurationMicros", "indexSearcherUpdateCount", "serviceDeleteCount", "expiredDocumentCount", "expiredDocumentForcedMaintenanceCount"};
    protected static final int UPDATE_THREAD_COUNT = Utils.DEFAULT_THREAD_COUNT / 2;
    protected static final int QUERY_THREAD_COUNT = Utils.DEFAULT_THREAD_COUNT;
    protected Object searchSync;
    protected Queue<IndexSearcher> searchersPendingClose = new ConcurrentLinkedQueue<IndexSearcher>();
    protected TreeMap<Long, List<IndexSearcher>> searchersForPaginatedQueries = new TreeMap();
    protected IndexSearcher searcher = null;
    protected IndexWriter writer = null;
    protected final Semaphore writerAvailable = new Semaphore(UPDATE_THREAD_COUNT + QUERY_THREAD_COUNT);
    protected Map<String, QueryTask> activeQueries = new ConcurrentSkipListMap<String, QueryTask>();
    private long searcherUpdateTimeMicros;
    private long indexUpdateTimeMicros;
    private long indexWriterCreationTimeMicros;
    private final Map<String, Long> linkAccessTimes = new HashMap<String, Long>();
    private final Map<String, Long> linkDocumentRetentionEstimates = new HashMap<String, Long>();
    private long linkAccessMemoryLimitMB;
    private Sort versionSort;
    private ExecutorService privateIndexingExecutor;
    private ExecutorService privateQueryExecutor;
    private Set<String> fieldsToLoadNoExpand;
    private Set<String> fieldsToLoadWithExpand;
    private RoundRobinOperationQueue queryQueue = RoundRobinOperationQueue.create();
    private RoundRobinOperationQueue updateQueue = RoundRobinOperationQueue.create();
    private URI uri;

    public static void setSearcherCountThreshold(int count) {
        INDEX_SEARCHER_COUNT_THRESHOLD = count;
    }

    public static void setIndexFileCountThresholdForWriterRefresh(int count) {
        INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH = count;
    }

    public static int getIndexFileCountThresholdForWriterRefresh() {
        return INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH;
    }

    public static void setExpiredDocumentSearchThreshold(int count) {
        EXPIRED_DOCUMENT_SEARCH_THRESHOLD = count;
    }

    public static int getExpiredDocumentSearchThreshold() {
        return EXPIRED_DOCUMENT_SEARCH_THRESHOLD;
    }

    public LuceneDocumentIndexService() {
        this(FILE_PATH_LUCENE);
    }

    public LuceneDocumentIndexService(String indexDirectory) {
        super(ServiceDocument.class);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        this.indexDirectory = indexDirectory;
    }

    @Override
    public void handleStart(Operation post) {
        super.setMaintenanceIntervalMicros(this.getHost().getMaintenanceIntervalMicros() * 5L);
        this.uri = super.getUri();
        File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
        this.privateQueryExecutor = Executors.newFixedThreadPool(QUERY_THREAD_COUNT, r -> new Thread(r, this.getUri() + "/queries/" + Utils.getNowMicrosUtc()));
        this.privateIndexingExecutor = Executors.newFixedThreadPool(UPDATE_THREAD_COUNT, r -> new Thread(r, this.getSelfLink() + "/updates/" + Utils.getNowMicrosUtc()));
        this.initializeInstance();
        for (int retryCount = 0; retryCount < 2; ++retryCount) {
            try {
                this.createWriter(directory, true);
                this.doSelfValidationQuery();
                if (retryCount != 1) break;
                this.logInfo("Retry to create index writer was successful", new Object[0]);
                break;
            }
            catch (Throwable e) {
                this.adjustStat(STAT_NAME_INDEX_LOAD_RETRY_COUNT, 1.0);
                if (retryCount >= 1) {
                    this.logWarning("Failure creating index writer: %s", Utils.toString(e));
                    post.fail(e);
                    return;
                }
                this.logWarning("Failure creating index writer, will retry", new Object[0]);
                this.close(this.writer);
                this.archiveCorruptIndexFiles(directory);
                continue;
            }
        }
        this.initializeStats();
        post.complete();
    }

    private void initializeInstance() {
        this.searchSync = new Object();
        this.searcher = null;
        this.searchersForPaginatedQueries.clear();
        this.searchersPendingClose.clear();
        this.versionSort = new Sort((SortField)new SortedNumericSortField("documentVersion", SortField.Type.LONG, true));
        this.fieldsToLoadNoExpand = new HashSet<String>();
        this.fieldsToLoadNoExpand.add("documentSelfLink");
        this.fieldsToLoadNoExpand.add("documentVersion");
        this.fieldsToLoadNoExpand.add("documentUpdateTimeMicros");
        this.fieldsToLoadNoExpand.add("documentUpdateAction");
        this.fieldsToLoadNoExpand.add("documentExpirationTimeMicros");
        this.fieldsToLoadWithExpand = new HashSet<String>(this.fieldsToLoadNoExpand);
        this.fieldsToLoadWithExpand.add(LUCENE_FIELD_NAME_JSON_SERIALIZED_STATE);
        this.fieldsToLoadWithExpand.add(LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE);
    }

    private void initializeStats() {
        IndexWriter w = this.writer;
        for (String name : TIME_SERIES_ENABLED_STATS) {
            if (STAT_NAME_INDEXED_DOCUMENT_COUNT.equals(name)) {
                this.createTimeSeriesStat(STAT_NAME_INDEXED_DOCUMENT_COUNT, w != null ? (double)w.numDocs() : 0.0);
                continue;
            }
            if (STAT_NAME_INDEXED_FIELD_COUNT.equals(name)) {
                this.createTimeSeriesStat(STAT_NAME_INDEXED_FIELD_COUNT, w != null ? (double)(w.numDocs() * 10) : 0.0);
                continue;
            }
            this.createTimeSeriesStat(name, 0.0);
        }
    }

    private void createTimeSeriesStat(String name, double v) {
        this.createDayTimeSeriesStat(name, v);
        this.createHourTimeSeriesStat(name, v);
    }

    private void createDayTimeSeriesStat(String name, double v) {
        ServiceStats.ServiceStat st = new ServiceStats.ServiceStat();
        st.name = name + "PerDay";
        st.timeSeriesStats = new ServiceStats.TimeSeriesStats((int)TimeUnit.DAYS.toHours(1L), TimeUnit.HOURS.toMillis(1L), EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.AVG));
        super.setStat(st, v);
    }

    private void createHourTimeSeriesStat(String name, double v) {
        ServiceStats.ServiceStat st = new ServiceStats.ServiceStat();
        st.name = name + "PerHour";
        st.timeSeriesStats = new ServiceStats.TimeSeriesStats((int)TimeUnit.HOURS.toMinutes(1L), TimeUnit.MINUTES.toMillis(1L), EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.AVG));
        super.setStat(st, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter createWriter(File directory, boolean doUpgrade) throws Exception {
        SimpleAnalyzer analyzer = new SimpleAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
        Long totalMBs = this.getHost().getServiceMemoryLimitMB(this.getSelfLink(), ServiceHost.ServiceHostState.MemoryLimitType.EXACT);
        if (totalMBs != null) {
            long cacheSizeMB = totalMBs * 3L / 4L;
            cacheSizeMB = Math.max(1L, cacheSizeMB);
            iwc.setRAMBufferSizeMB((double)cacheSizeMB);
            this.linkAccessMemoryLimitMB = totalMBs / 4L;
        }
        FSDirectory dir = MMapDirectory.open((Path)directory.toPath());
        if (doUpgrade && DirectoryReader.indexExists((Directory)dir)) {
            this.upgradeIndex((Directory)dir);
        }
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        iwc.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        w.commit();
        Object object = this.searchSync;
        synchronized (object) {
            this.writer = w;
            this.linkAccessTimes.clear();
            this.indexWriterCreationTimeMicros = this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
        }
        return this.writer;
    }

    private void upgradeIndex(Directory dir) throws IOException {
        boolean doUpgrade = false;
        String lastSegmentsFile = SegmentInfos.getLastCommitSegmentsFileName((String[])dir.listAll());
        SegmentInfos sis = SegmentInfos.readCommit((Directory)dir, (String)lastSegmentsFile);
        for (SegmentCommitInfo commit : sis) {
            if (commit.info.getVersion().equals((Object)Version.LATEST)) continue;
            this.logInfo("Found Index version %s", commit.info.getVersion().toString());
            doUpgrade = true;
            break;
        }
        if (doUpgrade) {
            this.logInfo("Upgrading index to %s", Version.LATEST.toString());
            IndexWriterConfig iwc = new IndexWriterConfig(null);
            new IndexUpgrader(dir, iwc, false).upgrade();
            this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
        }
    }

    private void archiveCorruptIndexFiles(File directory) {
        File newDirectory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory + "." + Utils.getNowMicrosUtc());
        try {
            Files.createDirectory(newDirectory.toPath(), new FileAttribute[0]);
            FileUtils.moveOrDeleteFiles(directory, newDirectory, false);
        }
        catch (IOException e) {
            this.logWarning(e.toString(), new Object[0]);
        }
    }

    private void doSelfValidationQuery() throws Throwable {
        TermQuery tq = new TermQuery(new Term("documentSelfLink", this.getSelfLink()));
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        Operation op = Operation.createGet(this.getUri());
        EnumSet<QueryTask.QuerySpecification.QueryOption> options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        IndexSearcher s = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.writer, (boolean)true, (boolean)true));
        this.queryIndex(op, options, s, (Query)tq, null, Integer.MAX_VALUE, 0L, null, rsp, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleBackup(Operation op, BackupRequest req) throws Throwable {
        IndexWriter w;
        block6: {
            SnapshotDeletionPolicy snapshotter = null;
            IndexCommit commit = null;
            this.handleMaintenanceImpl(true);
            w = this.writer;
            if (w == null) {
                op.fail(new CancellationException());
                return;
            }
            try {
                snapshotter = (SnapshotDeletionPolicy)w.getConfig().getIndexDeletionPolicy();
                commit = snapshotter.snapshot();
                String indexDirectory = UriUtils.buildUriPath(this.getHost().getStorageSandbox().getPath(), this.indexDirectory);
                List<URI> fileList = FileUtils.filesToUris(indexDirectory, commit.getFileNames());
                req.backupFile = FileUtils.zipFiles(fileList, this.indexDirectory + "-" + Utils.getNowMicrosUtc());
                op.setBody(req).complete();
                if (snapshotter == null) break block6;
            }
            catch (Exception e) {
                try {
                    this.logSevere(e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (snapshotter != null) {
                        snapshotter.release(commit);
                    }
                    w.deleteUnusedFiles();
                    throw throwable;
                }
            }
            snapshotter.release(commit);
        }
        w.deleteUnusedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRestore(Operation op, RestoreRequest req) {
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException());
            return;
        }
        int semaphoreCount = QUERY_THREAD_COUNT + UPDATE_THREAD_COUNT - 1;
        try {
            File[] files;
            this.writerAvailable.acquire(semaphoreCount);
            this.close(w);
            File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
            if (directory.exists() && (files = directory.listFiles()) != null && files.length > 0) {
                this.logInfo("archiving existing index %s", directory);
                this.archiveCorruptIndexFiles(directory);
            }
            this.logInfo("restoring index %s from %s md5sum(%s)", directory, req.backupFile, FileUtils.md5sum(new File(req.backupFile)));
            FileUtils.extractZipArchive(new File(req.backupFile), directory.toPath());
            this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
            this.createWriter(directory, true);
            op.complete();
            this.logInfo("restore complete", new Object[0]);
        }
        catch (Throwable e) {
            this.logSevere(e);
            op.fail(e);
        }
        finally {
            this.writerAvailable.release(semaphoreCount);
        }
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        Service.Action a = op.getAction();
        if (a == Service.Action.PUT) {
            this.getHost().failRequestActionNotSupported(op);
            return;
        }
        if (a == Service.Action.PATCH && op.isRemote()) {
            this.getHost().failRequestActionNotSupported(op);
            return;
        }
        try {
            if (a == Service.Action.GET || a == Service.Action.PATCH) {
                if (this.offerQueryOperation(op)) {
                    this.privateQueryExecutor.execute(this::handleQueryRequest);
                }
            } else if (this.offerUpdateOperation(op)) {
                this.privateIndexingExecutor.execute(this::handleUpdateRequest);
            }
        }
        catch (RejectedExecutionException e) {
            op.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryRequest() {
        Operation op = this.pollQueryOperation();
        try {
            this.writerAvailable.acquire();
            while (op != null) {
                switch (op.getAction()) {
                    case GET: {
                        this.handleGetImpl(op);
                        break;
                    }
                    case PATCH: {
                        ServiceDocument sd = (ServiceDocument)op.getBodyRaw();
                        if (sd.documentKind != null) {
                            ServiceDocument backupRequest;
                            if (sd.documentKind.equals(QueryTask.KIND)) {
                                QueryTask task = (QueryTask)op.getBodyRaw();
                                this.handleQueryTaskPatch(op, task);
                                break;
                            }
                            if (sd.documentKind.equals(BackupRequest.KIND)) {
                                backupRequest = (BackupRequest)op.getBodyRaw();
                                this.handleBackup(op, (BackupRequest)backupRequest);
                                break;
                            }
                            if (sd.documentKind.equals(RestoreRequest.KIND)) {
                                backupRequest = (RestoreRequest)op.getBodyRaw();
                                this.handleRestore(op, (RestoreRequest)backupRequest);
                                break;
                            }
                        }
                        this.getHost().failRequestActionNotSupported(op);
                        break;
                    }
                }
                op = this.pollQueryOperation();
            }
        }
        catch (Throwable e) {
            this.checkFailureAndRecover(e);
            if (op != null) {
                op.fail(e);
            }
        }
        finally {
            this.writerAvailable.release();
        }
    }

    private void handleUpdateRequest() {
        Operation op = this.pollUpdateOperation();
        try {
            this.writerAvailable.acquire();
            while (op != null) {
                switch (op.getAction()) {
                    case DELETE: {
                        this.handleDeleteImpl(op);
                        break;
                    }
                    case POST: {
                        this.updateIndex(op);
                        break;
                    }
                }
                op = this.pollUpdateOperation();
            }
        }
        catch (Throwable e) {
            this.checkFailureAndRecover(e);
            if (op != null) {
                op.fail(e);
            }
        }
        finally {
            this.writerAvailable.release();
        }
    }

    private void handleQueryTaskPatch(Operation op, QueryTask task) throws Throwable {
        QueryTask.QuerySpecification qs = task.querySpec;
        Query luceneQuery = (Query)qs.context.nativeQuery;
        Sort luceneSort = (Sort)qs.context.nativeSort;
        if (luceneQuery == null) {
            luceneQuery = LuceneQueryConverter.convertToLuceneQuery(task.querySpec.query);
            qs.context.nativeQuery = luceneQuery;
        }
        if (luceneSort == null && task.querySpec.options != null && task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.SORT)) {
            luceneSort = LuceneQueryConverter.convertToLuceneSort(task.querySpec, false);
            task.querySpec.context.nativeSort = luceneSort;
        }
        if (qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS) && this.handleContinuousQueryTaskPatch(op, task, qs)) {
            return;
        }
        if (qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.GROUP_BY)) {
            this.handleGroupByQueryTaskPatch(op, task);
            return;
        }
        QueryPageService.LuceneQueryPage lucenePage = (QueryPageService.LuceneQueryPage)qs.context.nativePage;
        IndexSearcher s = (IndexSearcher)qs.context.nativeSearcher;
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        if (s == null && qs.resultLimit != null && qs.resultLimit > 0 && qs.resultLimit != Integer.MAX_VALUE && !qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS)) {
            s = this.createPaginatedQuerySearcher(task.documentExpirationTimeMicros, this.writer);
        }
        if (!this.queryIndex(s, op, null, qs.options, luceneQuery, lucenePage, qs.resultLimit, task.documentExpirationTimeMicros, task.indexLink, rsp, qs)) {
            op.setBodyNoCloning(rsp).complete();
        }
    }

    private boolean handleContinuousQueryTaskPatch(Operation op, QueryTask task, QueryTask.QuerySpecification qs) throws QueryFilter.QueryFilterException {
        switch (task.taskInfo.stage) {
            case CREATED: {
                this.logWarning("Task %s is in invalid state: %s", new Object[]{task.taskInfo.stage});
                op.fail(new IllegalStateException("Stage not supported"));
                return true;
            }
            case STARTED: {
                QueryTask clonedTask = new QueryTask();
                clonedTask.documentSelfLink = task.documentSelfLink;
                clonedTask.querySpec = task.querySpec;
                clonedTask.querySpec.context.filter = QueryFilter.create(qs.query);
                this.activeQueries.put(task.documentSelfLink, clonedTask);
                this.setStat(STAT_NAME_ACTIVE_QUERY_FILTERS, (double)this.activeQueries.size());
                this.logInfo("Activated continuous query task: %s", task.documentSelfLink);
                break;
            }
            case CANCELLED: 
            case FAILED: 
            case FINISHED: {
                this.activeQueries.remove(task.documentSelfLink);
                this.setStat(STAT_NAME_ACTIVE_QUERY_FILTERS, (double)this.activeQueries.size());
                op.complete();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher createPaginatedQuerySearcher(long expirationMicros, IndexWriter w) throws IOException {
        if (w == null) {
            throw new IllegalStateException("Writer not available");
        }
        IndexSearcher s = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)w, (boolean)true, (boolean)true));
        Object object = this.searchSync;
        synchronized (object) {
            List<IndexSearcher> searchers = this.searchersForPaginatedQueries.get(expirationMicros);
            if (searchers == null) {
                searchers = new ArrayList<IndexSearcher>();
            }
            searchers.add(s);
            this.searchersForPaginatedQueries.put(expirationMicros, searchers);
        }
        return s;
    }

    public void handleGetImpl(Operation get) throws Throwable {
        String selfLink = null;
        Long version = null;
        Service.ServiceOption targetIndex = Service.ServiceOption.NONE;
        EnumSet<QueryTask.QuerySpecification.QueryOption> options = EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class);
        if (get.hasPragmaDirective("xn-check-index")) {
            targetIndex = Service.ServiceOption.PERSISTENCE;
            selfLink = get.getUri().getPath();
            options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED);
        } else {
            Map<String, String> params = UriUtils.parseUriQueryParams(get.getUri());
            String cap = params.get("capability");
            if (cap != null) {
                targetIndex = Service.ServiceOption.valueOf(cap);
            }
            if (params.containsKey("includeDeleted")) {
                options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED);
            }
            if (params.containsKey("documentVersion")) {
                version = Long.parseLong(params.get("documentVersion"));
            }
            selfLink = params.get("documentSelfLink");
            String fieldToExpand = params.get("$expand");
            if (fieldToExpand == null) {
                fieldToExpand = params.get("expand");
            }
            if (fieldToExpand != null && fieldToExpand.equals("documentLinks")) {
                options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
            }
        }
        if (selfLink == null) {
            get.fail(new IllegalArgumentException("documentSelfLink query parameter is required"));
            return;
        }
        if (!selfLink.endsWith("*")) {
            this.queryIndexSingle(selfLink, get, version);
            return;
        }
        int resultLimit = Integer.MAX_VALUE;
        selfLink = selfLink.substring(0, selfLink.length() - 1);
        PrefixQuery tq = new PrefixQuery(new Term("documentSelfLink", selfLink));
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        rsp.documentLinks = new ArrayList<String>();
        if (this.queryIndex(null, get, selfLink, options, (Query)tq, null, resultLimit, 0L, null, rsp, null)) {
            return;
        }
        if (targetIndex == Service.ServiceOption.PERSISTENCE) {
            get.setBodyNoCloning(rsp).complete();
            return;
        }
        this.queryServiceHost(selfLink + "*", options, get);
    }

    private Operation pollQueryOperation() {
        return this.queryQueue.poll();
    }

    private Operation pollUpdateOperation() {
        return this.updateQueue.poll();
    }

    private boolean offerQueryOperation(Operation op) {
        String subject = this.getSubject(op);
        return this.queryQueue.offer(subject, op);
    }

    private boolean offerUpdateOperation(Operation op) {
        String subject = this.getSubject(op);
        return this.updateQueue.offer(subject, op);
    }

    private String getSubject(Operation op) {
        String subject = null;
        subject = !this.getHost().isAuthorizationEnabled() || op.getAuthorizationContext().isSystemUser() ? SystemUserService.SELF_LINK : op.getAuthorizationContext().getClaims().getSubject();
        return subject;
    }

    private boolean queryIndex(IndexSearcher s, Operation op, String selfLinkPrefix, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Query tq, QueryPageService.LuceneQueryPage page, int count, long expiration, String indexLink, ServiceDocumentQueryResult rsp, QueryTask.QuerySpecification qs) throws Throwable {
        if (options == null) {
            options = EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class);
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            rsp.documents = new HashMap<String, Object>();
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
            rsp.documentCount = 0L;
        } else {
            rsp.documentLinks = new ArrayList<String>();
        }
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException());
            return true;
        }
        if (s == null) {
            s = this.searcher;
            if (!options.contains((Object)QueryTask.QuerySpecification.QueryOption.DO_NOT_REFRESH) || s == null) {
                s = this.updateSearcher(selfLinkPrefix, count, w);
            }
        }
        if ((tq = this.updateQuery(op, tq)) == null) {
            return false;
        }
        ServiceDocumentQueryResult result = this.queryIndex(op, options, s, tq, page, count, expiration, indexLink, rsp, qs);
        result.documentOwner = this.getHost().getId();
        if (!options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT) && result.documentLinks.isEmpty()) {
            return false;
        }
        op.setBodyNoCloning(result).complete();
        return true;
    }

    private void queryIndexSingle(String selfLink, Operation op, Long version) throws Throwable {
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException());
            return;
        }
        IndexSearcher s = this.updateSearcher(selfLink, 1, w);
        long start = 0L;
        long end = 0L;
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            start = System.nanoTime();
        }
        TopDocs hits = this.searchByVersion(selfLink, s, version);
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            end = System.nanoTime();
        }
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            ServiceStats.ServiceStat st = this.getHistogramStat(STAT_NAME_QUERY_SINGLE_DURATION_MICROS);
            this.setStat(st, (double)(end - start) / 1000.0);
        }
        if (hits.totalHits == 0) {
            op.complete();
            return;
        }
        Document doc = s.getIndexReader().document(hits.scoreDocs[0].doc, this.fieldsToLoadWithExpand);
        if (this.checkAndDeleteExpiratedDocuments(selfLink, s, hits.scoreDocs[0].doc, doc, Utils.getNowMicrosUtc())) {
            op.complete();
            return;
        }
        ServiceDocument sd = this.getStateFromLuceneDocument(doc, selfLink);
        op.setBodyNoCloning(sd).complete();
    }

    private TopDocs searchByVersion(String selfLink, IndexSearcher s, Long version) throws IOException {
        TermQuery tqSelfLink = new TermQuery(new Term("documentSelfLink", selfLink));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add((Query)tqSelfLink, BooleanClause.Occur.MUST);
        if (version != null) {
            Query versionQuery = LongPoint.newRangeQuery((String)"documentVersion", (long)version, (long)version);
            builder.add(versionQuery, BooleanClause.Occur.MUST);
        }
        TopFieldDocs hits = s.search((Query)builder.build(), 1, this.versionSort, false, false);
        return hits;
    }

    private void queryServiceHost(String selfLink, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Operation op) {
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            op.nestCompletion(o -> this.expandLinks((Operation)o, op));
        }
        this.getHost().queryServiceUris(selfLink, op);
    }

    private Query updateQuery(Operation op, Query tq) {
        Object rq = null;
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (!this.getHost().isAuthorizationEnabled()) {
            return tq;
        }
        if (ctx == null) {
            return null;
        }
        if (ctx.isSystemUser()) {
            return tq;
        }
        rq = ctx.getResourceQuery(Service.Action.GET) == null ? new MatchNoDocsQuery() : LuceneQueryConverter.convertToLuceneQuery(ctx.getResourceQuery(Service.Action.GET));
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add((Query)rq, BooleanClause.Occur.FILTER).add(tq, BooleanClause.Occur.FILTER);
        return builder.build();
    }

    private void handleGroupByQueryTaskPatch(Operation op, QueryTask task) throws IOException {
        int groupLimit;
        QueryTask.QuerySpecification qs = task.querySpec;
        IndexSearcher s = (IndexSearcher)qs.context.nativeSearcher;
        QueryPageService.LuceneQueryPage page = (QueryPageService.LuceneQueryPage)qs.context.nativePage;
        Query tq = (Query)qs.context.nativeQuery;
        Sort sort = (Sort)qs.context.nativeSort;
        if (sort == null && qs.sortTerm != null) {
            sort = LuceneQueryConverter.convertToLuceneSort(qs, false);
        }
        Sort groupSort = null;
        if (qs.groupSortTerm != null) {
            groupSort = LuceneQueryConverter.convertToLuceneSort(qs, true);
        }
        GroupingSearch groupingSearch = new GroupingSearch(qs.groupByTerm.propertyName);
        groupingSearch.setGroupSort(groupSort);
        groupingSearch.setSortWithinGroup(sort);
        super.adjustStat(STAT_NAME_GROUP_QUERY_COUNT, 1.0);
        int groupOffset = page != null ? page.groupOffset : 0;
        int n = groupLimit = qs.groupResultLimit != null ? qs.groupResultLimit : 10000;
        if (s == null && qs.groupResultLimit != null) {
            s = this.createPaginatedQuerySearcher(task.documentExpirationTimeMicros, this.writer);
        }
        if (s == null) {
            s = this.searcher;
            if (!qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.DO_NOT_REFRESH) || s == null) {
                s = this.updateSearcher(null, Integer.MAX_VALUE, this.writer);
            }
        }
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        rsp.nextPageLinksPerGroup = new TreeMap<String, String>();
        long startTimeMicros = Utils.getNowMicrosUtc();
        TopGroups groups = groupingSearch.search(s, tq, groupOffset, groupLimit);
        long endTimeMicros = Utils.getNowMicrosUtc();
        String statName = STAT_NAME_GROUP_QUERY_DURATION_MICROS;
        ServiceStats.ServiceStat st = this.getHistogramStat(statName);
        this.setStat(st, (double)(endTimeMicros - startTimeMicros));
        for (GroupDocs groupDocs : groups.groups) {
            if (groupDocs.totalHits == 0) continue;
            QueryTask.Query perGroupQuery = Utils.clone(qs.query);
            String groupValue = ((BytesRef)groupDocs.groupValue).utf8ToString();
            QueryTask.Query clause = new QueryTask.Query().setTermPropertyName(qs.groupByTerm.propertyName).setTermMatchValue(groupValue).setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
            clause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
            if (perGroupQuery.booleanClauses == null) {
                QueryTask.Query topLevelClause = perGroupQuery;
                perGroupQuery.addBooleanClause(topLevelClause);
            }
            perGroupQuery.addBooleanClause(clause);
            Query lucenePerGroupQuery = LuceneQueryConverter.convertToLuceneQuery(perGroupQuery);
            String pageLink = this.createNextPage(op, s, qs, lucenePerGroupQuery, sort, null, null, task.documentExpirationTimeMicros, task.indexLink, false);
            rsp.nextPageLinksPerGroup.put(groupValue, pageLink);
        }
        if (qs.groupResultLimit != null && groups.groups.length >= groupLimit) {
            groups = groupingSearch.search(s, tq, groupLimit + groupOffset, groupLimit);
            if (groups.totalGroupedHitCount > 0) {
                rsp.nextPageLink = this.createNextPage(op, s, qs, tq, sort, null, groupLimit + groupOffset, task.documentExpirationTimeMicros, task.indexLink, page != null);
            }
        }
        op.setBodyNoCloning(rsp).complete();
    }

    private ServiceDocumentQueryResult queryIndex(Operation op, EnumSet<QueryTask.QuerySpecification.QueryOption> options, IndexSearcher s, Query tq, QueryPageService.LuceneQueryPage page, int count, long expiration, String indexLink, ServiceDocumentQueryResult rsp, QueryTask.QuerySpecification qs) throws Throwable {
        long queryStartTimeMicros;
        ScoreDoc after = null;
        boolean isPaginatedQuery = count != Integer.MAX_VALUE && !options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS);
        boolean hasPage = page != null;
        boolean shouldProcessResults = true;
        int resultLimit = count;
        if (hasPage) {
            after = page.after;
            rsp.prevPageLink = page.previousPageLink;
        } else if (isPaginatedQuery) {
            resultLimit = 1;
            shouldProcessResults = false;
            rsp.documentCount = 1L;
        }
        Sort sort = this.versionSort;
        if (qs != null && qs.sortTerm != null) {
            if (qs.context != null) {
                sort = (Sort)qs.context.nativeSort;
            }
            if (sort == null) {
                sort = LuceneQueryConverter.convertToLuceneSort(qs, false);
            }
        }
        Object results = null;
        rsp.queryTimeMicros = 0L;
        long start = queryStartTimeMicros = Utils.getNowMicrosUtc();
        do {
            results = sort == null ? s.searchAfter(after, tq, count) : s.searchAfter(after, tq, count, sort, false, false);
            long end = Utils.getNowMicrosUtc();
            if (results == null) {
                return rsp;
            }
            ScoreDoc[] hits = results.scoreDocs;
            long queryTime = end - start;
            rsp.documentCount = 0L;
            ServiceDocumentQueryResult serviceDocumentQueryResult = rsp;
            Long.valueOf(serviceDocumentQueryResult.queryTimeMicros + queryTime);
            serviceDocumentQueryResult.queryTimeMicros = serviceDocumentQueryResult.queryTimeMicros;
            ScoreDoc bottom = null;
            if (shouldProcessResults) {
                start = Utils.getNowMicrosUtc();
                bottom = this.processQueryResults(qs, options, count, s, rsp, hits, queryStartTimeMicros);
                end = Utils.getNowMicrosUtc();
                if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                    String statName = options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS) ? STAT_NAME_QUERY_ALL_VERSIONS_DURATION_MICROS : STAT_NAME_QUERY_DURATION_MICROS;
                    ServiceStats.ServiceStat st = this.getHistogramStat(statName);
                    this.setStat(st, (double)queryTime);
                    st = this.getHistogramStat(STAT_NAME_RESULT_PROCESSING_DURATION_MICROS);
                    this.setStat(st, (double)(end - start));
                }
            }
            if (!isPaginatedQuery && !options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS) || hits.length == 0) break;
            if (isPaginatedQuery) {
                if (!hasPage) {
                    bottom = null;
                }
                if (!hasPage || rsp.documentLinks.size() >= count || hits.length < resultLimit) {
                    boolean createNextPageLink = true;
                    if (hasPage) {
                        createNextPageLink = this.checkNextPageHasEntry(bottom, options, s, tq, sort, count, qs, queryStartTimeMicros);
                    }
                    if (!createNextPageLink) break;
                    rsp.nextPageLink = this.createNextPage(op, s, qs, tq, sort, bottom, null, expiration += queryTime, indexLink, hasPage);
                    break;
                }
            }
            after = bottom;
        } while ((resultLimit = count - rsp.documentLinks.size()) > 0);
        return rsp;
    }

    private boolean checkNextPageHasEntry(ScoreDoc after, EnumSet<QueryTask.QuerySpecification.QueryOption> options, IndexSearcher s, Query tq, Sort sort, int count, QueryTask.QuerySpecification qs, long queryStartTimeMicros) throws Throwable {
        ScoreDoc[] hits;
        Object nextPageResults;
        boolean hasValidNextPageEntry = false;
        while (after != null && (nextPageResults = sort == null ? s.searchAfter(after, tq, count) : s.searchAfter(after, tq, count, sort, false, false)) != null && (hits = nextPageResults.scoreDocs).length != 0) {
            ServiceDocumentQueryResult rspForNextPage = new ServiceDocumentQueryResult();
            rspForNextPage.documents = new HashMap<String, Object>();
            after = this.processQueryResults(qs, options, count, s, rspForNextPage, hits, queryStartTimeMicros);
            if (rspForNextPage.documentCount <= 0L) continue;
            hasValidNextPageEntry = true;
            break;
        }
        return hasValidNextPageEntry;
    }

    private String createNextPage(Operation op, IndexSearcher s, QueryTask.QuerySpecification qs, Query tq, Sort sort, ScoreDoc after, Integer groupOffset, long expiration, String indexLink, boolean hasPage) {
        URI u = UriUtils.buildUri(this.getHost(), UriUtils.buildUriPath(ServiceUriPaths.CORE_QUERY_PAGE, Utils.getNowMicrosUtc() + ""));
        URI forwarderUri = UriUtils.buildForwardToPeerUri(u, this.getHost().getId(), "/core/node-selectors/default", EnumSet.noneOf(Service.ServiceOption.class));
        String nextLink = forwarderUri.getPath() + "?" + forwarderUri.getQuery();
        URI forwarderUriOfPrevLinkForNewPage = UriUtils.buildForwardToPeerUri(op.getReferer(), this.getHost().getId(), "/core/node-selectors/default", EnumSet.noneOf(Service.ServiceOption.class));
        String prevLinkForNewPage = forwarderUriOfPrevLinkForNewPage.getPath() + "?" + forwarderUriOfPrevLinkForNewPage.getQuery();
        QueryPageService.LuceneQueryPage page = null;
        page = after != null || groupOffset == null ? new QueryPageService.LuceneQueryPage(hasPage ? prevLinkForNewPage : null, after) : new QueryPageService.LuceneQueryPage(hasPage ? prevLinkForNewPage : null, groupOffset);
        QueryTask.QuerySpecification spec = new QueryTask.QuerySpecification();
        qs.copyTo(spec);
        if (groupOffset == null) {
            spec.options.remove((Object)QueryTask.QuerySpecification.QueryOption.GROUP_BY);
        }
        spec.context.nativeQuery = tq;
        spec.context.nativePage = page;
        spec.context.nativeSearcher = s;
        spec.context.nativeSort = sort;
        ServiceDocument body = new ServiceDocument();
        body.documentSelfLink = u.getPath();
        body.documentExpirationTimeMicros = expiration;
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx != null) {
            body.documentAuthPrincipalLink = ctx.getClaims().getSubject();
        }
        Operation startPost = Operation.createPost(u).setBody(body).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Unable to start next page service: %s", e.toString());
            }
        });
        if (ctx != null) {
            this.setAuthorizationContext(startPost, ctx);
        }
        this.getHost().startService(startPost, new QueryPageService(spec, indexLink));
        return nextLink;
    }

    private ScoreDoc processQueryResults(QueryTask.QuerySpecification qs, EnumSet<QueryTask.QuerySpecification.QueryOption> options, int resultLimit, IndexSearcher s, ServiceDocumentQueryResult rsp, ScoreDoc[] hits, long queryStartTimeMicros) throws Throwable {
        ScoreDoc lastDocVisited = null;
        Set<String> fieldsToLoad = this.fieldsToLoadNoExpand;
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION)) {
            fieldsToLoad = this.fieldsToLoadWithExpand;
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS)) {
            fieldsToLoad = new HashSet<String>(fieldsToLoad);
            for (QueryTask.QueryTerm link : qs.linkTerms) {
                fieldsToLoad.add(link.propertyName);
            }
        }
        LinkedHashSet<String> uniques = new LinkedHashSet<String>(rsp.documentLinks);
        boolean hasCountOption = options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT);
        boolean hasIncludeAllVersionsOption = options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        Set<String> linkWhiteList = null;
        if (qs != null && qs.context != null && qs.context.documentLinkWhiteList != null) {
            linkWhiteList = qs.context.documentLinkWhiteList;
        }
        HashMap<String, Long> latestVersions = new HashMap<String, Long>();
        for (ScoreDoc sd : hits) {
            String link;
            if (uniques.size() >= resultLimit) break;
            lastDocVisited = sd;
            Document d = s.getIndexReader().document(sd.doc, fieldsToLoad);
            String originalLink = link = d.get("documentSelfLink");
            if (linkWhiteList != null && !linkWhiteList.contains(link)) continue;
            IndexableField versionField = d.getField("documentVersion");
            Long documentVersion = versionField.numericValue().longValue();
            Long latestVersion = null;
            if (hasIncludeAllVersionsOption) {
                link = UriUtils.buildPathWithVersion(link, documentVersion);
            } else {
                latestVersion = (Long)latestVersions.get(link);
                if (latestVersion == null) {
                    latestVersion = this.getLatestVersion(s, link);
                    latestVersions.put(link, latestVersion);
                }
                if (documentVersion < latestVersion) continue;
                boolean isDeleted = Service.Action.DELETE.toString().equals(d.get("documentUpdateAction"));
                if (isDeleted && !options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED)) {
                    if (documentVersion < latestVersion) continue;
                    uniques.remove(link);
                    if (rsp.documents != null) {
                        rsp.documents.remove(link);
                    }
                    if (rsp.selectedLinksPerDocument == null) continue;
                    rsp.selectedLinksPerDocument.remove(link);
                    continue;
                }
            }
            if (this.checkAndDeleteExpiratedDocuments(link, s, sd.doc, d, queryStartTimeMicros)) {
                latestVersions.put(link, Long.MAX_VALUE);
                continue;
            }
            if (hasCountOption) {
                uniques.add(link);
                latestVersions.put(link, Long.MAX_VALUE);
                continue;
            }
            String json = null;
            ServiceDocument state = null;
            if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) || options.contains((Object)QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION)) {
                state = this.getStateFromLuceneDocument(d, originalLink);
                if (state == null) {
                    json = d.get(LUCENE_FIELD_NAME_JSON_SERIALIZED_STATE);
                    if (json == null) {
                        continue;
                    }
                } else {
                    json = Utils.toJson(state);
                }
            }
            if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION) && !this.processQueryResultsForOwnerSelection(json, state)) continue;
            if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) && !rsp.documents.containsKey(link)) {
                if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BUILTIN_CONTENT_ONLY)) {
                    ServiceDocument stateClone = new ServiceDocument();
                    state.copyTo(stateClone);
                    rsp.documents.put(link, stateClone);
                } else {
                    JsonObject jo = new JsonParser().parse(json).getAsJsonObject();
                    rsp.documents.put(link, jo);
                }
            }
            if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS)) {
                state = this.processQueryResultsForSelectLinks(s, qs, rsp, d, sd.doc, link, state);
            }
            uniques.add(link);
        }
        if (hasCountOption) {
            rsp.documentCount = uniques.size();
        } else {
            rsp.documentLinks.clear();
            rsp.documentLinks.addAll(uniques);
            rsp.documentCount = rsp.documentLinks.size();
        }
        return lastDocVisited;
    }

    private boolean processQueryResultsForOwnerSelection(String json, ServiceDocument state) {
        String documentOwner = null;
        documentOwner = state == null ? Utils.fromJson((String)json, ServiceDocument.class).documentOwner : state.documentOwner;
        return documentOwner == null || documentOwner.equals(this.getHost().getId());
    }

    private ServiceDocument processQueryResultsForSelectLinks(IndexSearcher s, QueryTask.QuerySpecification qs, ServiceDocumentQueryResult rsp, Document d, int docId, String link, ServiceDocument state) throws Throwable {
        Map<String, String> linksPerDocument;
        if (rsp.selectedLinksPerDocument == null) {
            rsp.selectedLinksPerDocument = new HashMap<String, Map<String, String>>();
            rsp.selectedLinks = new HashSet<String>();
        }
        if ((linksPerDocument = rsp.selectedLinksPerDocument.get(link)) == null) {
            linksPerDocument = new HashMap<String, String>();
            rsp.selectedLinksPerDocument.put(link, linksPerDocument);
        }
        for (QueryTask.QueryTerm qt : qs.linkTerms) {
            String linkValue = d.get(qt.propertyName);
            if (linkValue != null) {
                linksPerDocument.put(qt.propertyName, linkValue);
                rsp.selectedLinks.add(linkValue);
                continue;
            }
            if (state == null && (state = this.getStateFromLuceneDocument(d = s.getIndexReader().document(docId, this.fieldsToLoadWithExpand), link)) == null) {
                this.logWarning("Skipping link %s, can not find serialized state", link);
                continue;
            }
            Field linkCollectionField = ReflectionUtils.getField(state.getClass(), qt.propertyName);
            if (linkCollectionField == null) {
                this.logWarning("Skipping link %s, can not find field", link);
                continue;
            }
            Object fieldValue = linkCollectionField.get(state);
            if (!(fieldValue instanceof Collection)) {
                this.logWarning("Skipping link %s, field is not a collection", link);
                continue;
            }
            Collection linkCollection = (Collection)fieldValue;
            int index = 0;
            for (String item : linkCollection) {
                linksPerDocument.put(QueryTask.QuerySpecification.buildLinkCollectionItemName(qt.propertyName, index++), item);
                rsp.selectedLinks.add(item);
            }
        }
        return state;
    }

    private ServiceDocument getStateFromLuceneDocument(Document doc, String link) {
        BytesRef binaryStateField = doc.getBinaryValue(LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE);
        if (binaryStateField == null) {
            this.logWarning("State not found for %s", link);
            return null;
        }
        ServiceDocument state = (ServiceDocument)KryoSerializers.deserializeDocument(binaryStateField.bytes, binaryStateField.offset, binaryStateField.length);
        if (state.documentSelfLink == null) {
            state.documentSelfLink = link;
        }
        if (state.documentKind == null) {
            state.documentKind = Utils.buildKind(state.getClass());
        }
        return state;
    }

    private long getLatestVersion(IndexSearcher s, String link) throws IOException {
        TopDocs td = this.searchByVersion(link, s, null);
        Document latestVersionDoc = s.getIndexReader().document(td.scoreDocs[0].doc, this.fieldsToLoadNoExpand);
        IndexableField versionField = latestVersionDoc.getField("documentVersion");
        long latestVersion = versionField.numericValue().longValue();
        return latestVersion;
    }

    private void expandLinks(Operation o, Operation get) {
        ServiceDocumentQueryResult r = o.getBody(ServiceDocumentQueryResult.class);
        if (r.documentLinks == null || r.documentLinks.isEmpty()) {
            get.setBodyNoCloning(r).complete();
            return;
        }
        r.documents = new HashMap<String, Object>();
        AtomicInteger i = new AtomicInteger(r.documentLinks.size());
        Operation.CompletionHandler c = (op, e) -> {
            try {
                if (e != null) {
                    this.logWarning("failure expanding %s: %s", op.getUri().getPath(), e.getMessage());
                    return;
                }
                Map<String, Object> map = r.documents;
                synchronized (map) {
                    r.documents.put(op.getUri().getPath(), op.getBodyRaw());
                }
            }
            finally {
                if (i.decrementAndGet() == 0) {
                    get.setBodyNoCloning(r).complete();
                }
            }
        };
        for (String selfLink : r.documentLinks) {
            this.sendRequest(Operation.createGet(this, selfLink).setCompletion(c));
        }
    }

    public void handleDeleteImpl(Operation delete) throws Throwable {
        this.setProcessingStage(Service.ProcessingStage.STOPPED);
        this.privateIndexingExecutor.shutdown();
        this.privateQueryExecutor.shutdown();
        IndexWriter w = this.writer;
        this.writer = null;
        this.close(w);
        this.getHost().stopService(this);
        delete.complete();
    }

    private void close(IndexWriter wr) {
        try {
            if (wr == null) {
                return;
            }
            this.logInfo("Document count: %d ", wr.maxDoc());
            wr.commit();
            wr.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void updateIndex(Operation updateOp) throws Throwable {
        UpdateIndexRequest r = updateOp.getBody(UpdateIndexRequest.class);
        ServiceDocument s = r.document;
        ServiceDocumentDescription desc = r.description;
        if (updateOp.isRemote()) {
            updateOp.fail(new IllegalStateException("Remote requests not allowed"));
            return;
        }
        if (s == null) {
            updateOp.fail(new IllegalArgumentException("document is required"));
            return;
        }
        String link = s.documentSelfLink;
        if (link == null) {
            updateOp.fail(new IllegalArgumentException("documentSelfLink is required"));
            return;
        }
        if (s.documentUpdateAction == null) {
            updateOp.fail(new IllegalArgumentException("documentUpdateAction is required"));
            return;
        }
        if (desc == null) {
            updateOp.fail(new IllegalArgumentException("description is required"));
            return;
        }
        s.documentDescription = null;
        Document doc = new Document();
        StoredField updateActionField = new StoredField("documentUpdateAction", s.documentUpdateAction);
        doc.add((IndexableField)updateActionField);
        this.addBinaryStateFieldToDocument(s, r.serializedDocument, desc, doc);
        StringField selfLinkField = new StringField("documentSelfLink", link, Field.Store.YES);
        doc.add((IndexableField)selfLinkField);
        SortedDocValuesField sortedSelfLinkField = new SortedDocValuesField("documentSelfLink", new BytesRef((CharSequence)link));
        doc.add((IndexableField)sortedSelfLinkField);
        String kind = s.documentKind;
        if (kind != null) {
            StringField kindField = new StringField("documentKind", kind, Field.Store.NO);
            doc.add((IndexableField)kindField);
        }
        if (s.documentAuthPrincipalLink != null) {
            StringField principalField = new StringField("documentAuthPrincipalLink", s.documentAuthPrincipalLink, Field.Store.NO);
            doc.add((IndexableField)principalField);
        }
        if (s.documentTransactionId != null) {
            StringField transactionField = new StringField("documentTransactionId", s.documentTransactionId, Field.Store.NO);
            doc.add((IndexableField)transactionField);
        }
        LuceneDocumentIndexService.addNumericField(doc, "documentUpdateTimeMicros", s.documentUpdateTimeMicros, true);
        if (s.documentExpirationTimeMicros > 0L) {
            LuceneDocumentIndexService.addNumericField(doc, "documentExpirationTimeMicros", s.documentExpirationTimeMicros, true);
        }
        LuceneDocumentIndexService.addNumericField(doc, "documentVersion", s.documentVersion, true);
        if (desc.propertyDescriptions == null || desc.propertyDescriptions.isEmpty()) {
            this.addDocumentToIndex(updateOp, doc, s, desc);
            return;
        }
        this.addIndexableFieldsToDocument(doc, s, desc);
        this.addDocumentToIndex(updateOp, doc, s, desc);
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            int fieldCount = doc.getFields().size();
            ServiceStats.ServiceStat st = this.getStat(STAT_NAME_INDEXED_FIELD_COUNT);
            this.adjustStat(st, (double)fieldCount);
            st = this.getHistogramStat(STAT_NAME_FIELD_COUNT_PER_DOCUMENT);
            this.setStat(st, (double)fieldCount);
        }
    }

    private void addBinaryStateFieldToDocument(ServiceDocument s, byte[] serializedDocument, ServiceDocumentDescription desc, Document doc) {
        try {
            int count = 0;
            if (serializedDocument == null) {
                Output o = KryoSerializers.serializeDocumentForIndexing(s, desc.serializedStateSizeLimit);
                count = o.position();
                serializedDocument = o.getBuffer();
            } else {
                count = serializedDocument.length;
            }
            StoredField bodyField = new StoredField(LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE, serializedDocument, 0, count);
            doc.add((IndexableField)bodyField);
        }
        catch (KryoException ke) {
            throw new IllegalArgumentException("Failure serializing state of service " + s.documentSelfLink + ", possibly due to size limit. Service author should override getDocumentTemplate() and adjust ServiceDocumentDescription.serializedStateSizeLimit. Cause: " + ke.toString());
        }
    }

    private void addIndexableFieldsToDocument(Document doc, Object podo, ServiceDocumentDescription sd) {
        for (Map.Entry<String, ServiceDocumentDescription.PropertyDescription> e : sd.propertyDescriptions.entrySet()) {
            String name = e.getKey();
            ServiceDocumentDescription.PropertyDescription pd = e.getValue();
            if (pd.usageOptions != null && pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.INFRASTRUCTURE)) continue;
            Object v = ReflectionUtils.getPropertyValue(pd, podo);
            this.addIndexableFieldToDocument(doc, v, pd, name);
        }
    }

    private void addIndexableFieldToDocument(Document doc, Object podo, ServiceDocumentDescription.PropertyDescription pd, String fieldName) {
        boolean isStored;
        Object luceneField = null;
        SortedDocValuesField luceneDocValuesField = null;
        Field.Store fsv = Field.Store.NO;
        boolean isSorted = false;
        boolean expandField = false;
        Object v = podo;
        if (v == null) {
            return;
        }
        EnumSet<ServiceDocumentDescription.PropertyIndexingOption> opts = pd.indexingOptions;
        if (opts != null) {
            if (opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.STORE_ONLY)) {
                return;
            }
            if (opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
                isSorted = true;
            }
            if (opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.EXPAND)) {
                expandField = true;
            }
        }
        if (pd.usageOptions != null) {
            if (pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.LINK)) {
                fsv = Field.Store.YES;
            }
            if (pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.LINKS)) {
                expandField = true;
            }
        }
        boolean bl = isStored = fsv == Field.Store.YES;
        if (v instanceof String) {
            String stringValue = v.toString();
            if (opts == null) {
                luceneField = new StringField(fieldName, stringValue, fsv);
            } else {
                if (opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.CASE_INSENSITIVE)) {
                    stringValue = stringValue.toLowerCase();
                }
                luceneField = opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.TEXT) ? new TextField(fieldName, stringValue, fsv) : new StringField(fieldName, stringValue, fsv);
            }
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)stringValue));
            }
        } else if (v instanceof URI) {
            String uriValue = QueryTask.QuerySpecification.toMatchValue((URI)v);
            luceneField = new StringField(fieldName, uriValue, fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)v.toString()));
            }
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.ENUM)) {
            String enumValue = QueryTask.QuerySpecification.toMatchValue((Enum)v);
            luceneField = new StringField(fieldName, enumValue, fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)v.toString()));
            }
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.LONG)) {
            long value = ((Number)v).longValue();
            LuceneDocumentIndexService.addNumericField(doc, fieldName, value, isStored);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.DATE)) {
            long value = ((Date)v).getTime() * 1000L;
            LuceneDocumentIndexService.addNumericField(doc, fieldName, value, isStored);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.DOUBLE)) {
            double value = ((Number)v).doubleValue();
            LuceneDocumentIndexService.addNumericField(doc, fieldName, value, isStored);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.BOOLEAN)) {
            String booleanValue = QueryTask.QuerySpecification.toMatchValue((Boolean)v);
            luceneField = new StringField(fieldName, booleanValue, fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)booleanValue));
            }
        } else if (!pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.BYTES)) {
            if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.PODO)) {
                if (!(v instanceof TaskState) && !expandField) {
                    return;
                }
                this.addObjectIndexableFieldToDocument(doc, v, pd, fieldName);
                return;
            }
            if (expandField && pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.MAP)) {
                this.addMapIndexableFieldToDocument(doc, v, pd, fieldName);
                return;
            }
            if (expandField && pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.COLLECTION)) {
                this.addCollectionIndexableFieldToDocument(doc, v, pd, fieldName);
                return;
            }
            luceneField = new StringField(fieldName, v.toString(), fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)v.toString()));
            }
        }
        if (luceneField != null) {
            doc.add((IndexableField)luceneField);
        }
        if (luceneDocValuesField != null) {
            doc.add(luceneDocValuesField);
        }
    }

    private void addObjectIndexableFieldToDocument(Document doc, Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        for (Map.Entry<String, ServiceDocumentDescription.PropertyDescription> e : pd.fieldDescriptions.entrySet()) {
            ServiceDocumentDescription.PropertyDescription fieldDescription = e.getValue();
            if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
                fieldDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
            }
            Object fieldValue = ReflectionUtils.getPropertyValue(fieldDescription, v);
            String fieldName = QueryTask.QuerySpecification.buildCompositeFieldName(fieldNamePrefix, e.getKey());
            this.addIndexableFieldToDocument(doc, fieldValue, fieldDescription, fieldName);
        }
    }

    private void addMapIndexableFieldToDocument(Document doc, Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        String errorMsg = "Field not supported. Map keys must be of type String.";
        Map m = (Map)v;
        if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
            pd.elementDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
        }
        for (Map.Entry o : m.entrySet()) {
            Map.Entry entry = o;
            Object mapKey = entry.getKey();
            if (!(mapKey instanceof String)) {
                throw new IllegalArgumentException("Field not supported. Map keys must be of type String.");
            }
            this.addIndexableFieldToDocument(doc, entry.getValue(), pd.elementDescription, QueryTask.QuerySpecification.buildCompositeFieldName(fieldNamePrefix, (String)mapKey));
            if (!pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.FIXED_ITEM_NAME)) continue;
            this.addIndexableFieldToDocument(doc, entry.getKey(), new ServiceDocumentDescription.PropertyDescription(), fieldNamePrefix);
            this.addIndexableFieldToDocument(doc, entry.getValue(), pd.elementDescription, fieldNamePrefix);
        }
    }

    private void addCollectionIndexableFieldToDocument(Document doc, Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        fieldNamePrefix = QueryTask.QuerySpecification.buildCollectionItemName(fieldNamePrefix);
        List<Object> c = v instanceof Collection ? (List<Object>)v : Arrays.asList((Object[])v);
        if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
            pd.elementDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
        }
        for (Object e : c) {
            if (e == null) continue;
            this.addIndexableFieldToDocument(doc, e, pd.elementDescription, fieldNamePrefix);
        }
    }

    private boolean checkAndDeleteExpiratedDocuments(String link, IndexSearcher searcher, Integer docId, Document doc, long now) throws Throwable {
        long expiration = 0L;
        boolean hasExpired = false;
        IndexableField expirationValue = doc.getField("documentExpirationTimeMicros");
        if (expirationValue != null) {
            expiration = expirationValue.numericValue().longValue();
            boolean bl = hasExpired = expiration <= now;
        }
        if (!hasExpired) {
            return false;
        }
        this.adjustStat(STAT_NAME_DOCUMENT_EXPIRATION_COUNT, 1.0);
        doc = searcher.getIndexReader().document(docId.intValue(), this.fieldsToLoadWithExpand);
        ServiceDocument s = null;
        try {
            s = this.getStateFromLuceneDocument(doc, link);
        }
        catch (Throwable e) {
            this.logWarning("Error deserializing state for %s: %s", link, e.getMessage());
        }
        this.deleteAllDocumentsForSelfLink(Operation.createDelete(null), link, s);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDocumentRetentionLimit(ServiceDocument state, ServiceDocumentDescription desc) {
        if (desc.versionRetentionLimit == Long.MIN_VALUE) {
            return;
        }
        Map<String, Long> map = this.linkDocumentRetentionEstimates;
        synchronized (map) {
            if (this.linkDocumentRetentionEstimates.containsKey(state.documentSelfLink)) {
                return;
            }
            long limit = Math.max(1L, desc.versionRetentionLimit);
            if (state.documentVersion < limit) {
                return;
            }
            this.linkDocumentRetentionEstimates.put(state.documentSelfLink, limit);
        }
    }

    private void checkFailureAndRecover(Throwable e) {
        if (!(e instanceof AlreadyClosedException)) {
            if (this.writer != null && !this.getHost().isStopping()) {
                this.logSevere(e);
            }
            return;
        }
        this.adjustStat(STAT_NAME_WRITER_ALREADY_CLOSED_EXCEPTION_COUNT, 1.0);
        this.reOpenWriterSynchronously();
    }

    private void deleteAllDocumentsForSelfLink(Operation postOrDelete, String link, ServiceDocument state) throws Throwable {
        this.deleteDocumentsFromIndex(postOrDelete, link, 0L);
        ServiceStats.ServiceStat st = this.getStat(STAT_NAME_SERVICE_DELETE_COUNT);
        this.adjustStat(st, 1.0);
        this.logFine("%s expired", link);
        if (state == null) {
            return;
        }
        this.applyActiveQueries(postOrDelete, state, null);
        this.sendRequest(Operation.createDelete(this, state.documentSelfLink).setBodyNoCloning(state).disableFailureLogging(true).addPragmaDirective("xn-no-index-update"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDocumentsFromIndex(Operation delete, String link, long versionsToKeep) throws Throwable {
        IndexWriter wr = this.writer;
        if (wr == null) {
            delete.fail(new CancellationException());
            return;
        }
        TermQuery linkQuery = new TermQuery(new Term("documentSelfLink", link));
        IndexSearcher s = this.updateSearcher(link, Integer.MAX_VALUE, wr);
        if (s == null) {
            delete.fail(new CancellationException());
            return;
        }
        TopFieldDocs results = s.search((Query)linkQuery, Integer.MAX_VALUE, this.versionSort, false, false);
        if (results == null) {
            return;
        }
        ScoreDoc[] hits = results.scoreDocs;
        if (hits == null || hits.length == 0) {
            return;
        }
        if (versionsToKeep == 0L) {
            wr.deleteDocuments(new Query[]{linkQuery});
            this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
            delete.complete();
            return;
        }
        int versionCount = hits.length;
        Document hitDoc = s.doc(hits[versionCount - 1].doc);
        long versionLowerBound = Long.parseLong(hitDoc.get("documentVersion"));
        hitDoc = s.doc(hits[0].doc);
        long versionUpperBound = Long.parseLong(hitDoc.get("documentVersion"));
        if ((long)versionCount <= versionsToKeep) {
            return;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        hitDoc = s.doc(hits[(int)versionsToKeep].doc);
        long cutOffVersion = Long.parseLong(hitDoc.get("documentVersion"));
        Query versionQuery = LongPoint.newRangeQuery((String)"documentVersion", (long)versionLowerBound, (long)cutOffVersion);
        builder.add(versionQuery, BooleanClause.Occur.MUST);
        builder.add((Query)linkQuery, BooleanClause.Occur.MUST);
        BooleanQuery bq = builder.build();
        results = s.search((Query)bq, Integer.MAX_VALUE);
        this.logInfo("Version grooming for %s found %d versions from %d to %d. Trimming %d versions from %d to %d", link, versionCount, versionLowerBound, versionUpperBound, results.scoreDocs.length, versionLowerBound, cutOffVersion);
        wr.deleteDocuments(new Query[]{bq});
        if ((long)versionCount < versionUpperBound - versionLowerBound + 1L) {
            this.logWarning("Adding %s back for version grooming since versionCount %d was lower than version delta from %d to %d.", link, versionCount, versionLowerBound, versionUpperBound);
            Map<String, Long> map = this.linkDocumentRetentionEstimates;
            synchronized (map) {
                this.linkDocumentRetentionEstimates.put(link, versionsToKeep);
            }
        }
        long now = Utils.getNowMicrosUtc();
        this.updateLinkAccessTime(now, link);
        delete.complete();
    }

    private void addDocumentToIndex(Operation op, Document doc, ServiceDocument sd, ServiceDocumentDescription desc) throws IOException {
        IndexWriter wr = this.writer;
        if (wr == null) {
            op.fail(new CancellationException());
            return;
        }
        long start = Utils.getNowMicrosUtc();
        wr.addDocument((Iterable)doc);
        long end = Utils.getNowMicrosUtc();
        this.updateLinkAccessTime(end, sd.documentSelfLink);
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            ServiceStats.ServiceStat s = this.getHistogramStat(STAT_NAME_INDEXING_DURATION_MICROS);
            this.setStat(s, (double)(end - start));
        }
        op.setBody(null).complete();
        this.checkDocumentRetentionLimit(sd, desc);
        this.applyActiveQueries(op, sd, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkAccessTime(long t, String link) {
        Object object = this.searchSync;
        synchronized (object) {
            this.linkAccessTimes.put(link, t);
            if (this.indexUpdateTimeMicros < t) {
                this.indexUpdateTimeMicros = t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher updateSearcher(String selfLink, int resultLimit, IndexWriter w) throws IOException {
        IndexSearcher s;
        boolean needNewSearcher = false;
        long now = Utils.getNowMicrosUtc();
        Object object = this.searchSync;
        synchronized (object) {
            s = this.searcher;
            if (s == null) {
                needNewSearcher = true;
            } else if (selfLink != null && resultLimit == 1) {
                Long latestUpdate = this.linkAccessTimes.get(selfLink);
                if (latestUpdate != null && latestUpdate.compareTo(this.searcherUpdateTimeMicros) >= 0) {
                    needNewSearcher = true;
                }
            } else if (this.searcherUpdateTimeMicros < this.indexUpdateTimeMicros) {
                needNewSearcher = true;
            }
            if (!needNewSearcher) {
                return s;
            }
        }
        s = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)w, (boolean)true, (boolean)true));
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            ServiceStats.ServiceStat st = this.getStat(STAT_NAME_SEARCHER_UPDATE_COUNT);
            this.adjustStat(st, 1.0);
        }
        object = this.searchSync;
        synchronized (object) {
            this.searchersPendingClose.add(s);
            if (this.searcherUpdateTimeMicros < now) {
                this.searcher = s;
                this.searcherUpdateTimeMicros = now;
            }
            return s;
        }
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void handleMaintenance(Operation post) {
        this.privateIndexingExecutor.execute(() -> {
            try {
                this.writerAvailable.acquire();
                this.handleMaintenanceImpl(false);
                post.complete();
            }
            catch (Throwable e) {
                post.fail(e);
            }
            finally {
                this.writerAvailable.release();
            }
        });
    }

    private void handleMaintenanceImpl(boolean forceMerge) throws Throwable {
        try {
            long start = Utils.getNowMicrosUtc();
            IndexWriter w = this.writer;
            if (w == null) {
                return;
            }
            this.setStat(STAT_NAME_INDEXED_DOCUMENT_COUNT, (double)w.maxDoc());
            this.adjustStat(STAT_NAME_COMMIT_COUNT, 1.0);
            long end = Utils.getNowMicrosUtc();
            this.setStat(STAT_NAME_COMMIT_DURATION_MICROS, (double)(end - start));
            IndexSearcher s = this.updateSearcher(null, Integer.MAX_VALUE, w);
            if (s == null) {
                return;
            }
            long deadline = Utils.getNowMicrosUtc() + this.getMaintenanceIntervalMicros();
            this.applyDocumentExpirationPolicy(w, deadline);
            this.applyDocumentVersionRetentionPolicy();
            w.commit();
            this.applyMemoryLimit();
            this.applyTimeSeriesStatsUpdates();
            boolean reOpenWriter = this.applyIndexSearcherAndFileLimit();
            if (!forceMerge && !reOpenWriter) {
                return;
            }
            this.reOpenWriterSynchronously();
        }
        catch (Throwable e) {
            if (this.getHost().isStopping()) {
                return;
            }
            this.logWarning("Attempting recovery due to error: %s", e.getMessage());
            this.reOpenWriterSynchronously();
            throw e;
        }
    }

    private void applyTimeSeriesStatsUpdates() {
        for (String name : TIME_SERIES_ENABLED_STATS) {
            this.updateTimeSeriesStat(name);
        }
    }

    private void updateTimeSeriesStat(String name) {
        ServiceStats.ServiceStat st = this.getStat(name);
        if (st == null) {
            return;
        }
        super.setStat(name + "PerDay", st.latestValue);
        super.setStat(name + "PerHour", st.latestValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyIndexSearcherAndFileLimit() {
        File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
        String[] list = directory.list();
        int count = list == null ? 0 : list.length;
        boolean reOpenWriter = count >= INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH;
        int searcherCount = this.searchersPendingClose.size();
        if (searcherCount < INDEX_SEARCHER_COUNT_THRESHOLD && !reOpenWriter) {
            return reOpenWriter;
        }
        int acquireReleaseCount = QUERY_THREAD_COUNT + UPDATE_THREAD_COUNT;
        try {
            if (this.getHost().isStopping()) {
                boolean bl = false;
                return bl;
            }
            this.writerAvailable.release();
            this.writerAvailable.acquire(acquireReleaseCount);
            this.searcher = null;
            this.logInfo("Closing %d pending searchers, index file count: %d", searcherCount, count);
            for (IndexSearcher s : this.searchersPendingClose) {
                try {
                    s.getIndexReader().close();
                }
                catch (Throwable throwable) {}
            }
            this.searchersPendingClose.clear();
            IndexWriter w = this.writer;
            if (w != null) {
                try {
                    w.deleteUnusedFiles();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (InterruptedException e1) {
            this.logSevere(e1);
        }
        finally {
            this.writerAvailable.release(acquireReleaseCount - 1);
        }
        return reOpenWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reOpenWriterSynchronously() {
        int acquireReleaseCount = QUERY_THREAD_COUNT + UPDATE_THREAD_COUNT;
        try {
            if (this.getHost().isStopping()) {
                return;
            }
            this.writerAvailable.release();
            this.writerAvailable.acquire(acquireReleaseCount);
            IndexWriter w = this.writer;
            long now = Utils.getNowMicrosUtc();
            if (now - this.indexWriterCreationTimeMicros < this.getHost().getMaintenanceIntervalMicros()) {
                this.logInfo("Skipping writer re-open, it was created recently", new Object[0]);
                return;
            }
            File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            w = this.createWriter(directory, false);
            this.logInfo("Reopened writer, document count: %d", w.maxDoc());
        }
        catch (Throwable e) {
            this.logSevere(e);
            this.logWarning("Stopping local host since index is not accessible", new Object[0]);
            this.close(this.writer);
            this.writer = null;
            this.sendRequest(Operation.createDelete(this, "/core/management"));
        }
        finally {
            this.writerAvailable.release(acquireReleaseCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDocumentVersionRetentionPolicy() throws Throwable {
        IndexWriter wr = this.writer;
        if (wr == null) {
            return;
        }
        Operation dummyDelete = Operation.createDelete(null);
        int count = 0;
        HashMap<String, Long> links = new HashMap<String, Long>();
        Map<String, Long> map = this.linkDocumentRetentionEstimates;
        synchronized (map) {
            links.putAll(this.linkDocumentRetentionEstimates);
            this.linkDocumentRetentionEstimates.clear();
        }
        for (Map.Entry entry : links.entrySet()) {
            this.deleteDocumentsFromIndex(dummyDelete, (String)entry.getKey(), (Long)entry.getValue());
            ++count;
        }
        if (!links.isEmpty()) {
            this.logInfo("Applied retention policy to %d links", count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMemoryLimit() {
        if (this.getHost().isStopping()) {
            return;
        }
        long memThresholdBytes = this.linkAccessMemoryLimitMB * 1024L * 1024L;
        int bytesPerLinkEstimate = 256;
        int count = 0;
        Object object = this.searchSync;
        synchronized (object) {
            if (this.linkAccessTimes.isEmpty()) {
                return;
            }
            if (memThresholdBytes < (long)(this.linkAccessTimes.size() * 256)) {
                count = this.linkAccessTimes.size();
                this.linkAccessTimes.clear();
                if (this.searcher != null) {
                    this.searchersPendingClose.add(this.searcher);
                }
                this.searcher = null;
            }
        }
        if (count > 0) {
            this.logInfo("Cleared %d link access times", count);
        }
        long now = Utils.getNowMicrosUtc();
        HashMap<Long, List<IndexSearcher>> entriesToClose = new HashMap<Long, List<IndexSearcher>>();
        Iterator iterator = this.searchSync;
        synchronized (iterator) {
            Map.Entry<Long, List<IndexSearcher>> entry;
            Iterator<Map.Entry<Long, List<IndexSearcher>>> itr = this.searchersForPaginatedQueries.entrySet().iterator();
            while (itr.hasNext() && (entry = itr.next()).getKey() <= now) {
                entriesToClose.put(entry.getKey(), entry.getValue());
                itr.remove();
            }
            this.setStat(STAT_NAME_ACTIVE_PAGINATED_QUERIES, (double)this.searchersForPaginatedQueries.size());
        }
        for (Map.Entry entry : entriesToClose.entrySet()) {
            List searchers = (List)entry.getValue();
            for (IndexSearcher s : searchers) {
                try {
                    this.logFine("Closing paginated query searcher, expired at %d", entry.getKey());
                    s.getIndexReader().close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void applyDocumentExpirationPolicy(IndexWriter w, long deadline) throws Throwable {
        IndexSearcher s;
        IndexSearcher indexSearcher = s = this.searcher != null ? this.searcher : this.updateSearcher(null, Integer.MAX_VALUE, w);
        if (s == null) {
            return;
        }
        long expirationUpperBound = Utils.getNowMicrosUtc();
        Query versionQuery = LongPoint.newRangeQuery((String)"documentExpirationTimeMicros", (long)1L, (long)expirationUpperBound);
        ScoreDoc after = null;
        boolean firstQuery = true;
        HashMap<String, Long> latestVersions = new HashMap<String, Long>();
        do {
            TopFieldDocs results = s.searchAfter(after, versionQuery, EXPIRED_DOCUMENT_SEARCH_THRESHOLD, this.versionSort, false, false);
            if (results.scoreDocs == null || results.scoreDocs.length == 0) {
                return;
            }
            after = results.scoreDocs[results.scoreDocs.length - 1];
            if (firstQuery && results.totalHits > EXPIRED_DOCUMENT_SEARCH_THRESHOLD) {
                this.adjustStat(STAT_NAME_DOCUMENT_EXPIRATION_FORCED_MAINTENANCE_COUNT, 1.0);
            }
            firstQuery = false;
            long now = Utils.getNowMicrosUtc();
            for (ScoreDoc sd : results.scoreDocs) {
                Document d = s.getIndexReader().document(sd.doc, this.fieldsToLoadNoExpand);
                String link = d.get("documentSelfLink");
                IndexableField versionField = d.getField("documentVersion");
                long versionExpired = versionField.numericValue().longValue();
                Long latestVersion = (Long)latestVersions.get(link);
                if (latestVersion == null) {
                    latestVersion = this.getLatestVersion(s, link);
                    latestVersions.put(link, latestVersion);
                }
                if (versionExpired < latestVersion) continue;
                this.checkAndDeleteExpiratedDocuments(link, s, sd.doc, d, now);
            }
        } while (Utils.getNowMicrosUtc() < deadline);
    }

    private void applyActiveQueries(Operation op, ServiceDocument latestState, ServiceDocumentDescription desc) {
        if (this.activeQueries.isEmpty()) {
            return;
        }
        OperationContext.setFrom(op);
        for (Map.Entry<String, QueryTask> taskEntry : this.activeQueries.entrySet()) {
            if (this.getHost().isStopping()) continue;
            QueryTask activeTask = taskEntry.getValue();
            QueryFilter filter = activeTask.querySpec.context.filter;
            if (desc == null ? !QueryFilterUtils.evaluate(filter, latestState, this.getHost()) : !filter.evaluate(latestState, desc)) continue;
            QueryTask patchBody = new QueryTask();
            patchBody.taskInfo.stage = TaskState.TaskStage.STARTED;
            patchBody.querySpec = null;
            patchBody.results = new ServiceDocumentQueryResult();
            patchBody.results.documentLinks.add(latestState.documentSelfLink);
            if (activeTask.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
                patchBody.results.documents = new HashMap<String, Object>();
                patchBody.results.documents.put(latestState.documentSelfLink, latestState);
            }
            this.sendRequest(Operation.createPatch(this, activeTask.documentSelfLink).setBodyNoCloning(patchBody));
        }
    }

    public static Document addNumericField(Document doc, String propertyName, long propertyValue, boolean stored) {
        if (stored) {
            doc.add((IndexableField)new StoredField(propertyName, propertyValue));
        }
        doc.add((IndexableField)new LongPoint(propertyName, new long[]{propertyValue}));
        doc.add((IndexableField)new NumericDocValuesField(propertyName, propertyValue));
        return doc;
    }

    public static Document addNumericField(Document doc, String propertyName, double propertyValue, boolean stored) {
        long longPropertyValue = NumericUtils.doubleToSortableLong((double)propertyValue);
        if (stored) {
            doc.add((IndexableField)new StoredField(propertyName, propertyValue));
        }
        doc.add((IndexableField)new DoublePoint(propertyName, new double[]{propertyValue}));
        doc.add((IndexableField)new NumericDocValuesField(propertyName, longPropertyValue));
        return doc;
    }

    public static class RestoreRequest
    extends ServiceDocument {
        URI backupFile;
        static final String KIND = Utils.buildKind(RestoreRequest.class);
    }

    public static class BackupRequest
    extends ServiceDocument {
        URI backupFile;
        static final String KIND = Utils.buildKind(BackupRequest.class);
    }
}

