/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.jwt;

import com.vmware.xenon.common.PrivateKeyReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JWTUtils {
    private static final Logger logger = Logger.getLogger(JWTUtils.class.getName());

    public static byte[] getJWTSecret(URI privateKeyFileUri, String privateKeyPassphrase, boolean isAuthorizationEnabled) throws IOException {
        byte[] secret;
        if (privateKeyFileUri != null) {
            Path privateKeyFilePath = Paths.get(privateKeyFileUri);
            PrivateKey privateKey = PrivateKeyReader.fromPem(privateKeyFilePath, privateKeyPassphrase);
            secret = privateKey.getEncoded();
        } else {
            if (isAuthorizationEnabled) {
                String msg = "\n\n########################################################\n##  Using default secret to sign/verify JSON(JWT)     ##\n##  This is NOT secure. Please consider enabling SSL. ##\n########################################################\n\n";
                logger.log(Level.WARNING, msg);
            }
            secret = "BAD_SECRET_NOT_SECURE".getBytes("UTF-8");
        }
        return secret;
    }
}

