/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.http.netty.NettyHttpServiceClient;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestCallbackService
extends StatelessService {
    Map<Long, Operation> pendingOperations = new HashMap<Long, Operation>();
    private String publicUri;
    private long nextKey = 0L;
    private NettyHttpServiceClient client;

    public HttpRequestCallbackService(NettyHttpServiceClient client) {
        super(ServiceDocument.class);
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queueUntilCallback(Operation op) {
        long key = 0L;
        Map<Long, Operation> map = this.pendingOperations;
        synchronized (map) {
            key = this.nextKey++;
            this.pendingOperations.put(key, op);
        }
        if (this.publicUri == null) {
            this.publicUri = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink()).toString();
        }
        return this.publicUri + "?" + key;
    }

    @Override
    public void authorizeRequest(Operation o) {
        if (o.getAction() != Service.Action.PATCH) {
            super.authorizeRequest(o);
            return;
        }
        o.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(Operation o) {
        if (o.getAction() == Service.Action.DELETE) {
            super.handleRequest(o);
            return;
        }
        if (o.getAction() != Service.Action.PATCH) {
            o.fail(new IllegalArgumentException("action not supported: " + (Object)((Object)o.getAction())));
            return;
        }
        Operation request = null;
        try {
            String query = o.getUri().getQuery();
            if (query == null) {
                o.fail(new IllegalArgumentException("Missing query parameter"));
                return;
            }
            Long opId = Long.parseLong(query);
            Map<Long, Operation> map = this.pendingOperations;
            synchronized (map) {
                request = this.pendingOperations.remove(opId);
            }
            if (request == null) {
                o.fail(new IllegalArgumentException("Operation not found: " + o.getUri()));
                return;
            }
            this.client.stopTracking(request);
            String responseStatusValue = o.getRequestHeaders().remove("x-xenon-rsp-status");
            if (responseStatusValue == null) {
                request.fail(new IllegalArgumentException("Missing response callback status header :" + o.toString()));
                return;
            }
            request.setBodyNoCloning(o.getBodyRaw());
            request.transferRequestHeadersToResponseHeadersFrom(o);
            request.setStatusCode(Integer.parseInt(responseStatusValue));
            if (request.getStatusCode() >= 400) {
                request.fail(new Exception("request failed, see body for details"));
            } else {
                request.complete();
            }
        }
        catch (Throwable e) {
            this.logSevere(e);
            if (request != null) {
                request.fail(e);
            }
        }
        finally {
            if (request != null) {
                o.complete();
            }
        }
    }
}

