/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceSubscriptionState;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.ReliableSubscriptionService;
import com.vmware.xenon.services.common.TaskService;
import java.net.URI;
import java.util.Arrays;
import java.util.function.Consumer;

public class TaskFactoryService
extends FactoryService {
    public TaskFactoryService(Class<? extends TaskService.TaskServiceState> stateClass) {
        super(stateClass);
    }

    public static FactoryService create(final Class<? extends Service> childServiceType, Service.ServiceOption ... options) {
        try {
            Service s = childServiceType.newInstance();
            Class<? extends ServiceDocument> childServiceDocumentType = s.getStateType();
            TaskFactoryService fs = new TaskFactoryService(childServiceDocumentType){

                @Override
                public Service createServiceInstance() throws Throwable {
                    return (Service)childServiceType.newInstance();
                }
            };
            Arrays.stream(options).forEach(option -> fs.toggleOption((Service.ServiceOption)((Object)option), true));
            return fs;
        }
        catch (Throwable e) {
            Utils.logWarning("Failure creating factory for %s: %s", childServiceType, Utils.toString(e));
            return null;
        }
    }

    @Override
    public void handleRequest(Operation op, Service.OperationProcessingStage opProcessingStage) {
        boolean isIdempotentPut;
        opProcessingStage = Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER;
        boolean bl = isIdempotentPut = op.getAction() == Service.Action.PUT && op.hasPragmaDirective("xn-post-to-put");
        if (op.getAction() != Service.Action.POST && !isIdempotentPut) {
            super.handleRequest(op, opProcessingStage);
            return;
        }
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        TaskService.TaskServiceState initState = (TaskService.TaskServiceState)op.getBody(super.getStateType());
        if (initState.taskInfo == null || !initState.taskInfo.isDirect) {
            super.handleRequest(op, opProcessingStage);
            return;
        }
        if (op.isFromReplication() || op.isForwarded()) {
            super.handleRequest(op, opProcessingStage);
            return;
        }
        this.handleDirectTaskPost(op, initState);
    }

    private void handleDirectTaskPost(Operation post, TaskService.TaskServiceState initState) {
        if (initState.taskInfo.stage == null) {
            initState.taskInfo.stage = TaskState.TaskStage.CREATED;
        }
        Operation clonedPost = post.clone();
        clonedPost.setCompletion((o, e) -> {
            if (e != null) {
                post.setStatusCode(o.getStatusCode()).setBodyNoCloning(o.getBodyRaw()).fail(e);
                return;
            }
            this.subscribeToChildTask(o, post);
        });
        super.handleRequest(clonedPost, Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER);
    }

    private void subscribeToChildTask(Operation o, Operation post) {
        TaskService.TaskServiceState initState = (TaskService.TaskServiceState)o.getBody(super.getStateType());
        Operation subscribe = Operation.createPost(this, initState.documentSelfLink).transferRefererFrom(post).setCompletion((so, e) -> {
            if (e == null) {
                return;
            }
            post.setStatusCode(so.getStatusCode()).setBodyNoCloning(so.getBodyRaw()).fail(e);
        });
        ServiceSubscriptionState.ServiceSubscriber sr = ServiceSubscriptionState.ServiceSubscriber.create(true).setUsePublicUri(true);
        Consumer<Operation> notifyC = nOp -> {
            nOp.complete();
            switch (nOp.getAction()) {
                case PUT: 
                case PATCH: {
                    TaskService.TaskServiceState task = (TaskService.TaskServiceState)nOp.getBody(super.getStateType());
                    if (task.taskInfo == null || TaskState.isInProgress(task.taskInfo)) {
                        return;
                    }
                    post.setBodyNoCloning(task).complete();
                    this.stopInDirectTaskSubscription(subscribe, nOp.getUri());
                    return;
                }
                case DELETE: {
                    post.setStatusCode(408).fail(new IllegalStateException("Task self deleted"));
                    this.stopInDirectTaskSubscription(subscribe, nOp.getUri());
                    return;
                }
            }
        };
        if (this.hasChildOption(Service.ServiceOption.OWNER_SELECTION)) {
            ReliableSubscriptionService notificationTarget = ReliableSubscriptionService.create(subscribe, sr, notifyC);
            this.getHost().startSubscriptionService(subscribe, notificationTarget, sr);
        } else {
            this.getHost().startSubscriptionService(subscribe, notifyC, sr);
        }
    }

    private void stopInDirectTaskSubscription(Operation sub, URI notificationTarget) {
        this.getHost().stopSubscriptionService(sub.clone().setAction(Service.Action.DELETE), notificationTarget);
    }

    @Override
    public Service createServiceInstance() throws Throwable {
        return null;
    }
}

