/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.AuthorizationCacheUtils;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.util.Set;

public class RoleService
extends StatefulService {
    public static final String FACTORY_LINK = ServiceUriPaths.CORE_AUTHZ_ROLES;

    public static Service createFactory() {
        FactoryService fs = new FactoryService(RoleState.class){

            @Override
            public Service createServiceInstance() throws Throwable {
                return new RoleService();
            }

            @Override
            public void handlePost(Operation request) {
                RoleService.checkAndNestCompletionForAuthzCacheClear(this, request);
                super.handlePost(request);
            }
        };
        fs.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
        return fs;
    }

    private static void checkAndNestCompletionForAuthzCacheClear(Service s, Operation op) {
        RoleState state;
        if (AuthorizationCacheUtils.isAuthzCacheClearApplicableOperation(op) && (state = AuthorizationCacheUtils.extractBody(op, s, RoleState.class)) != null) {
            AuthorizationCacheUtils.clearAuthzCacheForRole(s, op, state);
        }
    }

    public RoleService() {
        super(RoleState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void processCompletionStageUpdateAuthzArtifacts(Operation op) {
        RoleService.checkAndNestCompletionForAuthzCacheClear(this, op);
        op.complete();
    }

    @Override
    public void setProcessingStage(Service.ProcessingStage stage) {
        if (stage == Service.ProcessingStage.PAUSED) {
            throw new IllegalStateException("Cannot pause service.");
        }
        super.setProcessingStage(stage);
    }

    @Override
    public void handleStart(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        RoleState state = op.getBody(RoleState.class);
        if (!this.validate(op, state)) {
            return;
        }
        op.complete();
    }

    @Override
    public void handlePut(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        RoleState newState = op.getBody(RoleState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        RoleState currentState = (RoleState)this.getState(op);
        ServiceDocumentDescription documentDescription = this.getStateDescription();
        if (ServiceDocument.equals(documentDescription, currentState, newState)) {
            op.setStatusCode(304);
        } else {
            this.setState(op, newState);
        }
        op.complete();
    }

    private boolean validate(Operation op, RoleState state) {
        if (state.userGroupLink == null) {
            op.fail(new IllegalArgumentException("userGroupLink is required"));
            return false;
        }
        if (state.resourceGroupLink == null) {
            op.fail(new IllegalArgumentException("resourceGroupLink is required"));
            return false;
        }
        if (state.verbs == null) {
            op.fail(new IllegalArgumentException("verbs is required"));
            return false;
        }
        if (state.policy == null) {
            op.fail(new IllegalArgumentException("policy is required"));
            return false;
        }
        if (state.policy == Policy.DENY) {
            op.fail(new IllegalArgumentException("DENY policy is not supported"));
            return false;
        }
        return true;
    }

    public static class RoleState
    extends ServiceDocument {
        public static final String KIND = Utils.buildKind(RoleState.class);
        public static final String FIELD_NAME_USER_GROUP_LINK = "userGroupLink";
        public static final String FIELD_NAME_RESOURCE_GROUP_LINK = "resourceGroupLink";
        public String userGroupLink;
        public String resourceGroupLink;
        public Set<Service.Action> verbs;
        public Policy policy;
        public int priority;
    }

    public static enum Policy {
        ALLOW,
        DENY;

    }
}

