/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.services.common.QueryTask;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

class LuceneQueryConverter {
    LuceneQueryConverter() {
    }

    static Query convertToLuceneQuery(QueryTask.Query query) {
        if (query.occurance == null) {
            query.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        }
        if (query.booleanClauses != null) {
            if (query.term != null) {
                throw new IllegalArgumentException("term and booleanClauses are mutually exclusive");
            }
            return LuceneQueryConverter.convertToLuceneBooleanQuery(query);
        }
        if (query.term == null) {
            throw new IllegalArgumentException("One of term, booleanClauses must be provided");
        }
        QueryTask.QueryTerm term = query.term;
        LuceneQueryConverter.validateTerm(term);
        if (term.matchType == null) {
            term.matchType = QueryTask.QueryTerm.MatchType.TERM;
        }
        if (query.term.range != null) {
            return LuceneQueryConverter.convertToLuceneNumericRangeQuery(query);
        }
        if (query.term.matchType == QueryTask.QueryTerm.MatchType.WILDCARD) {
            return LuceneQueryConverter.convertToLuceneWildcardTermQuery(query);
        }
        if (query.term.matchType == QueryTask.QueryTerm.MatchType.PHRASE) {
            return LuceneQueryConverter.convertToLucenePhraseQuery(query);
        }
        if (query.term.matchType == QueryTask.QueryTerm.MatchType.PREFIX) {
            return LuceneQueryConverter.convertToLucenePrefixQuery(query);
        }
        return LuceneQueryConverter.convertToLuceneSingleTermQuery(query);
    }

    static Query convertToLuceneSingleTermQuery(QueryTask.Query query) {
        return new TermQuery(LuceneQueryConverter.convertToLuceneTerm(query.term));
    }

    static Query convertToLucenePhraseQuery(QueryTask.Query query) {
        String[] tokens = query.term.matchValue.split("\\W");
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        for (String token : tokens) {
            builder.add(new Term(query.term.propertyName, token));
        }
        return builder.build();
    }

    static Query convertToLucenePrefixQuery(QueryTask.Query query) {
        return new PrefixQuery(LuceneQueryConverter.convertToLuceneTerm(query.term));
    }

    static Query convertToLuceneWildcardTermQuery(QueryTask.Query query) {
        return new WildcardQuery(LuceneQueryConverter.convertToLuceneTerm(query.term));
    }

    static Query convertToLuceneNumericRangeQuery(QueryTask.Query query) {
        QueryTask.QueryTerm term = query.term;
        term.range.validate();
        if (term.range.type == ServiceDocumentDescription.TypeName.LONG) {
            return LuceneQueryConverter.createLongRangeQuery(term.propertyName, term.range);
        }
        if (term.range.type == ServiceDocumentDescription.TypeName.DOUBLE) {
            return LuceneQueryConverter.createDoubleRangeQuery(term.propertyName, term.range);
        }
        if (term.range.type == ServiceDocumentDescription.TypeName.DATE) {
            return LuceneQueryConverter.createLongRangeQuery(term.propertyName, term.range);
        }
        throw new IllegalArgumentException("Type is not supported:" + (Object)((Object)term.range.type));
    }

    static Query convertToLuceneBooleanQuery(QueryTask.Query query) {
        BooleanQuery.Builder parentQuery = new BooleanQuery.Builder();
        for (QueryTask.Query q : query.booleanClauses) {
            LuceneQueryConverter.buildBooleanQuery(parentQuery, q);
        }
        return parentQuery.build();
    }

    static void buildBooleanQuery(BooleanQuery.Builder parent, QueryTask.Query clause) {
        Query lq = LuceneQueryConverter.convertToLuceneQuery(clause);
        BooleanClause bc = new BooleanClause(lq, LuceneQueryConverter.convertToLuceneOccur(clause.occurance));
        parent.add(bc);
    }

    static BooleanClause.Occur convertToLuceneOccur(QueryTask.Query.Occurance occurance) {
        if (occurance == null) {
            return BooleanClause.Occur.MUST;
        }
        switch (occurance) {
            case MUST_NOT_OCCUR: {
                return BooleanClause.Occur.MUST_NOT;
            }
            case MUST_OCCUR: {
                return BooleanClause.Occur.MUST;
            }
            case SHOULD_OCCUR: {
                return BooleanClause.Occur.SHOULD;
            }
        }
        return BooleanClause.Occur.MUST;
    }

    static Term convertToLuceneTerm(QueryTask.QueryTerm term) {
        return new Term(term.propertyName, term.matchValue);
    }

    static void validateTerm(QueryTask.QueryTerm term) {
        if (term.range == null && term.matchValue == null) {
            throw new IllegalArgumentException("One of term.matchValue, term.range is required");
        }
        if (term.range != null && term.matchValue != null) {
            throw new IllegalArgumentException("term.matchValue and term.range are exclusive of each other");
        }
        if (term.propertyName == null) {
            throw new IllegalArgumentException("term.propertyName is required");
        }
    }

    static SortField.Type convertToLuceneType(ServiceDocumentDescription.TypeName typeName) {
        if (typeName == null) {
            return SortField.Type.STRING;
        }
        switch (typeName) {
            case STRING: {
                return SortField.Type.STRING;
            }
            case BYTES: {
                return SortField.Type.BYTES;
            }
            case DOUBLE: {
                return SortField.Type.DOUBLE;
            }
            case LONG: {
                return SortField.Type.LONG;
            }
        }
        return SortField.Type.STRING;
    }

    static Sort convertToLuceneSort(QueryTask.QuerySpecification querySpecification, boolean isGroupSort) {
        QueryTask.QueryTerm sortTerm = isGroupSort ? querySpecification.groupSortTerm : querySpecification.sortTerm;
        QueryTask.QuerySpecification.SortOrder sortOrder = isGroupSort ? querySpecification.groupSortOrder : querySpecification.sortOrder;
        LuceneQueryConverter.validateSortTerm(sortTerm);
        if (querySpecification.options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS) && (querySpecification.resultLimit <= 0 || querySpecification.resultLimit == Integer.MAX_VALUE)) {
            throw new IllegalArgumentException("resultLimit should be a positive integer less than MAX_VALUE");
        }
        if (sortOrder == null) {
            if (isGroupSort) {
                querySpecification.groupSortOrder = QueryTask.QuerySpecification.SortOrder.ASC;
            } else {
                querySpecification.sortOrder = QueryTask.QuerySpecification.SortOrder.ASC;
            }
        }
        boolean order = sortOrder != QueryTask.QuerySpecification.SortOrder.ASC;
        SortedNumericSortField sortField = null;
        SortField.Type type = LuceneQueryConverter.convertToLuceneType(sortTerm.propertyType);
        switch (type) {
            case LONG: 
            case DOUBLE: {
                sortField = new SortedNumericSortField(sortTerm.propertyName, type, order);
                break;
            }
            default: {
                sortField = new SortField(sortTerm.propertyName, type, order);
            }
        }
        return new Sort((SortField)sortField);
    }

    static void validateSortTerm(QueryTask.QueryTerm term) {
        if (term.propertyType == null) {
            throw new IllegalArgumentException("term.propertyType is required");
        }
        if (term.propertyName == null) {
            throw new IllegalArgumentException("term.propertyName is required");
        }
    }

    private static Query createLongRangeQuery(String propertyName, QueryTask.NumericRange<?> range) {
        Long min = range.min == null ? Long.MIN_VALUE : ((Number)range.min).longValue();
        Long max = range.max == null ? Long.MAX_VALUE : ((Number)range.max).longValue();
        if (!range.isMinInclusive) {
            min = Math.addExact(min, 1L);
        }
        if (!range.isMaxInclusive) {
            max = Math.addExact(max, -1L);
        }
        return LongPoint.newRangeQuery((String)propertyName, (long)min, (long)max);
    }

    private static Query createDoubleRangeQuery(String propertyName, QueryTask.NumericRange<?> range) {
        Double min = range.min == null ? Double.NEGATIVE_INFINITY : ((Number)range.min).doubleValue();
        Double max = range.max == null ? Double.POSITIVE_INFINITY : ((Number)range.max).doubleValue();
        if (!range.isMinInclusive) {
            min = Math.nextUp(min);
        }
        if (!range.isMaxInclusive) {
            max = Math.nextDown(max);
        }
        return DoublePoint.newRangeQuery((String)propertyName, (double)min, (double)max);
    }
}

