/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.LuceneDocumentIndexService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.BytesRef;

public class LuceneBlobIndexService
extends StatelessService {
    public static final String SELF_LINK = ServiceUriPaths.CORE_BLOB_INDEX;
    public static final String FILE_PATH = "lucene-blob-index";
    public static final String URI_PARAM_NAME_KEY = "key";
    private static final String URI_PARAM_NAME_UPDATE_TIME = "updateTime";
    private static final String LUCENE_FIELD_NAME_BINARY_CONTENT = "binaryContent";
    private String indexDirectory;
    private IndexSearcher searcher = null;
    private IndexWriter writer = null;
    private long searcherUpdateTimeMicros;
    private long indexUpdateTimeMicros;
    private EnumSet<BlobIndexOption> indexOptions;
    private Sort timeSort;
    private final int maxBinaryContextSizeBytes = 0x100000;
    private ExecutorService singleThreadedExecutor;
    private byte[] buffer;

    public static Operation createPost(ServiceHost host, String key, Object blob) {
        return LuceneBlobIndexService.createPost(host, SELF_LINK, key, blob);
    }

    public static Operation createGet(ServiceHost host, String key) {
        return LuceneBlobIndexService.createGet(host, SELF_LINK, key);
    }

    protected static Operation createPost(ServiceHost host, String indexPath, String key, Object blob) {
        URI indexUri = UriUtils.buildUri(host, indexPath, "key=" + key + "&" + URI_PARAM_NAME_UPDATE_TIME + "=" + Utils.getNowMicrosUtc());
        return Operation.createPost(indexUri).setBodyNoCloning(blob);
    }

    protected static Operation createGet(ServiceHost host, String indexPath, String key) {
        URI indexUri = UriUtils.buildUri(host, indexPath, "key=" + key);
        return Operation.createGet(indexUri);
    }

    public LuceneBlobIndexService() {
        this.indexDirectory = FILE_PATH;
        this.indexOptions = EnumSet.noneOf(BlobIndexOption.class);
    }

    public LuceneBlobIndexService(EnumSet<BlobIndexOption> options, String indexDirectory) {
        super(ServiceDocument.class);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        this.indexDirectory = indexDirectory;
        this.indexOptions = options;
    }

    @Override
    public void handleStart(Operation post) {
        this.singleThreadedExecutor = this.getHost().allocateExecutor(this, 1);
        super.setMaintenanceIntervalMicros(this.getHost().getMaintenanceIntervalMicros() * 5L);
        File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
        this.timeSort = new Sort(new SortField(URI_PARAM_NAME_UPDATE_TIME, SortField.Type.LONG, true));
        try {
            this.writer = this.createWriter(directory);
        }
        catch (Throwable e) {
            this.logSevere("Failure creating index writer on directory %s: %s", directory, Utils.toString(e));
            post.fail(e);
            return;
        }
        post.complete();
    }

    public IndexWriter createWriter(File directory) throws IOException {
        FSDirectory dir = MMapDirectory.open((Path)directory.toPath());
        SimpleAnalyzer analyzer = new SimpleAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
        if (this.indexOptions.contains((Object)BlobIndexOption.CREATE)) {
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        Long totalMBs = this.getHost().getServiceMemoryLimitMB(this.getSelfLink(), ServiceHost.ServiceHostState.MemoryLimitType.EXACT);
        if (totalMBs != null) {
            totalMBs = Math.max(1L, totalMBs);
            iwc.setRAMBufferSizeMB((double)totalMBs.longValue());
        }
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        w.commit();
        return w;
    }

    @Override
    public void handleRequest(Operation op) {
        Service.Action a = op.getAction();
        this.singleThreadedExecutor.execute(() -> {
            try {
                switch (a) {
                    case DELETE: {
                        this.handleDelete(op);
                        break;
                    }
                    case GET: {
                        this.handleGet(op);
                        break;
                    }
                    case POST: {
                        this.handlePost(op);
                        break;
                    }
                    default: {
                        this.getHost().failRequestActionNotSupported(op);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                op.fail(e);
            }
        });
    }

    @Override
    public void handleGet(Operation get) {
        try {
            Map<String, String> params = UriUtils.parseUriQueryParams(get.getUri());
            String key = params.get(URI_PARAM_NAME_KEY);
            if (key == null) {
                get.fail(new IllegalArgumentException("key query parameter is required"));
                return;
            }
            this.queryIndex(key, get);
        }
        catch (Throwable e) {
            this.logSevere(e);
            get.fail(e);
        }
    }

    private void queryIndex(String key, Operation op) throws Throwable {
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException());
            return;
        }
        IndexSearcher s = this.updateSearcher(w);
        TermQuery linkQuery = new TermQuery(new Term(URI_PARAM_NAME_KEY, key));
        TopFieldDocs hits = s.search((Query)linkQuery, 1, this.timeSort, false, false);
        if (hits.totalHits == 0) {
            op.complete();
            return;
        }
        Document hitDoc = s.doc(hits.scoreDocs[0].doc);
        BytesRef content = hitDoc.getBinaryValue(LUCENE_FIELD_NAME_BINARY_CONTENT);
        long updateTime = Long.parseLong(hitDoc.get(URI_PARAM_NAME_UPDATE_TIME));
        Object hydratedInstance = Utils.fromBytes(content.bytes, content.offset, content.length);
        this.applyBlobRetentionPolicy((Query)linkQuery, updateTime);
        op.setBodyNoCloning(hydratedInstance).complete();
    }

    @Override
    public void handlePost(Operation post) {
        if (post.isRemote()) {
            post.fail(new IllegalStateException("Remote requests not allowed"));
            return;
        }
        Map<String, String> params = UriUtils.parseUriQueryParams(post.getUri());
        String key = params.get(URI_PARAM_NAME_KEY);
        if (key == null) {
            post.fail(new IllegalArgumentException("key query parameter is required"));
            return;
        }
        String updateTimeParam = params.get(URI_PARAM_NAME_UPDATE_TIME);
        if (updateTimeParam == null) {
            post.fail(new IllegalArgumentException("update time query parameter is required"));
            return;
        }
        long updateTime = Long.parseLong(updateTimeParam);
        IndexWriter wr = this.writer;
        if (wr == null) {
            post.fail(new CancellationException());
            return;
        }
        try {
            Object content = post.getBodyRaw();
            if (content == null) {
                post.fail(new IllegalArgumentException("service instance is required"));
                return;
            }
            byte[] binaryContent = this.getBuffer();
            int count = Utils.toBytes(content, binaryContent, 0);
            Document doc = new Document();
            StoredField binaryContentField = new StoredField(LUCENE_FIELD_NAME_BINARY_CONTENT, binaryContent, 0, count);
            doc.add((IndexableField)binaryContentField);
            StringField keyField = new StringField(URI_PARAM_NAME_KEY, key, Field.Store.NO);
            doc.add((IndexableField)keyField);
            LuceneDocumentIndexService.addNumericField(doc, URI_PARAM_NAME_UPDATE_TIME, updateTime, true);
            wr.addDocument((Iterable)doc);
            this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
            post.setBody(null).complete();
        }
        catch (Throwable e) {
            this.logSevere(e);
            post.fail(e);
        }
    }

    private byte[] getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        this.buffer = new byte[this.maxBinaryContextSizeBytes];
        return this.buffer;
    }

    @Override
    public void handleDelete(Operation delete) {
        if (delete.hasBody()) {
            this.getHost().failRequestActionNotSupported(delete);
            return;
        }
        this.setProcessingStage(Service.ProcessingStage.STOPPED);
        IndexWriter w = this.writer;
        this.writer = null;
        this.close(w);
        this.singleThreadedExecutor.shutdownNow();
        delete.complete();
    }

    private void close(IndexWriter wr) {
        try {
            if (wr == null) {
                return;
            }
            wr.commit();
            wr.close();
            this.buffer = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private IndexSearcher updateSearcher(IndexWriter w) throws IOException {
        long now = Utils.getNowMicrosUtc();
        IndexSearcher s = this.searcher;
        if (s != null && this.searcherUpdateTimeMicros > this.indexUpdateTimeMicros) {
            return s;
        }
        s = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)w, (boolean)true, (boolean)true));
        if (this.searcherUpdateTimeMicros < now) {
            this.closeSearcherSafe();
            this.searcher = s;
            this.searcherUpdateTimeMicros = now;
        }
        return this.searcher;
    }

    private void applyBlobRetentionPolicy(Query linkQuery, long updateTime) throws IOException {
        IndexWriter wr = this.writer;
        if (wr == null) {
            return;
        }
        if (!this.indexOptions.contains((Object)BlobIndexOption.SINGLE_USE_KEYS)) {
            return;
        }
        Query timeQuery = LongPoint.newRangeQuery((String)URI_PARAM_NAME_UPDATE_TIME, (long)Long.MIN_VALUE, (long)updateTime);
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add(linkQuery, BooleanClause.Occur.MUST).add(timeQuery, BooleanClause.Occur.MUST);
        wr.deleteDocuments(new Query[]{builder.build()});
        this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
    }

    @Override
    public void handleMaintenance(Operation post) {
        this.singleThreadedExecutor.execute(() -> this.handleMaintenanceSafe(post));
    }

    private void handleMaintenanceSafe(Operation post) {
        try {
            int count;
            IndexWriter w = this.writer;
            if (w == null) {
                post.complete();
                return;
            }
            w.commit();
            this.setStat("indexedDocumentCount", (double)w.maxDoc());
            File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
            String[] list = directory.list();
            int n = count = list == null ? 0 : list.length;
            if (count > LuceneDocumentIndexService.getIndexFileCountThresholdForWriterRefresh()) {
                this.logInfo("Index file count: %d, document count: %d", count, w.maxDoc());
                this.closeSearcherSafe();
                w.deleteUnusedFiles();
            }
            this.buffer = null;
            post.complete();
        }
        catch (Throwable e) {
            this.logSevere(e);
            post.fail(e);
        }
    }

    private void closeSearcherSafe() {
        if (this.searcher == null) {
            return;
        }
        try {
            this.searcher.getIndexReader().close();
            this.searcher = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static enum BlobIndexOption {
        SINGLE_USE_KEYS,
        CREATE;

    }
}

