/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.Utils;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class TaskService<T extends TaskServiceState>
extends StatefulService {
    public static final long DEFAULT_EXPIRATION_MINUTES = TimeUnit.HOURS.toMinutes(4L);

    protected TaskService(Class<? extends ServiceDocument> stateType) {
        super(stateType);
    }

    protected void setExpiration(T state, long timeUnitValue, TimeUnit timeUnit) {
        if (state == null) {
            throw new IllegalArgumentException("state cannot be null");
        }
        ((TaskServiceState)state).documentExpirationTimeMicros = Utils.getNowMicrosUtc() + timeUnit.toMicros(timeUnitValue);
    }

    @Override
    public void handleStart(Operation taskOperation) {
        T task = this.validateStartPost(taskOperation);
        if (task == null) {
            return;
        }
        taskOperation.complete();
        if (!ServiceHost.isServiceCreate(taskOperation) || ((TaskServiceState)task).taskInfo != null && !TaskState.isCreated(((TaskServiceState)task).taskInfo)) {
            return;
        }
        this.initializeState(task, taskOperation);
        this.sendSelfPatch(task);
    }

    protected T validateStartPost(Operation taskOperation) {
        TaskServiceState task = (TaskServiceState)this.getBody(taskOperation);
        if (!taskOperation.hasBody()) {
            taskOperation.fail(new IllegalArgumentException("POST body is required"));
            return null;
        }
        if (!ServiceHost.isServiceCreate(taskOperation)) {
            return (T)task;
        }
        return (T)task;
    }

    protected void initializeState(T task, Operation taskOperation) {
        if (((TaskServiceState)task).taskInfo == null) {
            ((TaskServiceState)task).taskInfo = new TaskState();
        }
        ((TaskServiceState)task).taskInfo.failure = null;
        ((TaskServiceState)task).taskInfo.durationMicros = null;
        ((TaskServiceState)task).taskInfo.stage = TaskState.TaskStage.STARTED;
        if (((TaskServiceState)task).documentExpirationTimeMicros == 0L) {
            this.setExpiration(task, DEFAULT_EXPIRATION_MINUTES, TimeUnit.MINUTES);
        }
        taskOperation.setBody(task);
    }

    protected void sendSelfPatch(T task) {
        Operation patch = Operation.createPatch(this.getUri()).setBody(task);
        this.sendRequest(patch);
    }

    protected boolean validateTransition(Operation patch, T currentTask, T patchBody) {
        if (((TaskServiceState)patchBody).taskInfo == null) {
            patch.fail(new IllegalArgumentException("Missing taskInfo"));
            return false;
        }
        if (((TaskServiceState)patchBody).taskInfo.stage == null) {
            patch.fail(new IllegalArgumentException("Missing stage"));
            return false;
        }
        if (((TaskServiceState)patchBody).taskInfo.stage == TaskState.TaskStage.CREATED) {
            patch.fail(new IllegalArgumentException("Did not expect to receive CREATED stage"));
            return false;
        }
        if (((TaskServiceState)currentTask).taskInfo != null && ((TaskServiceState)currentTask).taskInfo.stage != null && ((TaskServiceState)currentTask).taskInfo.stage.ordinal() > ((TaskServiceState)patchBody).taskInfo.stage.ordinal()) {
            patch.fail(new IllegalArgumentException("Task stage cannot move backwards"));
            return false;
        }
        return true;
    }

    protected void updateState(T currentTask, T patchBody) {
        Utils.mergeWithState(this.getStateDescription(), currentTask, patchBody);
    }

    protected void sendSelfFinishedPatch(T task) {
        this.sendSelfPatch(task, TaskState.TaskStage.FINISHED, null);
    }

    protected void sendSelfFailurePatch(T task, String failureMessage) {
        this.sendSelfPatch(task, TaskState.TaskStage.FAILED, s -> {
            s.failureMessage = failureMessage;
        });
    }

    protected void sendSelfCancellationPatch(T task, String cancellationMessage) {
        this.sendSelfPatch(task, TaskState.TaskStage.CANCELLED, s -> {
            s.failureMessage = cancellationMessage;
        });
    }

    protected void sendSelfPatch(T taskState, TaskState.TaskStage stage, Consumer<T> updateTaskState) {
        if (((TaskServiceState)taskState).taskInfo == null) {
            ((TaskServiceState)taskState).taskInfo = new TaskState();
        }
        ((TaskServiceState)taskState).taskInfo.stage = stage;
        if (updateTaskState != null) {
            updateTaskState.accept(taskState);
        }
        this.sendSelfPatch(taskState);
    }

    public static abstract class TaskServiceState
    extends ServiceDocument {
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public TaskState taskInfo;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String failureMessage;
    }
}

