/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class NodeSelectorReplicationService
extends StatelessService {
    public static final int BINARY_SERIALIZATION = Integer.getInteger("xenon.NodeSelectorReplicationService.BINARY_SERIALIZATION", 1);
    private Service parent;
    private Map<String, Integer> nodeCountPerLocation;
    private Map<URI, String> locationPerNodeURI;

    public NodeSelectorReplicationService(Service parent) {
        this.parent = parent;
        super.setHost(parent.getHost());
        super.setSelfLink(UriUtils.buildUriPath(parent.getSelfLink(), "/replication"));
        if (parent.getHost().getLocation() != null) {
            this.nodeCountPerLocation = new ConcurrentHashMap<String, Integer>();
            this.locationPerNodeURI = new ConcurrentHashMap<URI, String>();
        }
        super.setProcessingStage(Service.ProcessingStage.AVAILABLE);
    }

    void replicateUpdate(NodeGroupService.NodeGroupState localState, Operation outboundOp, NodeSelectorService.SelectAndForwardRequest req, NodeSelectorService.SelectOwnerResponse rsp) {
        int memberCount = localState.nodes.size();
        NodeState selfNode = localState.nodes.get(this.getHost().getId());
        if (req.serviceOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION) && selfNode.membershipQuorum > memberCount) {
            outboundOp.fail(new IllegalStateException("Not enough peers: " + memberCount));
            return;
        }
        if (memberCount == 1) {
            outboundOp.complete();
            return;
        }
        Collection<NodeState> selectedNodes = rsp.selectedNodes;
        int eligibleMemberCount = selectedNodes.size();
        String location = this.getHost().getLocation();
        String rplQuorumValue = outboundOp.getRequestHeader("x-xenon-rpl-quorum");
        if (rplQuorumValue != null) {
            int successThreshold;
            try {
                successThreshold = "x-xenon-all".equals(rplQuorumValue) ? eligibleMemberCount : Integer.parseInt(rplQuorumValue);
                if (successThreshold > eligibleMemberCount) {
                    String errorMsg = String.format("Requested quorum %d is larger than member count %d", successThreshold, eligibleMemberCount);
                    throw new IllegalArgumentException(errorMsg);
                }
                outboundOp.getRequestHeaders().remove("x-xenon-rpl-quorum");
            }
            catch (Throwable e) {
                outboundOp.setRetryCount(0).fail(e);
                return;
            }
            int failureThreshold = eligibleMemberCount - successThreshold + 1;
            this.replicateUpdateToNodes(outboundOp, selectedNodes, successThreshold, failureThreshold, location);
            return;
        }
        if (req.serviceOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION)) {
            int failureThreshold;
            int successThreshold;
            if (location == null) {
                successThreshold = Math.min(eligibleMemberCount, selfNode.membershipQuorum);
                failureThreshold = eligibleMemberCount - successThreshold + 1;
            } else {
                int localNodeCount = this.getNodeCountInLocation(location, selectedNodes);
                successThreshold = Math.min(localNodeCount, selfNode.membershipQuorum);
                failureThreshold = localNodeCount - successThreshold + 1;
            }
            this.replicateUpdateToNodes(outboundOp, selectedNodes, successThreshold, failureThreshold, location);
            return;
        }
        int successThreshold = Math.min(2, eligibleMemberCount - 1);
        int failureThreshold = eligibleMemberCount - successThreshold + 1;
        this.replicateUpdateToNodes(outboundOp, selectedNodes, successThreshold, failureThreshold, location);
    }

    private int getNodeCountInLocation(String location, Collection<NodeState> nodes) {
        Integer count = this.nodeCountPerLocation.get(location);
        if (count != null) {
            return count;
        }
        int intCount = (int)nodes.stream().filter(ns -> Objects.equals(location, ns.customProperties.get("xenon.NodeState.location"))).peek(ns -> this.locationPerNodeURI.put(UriUtils.buildUri(ns.groupReference.getHost(), ns.groupReference.getPort(), null, null), location)).count();
        this.nodeCountPerLocation.put(location, intCount);
        return intCount;
    }

    private boolean isResponseFromLocation(Operation remotePeerResponse, String location, Collection<NodeState> nodes) {
        if (remotePeerResponse == null) {
            return true;
        }
        URI remotePeerService = remotePeerResponse.getUri();
        URI remoteNodeUri = UriUtils.buildUri(remotePeerService.getHost(), remotePeerService.getPort(), null, null);
        String remoteNodeLocation = this.locationPerNodeURI.get(remoteNodeUri);
        return location.equals(remoteNodeLocation);
    }

    private void replicateUpdateToNodes(Operation outboundOp, Collection<NodeState> nodes, int successThreshold, int failureThreshold, String location) {
        String commitHeader;
        int successThresholdFinal = successThreshold;
        int failureThresholdFinal = failureThreshold;
        int[] countsAndStatus = new int[3];
        Operation.CompletionHandler c = (o, e) -> {
            if (location != null && !this.isResponseFromLocation(o, location, nodes)) {
                return;
            }
            if (e == null && o != null && o.getStatusCode() >= 400) {
                e = new IllegalStateException("Request failed: " + o.toString());
            }
            int sCount = countsAndStatus[0];
            int fCount = countsAndStatus[1];
            boolean completeWithSuccess = false;
            boolean completeWithFailure = false;
            Operation operation = outboundOp;
            synchronized (operation) {
                if (e != null) {
                    countsAndStatus[1] = countsAndStatus[1] + 1;
                    fCount = countsAndStatus[1];
                    completeWithFailure = fCount == failureThresholdFinal;
                } else {
                    countsAndStatus[0] = countsAndStatus[0] + 1;
                    sCount = countsAndStatus[0];
                    completeWithSuccess = sCount == successThresholdFinal;
                }
            }
            if (completeWithSuccess) {
                outboundOp.setStatusCode(200).complete();
                return;
            }
            if (e != null && o != null) {
                this.logWarning("(Original id: %d) Replication request to %s failed with %d, %s", outboundOp.getId(), o.getUri(), o.getStatusCode(), e.getMessage());
                countsAndStatus[2] = o.getStatusCode();
            }
            if (completeWithFailure) {
                String error = String.format("(Original id: %d) %s to %s failed. Success: %d,  Fail: %d, quorum: %d, failure threshold: %d", new Object[]{outboundOp.getId(), outboundOp.getAction(), outboundOp.getUri().getPath(), sCount, fCount, successThresholdFinal, failureThresholdFinal});
                this.logWarning("%s", error);
                outboundOp.setStatusCode(countsAndStatus[2]).fail(new IllegalStateException(error));
            }
        };
        String path = outboundOp.getUri().getPath();
        String query = outboundOp.getUri().getQuery();
        Operation update = Operation.createPost(null).setAction(outboundOp.getAction()).setCompletion(c).setRetryCount(1).setExpiration(outboundOp.getExpirationMicrosUtc()).transferRefererFrom(outboundOp);
        String pragmaHeader = outboundOp.getRequestHeader("pragma");
        if (pragmaHeader != null && !"xn-fwd".equals(pragmaHeader)) {
            update.addRequestHeader("pragma", pragmaHeader);
            update.addPragmaDirective("xn-rpl");
        }
        if ((commitHeader = outboundOp.getRequestHeader("x-xenon-rpl-phase")) != null) {
            update.addRequestHeader("x-xenon-rpl-phase", commitHeader);
        }
        Utils.encodeAndTransferLinkedStateToBody(outboundOp, update, BINARY_SERIALIZATION == 1);
        update.setFromReplication(true);
        update.setConnectionTag("xn-cnx-tag-replication");
        if (NodeSelectorService.REPLICATION_OPERATION_OPTION != null) {
            update.toggleOption(NodeSelectorService.REPLICATION_OPERATION_OPTION, true);
        }
        if (update.getCookies() != null) {
            update.getCookies().clear();
        }
        ServiceClient cl = this.getHost().getClient();
        String selfId = this.getHost().getId();
        c.handle(null, null);
        for (NodeState m : nodes) {
            if (m.id.equals(selfId) || m.options.contains((Object)NodeState.NodeOption.OBSERVER)) continue;
            try {
                URI remoteHost = m.groupReference;
                URI remotePeerService = new URI(remoteHost.getScheme(), null, remoteHost.getHost(), remoteHost.getPort(), path, query, null);
                update.setUri(remotePeerService);
            }
            catch (Throwable remoteHost) {
                // empty catch block
            }
            if (NodeState.isUnAvailable(m)) {
                int originalStatusCode = update.getStatusCode();
                update.setStatusCode(400);
                c.handle(update, new IllegalStateException("node is not available"));
                update.setStatusCode(originalStatusCode);
                continue;
            }
            cl.send(update);
        }
    }

    @Override
    public void sendRequest(Operation op) {
        this.parent.sendRequest(op);
    }

    @Override
    public ServiceHost getHost() {
        return this.parent.getHost();
    }
}

