/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.VersionFieldSerializer;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.serialization.BufferThreadLocal;
import com.vmware.xenon.common.serialization.FieldNullifyingVersionFieldSerializer;
import com.vmware.xenon.common.serialization.InstantSerializer;
import com.vmware.xenon.common.serialization.OutputWithRoot;
import com.vmware.xenon.common.serialization.URISerializer;
import com.vmware.xenon.common.serialization.UUIDSerializer;
import com.vmware.xenon.common.serialization.ZoneIdSerializer;
import com.vmware.xenon.common.serialization.ZonedDateTimeSerializer;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public final class KryoSerializers {
    private static final ThreadLocal<Kryo> kryoForObjectPerThread = new KryoForObjectThreadLocal();
    private static final ThreadLocal<Kryo> kryoForDocumentPerThread = new KryoForDocumentThreadLocal();
    private static ThreadLocal<Kryo> kryoForObjectPerThreadCustom;
    private static ThreadLocal<Kryo> kryoForDocumentPerThreadCustom;
    public static final long THREAD_LOCAL_BUFFER_LIMIT_BYTES = 0x100000L;
    private static final BufferThreadLocal bufferPerThread;

    private KryoSerializers() {
    }

    public static Kryo create(boolean isObjectSerializer) {
        Kryo k = new Kryo();
        k.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        k.setDefaultSerializer(VersionFieldSerializer.class);
        k.addDefaultSerializer(ZonedDateTime.class, (Serializer)ZonedDateTimeSerializer.INSTANCE);
        k.addDefaultSerializer(Instant.class, (Serializer)InstantSerializer.INSTANCE);
        k.addDefaultSerializer(ZoneId.class, (Serializer)ZoneIdSerializer.INSTANCE);
        k.addDefaultSerializer(UUID.class, (Serializer)UUIDSerializer.INSTANCE);
        k.addDefaultSerializer(URI.class, (Serializer)URISerializer.INSTANCE);
        if (!isObjectSerializer) {
            k.setReferences(false);
            k.setCopyReferences(false);
            k.setDefaultSerializer(FieldNullifyingVersionFieldSerializer.class);
        } else {
            k.setAutoReset(true);
        }
        return k;
    }

    public static void register(ThreadLocal<Kryo> kryoThreadLocal, boolean isDocumentSerializer) {
        if (isDocumentSerializer) {
            kryoForDocumentPerThreadCustom = kryoThreadLocal;
        } else {
            kryoForObjectPerThreadCustom = kryoThreadLocal;
        }
    }

    private static Kryo getKryoThreadLocalForDocuments() {
        ThreadLocal<Kryo> tl = kryoForDocumentPerThreadCustom;
        if (tl == null) {
            tl = kryoForDocumentPerThread;
        }
        Kryo k = tl.get();
        return k;
    }

    private static Kryo getKryoThreadLocalForObjects() {
        ThreadLocal<Kryo> tl = kryoForObjectPerThreadCustom;
        if (tl == null) {
            tl = kryoForObjectPerThread;
        }
        Kryo k = tl.get();
        return k;
    }

    public static int serializeDocument(ServiceDocument o, byte[] buffer, int position) {
        return KryoSerializers.serializeAsDocument(o, buffer, position);
    }

    public static int serializeAsDocument(Object o, byte[] buffer, int position) {
        Kryo k = KryoSerializers.getKryoThreadLocalForDocuments();
        Output out = new Output(buffer);
        out.setPosition(position);
        k.writeClassAndObject(out, o);
        return out.position();
    }

    public static int serializeObjectForIndexing(Object o, byte[] buffer, int position) {
        Kryo k = KryoSerializers.getKryoThreadLocalForDocuments();
        OutputWithRoot out = new OutputWithRoot(buffer, o);
        out.setPosition(position);
        k.writeClassAndObject((Output)out, o);
        return out.position();
    }

    public static int serializeObject(Object o, byte[] buffer, int position) {
        Kryo k = KryoSerializers.getKryoThreadLocalForObjects();
        Output out = new Output(buffer);
        out.setPosition(position);
        k.writeClassAndObject(out, o);
        return out.position();
    }

    public static <T> T clone(T t) {
        Kryo k = KryoSerializers.getKryoThreadLocalForDocuments();
        Object clone = k.copy(t);
        return (T)clone;
    }

    public static <T> T cloneObject(T t) {
        Kryo k = KryoSerializers.getKryoThreadLocalForObjects();
        Object clone = k.copy(t);
        k.reset();
        return (T)clone;
    }

    public static byte[] getBuffer(int capacity) {
        if ((long)capacity > 0x100000L) {
            return new byte[capacity];
        }
        byte[] buffer = (byte[])bufferPerThread.get();
        if (buffer.length < capacity) {
            buffer = new byte[capacity];
            bufferPerThread.set(buffer);
        }
        if (buffer.length > capacity * 10) {
            buffer = new byte[capacity];
            bufferPerThread.set(buffer);
        }
        return buffer;
    }

    public static Object deserializeObject(byte[] bytes, int position, int length) {
        Kryo k = KryoSerializers.getKryoThreadLocalForObjects();
        Input in = new Input(bytes, position, length);
        return k.readClassAndObject(in);
    }

    public static Object deserializeDocument(byte[] bytes, int position, int length) {
        Kryo k = KryoSerializers.getKryoThreadLocalForDocuments();
        Input in = new Input(bytes, position, length);
        return k.readClassAndObject(in);
    }

    static {
        bufferPerThread = new BufferThreadLocal();
    }

    public static class KryoForDocumentThreadLocal
    extends ThreadLocal<Kryo> {
        @Override
        protected Kryo initialValue() {
            return KryoSerializers.create(false);
        }
    }

    public static class KryoForObjectThreadLocal
    extends ThreadLocal<Kryo> {
        @Override
        protected Kryo initialValue() {
            return KryoSerializers.create(true);
        }
    }
}

