/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Utils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class ServiceErrorResponse {
    public static final int ERROR_CODE_INTERNAL_MASK = Integer.MIN_VALUE;
    public static final int ERROR_CODE_OUTDATED_SYNCH_REQUEST = -2147483647;
    public static final int ERROR_CODE_STATE_MARKED_DELETED = -2147483646;
    public static final int ERROR_CODE_SERVICE_ALREADY_EXISTS = -2147483645;
    public static final String KIND = Utils.buildKind(ServiceErrorResponse.class);
    public String message;
    public String messageId;
    public List<String> stackTrace;
    public int statusCode;
    public EnumSet<ErrorDetail> details;
    public String documentKind = KIND;
    protected int errorCode;

    public static ServiceErrorResponse create(Throwable e, int statusCode) {
        return ServiceErrorResponse.create(e, statusCode, null);
    }

    public static ServiceErrorResponse createWithShouldRetry(Throwable e) {
        return ServiceErrorResponse.create(e, 400, EnumSet.of(ErrorDetail.SHOULD_RETRY));
    }

    public static ServiceErrorResponse create(Throwable e, int statusCode, EnumSet<ErrorDetail> details) {
        ServiceErrorResponse rsp = new ServiceErrorResponse();
        rsp.message = e.getLocalizedMessage();
        rsp.stackTrace = new ArrayList<String>();
        for (StackTraceElement se : e.getStackTrace()) {
            rsp.stackTrace.add(se.toString());
        }
        rsp.details = details;
        rsp.statusCode = statusCode;
        return rsp;
    }

    private static boolean isInternalErrorCode(int errorCode) {
        return (errorCode & Integer.MIN_VALUE) != 0;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        if (ServiceErrorResponse.isInternalErrorCode(errorCode)) {
            throw new IllegalArgumentException("Error code must not use internal xenon errorCode range.");
        }
        this.errorCode = errorCode;
    }

    public void setInternalCode(int errorCode) {
        if (!ServiceErrorResponse.isInternalErrorCode(errorCode)) {
            throw new IllegalArgumentException("Error code must use internal xenon errorCode range.");
        }
        this.errorCode = errorCode;
    }

    public static enum ErrorDetail {
        SHOULD_RETRY;

    }
}

