/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class ServiceDocumentDescription {
    public static final int DEFAULT_VERSION_RETENTION_LIMIT = 1000;
    public static final long FIELD_VALUE_DISABLED_VERSION_RETENTION = Long.MIN_VALUE;
    public static final int DEFAULT_SERIALIZED_STATE_LIMIT = 32768;
    public static final String FIELD_NAME_TENANT_LINKS = "tenantLinks";
    public Map<String, PropertyDescription> propertyDescriptions;
    public EnumSet<Service.ServiceOption> serviceCapabilities;
    public Map<Service.Action, List<RequestRouter.Route>> serviceRequestRoutes;
    public String userInterfaceResourcePath;
    public long versionRetentionLimit = 1000L;
    public int serializedStateSizeLimit = 32768;

    public static class Builder {
        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public ServiceDocumentDescription buildDescription(Class<? extends ServiceDocument> type) {
            PropertyDescription root = this.buildPodoPropertyDescription(type, new HashSet<String>(), 0);
            ServiceDocumentDescription desc = new ServiceDocumentDescription();
            ServiceDocument.IndexingParameters indexingParameters = type.getAnnotation(ServiceDocument.IndexingParameters.class);
            if (indexingParameters != null) {
                desc.serializedStateSizeLimit = indexingParameters.serializedStateSize();
                desc.versionRetentionLimit = indexingParameters.versionRetention();
            }
            desc.propertyDescriptions = root.fieldDescriptions;
            return desc;
        }

        public PropertyDescription buildPodoPropertyDescription(Class<?> type) {
            return this.buildPodoPropertyDescription(type, new HashSet<String>(), 0);
        }

        public ServiceDocumentDescription buildDescription(Class<? extends ServiceDocument> type, EnumSet<Service.ServiceOption> serviceCaps) {
            ServiceDocumentDescription desc = this.buildDescription(type);
            desc.serviceCapabilities = serviceCaps;
            return desc;
        }

        public ServiceDocumentDescription buildDescription(Class<? extends ServiceDocument> type, EnumSet<Service.ServiceOption> serviceCaps, RequestRouter serviceRequestRouter) {
            ServiceDocumentDescription desc = this.buildDescription(type, serviceCaps);
            if (serviceRequestRouter != null) {
                desc.serviceRequestRoutes = serviceRequestRouter.getRoutes();
            }
            return desc;
        }

        protected PropertyDescription buildPodoPropertyDescription(Class<?> clazz, Set<String> visited, int depth) {
            PropertyDescription pd = new PropertyDescription();
            pd.fieldDescriptions = new HashMap<String, PropertyDescription>();
            String typeName = clazz.getTypeName();
            if (visited.contains(typeName)) {
                return pd;
            }
            visited.add(typeName);
            for (Field f : clazz.getFields()) {
                int mods = f.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isTransient(mods) || ServiceDocument.isBuiltInNonIndexedDocumentField(f.getName())) continue;
                PropertyDescription fd = new PropertyDescription();
                if (ServiceDocument.isBuiltInInfrastructureDocumentField(f.getName())) {
                    fd.usageOptions.add(PropertyUsageOption.INFRASTRUCTURE);
                }
                if (ServiceDocument.isAutoMergeEnabledByDefaultForField(f.getName())) {
                    fd.usageOptions.add(PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL);
                }
                if (ServiceDocument.isBuiltInSignatureExcludedDocumentField(f.getName())) {
                    fd.indexingOptions.add(PropertyIndexingOption.EXCLUDE_FROM_SIGNATURE);
                }
                if (ServiceDocument.isLink(f.getName())) {
                    fd.usageOptions.add(PropertyUsageOption.LINK);
                }
                if (ServiceDocument.isLinks(f.getName())) {
                    fd.usageOptions.add(PropertyUsageOption.LINKS);
                }
                if (f.getName().equals("documentOwner")) {
                    fd.usageOptions.add(PropertyUsageOption.ID);
                }
                if (fd.usageOptions.contains((Object)PropertyUsageOption.LINKS)) {
                    fd.indexingOptions.add(PropertyIndexingOption.EXPAND);
                }
                this.buildPropertyDescription(fd, f.getType(), f.getGenericType(), f.getAnnotations(), visited, depth);
                if (ServiceDocument.isBuiltInDocumentFieldWithNullExampleValue(f.getName())) {
                    fd.exampleValue = null;
                }
                fd.accessor = f;
                pd.fieldDescriptions.put(f.getName(), fd);
                if (fd.typeName != TypeName.PODO) continue;
                fd.kind = Utils.buildKind(f.getType());
            }
            visited.remove(typeName);
            return pd;
        }

        protected void buildPropertyDescription(PropertyDescription pd, Class<?> clazz, Type typ, Annotation[] annotations, Set<String> visited, int depth) {
            boolean isSimpleType = true;
            if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
                pd.typeName = TypeName.BOOLEAN;
                pd.exampleValue = false;
            } else if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
                pd.typeName = TypeName.LONG;
                pd.exampleValue = (short)0;
            } else if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
                pd.typeName = TypeName.LONG;
                pd.exampleValue = 0;
            } else if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
                pd.typeName = TypeName.LONG;
                pd.exampleValue = 0L;
            } else if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
                pd.typeName = TypeName.LONG;
                pd.exampleValue = (byte)0;
            } else if (byte[].class.equals(clazz)) {
                pd.typeName = TypeName.BYTES;
            } else if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
                pd.typeName = TypeName.DOUBLE;
                pd.exampleValue = 0.0;
            } else if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
                pd.typeName = TypeName.DOUBLE;
                pd.exampleValue = Float.valueOf(0.0f);
            } else if (Number.class.equals(clazz)) {
                pd.typeName = TypeName.DOUBLE;
                pd.exampleValue = 0.0;
            } else if (Character.class.equals(clazz) || Character.TYPE.equals(clazz)) {
                pd.typeName = TypeName.STRING;
                pd.exampleValue = Character.valueOf('a');
            } else if (String.class.equals(clazz)) {
                pd.typeName = TypeName.STRING;
                pd.exampleValue = "example string";
            } else if (Date.class.equals(clazz)) {
                pd.exampleValue = new Date();
                pd.typeName = TypeName.DATE;
            } else if (URI.class.equals(clazz)) {
                pd.exampleValue = URI.create("http://localhost:1234/some/service");
                pd.typeName = TypeName.URI;
            } else {
                isSimpleType = false;
            }
            if (annotations != null) {
                for (Annotation a : annotations) {
                    if (ServiceDocument.Documentation.class.equals(a.annotationType())) {
                        ServiceDocument.Documentation df = (ServiceDocument.Documentation)a;
                        if (df.description() != null && !df.description().isEmpty()) {
                            pd.propertyDocumentation = df.description();
                        }
                        if (df.exampleString() == null || df.exampleString().isEmpty()) continue;
                        pd.exampleValue = df.exampleString();
                        continue;
                    }
                    if (ServiceDocument.UsageOptions.class.equals(a.annotationType())) {
                        ServiceDocument.UsageOptions usageOptions = (ServiceDocument.UsageOptions)a;
                        for (ServiceDocument.UsageOption usageOption : usageOptions.value()) {
                            pd.usageOptions.add(usageOption.option());
                        }
                        continue;
                    }
                    if (ServiceDocument.UsageOption.class.equals(a.annotationType())) {
                        ServiceDocument.UsageOption usageOption = (ServiceDocument.UsageOption)a;
                        pd.usageOptions.add(usageOption.option());
                        continue;
                    }
                    if (!ServiceDocument.PropertyOptions.class.equals(a.annotationType())) continue;
                    ServiceDocument.PropertyOptions po = (ServiceDocument.PropertyOptions)a;
                    pd.indexingOptions.addAll(Arrays.asList(po.indexing()));
                    pd.usageOptions.addAll(Arrays.asList(po.usage()));
                }
                if (pd.usageOptions.contains((Object)PropertyUsageOption.ID)) {
                    pd.exampleValue = UUID.randomUUID().toString();
                    if (pd.propertyDocumentation != null && pd.propertyDocumentation.isEmpty()) {
                        pd.propertyDocumentation = "This must be unique across all instances of all services";
                    }
                }
                if (pd.usageOptions.contains((Object)PropertyUsageOption.LINK)) {
                    pd.exampleValue = "some/service";
                }
            }
            if (!isSimpleType) {
                PropertyDescription fd;
                ParameterizedType parameterizedComponentType;
                Class componentClass;
                ParameterizedType parameterizedType;
                if (Map.class.isAssignableFrom(clazz)) {
                    pd.typeName = TypeName.MAP;
                    if (depth > 0) {
                        pd.indexingOptions.add(PropertyIndexingOption.EXPAND);
                    }
                    if (!(typ instanceof ParameterizedType)) {
                        PropertyDescription fd2 = new PropertyDescription();
                        this.buildPropertyDescription(fd2, String.class, (Type)((Object)String.class), null, visited, depth + 1);
                        pd.elementDescription = fd2;
                        return;
                    }
                    parameterizedType = (ParameterizedType)typ;
                    Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                    Type componentType = actualTypeArguments[1];
                    if (componentType instanceof Class) {
                        componentClass = (Class)componentType;
                    } else {
                        parameterizedComponentType = (ParameterizedType)componentType;
                        componentClass = (Class)parameterizedComponentType.getRawType();
                    }
                    fd = new PropertyDescription();
                    this.buildPropertyDescription(fd, componentClass, componentType, null, visited, depth + 1);
                    pd.elementDescription = fd;
                } else if (Enum.class.isAssignableFrom(clazz)) {
                    pd.typeName = TypeName.ENUM;
                    ?[] enumConstants = clazz.getEnumConstants();
                    if (enumConstants != null) {
                        pd.enumValues = Arrays.stream(enumConstants).map(o -> ((Enum)o).name()).collect(Collectors.toList()).toArray(new String[0]);
                    }
                } else if (clazz.isArray()) {
                    pd.typeName = TypeName.COLLECTION;
                    Class<?> componentType = clazz.getComponentType();
                    Class<?> componentClass2 = clazz.getComponentType();
                    PropertyDescription fd3 = new PropertyDescription();
                    this.buildPropertyDescription(fd3, componentClass2, componentType, null, visited, depth + 1);
                    pd.elementDescription = fd3;
                } else if (Collection.class.isAssignableFrom(clazz)) {
                    Type[] actualTypeArguments;
                    Type componentType;
                    pd.typeName = TypeName.COLLECTION;
                    if (depth > 0) {
                        pd.indexingOptions.add(PropertyIndexingOption.EXPAND);
                    }
                    if ((componentType = (actualTypeArguments = (parameterizedType = (ParameterizedType)typ).getActualTypeArguments())[0]) instanceof Class) {
                        componentClass = (Class)componentType;
                    } else {
                        parameterizedComponentType = (ParameterizedType)componentType;
                        componentClass = (Class)parameterizedComponentType.getRawType();
                    }
                    fd = new PropertyDescription();
                    this.buildPropertyDescription(fd, componentClass, componentType, null, visited, depth + 1);
                    pd.elementDescription = fd;
                } else {
                    pd.typeName = TypeName.PODO;
                    pd.kind = Utils.buildKind(clazz);
                    if (depth > 0) {
                        pd.indexingOptions.add(PropertyIndexingOption.EXPAND);
                    }
                    PropertyDescription podo = this.buildPodoPropertyDescription(clazz, visited, depth + 1);
                    pd.fieldDescriptions = podo.fieldDescriptions;
                }
            }
        }
    }

    public static class PropertyDescription {
        public TypeName typeName;
        public String kind;
        public Object exampleValue;
        transient Field accessor;
        public EnumSet<PropertyIndexingOption> indexingOptions = EnumSet.noneOf(PropertyIndexingOption.class);
        public EnumSet<PropertyUsageOption> usageOptions = EnumSet.noneOf(PropertyUsageOption.class);
        public String propertyDocumentation;
        public Map<String, PropertyDescription> fieldDescriptions;
        public PropertyDescription elementDescription;
        public String[] enumValues;
    }

    public static enum PropertyIndexingOption {
        EXPAND,
        FIXED_ITEM_NAME,
        STORE_ONLY,
        TEXT,
        CASE_INSENSITIVE,
        EXCLUDE_FROM_SIGNATURE,
        SORT;

    }

    public static enum PropertyUsageOption {
        SINGLE_ASSIGNMENT,
        OPTIONAL,
        SERVICE_USE,
        INFRASTRUCTURE,
        AUTO_MERGE_IF_NOT_NULL,
        ID,
        LINK,
        LINKS,
        SENSITIVE,
        REQUIRED;

    }

    public static enum TypeName {
        LONG,
        STRING,
        BYTES,
        PODO,
        COLLECTION,
        MAP,
        BOOLEAN,
        DOUBLE,
        InternetAddressV4,
        InternetAddressV6,
        DATE,
        URI,
        ENUM;

    }
}

