/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceHost;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

class OperationTracker {
    private ServiceHost host;
    private final SortedSet<Operation> pendingStartOperations = OperationTracker.createOperationSet();
    private final Map<String, SortedSet<Operation>> pendingServiceAvailableCompletions = new ConcurrentSkipListMap<String, SortedSet<Operation>>();
    private final ConcurrentSkipListMap<Long, Operation> pendingOperationsForRetry = new ConcurrentSkipListMap();

    OperationTracker() {
    }

    public static ConcurrentSkipListSet<Operation> createOperationSet() {
        return new ConcurrentSkipListSet<Operation>(new Comparator<Operation>(){

            @Override
            public int compare(Operation o1, Operation o2) {
                return Long.compare(o1.getExpirationMicrosUtc(), o2.getExpirationMicrosUtc());
            }
        });
    }

    public static OperationTracker create(ServiceHost host) {
        OperationTracker omt = new OperationTracker();
        omt.host = host;
        return omt;
    }

    public void trackOperationForRetry(long expirationMicros, Throwable e, Operation op) {
        this.host.log(Level.WARNING, "Retrying id %d to %s (retries: %d). Failure: %s", op.getId(), op.getUri().getHost() + ":" + op.getUri().getPort(), op.getRetryCount(), e.toString());
        op.incrementRetryCount();
        this.pendingOperationsForRetry.put(expirationMicros, op);
    }

    public void trackStartOperation(Operation op) {
        this.pendingStartOperations.add(op);
    }

    public void removeStartOperation(Operation post) {
        this.pendingStartOperations.remove(post);
    }

    public synchronized SortedSet<Operation> trackServiceAvailableCompletion(String link, Operation opTemplate, boolean doOpClone) {
        SortedSet<Operation> pendingOps = this.pendingServiceAvailableCompletions.get(link);
        if (pendingOps == null) {
            pendingOps = OperationTracker.createOperationSet();
            this.pendingServiceAvailableCompletions.put(link, pendingOps);
        }
        pendingOps.add(doOpClone ? opTemplate.clone() : opTemplate);
        return pendingOps;
    }

    public boolean hasPendingServiceAvailableCompletions(String link) {
        return this.pendingServiceAvailableCompletions.containsKey(link);
    }

    public SortedSet<Operation> removeServiceAvailableCompletions(String link) {
        return this.pendingServiceAvailableCompletions.remove(link);
    }

    public void performMaintenance(long nowMicros) {
        Iterator<Operation> it;
        Iterator<Operation> startOpsIt = this.pendingStartOperations.iterator();
        this.checkOperationExpiration(nowMicros, startOpsIt);
        for (SortedSet<Operation> ops : this.pendingServiceAvailableCompletions.values()) {
            it = ops.iterator();
            this.checkOperationExpiration(nowMicros, it);
        }
        long intervalMicros = TimeUnit.SECONDS.toMicros(1L);
        it = this.pendingOperationsForRetry.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)((Object)it.next());
            Operation o = (Operation)entry.getValue();
            if (this.host.isStopping()) {
                o.fail(new CancellationException());
                return;
            }
            long queuingTimeMicros = (Long)entry.getKey();
            long estimatedRetryTimeMicros = (long)o.getRetryCount() * intervalMicros + queuingTimeMicros;
            if (estimatedRetryTimeMicros > nowMicros) continue;
            it.remove();
            this.host.handleRequest(null, o);
        }
    }

    private void checkOperationExpiration(long now, Iterator<Operation> iterator) {
        Operation op;
        while (iterator.hasNext() && (op = iterator.next()) != null && op.getExpirationMicrosUtc() <= now) {
            iterator.remove();
            this.host.run(() -> op.fail(new TimeoutException(op.toString())));
        }
    }

    public void close() {
        for (Operation operation : this.pendingOperationsForRetry.values()) {
            operation.fail(new CancellationException());
        }
        this.pendingOperationsForRetry.clear();
        for (Operation operation : this.pendingStartOperations) {
            operation.fail(new CancellationException());
        }
        this.pendingStartOperations.clear();
        for (SortedSet sortedSet : this.pendingServiceAvailableCompletions.values()) {
            for (Operation op : sortedSet) {
                op.fail(new CancellationException());
            }
        }
        this.pendingServiceAvailableCompletions.clear();
    }
}

