/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class OperationProcessingChain {
    private Service service;
    private List<Predicate<Operation>> filters;

    public OperationProcessingChain(Service service) {
        this.service = service;
        this.filters = new ArrayList<Predicate<Operation>>();
    }

    public OperationProcessingChain add(Predicate<Operation> filter) {
        this.filters.add(filter);
        return this;
    }

    public List<Predicate<Operation>> getFilters() {
        return this.filters;
    }

    public boolean processRequest(Operation op) {
        for (Predicate<Operation> filter : this.filters) {
            if (filter.test(op)) continue;
            return false;
        }
        return true;
    }

    public void resumeProcessingRequest(Operation op, Predicate<Operation> invokingFilter) {
        int invokingFilterPosition = this.filters.indexOf(invokingFilter);
        if (invokingFilterPosition < 0) {
            return;
        }
        for (int i = invokingFilterPosition + 1; i < this.filters.size(); ++i) {
            Predicate<Operation> filter = this.filters.get(i);
            if (filter.test(op)) continue;
            return;
        }
        this.service.getHost().run(() -> this.service.handleRequest(op, Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER));
    }
}

