/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.LogFormatter;
import java.util.logging.LogRecord;

public class ColorLogFormatter
extends LogFormatter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_DEFAULT = "";
    public static final String TERM = "TERM";
    public static final String COLOR = "color";
    public static final String COLOR_256 = "256";
    public String colorSevere = "";
    public String colorWarn = "";
    public String colorConfig = "";
    public String colorInfo = "";
    public String colorFine = "";
    public boolean colorsEnabled;

    public ColorLogFormatter() {
        String term = System.getenv(TERM);
        boolean bl = this.colorsEnabled = term != null && term.contains(COLOR);
        if (this.colorsEnabled) {
            if (term.contains(COLOR_256)) {
                this.colorSevere = "\u001b[38;5;196m";
                this.colorWarn = "\u001b[38;5;215m";
                this.colorConfig = "\u001b[38;5;116m";
                this.colorInfo = ANSI_DEFAULT;
                this.colorFine = "\u001b[38;5;107m";
            } else {
                this.colorSevere = ANSI_RED;
                this.colorWarn = ANSI_YELLOW;
                this.colorConfig = ANSI_CYAN;
                this.colorInfo = ANSI_DEFAULT;
                this.colorFine = ANSI_GREEN;
            }
        }
    }

    protected String getFormattedMessage(LogRecord record) {
        return super.format(record);
    }

    @Override
    public String format(LogRecord record) {
        String color;
        String formatted = this.getFormattedMessage(record);
        if (!this.colorsEnabled) {
            return formatted;
        }
        String reset = ANSI_RESET;
        switch (record.getLevel().getName().substring(0, 1).toUpperCase()) {
            case "S": {
                color = this.colorSevere;
                break;
            }
            case "W": {
                color = this.colorWarn;
                break;
            }
            case "I": {
                color = this.colorInfo;
                break;
            }
            case "F": {
                color = this.colorFine;
                break;
            }
            case "C": {
                color = this.colorConfig;
                break;
            }
            default: {
                color = ANSI_DEFAULT;
            }
        }
        if (color.equals(ANSI_DEFAULT)) {
            reset = ANSI_DEFAULT;
        }
        return color + formatted + reset;
    }
}

