/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.AuthorizationCacheUtils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;

public class ResourceGroupService
extends StatefulService {
    public static final String FACTORY_LINK = ServiceUriPaths.CORE_AUTHZ_RESOURCE_GROUPS;

    public static Service createFactory() {
        ResourceGroupState st = new ResourceGroupState();
        st.query = QueryTask.Query.Builder.create().addFieldClause("one", "one").build();
        Utils.toJson(st);
        return FactoryService.createIdempotent(ResourceGroupService.class);
    }

    public ResourceGroupService() {
        super(ResourceGroupState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleRequest(Operation request, Service.OperationProcessingStage opProcessingStage) {
        if (request.getAction() == Service.Action.DELETE || request.getAction() == Service.Action.PUT) {
            ResourceGroupState resourceGroupState = null;
            resourceGroupState = request.isFromReplication() && request.hasBody() ? (ResourceGroupState)this.getBody(request) : (ResourceGroupState)this.getState(request);
            if (resourceGroupState != null) {
                AuthorizationCacheUtils.clearAuthzCacheForResourceGroup(this, request, resourceGroupState);
            }
        }
        super.handleRequest(request, opProcessingStage);
    }

    @Override
    public void handleStart(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        ResourceGroupState state = op.getBody(ResourceGroupState.class);
        if (!this.validate(op, state)) {
            return;
        }
        op.complete();
    }

    @Override
    public void handlePut(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        ResourceGroupState newState = op.getBody(ResourceGroupState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        ResourceGroupState currentState = (ResourceGroupState)this.getState(op);
        ServiceDocumentDescription documentDescription = this.getStateDescription();
        if (ServiceDocument.equals(documentDescription, currentState, newState)) {
            op.setStatusCode(304);
        } else {
            this.setState(op, newState);
        }
        op.complete();
    }

    private boolean validate(Operation op, ResourceGroupState state) {
        if (state.query == null) {
            op.fail(new IllegalArgumentException("query is required"));
            return false;
        }
        return true;
    }

    public static class ResourceGroupState
    extends ServiceDocument {
        public QueryTask.Query query;
    }
}

