/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ODataUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.EnumSet;

public class ODataQueryService
extends StatelessService {
    public static String SELF_LINK = ServiceUriPaths.ODATA_QUERIES;

    @Override
    public void handleGet(Operation op) {
        try {
            String skipTo = UriUtils.getODataSkipToParamValue(op.getUri());
            if (skipTo != null) {
                this.handleOdataPaginationCompletion(op, skipTo);
                return;
            }
            QueryTask task = ODataUtils.toQuery(op, true);
            if (task == null) {
                return;
            }
            this.sendRequest(Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task).setCompletion((o, e) -> {
                if (e != null) {
                    op.fail(e);
                    return;
                }
                QueryTask result = o.getBody(QueryTask.class);
                op.setBodyNoCloning(result);
                op.complete();
            }));
        }
        catch (Exception e2) {
            op.fail(e2);
        }
    }

    private void handleOdataPaginationCompletion(Operation op, String skipTo) {
        String node = UriUtils.getODataNodeParamValue(op.getUri());
        if (node == null) {
            op.fail(new IllegalArgumentException(String.format(" When using %s , %s must be supplied", "$skipto", "$nodeid")));
            return;
        }
        URI u = UriUtils.buildUri(this.getHost(), UriUtils.buildUriPath(ServiceUriPaths.CORE_QUERY_PAGE, skipTo + ""));
        URI forwarderUri = UriUtils.buildForwardToPeerUri(u, node, "/core/node-selectors/default", EnumSet.noneOf(Service.ServiceOption.class));
        String nextLink = forwarderUri.getPath() + "?" + forwarderUri.getQuery();
        this.sendRequest(Operation.createGet(this, nextLink).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            QueryTask qrt = o.getBody(QueryTask.class);
            op.setBodyNoCloning(qrt).complete();
        }));
    }
}

