/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class NodeGroupUtils {
    public static void checkServiceAvailability(Operation.CompletionHandler ch, Service s) {
        NodeGroupUtils.checkServiceAvailability(ch, s.getHost(), s.getSelfLink(), s.getPeerNodeSelectorPath());
    }

    public static void checkServiceAvailability(Operation.CompletionHandler ch, ServiceHost host, String link, String selectorPath) {
        if (link == null) {
            throw new IllegalArgumentException("link is required");
        }
        URI service = UriUtils.buildUri(host, link);
        NodeGroupUtils.checkServiceAvailability(ch, host, service, selectorPath);
    }

    public static void checkServiceAvailability(Operation.CompletionHandler ch, ServiceHost host, URI service, String selectorPath) {
        URI statsUri = UriUtils.buildStatsUri(service);
        if (selectorPath == null) {
            throw new IllegalArgumentException("selectorPath is required");
        }
        Operation get = Operation.createGet(statsUri).setCompletion((o, e) -> {
            if (e != null) {
                host.log(Level.WARNING, "%s to %s failed: %s", new Object[]{o.getAction(), o.getUri(), e.toString()});
                ch.handle(null, e);
                return;
            }
            ServiceStats s = o.getBody(ServiceStats.class);
            ServiceStats.ServiceStat availableStat = s.entries.get("isAvailable");
            if (availableStat == null || availableStat.latestValue == 0.0) {
                ch.handle(o, new IllegalStateException("not available"));
                return;
            }
            ch.handle(o, null);
        });
        get.setReferer(host.getPublicUri()).setExpiration(Utils.getNowMicrosUtc() + host.getOperationTimeoutMicros());
        URI nodeSelector = UriUtils.buildUri(service, selectorPath);
        NodeSelectorService.SelectAndForwardRequest req = new NodeSelectorService.SelectAndForwardRequest();
        req.key = service.getPath();
        Operation selectPost = Operation.createPost(nodeSelector).setReferer(host.getPublicUri()).setBodyNoCloning(req);
        selectPost.setCompletion((o, e) -> {
            if (e != null) {
                host.log(Level.WARNING, "SelectOwner for %s to %s failed: %s", req.key, nodeSelector, e.toString());
                ch.handle(get, e);
                return;
            }
            NodeSelectorService.SelectOwnerResponse selectRsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            URI serviceOnOwner = UriUtils.buildUri(selectRsp.ownerNodeGroupReference, statsUri.getPath());
            get.setUri(serviceOnOwner).sendWith(host);
        }).sendWith(host);
    }

    public static void checkConvergenceFromAnyHost(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
    }

    public static void checkConvergence(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        NodeState self = ngs.nodes.get(host.getId());
        if (self == null) {
            parentOp.fail(new IllegalStateException("Self node is required"));
            return;
        }
        if (self.membershipQuorum == 1 && ngs.nodes.size() == 1) {
            parentOp.complete();
            return;
        }
        NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
    }

    private static void checkConvergenceAcrossPeers(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        OperationJoin.JoinedCompletionHandler joinedCompletion = (ops, failures) -> {
            if (failures != null) {
                parentOp.fail(new IllegalStateException("At least one peer failed convergence"));
                return;
            }
            HashMap<URI, Long> membershipUpdateTimes = new HashMap<URI, Long>();
            HashSet<Long> uniqueTimes = new HashSet<Long>();
            for (Operation peerOp : ops.values()) {
                NodeGroupService.NodeGroupState rsp = peerOp.getBody(NodeGroupService.NodeGroupState.class);
                membershipUpdateTimes.put(peerOp.getUri(), rsp.membershipUpdateTimeMicros);
                uniqueTimes.add(rsp.membershipUpdateTimeMicros);
            }
            if (uniqueTimes.size() > 1) {
                String error = String.format("Membership times not converged: %s", membershipUpdateTimes);
                parentOp.fail(new IllegalStateException(error));
                return;
            }
            parentOp.complete();
        };
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        for (NodeState ns : ngs.nodes.values()) {
            if (NodeState.isUnAvailable(ns)) continue;
            Operation peerOp = Operation.createGet(ns.groupReference).transferRefererFrom(parentOp).setExpiration(parentOp.getExpirationMicrosUtc());
            ops2.add(peerOp);
        }
        if (ops2.isEmpty()) {
            parentOp.fail(new IllegalStateException("no available nodes"));
            return;
        }
        OperationJoin.create(ops2).setCompletion(joinedCompletion).sendWith(host);
    }

    public static void checkConvergence(ServiceHost host, URI nodegroupReference, Operation parentOp) {
        Operation.createGet(nodegroupReference).transferRefererFrom(parentOp).setCompletion((o, t) -> {
            if (t != null) {
                parentOp.fail(t);
                return;
            }
            NodeGroupService.NodeGroupState ngs = o.getBody(NodeGroupService.NodeGroupState.class);
            NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
        }).sendWith(host);
    }

    public static boolean isMembershipSettled(ServiceHost host, long maintIntervalMicros, NodeGroupService.NodeGroupState localState) {
        NodeState selfNode = localState.nodes.get(host.getId());
        if (selfNode == null) {
            return false;
        }
        if (localState.nodes.size() == 1 && selfNode.membershipQuorum == 1) {
            return true;
        }
        long threshold = localState.localMembershipUpdateTimeMicros + localState.config.stableGroupMaintenanceIntervalCount * maintIntervalMicros;
        return Utils.getNowMicrosUtc() - threshold >= 0L;
    }

    public static boolean hasMembershipQuorum(ServiceHost host, NodeGroupService.NodeGroupState ngs) {
        NodeState selfNode = ngs.nodes.get(host.getId());
        if (selfNode == null) {
            return false;
        }
        int availableNodeCount = 0;
        if (ngs.nodes.size() == 1) {
            availableNodeCount = 1;
        } else {
            for (NodeState ns : ngs.nodes.values()) {
                if (!NodeState.isAvailable(ns, selfNode.id, false)) continue;
                ++availableNodeCount;
            }
        }
        return availableNodeCount >= selfNode.membershipQuorum;
    }

    public static boolean isNodeGroupAvailable(ServiceHost host, NodeGroupService.NodeGroupState localState) {
        return NodeGroupUtils.isMembershipSettled(host, host.getMaintenanceIntervalMicros(), localState) && NodeGroupUtils.hasMembershipQuorum(host, localState);
    }

    public static void registerForReplicatedServiceAvailability(ServiceHost host, Operation op, String servicePath, String nodeSelectorPath) {
        Operation.CompletionHandler ch = (o, e) -> {
            if (e != null) {
                if (op.getExpirationMicrosUtc() < Utils.getNowMicrosUtc()) {
                    String msg = "Failed to check replicated service availability";
                    op.fail(new TimeoutException(msg));
                    return;
                }
                host.schedule(() -> NodeGroupUtils.registerForReplicatedServiceAvailability(host, op, servicePath, nodeSelectorPath), host.getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
                return;
            }
            op.complete();
        };
        host.checkReplicatedServiceAvailable(ch, servicePath, nodeSelectorPath);
    }
}

