/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.GraphQueryTask;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.TaskService;
import java.util.ArrayList;

public class GraphQueryTaskService
extends TaskService<GraphQueryTask> {
    public static final String FACTORY_LINK = ServiceUriPaths.CORE_GRAPH_QUERIES;

    public GraphQueryTaskService() {
        super(GraphQueryTask.class);
        this.toggleOption(Service.ServiceOption.REPLICATION, true);
        this.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation post) {
        GraphQueryTask initialState = this.validateStartPost(post);
        if (initialState == null) {
            return;
        }
        this.initializeState(initialState, post);
        initialState.taskInfo.stage = TaskState.TaskStage.CREATED;
        post.setBody(initialState).setStatusCode(202).complete();
        this.sendSelfPatch(initialState, TaskState.TaskStage.STARTED, null);
    }

    @Override
    protected GraphQueryTask validateStartPost(Operation taskOperation) {
        GraphQueryTask task = (GraphQueryTask)super.validateStartPost(taskOperation);
        if (task == null) {
            return null;
        }
        if (!ServiceHost.isServiceCreate(taskOperation)) {
            return task;
        }
        if (task.currentDepth > 0) {
            taskOperation.fail(new IllegalArgumentException("Do not specify currentDepth: internal use only"));
            return null;
        }
        if (task.depthLimit < 2) {
            taskOperation.fail(new IllegalArgumentException("depthLimit must be a positive integer greater than one"));
            return null;
        }
        if (task.stages == null || task.stages.isEmpty()) {
            taskOperation.fail(new IllegalArgumentException("At least one stage is required"));
            return null;
        }
        if (task.stages.size() != task.depthLimit) {
            taskOperation.fail(new IllegalArgumentException("Number of stages must match depthLimit"));
            return null;
        }
        for (QueryTask stage : task.stages) {
            if (stage.querySpec == null || stage.querySpec.query == null) {
                taskOperation.fail(new IllegalArgumentException("Stage query specification is invalid: " + Utils.toJson(stage)));
                return null;
            }
            if (stage.querySpec.resultLimit != null) {
                taskOperation.fail(new IllegalArgumentException("Stage query specification resultLimit must be null: " + Utils.toJson(stage)));
                return null;
            }
            stage.results = null;
        }
        return task;
    }

    @Override
    public void handlePatch(Operation patch) {
        GraphQueryTask body;
        GraphQueryTask currentState = (GraphQueryTask)this.getState(patch);
        if (!this.validateTransition(patch, currentState, body = (GraphQueryTask)this.getBody(patch))) {
            return;
        }
        this.updateState(currentState, body);
        patch.complete();
        switch (body.taskInfo.stage) {
            case STARTED: {
                this.startOrContinueGraphQuery(currentState);
                break;
            }
            case CANCELLED: {
                this.logInfo("Task canceled: not implemented, ignoring", new Object[0]);
                break;
            }
            case FINISHED: {
                this.logFine("Task finished successfully", new Object[0]);
                break;
            }
            case FAILED: {
                this.logWarning("Task failed: %s", body.failureMessage == null ? "No reason given" : body.failureMessage);
                break;
            }
        }
    }

    @Override
    protected void updateState(GraphQueryTask task, GraphQueryTask patchBody) {
        super.updateState(task, patchBody);
        task.stages = patchBody.stages;
        task.resultLinks = patchBody.resultLinks;
    }

    @Override
    protected boolean validateTransition(Operation patch, GraphQueryTask currentState, GraphQueryTask patchBody) {
        if (patchBody.taskInfo == null) {
            patch.fail(new IllegalArgumentException("Missing taskInfo"));
            return false;
        }
        if (patchBody.taskInfo.stage == null) {
            patch.fail(new IllegalArgumentException("Missing stage"));
            return false;
        }
        if (patchBody.taskInfo.stage == TaskState.TaskStage.CREATED) {
            patch.fail(new IllegalArgumentException("Did not expect to receive CREATED stage"));
            return false;
        }
        if (patchBody.taskInfo.stage == TaskState.TaskStage.STARTED && patchBody.currentDepth > currentState.stages.size() - 1) {
            patch.fail(new IllegalStateException("new currentDepth is must be a valid stage index: " + currentState.currentDepth));
            return false;
        }
        if (patchBody.currentDepth < currentState.currentDepth) {
            patch.fail(new IllegalStateException("new currentDepth is less or equal to existing depth:" + currentState.currentDepth));
            return false;
        }
        if (patchBody.stages.size() != currentState.stages.size()) {
            patch.fail(new IllegalStateException("Query stages can not be modified after task is created"));
            return false;
        }
        return true;
    }

    private void startOrContinueGraphQuery(GraphQueryTask currentState) {
        int previousStageIndex = Math.max(currentState.currentDepth - 1, 0);
        ServiceDocumentQueryResult lastResults = currentState.stages.get((int)previousStageIndex).results;
        int traversalSpecIndex = Math.min(currentState.stages.size() - 1, currentState.currentDepth);
        QueryTask task = currentState.stages.get(traversalSpecIndex);
        task.documentExpirationTimeMicros = currentState.documentExpirationTimeMicros;
        this.scopeNextStageQueryToSelectedLinks(lastResults, task);
        Operation createQueryOp = Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBodyNoCloning(task).setConnectionSharing(true).setCompletion((o, e) -> this.handleQueryStageCompletion(currentState, o, e));
        this.sendRequest(createQueryOp);
    }

    private boolean checkAndPatchToFinished(GraphQueryTask currentState, ServiceDocumentQueryResult lastResults) {
        if (lastResults == null) {
            return false;
        }
        if (currentState.currentDepth > currentState.depthLimit - 1) {
            this.sendSelfPatch(currentState, TaskState.TaskStage.FINISHED, null);
            return true;
        }
        if (lastResults.documentCount == 0L) {
            this.sendSelfPatch(currentState, TaskState.TaskStage.FINISHED, null);
            return true;
        }
        if ((lastResults.selectedLinks == null || lastResults.selectedLinks.isEmpty()) && currentState.currentDepth < currentState.depthLimit - 1) {
            this.sendSelfPatch(currentState, TaskState.TaskStage.FINISHED, null);
            return true;
        }
        return false;
    }

    private void handleQueryStageCompletion(GraphQueryTask currentState, Operation o, Throwable e) {
        if (e != null) {
            this.sendSelfFailurePatch(currentState, e.toString());
            return;
        }
        QueryTask response = o.getBody(QueryTask.class);
        currentState.resultLinks.add(response.documentSelfLink);
        int traversalSpecIndex = Math.min(currentState.stages.size() - 1, currentState.currentDepth);
        currentState.stages.get((int)traversalSpecIndex).results = response.results;
        ++currentState.currentDepth;
        if (this.checkAndPatchToFinished(currentState, response.results)) {
            return;
        }
        this.sendSelfPatch(currentState, TaskState.TaskStage.STARTED, null);
    }

    private void scopeNextStageQueryToSelectedLinks(ServiceDocumentQueryResult lastResults, QueryTask task) {
        if (lastResults == null) {
            return;
        }
        task.querySpec.context.documentLinkWhiteList = lastResults.selectedLinks;
    }

    @Override
    protected void initializeState(GraphQueryTask task, Operation taskOperation) {
        task.currentDepth = 0;
        task.resultLinks = new ArrayList<String>();
        for (int i = 0; i < task.stages.size(); ++i) {
            QueryTask stageQueryTask = task.stages.get(i);
            stageQueryTask.taskInfo = new TaskState();
            stageQueryTask.taskInfo.isDirect = true;
            if (i >= task.stages.size() - 1) continue;
            stageQueryTask.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.SELECT_LINKS);
        }
        super.initializeState(task, taskOperation);
    }
}

