/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceSubscriptionState;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.services.common.GraphQueryTask;
import com.vmware.xenon.services.common.GraphQueryTaskService;
import com.vmware.xenon.services.common.ReliableSubscriptionService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.util.function.Consumer;

public class GraphQueryTaskFactoryService
extends FactoryService {
    public static final String SELF_LINK = ServiceUriPaths.CORE_GRAPH_QUERIES;

    public GraphQueryTaskFactoryService() {
        super(GraphQueryTask.class);
    }

    @Override
    public void handleRequest(Operation op, Service.OperationProcessingStage opProcessingStage) {
        opProcessingStage = Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER;
        if (op.getAction() != Service.Action.POST) {
            super.handleRequest(op, opProcessingStage);
            return;
        }
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        GraphQueryTask initState = op.getBody(GraphQueryTask.class);
        if (initState.taskInfo == null || !initState.taskInfo.isDirect) {
            super.handleRequest(op, opProcessingStage);
            return;
        }
        this.handleDirectTaskPost(op, initState);
    }

    private void handleDirectTaskPost(Operation post, GraphQueryTask initState) {
        Operation clonedPost = post.clone();
        clonedPost.setReplicationDisabled(true);
        clonedPost.setCompletion((o, e) -> {
            if (e != null) {
                post.setStatusCode(o.getStatusCode()).setBodyNoCloning(o.getBodyRaw()).fail(e);
                return;
            }
            this.subscribeToChildTask(o, post);
        });
        super.handleRequest(clonedPost, Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER);
    }

    private void subscribeToChildTask(Operation o, Operation post) {
        Operation subscribe = Operation.createPost(o.getUri()).transferRefererFrom(post).setCompletion((so, e) -> {
            if (e == null) {
                return;
            }
            post.setStatusCode(so.getStatusCode()).setBodyNoCloning(so.getBodyRaw()).fail(e);
        });
        ServiceSubscriptionState.ServiceSubscriber sr = ServiceSubscriptionState.ServiceSubscriber.create(true).setUsePublicUri(true);
        Consumer<Operation> notifyC = nOp -> {
            switch (nOp.getAction()) {
                case PUT: 
                case PATCH: {
                    GraphQueryTask task = nOp.getBody(GraphQueryTask.class);
                    if (TaskState.isInProgress(task.taskInfo)) {
                        return;
                    }
                    post.setBodyNoCloning(task).complete();
                    return;
                }
                case DELETE: {
                    post.setStatusCode(408).fail(new IllegalStateException("Task self deleted"));
                    return;
                }
            }
        };
        ReliableSubscriptionService notificationTarget = ReliableSubscriptionService.create(subscribe, sr, notifyC);
        this.getHost().startSubscriptionService(subscribe, notificationTarget, sr);
    }

    @Override
    public Service createServiceInstance() throws Throwable {
        return new GraphQueryTaskService();
    }
}

