/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.QueryFilterUtils;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ResourceGroupService;
import com.vmware.xenon.services.common.RoleService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.SystemUserService;
import com.vmware.xenon.services.common.UserGroupService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class AuthorizationContextService
extends StatelessService {
    public static final String SELF_LINK = ServiceUriPaths.CORE_AUTHZ_VERIFICATION;
    private final Map<String, Collection<Operation>> pendingOperationsBySubject = new HashMap<String, Collection<Operation>>();

    @Override
    public boolean queueRequest(Operation op) {
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            op.fail(new IllegalArgumentException("no authorization context"));
            return true;
        }
        Claims claims = ctx.getClaims();
        if (claims == null) {
            op.fail(new IllegalArgumentException("no claims"));
            return true;
        }
        String subject = claims.getSubject();
        if (subject == null) {
            op.fail(new IllegalArgumentException("no subject"));
            return true;
        }
        if (subject.equals(SystemUserService.SELF_LINK)) {
            op.complete();
            return true;
        }
        if (ctx.getResourceQueryFilter(op.getAction()) != null) {
            op.complete();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(Operation op) {
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            op.fail(new IllegalArgumentException("no authorization context"));
            return;
        }
        Claims claims = ctx.getClaims();
        if (claims == null) {
            op.fail(new IllegalArgumentException("no claims"));
            return;
        }
        Map<String, Collection<Operation>> map = this.pendingOperationsBySubject;
        synchronized (map) {
            String subject = claims.getSubject();
            Collection<Operation> pendingOperations = this.pendingOperationsBySubject.get(subject);
            if (pendingOperations != null) {
                pendingOperations.add(op);
                return;
            }
            pendingOperations = new LinkedList<Operation>();
            pendingOperations.add(op);
            this.pendingOperationsBySubject.put(subject, pendingOperations);
        }
        this.getSubject(ctx, claims);
    }

    private void getSubject(Operation.AuthorizationContext ctx, Claims claims) {
        URI getSubjectUri = UriUtils.buildUri(this.getHost(), claims.getSubject());
        Operation get = Operation.createGet(getSubjectUri).setCompletion((o, e) -> {
            if (e != null) {
                this.failThrowable(claims.getSubject(), e);
                return;
            }
            ServiceDocument userState = QueryFilterUtils.getServiceState(o, this.getHost());
            if (userState == null) {
                this.populateAuthorizationContext(ctx, claims, null);
                return;
            }
            this.loadUserGroups(ctx, claims, userState);
        });
        this.setAuthorizationContext(get, this.getSystemAuthorizationContext());
        this.sendRequest(get);
    }

    private void loadUserGroups(Operation.AuthorizationContext ctx, Claims claims, ServiceDocument userState) {
        URI getUserGroupsUri = UriUtils.buildUri(this.getHost(), ServiceUriPaths.CORE_AUTHZ_USER_GROUPS);
        getUserGroupsUri = UriUtils.buildExpandLinksQueryUri(getUserGroupsUri);
        Operation get = Operation.createGet(getUserGroupsUri).setCompletion((o, e) -> {
            if (e != null) {
                this.failThrowable(claims.getSubject(), e);
                return;
            }
            ServiceDocumentQueryResult result = o.getBody(ServiceDocumentQueryResult.class);
            ArrayList<UserGroupService.UserGroupState> userGroupStates = new ArrayList<UserGroupService.UserGroupState>();
            for (Object doc : result.documents.values()) {
                UserGroupService.UserGroupState userGroupState = Utils.fromJson(doc, UserGroupService.UserGroupState.class);
                try {
                    QueryFilter f = QueryFilter.create(userGroupState.query);
                    if (!QueryFilterUtils.evaluate(f, userState, this.getHost())) continue;
                    userGroupStates.add(userGroupState);
                }
                catch (QueryFilter.QueryFilterException qfe) {
                    this.logWarning("Error creating query filter: %s", qfe.toString());
                    this.failThrowable(claims.getSubject(), qfe);
                    return;
                }
            }
            if (userGroupStates.isEmpty()) {
                this.populateAuthorizationContext(ctx, claims, null);
                return;
            }
            this.loadRoles(ctx, claims, userGroupStates);
        });
        this.setAuthorizationContext(get, this.getSystemAuthorizationContext());
        this.sendRequest(get);
    }

    private void loadRoles(Operation.AuthorizationContext ctx, Claims claims, Collection<UserGroupService.UserGroupState> userGroupStates) {
        HashMap<String, UserGroupService.UserGroupState> userGroupStateMap = new HashMap<String, UserGroupService.UserGroupState>();
        for (UserGroupService.UserGroupState userGroupState : userGroupStates) {
            userGroupStateMap.put(userGroupState.documentSelfLink, userGroupState);
        }
        QueryTask.Query kindClause = new QueryTask.Query();
        kindClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        kindClause.setTermPropertyName("documentKind");
        kindClause.setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
        kindClause.setTermMatchValue(RoleService.RoleState.KIND);
        QueryTask.Query selfLinkClause = new QueryTask.Query();
        selfLinkClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        if (userGroupStates.size() == 1) {
            selfLinkClause.setTermPropertyName("userGroupLink");
            selfLinkClause.setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
            selfLinkClause.setTermMatchValue(userGroupStates.iterator().next().documentSelfLink);
        } else {
            for (UserGroupService.UserGroupState userGroupState : userGroupStates) {
                QueryTask.Query clause = new QueryTask.Query();
                clause.occurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                clause.setTermPropertyName("userGroupLink");
                clause.setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
                clause.setTermMatchValue(userGroupState.documentSelfLink);
                selfLinkClause.addBooleanClause(clause);
            }
        }
        QueryTask.Query query = new QueryTask.Query();
        query.addBooleanClause(kindClause);
        query.addBooleanClause(selfLinkClause);
        QueryTask queryTask = new QueryTask();
        queryTask.querySpec = new QueryTask.QuerySpecification();
        queryTask.querySpec.query = query;
        queryTask.querySpec.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        queryTask.setDirect(true);
        URI postQueryUri = UriUtils.buildUri(this.getHost(), ServiceUriPaths.CORE_LOCAL_QUERY_TASKS);
        Operation post = Operation.createPost(postQueryUri).setBody(queryTask).setCompletion((o, e) -> {
            if (e != null) {
                this.failThrowable(claims.getSubject(), e);
                return;
            }
            QueryTask queryTaskResult = o.getBody(QueryTask.class);
            ServiceDocumentQueryResult result = queryTaskResult.results;
            if (result.documents == null || result.documents.isEmpty()) {
                this.failForbidden(claims.getSubject());
                return;
            }
            LinkedList<Role> roles = new LinkedList<Role>();
            for (Object doc : result.documents.values()) {
                RoleService.RoleState roleState = Utils.fromJson(doc, RoleService.RoleState.class);
                Role role = new Role();
                role.setRoleState(roleState);
                role.setUserGroupState((UserGroupService.UserGroupState)userGroupStateMap.get(roleState.userGroupLink));
                roles.add(role);
            }
            this.loadResourceGroups(ctx, claims, roles);
        });
        this.setAuthorizationContext(post, this.getSystemAuthorizationContext());
        this.sendRequest(post);
    }

    private void loadResourceGroups(Operation.AuthorizationContext ctx, Claims claims, Collection<Role> roles) {
        HashMap<Object, LinkedList<Role>> rolesByResourceGroup = new HashMap<Object, LinkedList<Role>>();
        for (Role role : roles) {
            String resourceGroupLink = role.roleState.resourceGroupLink;
            LinkedList<Role> byResourceGroup = (LinkedList<Role>)rolesByResourceGroup.get(resourceGroupLink);
            if (byResourceGroup == null) {
                byResourceGroup = new LinkedList<Role>();
                rolesByResourceGroup.put(resourceGroupLink, byResourceGroup);
            }
            byResourceGroup.add(role);
        }
        OperationJoin.JoinedCompletionHandler handler = (ops, failures) -> {
            if (failures != null && !failures.isEmpty()) {
                this.failThrowable(claims.getSubject(), (Throwable)failures.values().iterator().next());
                return;
            }
            try {
                for (Operation op : ops.values()) {
                    ResourceGroupService.ResourceGroupState resourceGroupState = op.getBody(ResourceGroupService.ResourceGroupState.class);
                    Collection rolesForResourceGroup = (Collection)rolesByResourceGroup.get(resourceGroupState.documentSelfLink);
                    if (rolesForResourceGroup == null) continue;
                    for (Role role : rolesForResourceGroup) {
                        role.setResourceGroupState(resourceGroupState);
                    }
                }
                this.populateAuthorizationContext(ctx, claims, roles);
            }
            catch (Throwable e) {
                this.failThrowable(claims.getSubject(), e);
                return;
            }
        };
        LinkedList<Operation> gets = new LinkedList<Operation>();
        for (String resourceGroupLink : rolesByResourceGroup.keySet()) {
            Operation get = Operation.createGet(this, resourceGroupLink).setReferer(this.getUri());
            this.setAuthorizationContext(get, this.getSystemAuthorizationContext());
            gets.add(get);
        }
        OperationJoin join = OperationJoin.create(gets);
        join.setCompletion(handler);
        join.sendWith(this.getHost());
    }

    private void populateAuthorizationContext(Operation.AuthorizationContext ctx, Claims claims, Collection<Role> roles) {
        if (roles == null) {
            roles = Collections.emptyList();
        }
        try {
            Operation.AuthorizationContext.Builder builder = Operation.AuthorizationContext.Builder.create();
            builder.setClaims(ctx.getClaims());
            builder.setToken(ctx.getToken());
            if (!roles.isEmpty()) {
                HashMap<Service.Action, LinkedList<Role>> roleListByAction = new HashMap<Service.Action, LinkedList<Role>>(Service.Action.values().length);
                for (Role role : roles) {
                    for (Service.Action action : role.roleState.verbs) {
                        LinkedList<Role> roleList = (LinkedList<Role>)roleListByAction.get((Object)action);
                        if (roleList == null) {
                            roleList = new LinkedList<Role>();
                            roleListByAction.put(action, roleList);
                        }
                        roleList.add(role);
                    }
                }
                HashMap<Service.Action, QueryFilter> queryFilterByAction = new HashMap<Service.Action, QueryFilter>(Service.Action.values().length);
                HashMap<Service.Action, QueryTask.Query> queryByAction = new HashMap<Service.Action, QueryTask.Query>(Service.Action.values().length);
                for (Map.Entry entry : roleListByAction.entrySet()) {
                    QueryTask.Query q = new QueryTask.Query();
                    q.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
                    for (Role role : (Collection)entry.getValue()) {
                        if (role.resourceGroupState == null) continue;
                        QueryTask.Query resourceGroupQuery = role.resourceGroupState.query;
                        resourceGroupQuery.occurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                        q.addBooleanClause(resourceGroupQuery);
                    }
                    try {
                        queryFilterByAction.put((Service.Action)((Object)entry.getKey()), QueryFilter.create(q));
                        queryByAction.put((Service.Action)((Object)entry.getKey()), q);
                    }
                    catch (QueryFilter.QueryFilterException qfe) {
                        this.logWarning("Error creating query filter: %s", qfe.toString());
                        this.failThrowable(claims.getSubject(), qfe);
                        return;
                    }
                }
                builder.setResourceQueryMap(queryByAction);
                builder.setResourceQueryFilterMap(queryFilterByAction);
            }
            Operation.AuthorizationContext newContext = builder.getResult();
            this.getHost().cacheAuthorizationContext(this, newContext);
            this.completePendingOperations(claims.getSubject(), newContext);
        }
        catch (Throwable e) {
            this.failThrowable(claims.getSubject(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Operation> getPendingOperations(String subject) {
        Collection<Operation> operations;
        Map<String, Collection<Operation>> map = this.pendingOperationsBySubject;
        synchronized (map) {
            operations = this.pendingOperationsBySubject.get(subject);
            this.pendingOperationsBySubject.remove(subject);
        }
        if (operations == null) {
            return Collections.emptyList();
        }
        return operations;
    }

    private void completePendingOperations(String subject, Operation.AuthorizationContext ctx) {
        for (Operation op : this.getPendingOperations(subject)) {
            this.setAuthorizationContext(op, ctx);
            op.complete();
        }
    }

    private void failThrowable(String subject, Throwable e) {
        if (e instanceof ServiceHost.ServiceNotFoundException) {
            this.failNotFound(subject);
            return;
        }
        for (Operation op : this.getPendingOperations(subject)) {
            op.fail(e);
        }
    }

    private void failForbidden(String subject) {
        for (Operation op : this.getPendingOperations(subject)) {
            op.fail(403);
        }
    }

    private void failNotFound(String subject) {
        for (Operation op : this.getPendingOperations(subject)) {
            op.fail(404);
        }
    }

    private static class Role {
        protected RoleService.RoleState roleState;
        protected UserGroupService.UserGroupState userGroupState;
        protected ResourceGroupService.ResourceGroupState resourceGroupState;

        private Role() {
        }

        public void setRoleState(RoleService.RoleState roleState) {
            this.roleState = roleState;
        }

        public void setUserGroupState(UserGroupService.UserGroupState userGroupState) {
            this.userGroupState = userGroupState;
        }

        public void setResourceGroupState(ResourceGroupService.ResourceGroupState resourceGroupState) {
            this.resourceGroupState = resourceGroupState;
        }
    }
}

