/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.CookieJar;
import com.vmware.xenon.common.http.netty.HttpRequestCallbackService;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import com.vmware.xenon.common.http.netty.NettyFullHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class NettyHttpServiceClient
implements ServiceClient {
    public static final int DEFAULT_CONNECTIONS_PER_HOST = ServiceClient.DEFAULT_CONNECTION_LIMIT_PER_HOST;
    public static final Logger LOGGER = Logger.getLogger(ServiceClient.class.getName());
    private static final String ENV_VAR_NAME_HTTP_PROXY = "http_proxy";
    private URI httpProxy;
    private String userAgent;
    private NettyChannelPool sslChannelPool;
    private NettyChannelPool channelPool;
    private NettyChannelPool http2ChannelPool;
    private SortedMap<Long, Operation> pendingRequests = new ConcurrentSkipListMap<Long, Operation>();
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService executor;
    private SSLContext sslContext;
    private ServiceHost host;
    private HttpRequestCallbackService callbackService;
    CookieJar cookieJar = new CookieJar();
    private boolean isStarted;
    private boolean warnHttp2ConversionToCallbacks = false;
    private final Object START_LOCK = new Object();

    public static ServiceClient create(String userAgent, ExecutorService executor, ScheduledExecutorService scheduledExecutor) throws URISyntaxException {
        return NettyHttpServiceClient.create(userAgent, executor, scheduledExecutor, null);
    }

    public static ServiceClient create(String userAgent, ExecutorService executor, ScheduledExecutorService scheduledExecutor, ServiceHost host) throws URISyntaxException {
        NettyHttpServiceClient sc = new NettyHttpServiceClient();
        sc.userAgent = userAgent;
        sc.scheduledExecutor = scheduledExecutor;
        sc.executor = executor;
        sc.host = host;
        sc.channelPool = new NettyChannelPool();
        sc.http2ChannelPool = new NettyChannelPool();
        sc.sslChannelPool = new NettyChannelPool();
        String proxy = System.getenv(ENV_VAR_NAME_HTTP_PROXY);
        if (proxy != null) {
            sc.setHttpProxy(new URI(proxy));
        }
        sc.setConnectionLimitPerHost(DEFAULT_CONNECTION_LIMIT_PER_HOST);
        sc.setConnectionLimitPerTag("xn-cnx-tag-default", DEFAULT_CONNECTIONS_PER_HOST);
        sc.setConnectionLimitPerTag("xn-cnx-tag-http2-default", DEFAULT_CONNECTION_LIMIT_PER_TAG);
        sc.setRequestPayloadSizeLimit(ServiceClient.REQUEST_PAYLOAD_SIZE_LIMIT);
        return sc;
    }

    private String buildThreadTag() {
        if (this.host != null) {
            return UriUtils.extendUri(this.host.getUri(), "netty-client").toString();
        }
        return this.getClass().getSimpleName() + ":" + Utils.getNowMicrosUtc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.START_LOCK;
        synchronized (object) {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
        }
        this.channelPool.setThreadTag(this.buildThreadTag());
        this.channelPool.setThreadCount(Utils.DEFAULT_IO_THREAD_COUNT);
        if (this.host != null) {
            this.channelPool.setExecutor(this.executor);
        }
        this.channelPool.start();
        this.http2ChannelPool.setThreadTag(this.buildThreadTag());
        this.http2ChannelPool.setThreadCount(Utils.DEFAULT_IO_THREAD_COUNT);
        if (this.host != null) {
            this.http2ChannelPool.setExecutor(this.executor);
        }
        this.http2ChannelPool.setHttp2Only();
        this.http2ChannelPool.start();
        if (this.sslContext != null) {
            this.sslChannelPool.setThreadTag(this.buildThreadTag());
            this.sslChannelPool.setThreadCount(Utils.DEFAULT_IO_THREAD_COUNT);
            if (this.host != null) {
                this.sslChannelPool.setExecutor(this.executor);
            }
            this.sslChannelPool.setSSLContext(this.sslContext);
            this.sslChannelPool.start();
        }
        if (this.host != null) {
            Operation startCallbackPost = Operation.createPost(UriUtils.buildUri(this.host, "/core/callbacks")).setCompletion((o, e) -> {
                if (e != null) {
                    this.host.log(Level.WARNING, "Failed to start %s: %s", "/core/callbacks", e.toString());
                }
            });
            this.callbackService = new HttpRequestCallbackService(this);
            this.host.startService(startCallbackPost, this.callbackService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.START_LOCK;
        synchronized (object) {
            if (!this.isStarted) {
                return;
            }
            this.isStarted = false;
        }
        this.channelPool.stop();
        this.sslChannelPool.stop();
        this.http2ChannelPool.stop();
        if (this.host != null) {
            this.host.stopService(this.callbackService);
        }
        this.pendingRequests.clear();
    }

    public ServiceClient setHttpProxy(URI proxy) {
        this.httpProxy = proxy;
        return this;
    }

    @Override
    public void send(Operation op) {
        this.sendRequest(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(Operation op) {
        if (!NettyHttpServiceClient.validateOperation(op)) {
            return;
        }
        Operation clone = op.clone();
        this.setExpiration(clone);
        this.setCookies(clone);
        OperationContext ctx = OperationContext.getOperationContext();
        try {
            if (!op.isRemote() && this.host != null && this.host.handleRequest(clone)) {
                return;
            }
            this.sendRemote(clone);
        }
        finally {
            OperationContext.restoreOperationContext(ctx);
        }
    }

    private void setExpiration(Operation op) {
        if (op.getExpirationMicrosUtc() != 0L) {
            return;
        }
        long expMicros = this.host != null ? this.host.getOperationTimeoutMicros() : ServiceHost.ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS;
        op.setExpiration(Utils.getNowMicrosUtc() + expMicros);
    }

    private void setCookies(Operation clone) {
        if (this.cookieJar.isEmpty()) {
            return;
        }
        clone.setCookies(this.cookieJar.list(clone.getUri()));
    }

    private void startTracking(Operation op) {
        this.pendingRequests.put(op.getId(), op);
    }

    void stopTracking(Operation op) {
        this.pendingRequests.remove(op.getId());
    }

    private Operation prepareCallback(Operation op) {
        String u = this.callbackService.queueUntilCallback(op);
        Operation remoteOp = op.clone();
        remoteOp.setRequestCallbackLocation(u);
        remoteOp.setCompletion((o, e) -> {
            if (e != null) {
                this.stopTracking(op);
                op.setExpiration(0L).fail(e);
                return;
            }
        });
        return remoteOp;
    }

    private void updateCookieJarFromResponseHeaders(Operation op) {
        String value = op.getResponseHeader("set-cookie");
        if (value == null) {
            return;
        }
        Cookie cookie = ClientCookieDecoder.LAX.decode(value);
        if (cookie == null) {
            return;
        }
        this.cookieJar.add(op.getUri(), cookie);
    }

    private void sendRemote(Operation op) {
        this.startTracking(op);
        String remoteHost = op.getUri().getHost();
        String scheme = op.getUri().getScheme();
        int port = op.getUri().getPort();
        if (this.httpProxy != null && !"127.0.0.1".equals(remoteHost)) {
            remoteHost = this.httpProxy.getHost();
            port = this.httpProxy.getPort();
            scheme = this.httpProxy.getScheme();
        }
        boolean httpScheme = false;
        boolean httpsScheme = scheme.equals("https");
        if (!httpsScheme) {
            httpScheme = scheme.equals("http");
        }
        if (!httpScheme && !httpsScheme) {
            op.setRetryCount(0);
            this.fail(new IllegalArgumentException("Scheme is not supported: " + op.getUri().getScheme()), op, op.getBodyRaw());
            return;
        }
        if (httpsScheme && this.getSSLContext() == null) {
            op.setRetryCount(0);
            this.fail(new IllegalArgumentException("HTTPS not enabled, set SSL context before starting client:" + op.getUri().getScheme()), op, op.getBodyRaw());
            return;
        }
        if (port == -1) {
            int n = port = httpScheme ? 80 : 443;
        }
        if (op.isConnectionSharing() && httpsScheme) {
            op.setConnectionSharing(false);
            op.toggleOption(Operation.OperationOption.SEND_WITH_CALLBACK, true);
            if (!this.warnHttp2ConversionToCallbacks) {
                this.warnHttp2ConversionToCallbacks = true;
                LOGGER.warning("Converting Http/2 TLS requests to use Http/1.1 with SEND_WITH_CALLBACK.");
            }
        }
        NettyChannelPool pool = this.channelPool;
        if (op.isConnectionSharing()) {
            pool = this.http2ChannelPool;
        }
        if (scheme.equals("https")) {
            pool = this.sslChannelPool;
            op.setConnectionSharing(false);
        }
        if (op.hasOption(Operation.OperationOption.SEND_WITH_CALLBACK)) {
            op = this.prepareCallback(op);
        }
        this.connectChannel(pool, op, remoteHost, port);
    }

    private void connectChannel(NettyChannelPool pool, Operation op, String remoteHost, int port) {
        op.nestCompletion((o, e) -> {
            if (o.getStatusCode() == 408) {
                this.failWithTimeout(op, op.getBodyRaw());
                return;
            }
            if (e != null) {
                op.setBody(ServiceErrorResponse.create(e, 400, EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
                this.fail(e, op, op.getBodyRaw());
                return;
            }
            this.doSendRequest(op);
        });
        NettyChannelPool.NettyChannelGroupKey key = new NettyChannelPool.NettyChannelGroupKey(op.getConnectionTag(), remoteHost, port, pool.isHttp2Only());
        pool.connectOrReuse(key, op);
    }

    private void doSendRequest(Operation op) {
        Object originalBody = op.getBodyRaw();
        try {
            Operation.AuthorizationContext ctx;
            byte[] body = Utils.encodeBody(op);
            if (op.getContentLength() > (long)this.getRequestPayloadSizeLimit()) {
                this.stopTracking(op);
                IllegalArgumentException e2 = new IllegalArgumentException("Content-Length " + op.getContentLength() + " is greater than max size allowed " + this.getRequestPayloadSizeLimit());
                op.setBody(ServiceErrorResponse.create(e2, 400));
                op.fail(e2);
                return;
            }
            String path = op.getUri().getPath();
            String query = op.getUri().getRawQuery();
            path = path == null || path.isEmpty() ? "/" : path;
            String pathAndQuery = query != null ? path + "?" + query : path;
            boolean hasRequestHeaders = op.hasRequestHeaders();
            boolean useHttp2 = op.isConnectionSharing();
            if (this.httpProxy != null || useHttp2) {
                pathAndQuery = op.getUri().toString();
            }
            NettyFullHttpRequest request = null;
            HttpMethod method = HttpMethod.valueOf((String)op.getAction().toString());
            if (body == null || body.length == 0) {
                request = new NettyFullHttpRequest(HttpVersion.HTTP_1_1, method, pathAndQuery, Unpooled.buffer((int)0), false);
            } else {
                ByteBuf content = Unpooled.wrappedBuffer((byte[])body, (int)0, (int)((int)op.getContentLength()));
                request = new NettyFullHttpRequest(HttpVersion.HTTP_1_1, method, pathAndQuery, content, false);
            }
            if (useHttp2) {
                if (hasRequestHeaders) {
                    op.getRequestHeaders().remove("x-http2-stream-id");
                }
                request.setOperation(op);
            }
            String pragmaHeader = op.getRequestHeader("pragma");
            if (op.isFromReplication() && pragmaHeader == null) {
                request.headers().set((CharSequence)HttpHeaderNames.PRAGMA, (Object)"xn-rpl");
            }
            if (op.getTransactionId() != null) {
                request.headers().set("x-xenon-tx-id", (Object)op.getTransactionId());
            }
            if (op.getContextId() != null) {
                request.headers().set("x-xenon-ctx-id", (Object)op.getContextId());
            }
            if ((ctx = op.getAuthorizationContext()) != null && ctx.getToken() != null) {
                request.headers().set("x-xenon-auth-token", (Object)ctx.getToken());
            }
            boolean isXenonToXenon = op.isFromReplication();
            boolean isRequestWithCallback = false;
            if (hasRequestHeaders) {
                for (Map.Entry<String, String> nameValue : op.getRequestHeaders().entrySet()) {
                    String key = nameValue.getKey();
                    if (!isXenonToXenon) {
                        if ("x-xenon-req-location".equals(key)) {
                            isRequestWithCallback = true;
                            isXenonToXenon = true;
                        } else if ("x-xenon-rsp-status".equals(key)) {
                            isXenonToXenon = true;
                        }
                    }
                    request.headers().set(nameValue.getKey(), (Object)nameValue.getValue());
                }
            }
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Long.toString(op.getContentLength()));
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)op.getContentType());
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            if (!isXenonToXenon) {
                if (op.getCookies() != null) {
                    String header = CookieJar.encodeCookies(op.getCookies());
                    request.headers().set((CharSequence)HttpHeaderNames.COOKIE, (Object)header);
                }
                if (op.hasReferer()) {
                    request.headers().set((CharSequence)HttpHeaderNames.REFERER, (Object)op.getRefererAsString());
                }
                request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.userAgent);
                if (op.getRequestHeader("accept") == null) {
                    request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
                }
                request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)op.getUri().getHost());
            }
            boolean doCookieJarUpdate = !isXenonToXenon;
            boolean stopTracking = !isRequestWithCallback;
            op.nestCompletion((o, e) -> {
                if (e != null) {
                    this.fail(e, op, originalBody);
                    return;
                }
                if (stopTracking) {
                    this.stopTracking(op);
                }
                if (doCookieJarUpdate) {
                    this.updateCookieJarFromResponseHeaders(o);
                }
                op.complete();
            });
            op.getSocketContext().writeHttpRequest((Object)request);
        }
        catch (Throwable e3) {
            op.setBody(ServiceErrorResponse.create(e3, 400, EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
            this.fail(e3, op, originalBody);
        }
    }

    private void failWithTimeout(Operation op, Object originalBody) {
        TimeoutException e = new TimeoutException(op.getUri() + ":" + op.getExpirationMicrosUtc());
        op.setStatusCode(408);
        this.fail(e, op, originalBody);
    }

    private void fail(Throwable e, Operation op, Object originalBody) {
        boolean isRetryRequested;
        this.stopTracking(op);
        Operation.SocketContext ctx = op.getSocketContext();
        if (ctx != null && ctx instanceof NettyChannelContext) {
            NettyChannelContext nettyCtx = (NettyChannelContext)op.getSocketContext();
            NettyChannelPool pool = this.channelPool;
            if (this.sslChannelPool != null && this.sslChannelPool.isContextInUse(nettyCtx)) {
                pool = this.sslChannelPool;
            }
            if (nettyCtx.getProtocol() == NettyChannelContext.Protocol.HTTP2) {
                pool = this.http2ChannelPool;
                pool.returnOrClose(nettyCtx, false);
            } else {
                op.setSocketContext(null);
                pool.returnOrClose(nettyCtx, !op.isKeepAlive());
            }
        }
        if (this.scheduledExecutor.isShutdown()) {
            op.fail(new CancellationException());
            return;
        }
        boolean bl = isRetryRequested = op.getRetryCount() > 0 && op.decrementRetriesRemaining() >= 0;
        if (isRetryRequested) {
            if (op.getStatusCode() >= 500) {
                isRetryRequested = false;
            } else if (op.getStatusCode() == 409) {
                isRetryRequested = false;
            } else if (op.getStatusCode() == 401) {
                isRetryRequested = false;
            } else if (op.getStatusCode() == 404) {
                isRetryRequested = false;
            } else if (op.getStatusCode() == 403) {
                isRetryRequested = false;
            }
        }
        if (!isRetryRequested) {
            LOGGER.fine(String.format("Send of %d, from %s to %s failed with %s", op.getId(), op.getRefererAsString(), op.getUri(), e.toString()));
            op.fail(e);
            return;
        }
        LOGGER.info(String.format("Retry %d of request %d from %s to %s due to %s", op.getRetryCount() - op.getRetriesRemaining(), op.getId(), op.getRefererAsString(), op.getUri(), e.toString()));
        int delaySeconds = op.getRetryCount() - op.getRetriesRemaining();
        op.setStatusCode(200).setBodyNoCloning(originalBody);
        this.scheduledExecutor.schedule(() -> {
            this.startTracking(op);
            this.sendRemote(op);
        }, (long)delaySeconds, TimeUnit.SECONDS);
    }

    private static boolean validateOperation(Operation op) {
        if (op == null) {
            throw new IllegalArgumentException("Operation is required");
        }
        IllegalArgumentException e = null;
        if (op.getUri() == null) {
            e = new IllegalArgumentException("Uri is required");
        }
        if (e == null && op.getUri().getHost() == null) {
            e = new IllegalArgumentException("Missing host in URI");
        }
        if (e == null && op.getAction() == null) {
            e = new IllegalArgumentException("Action is required");
        }
        if (e == null && !op.hasReferer()) {
            e = new IllegalArgumentException("Referer is required");
        }
        if (e == null) {
            boolean needsBody;
            boolean bl = needsBody = op.getAction() != Service.Action.GET && op.getAction() != Service.Action.DELETE && op.getAction() != Service.Action.POST && op.getAction() != Service.Action.OPTIONS;
            if (!op.hasBody() && needsBody) {
                e = new IllegalArgumentException("Body is required");
            }
        }
        Operation.CompletionHandler c = op.getCompletion();
        if (e != null) {
            if (c != null) {
                c.handle(op, e);
                return false;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void handleMaintenance(Operation op) {
        long now = Utils.getNowMicrosUtc();
        if (this.sslChannelPool != null) {
            this.sslChannelPool.handleMaintenance(Operation.createPost(op.getUri()));
        }
        if (this.http2ChannelPool != null) {
            this.http2ChannelPool.handleMaintenance(Operation.createPost(op.getUri()));
        }
        this.channelPool.handleMaintenance(op);
        this.failExpiredRequests(now);
    }

    private void failExpiredRequests(long now) {
        ArrayList<Operation> expired = null;
        if (this.pendingRequests.isEmpty()) {
            return;
        }
        int searchLimit = 1000;
        int i = 0;
        for (Operation o : this.pendingRequests.values()) {
            if (i++ >= 1000) break;
            long exp = o.getExpirationMicrosUtc();
            if (exp > now) continue;
            if (o.getStatusCode() == 408) {
                if (expired == null) {
                    expired = new ArrayList<Operation>();
                }
                expired.add(o);
                continue;
            }
            o.setStatusCode(408);
        }
        if (expired == null) {
            return;
        }
        LOGGER.info("Failed expired operations, count: " + expired.size());
        for (Operation o : expired) {
            this.failWithTimeout(o, o.getBodyRaw());
        }
    }

    @Override
    public ServiceClient setConnectionLimitPerHost(int limit) {
        this.channelPool.setConnectionLimitPerHost(limit);
        if (this.sslChannelPool != null) {
            this.sslChannelPool.setConnectionLimitPerHost(limit);
        }
        if (this.http2ChannelPool != null) {
            this.http2ChannelPool.setConnectionLimitPerHost(limit);
        }
        return this;
    }

    @Override
    public int getConnectionLimitPerHost() {
        return this.channelPool.getConnectionLimitPerHost();
    }

    @Override
    public ServiceClient setConnectionLimitPerTag(String tag, int limit) {
        this.channelPool.setConnectionLimitPerTag(tag, limit);
        if (this.sslChannelPool != null) {
            this.sslChannelPool.setConnectionLimitPerTag(tag, limit);
        }
        if (this.http2ChannelPool != null) {
            this.http2ChannelPool.setConnectionLimitPerTag(tag, limit);
        }
        return this;
    }

    @Override
    public int getConnectionLimitPerTag(String tag) {
        return this.channelPool.getConnectionLimitPerTag(tag);
    }

    @Override
    public ServiceClient setSSLContext(SSLContext context) {
        this.sslContext = context;
        return this;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public NettyChannelPool getChannelPool() {
        return this.channelPool;
    }

    public NettyChannelPool getHttp2ChannelPool() {
        return this.http2ChannelPool;
    }

    public NettyChannelPool getSslChannelPool() {
        return this.sslChannelPool;
    }

    public NettyChannelContext getInUseHttp2Context(String tag, String host, int port) {
        if (this.http2ChannelPool == null) {
            throw new IllegalStateException("Internal error: no HTTP/2 channel pool");
        }
        return this.http2ChannelPool.getFirstValidHttp2Context(tag, host, port);
    }

    public int getInUseContextCount(String tag, String host, int port) {
        if (this.http2ChannelPool == null) {
            throw new IllegalStateException("Internal error: no HTTP/2 channel pool");
        }
        return this.http2ChannelPool.getHttp2ActiveContextCount(tag, host, port);
    }

    public void clearCookieJar() {
        this.cookieJar = new CookieJar();
    }

    @Override
    public int getRequestPayloadSizeLimit() {
        return this.channelPool.getRequestPayloadSizeLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceClient setRequestPayloadSizeLimit(int limit) {
        Object object = this.START_LOCK;
        synchronized (object) {
            if (this.isStarted) {
                throw new IllegalStateException("Already started");
            }
            this.channelPool.setRequestPayloadSizeLimit(limit);
            if (this.sslChannelPool != null) {
                this.sslChannelPool.setRequestPayloadSizeLimit(limit);
            }
            if (this.http2ChannelPool != null) {
                this.http2ChannelPool.setRequestPayloadSizeLimit(limit);
            }
        }
        return this;
    }
}

