/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.Utils;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ServiceStats
extends ServiceDocument {
    public static final String KIND = Utils.buildKind(ServiceStats.class);
    public String kind = KIND;
    public Map<String, ServiceStat> entries = new HashMap<String, ServiceStat>();

    public static class ServiceStat {
        public static final String KIND = Utils.buildKind(ServiceStat.class);
        public String name;
        public double latestValue;
        public double accumulatedValue;
        public long version;
        public long lastUpdateMicrosUtc;
        public String kind = KIND;
        public String unit;
        public Long sourceTimeMicrosUtc;
        public URI serviceReference;
        public ServiceStatLogHistogram logHistogram;
        public TimeSeriesStats timeSeriesStats;
    }

    public static class TimeSeriesStats {
        public SortedMap<Long, DataPoint> dataPoints;
        public int numBuckets;
        public long bucketDurationMillis;
        public EnumSet<AggregationType> aggregationType;

        public TimeSeriesStats(int numBuckets, long bucketDurationMillis, EnumSet<AggregationType> aggregationType) {
            this.numBuckets = numBuckets;
            this.bucketDurationMillis = bucketDurationMillis;
            this.dataPoints = new TreeMap<Long, DataPoint>();
            this.aggregationType = aggregationType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long timestampMicros, double value) {
            SortedMap<Long, DataPoint> sortedMap = this.dataPoints;
            synchronized (sortedMap) {
                long bucketId = this.normalizeTimestamp(timestampMicros, this.bucketDurationMillis);
                DataPoint dataBucket = null;
                if (this.dataPoints.containsKey(bucketId)) {
                    dataBucket = (DataPoint)this.dataPoints.get(bucketId);
                } else {
                    if (this.dataPoints.size() == this.numBuckets) {
                        if (this.dataPoints.firstKey() > timestampMicros) {
                            return;
                        }
                        this.dataPoints.remove(this.dataPoints.firstKey());
                    }
                    dataBucket = new DataPoint();
                    this.dataPoints.put(bucketId, dataBucket);
                }
                if (this.aggregationType.contains((Object)AggregationType.AVG)) {
                    if (dataBucket.avg == null) {
                        dataBucket.avg = new Double(value);
                        dataBucket.count = 1.0;
                    } else {
                        double newAvg = (dataBucket.avg * dataBucket.count + value) / (dataBucket.count + 1.0);
                        dataBucket.avg = newAvg;
                        dataBucket.count += 1.0;
                    }
                }
                if (this.aggregationType.contains((Object)AggregationType.MAX)) {
                    if (dataBucket.max == null) {
                        dataBucket.max = new Double(value);
                    } else if (dataBucket.max < value) {
                        dataBucket.max = value;
                    }
                }
                if (this.aggregationType.contains((Object)AggregationType.MIN)) {
                    if (dataBucket.min == null) {
                        dataBucket.min = new Double(value);
                    } else if (dataBucket.min > value) {
                        dataBucket.min = value;
                    }
                }
            }
        }

        private long normalizeTimestamp(long timestampMicros, long bucketDurationMillis) {
            long timeMillis = TimeUnit.MICROSECONDS.toMillis(timestampMicros);
            timeMillis -= timeMillis % bucketDurationMillis;
            return timeMillis;
        }

        public static enum AggregationType {
            AVG,
            MIN,
            MAX;

        }

        public static class DataPoint {
            public Double avg;
            public Double min;
            public Double max;
            public double count;
        }
    }

    public static class ServiceStatLogHistogram {
        public long[] bins = new long[15];
    }
}

