/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceHost;

public class OperationContext {
    private Operation.AuthorizationContext authContext;
    private String contextId;
    private String transactionId;
    private static final ThreadLocal<String> threadContextId = new ThreadLocal();
    private static final ThreadLocal<String> threadTransactionId = new ThreadLocal();
    private static final ThreadLocal<Operation.AuthorizationContext> threadAuthContext = new ThreadLocal();

    private OperationContext(Operation.AuthorizationContext authContext, String contextId, String transactionId) {
        this.authContext = authContext;
        this.contextId = contextId;
        this.transactionId = transactionId;
    }

    public static void setContextId(String contextId) {
        threadContextId.set(contextId);
    }

    public static String getContextId() {
        return threadContextId.get();
    }

    static void setAuthorizationContext(Operation.AuthorizationContext ctx) {
        threadAuthContext.set(ctx);
    }

    public static void setTransactionId(String transactionId) {
        threadTransactionId.set(transactionId);
    }

    public static String getTransactionId() {
        return threadTransactionId.get();
    }

    public static void setAuthorizationContext(ServiceHost host, Operation op) {
        OperationContext.setAuthorizationContext(host.getAuthorizationContext(op));
    }

    public static Operation.AuthorizationContext getAuthorizationContext() {
        return threadAuthContext.get();
    }

    public static OperationContext getOperationContext() {
        return new OperationContext(threadAuthContext.get(), threadContextId.get(), threadTransactionId.get());
    }

    public static void setFrom(OperationContext opContext) {
        threadAuthContext.set(opContext.authContext);
        threadContextId.set(opContext.contextId);
        threadTransactionId.set(opContext.transactionId);
    }

    public static void setFrom(Operation op) {
        threadAuthContext.set(op.getAuthorizationContext());
        threadContextId.set(op.getContextId());
        threadTransactionId.set(op.getTransactionId());
    }

    public static void reset() {
        threadAuthContext.set(null);
        threadContextId.set(null);
        threadTransactionId.set(null);
    }

    public static void restoreOperationContext(OperationContext ctx) {
        OperationContext.setAuthorizationContext(ctx.authContext);
        OperationContext.setContextId(ctx.contextId);
        OperationContext.setTransactionId(ctx.transactionId);
    }
}

