/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;

public class NodeSelectorReplicationService
extends StatelessService {
    public static final int BINARY_SERIALIZATION = Integer.getInteger("xenon.NodeSelectorReplicationService.BINARY_SERIALIZATION", 1);
    private Service parent;

    public NodeSelectorReplicationService(Service parent) {
        this.parent = parent;
        super.setHost(parent.getHost());
        super.setSelfLink(UriUtils.buildUriPath(parent.getSelfLink(), "/replication"));
        super.setProcessingStage(Service.ProcessingStage.AVAILABLE);
    }

    void replicateUpdate(NodeGroupService.NodeGroupState localState, Operation outboundOp, NodeSelectorService.SelectAndForwardRequest req, NodeSelectorService.SelectOwnerResponse rsp) {
        String commitHeader;
        String rplQuorumValue;
        int memberCount = localState.nodes.size();
        NodeState selfNode = localState.nodes.get(this.getHost().getId());
        if (req.serviceOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION) && selfNode.membershipQuorum > memberCount) {
            outboundOp.fail(new IllegalStateException("Not enough peers: " + memberCount));
            return;
        }
        if (memberCount == 1) {
            outboundOp.complete();
            return;
        }
        int[] completionCounts = new int[2];
        int eligibleMemberCount = rsp.selectedNodes.size();
        int successThreshold = Math.min(2, eligibleMemberCount - 1);
        int failureThreshold = eligibleMemberCount - successThreshold;
        if (req.serviceOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION)) {
            successThreshold = Math.min(eligibleMemberCount, selfNode.membershipQuorum);
            failureThreshold = eligibleMemberCount - successThreshold;
        }
        if ((rplQuorumValue = outboundOp.getRequestHeader("x-xenon-rpl-quorum")) != null) {
            try {
                successThreshold = "x-xenon-all".equals(rplQuorumValue) ? eligibleMemberCount : Integer.parseInt(rplQuorumValue);
                if (successThreshold > eligibleMemberCount) {
                    String errorMsg = String.format("Requested quorum %d is larger than member count %d", successThreshold, eligibleMemberCount);
                    throw new IllegalArgumentException(errorMsg);
                }
                failureThreshold = eligibleMemberCount - successThreshold;
                outboundOp.getRequestHeaders().remove("x-xenon-rpl-quorum");
            }
            catch (Throwable e2) {
                outboundOp.setRetryCount(0).fail(e2);
                return;
            }
        }
        int successThresholdFinal = successThreshold;
        int failureThresholdFinal = failureThreshold;
        Operation.CompletionHandler c = (o, e) -> {
            if (e == null && o != null && o.getStatusCode() >= 400) {
                e = new IllegalStateException("Request failed: " + o.toString());
            }
            int sCount = completionCounts[0];
            int fCount = completionCounts[1];
            Operation operation = outboundOp;
            synchronized (operation) {
                if (e != null) {
                    completionCounts[1] = completionCounts[1] + 1;
                    fCount = completionCounts[1];
                } else {
                    completionCounts[0] = completionCounts[0] + 1;
                    sCount = completionCounts[0];
                }
            }
            if (e != null && o != null) {
                this.logWarning("Replication request to %s failed with %d, %s", o.getUri(), o.getStatusCode(), e.getMessage());
            }
            if (sCount == successThresholdFinal) {
                outboundOp.complete();
                return;
            }
            if (fCount == 0) {
                return;
            }
            if (fCount > failureThresholdFinal || fCount + sCount == memberCount) {
                String error = String.format("%s to %s failed. Success: %d,  Fail: %d, quorum: %d, threshold: %d", new Object[]{outboundOp.getAction(), outboundOp.getUri().getPath(), sCount, fCount, selfNode.membershipQuorum, failureThresholdFinal});
                this.logWarning("%s", error);
                outboundOp.fail(new IllegalStateException(error));
            }
        };
        String path = outboundOp.getUri().getPath();
        String query = outboundOp.getUri().getQuery();
        Operation update = Operation.createPost(null).setAction(outboundOp.getAction()).setCompletion(c).setRetryCount(1).setExpiration(outboundOp.getExpirationMicrosUtc()).transferRefererFrom(outboundOp);
        String pragmaHeader = outboundOp.getRequestHeader("pragma");
        if (pragmaHeader != null && !"xn-fwd".equals(pragmaHeader)) {
            update.addRequestHeader("pragma", pragmaHeader);
            update.addPragmaDirective("xn-rpl");
        }
        if ((commitHeader = outboundOp.getRequestHeader("x-xenon-rpl-phase")) != null) {
            update.addRequestHeader("x-xenon-rpl-phase", commitHeader);
        }
        Utils.encodeAndTransferLinkedStateToBody(outboundOp, update, BINARY_SERIALIZATION == 1);
        update.setFromReplication(true);
        update.setConnectionTag("xn-cnx-tag-replication");
        if (NodeSelectorService.REPLICATION_OPERATION_OPTION != null) {
            update.toggleOption(NodeSelectorService.REPLICATION_OPERATION_OPTION, true);
        }
        if (update.getCookies() != null) {
            update.getCookies().clear();
        }
        ServiceClient cl = this.getHost().getClient();
        String selfId = this.getHost().getId();
        c.handle(null, null);
        for (NodeState m : rsp.selectedNodes) {
            if (m.id.equals(selfId) || m.options.contains((Object)NodeState.NodeOption.OBSERVER)) continue;
            try {
                URI remoteHost = m.groupReference;
                URI remotePeerService = new URI(remoteHost.getScheme(), null, remoteHost.getHost(), remoteHost.getPort(), path, query, null);
                update.setUri(remotePeerService);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (NodeState.isUnAvailable(m)) {
                update.setStatusCode(400);
                c.handle(update, new IllegalStateException("node is not available"));
                continue;
            }
            cl.send(update);
        }
    }

    @Override
    public void sendRequest(Operation op) {
        this.parent.sendRequest(op);
    }

    @Override
    public ServiceHost getHost() {
        return this.parent.getHost();
    }
}

