/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ResourceGroupService;
import com.vmware.xenon.services.common.RoleService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.UserGroupService;
import com.vmware.xenon.services.common.UserService;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;

class AuthorizationCacheUtils {
    AuthorizationCacheUtils() {
    }

    static void clearAuthzCacheForUser(StatefulService s, Operation op, UserService.UserState userState) {
        s.getHost().clearAuthorizationContext(s, userState.documentSelfLink);
        op.complete();
    }

    static void clearAuthzCacheForUserGroup(StatefulService s, Operation op, UserGroupService.UserGroupState userGroupState) {
        QueryTask queryTask = new QueryTask();
        queryTask.querySpec = new QueryTask.QuerySpecification();
        queryTask.querySpec.query = userGroupState.query;
        queryTask.setDirect(true);
        Operation postOp = Operation.createPost(s, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS).setBody(queryTask).setCompletion((queryOp, queryEx) -> {
            if (queryEx != null) {
                op.fail(queryEx);
                return;
            }
            QueryTask queryTaskResult = queryOp.getBody(QueryTask.class);
            ServiceDocumentQueryResult result = queryTaskResult.results;
            if (result.documentLinks == null || result.documentLinks.isEmpty()) {
                op.complete();
                return;
            }
            for (String userLink : result.documentLinks) {
                s.getHost().clearAuthorizationContext(s, userLink);
            }
            op.complete();
        });
        s.setAuthorizationContext(postOp, s.getSystemAuthorizationContext());
        s.sendRequest(postOp);
    }

    static void clearAuthzCacheForRole(StatefulService s, Operation op, RoleService.RoleState roleState) {
        Operation parentOp = Operation.createGet(s.getHost(), roleState.userGroupLink).setCompletion((getOp, getEx) -> {
            if (getOp.getStatusCode() == 404) {
                op.complete();
                return;
            }
            if (getEx != null) {
                op.setBodyNoCloning(getOp.getBodyRaw()).fail(getOp.getStatusCode());
                return;
            }
            UserGroupService.UserGroupState userGroupState = getOp.getBody(UserGroupService.UserGroupState.class);
            AuthorizationCacheUtils.clearAuthzCacheForUserGroup(s, op, userGroupState);
        });
        s.setAuthorizationContext(parentOp, s.getSystemAuthorizationContext());
        s.sendRequest(parentOp);
    }

    static void clearAuthzCacheForResourceGroup(StatefulService s, Operation op, ResourceGroupService.ResourceGroupState resourceGroupState) {
        QueryTask queryTask = new QueryTask();
        queryTask.querySpec = new QueryTask.QuerySpecification();
        QueryTask.Query resourceGroupQuery = QueryTask.Query.Builder.create().addFieldClause("resourceGroupLink", resourceGroupState.documentSelfLink).addKindFieldClause(RoleService.RoleState.class).build();
        queryTask.querySpec.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        queryTask.setDirect(true);
        queryTask.querySpec.query = resourceGroupQuery;
        queryTask.setDirect(true);
        Operation postOp = Operation.createPost(s, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS).setBody(queryTask).setCompletion((queryOp, queryEx) -> {
            if (queryEx != null) {
                op.fail(queryEx);
                return;
            }
            QueryTask queryTaskResult = queryOp.getBody(QueryTask.class);
            ServiceDocumentQueryResult result = queryTaskResult.results;
            if (result.documents == null || result.documents.isEmpty()) {
                op.complete();
                return;
            }
            AtomicInteger completionCount = new AtomicInteger(0);
            Operation.CompletionHandler handler = (subOp, subEx) -> {
                if (subEx != null) {
                    op.fail(subEx);
                    return;
                }
                if (completionCount.incrementAndGet() == result.documents.size()) {
                    op.complete();
                }
            };
            for (Object doc : result.documents.values()) {
                RoleService.RoleState roleState = Utils.fromJson(doc, RoleService.RoleState.class);
                Operation roleOp = new Operation();
                roleOp.setCompletion(handler);
                AuthorizationCacheUtils.clearAuthzCacheForRole(s, roleOp, roleState);
            }
        });
        s.setAuthorizationContext(postOp, s.getSystemAuthorizationContext());
        s.sendRequest(postOp);
    }
}

