/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import com.vmware.xenon.common.http.netty.NettyHttp2UserEventLogger;
import com.vmware.xenon.common.http.netty.NettyHttpServerResponseHandler;
import com.vmware.xenon.common.http.netty.NettyHttpServiceClient;
import com.vmware.xenon.common.http.netty.NettyHttpToHttp2Handler;
import com.vmware.xenon.common.http.netty.NettyHttpToHttp2HandlerBuilder;
import com.vmware.xenon.common.http.netty.NettyLoggingUtil;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslHandler;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;

public class NettyHttpClientRequestInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String SSL_HANDLER = "ssl";
    public static final String HTTP1_CODEC = "http1-codec";
    public static final String UPGRADE_HANDLER = "upgrade-handler";
    public static final String UPGRADE_REQUEST = "upgrade-request";
    public static final String AGGREGATOR_HANDLER = "aggregator";
    public static final String XENON_HANDLER = "xenon";
    public static final String EVENT_LOGGER = "event-logger";
    private final NettyChannelPool pool;
    private boolean isHttp2Only = false;
    private boolean debugLogging = false;

    public NettyHttpClientRequestInitializer(NettyChannelPool nettyChannelPool, boolean isHttp2Only) {
        this.pool = nettyChannelPool;
        this.isHttp2Only = isHttp2Only;
        NettyLoggingUtil.setupNettyLogging();
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        ch.config().setAllocator((ByteBufAllocator)NettyChannelContext.ALLOCATOR);
        ch.config().setSendBufferSize(65536);
        ch.config().setReceiveBufferSize(65536);
        if (this.pool.getSSLContext() != null) {
            if (this.isHttp2Only) {
                throw new IllegalArgumentException("HTTP/2 with SSL is not supported");
            }
            SSLEngine engine = this.pool.getSSLContext().createSSLEngine();
            engine.setUseClientMode(true);
            p.addLast(SSL_HANDLER, (ChannelHandler)new SslHandler(engine));
        }
        HttpClientCodec http1_codec = new HttpClientCodec(4096, 65536, 65536, false, false);
        p.addLast(HTTP1_CODEC, (ChannelHandler)http1_codec);
        if (this.isHttp2Only) {
            try {
                NettyHttpToHttp2Handler connectionHandler = this.makeHttp2ConnectionHandler();
                Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)connectionHandler);
                HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)http1_codec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, NettyHttpServiceClient.getRequestPayloadSizeLimit());
                p.addLast(UPGRADE_HANDLER, (ChannelHandler)upgradeHandler);
                p.addLast(UPGRADE_REQUEST, (ChannelHandler)new UpgradeRequestHandler());
                ChannelPromise settingsPromise = ch.newPromise();
                p.addLast("settings-handler", (ChannelHandler)new Http2SettingsHandler(settingsPromise));
                ch.attr(NettyChannelContext.SETTINGS_PROMISE_KEY).set((Object)settingsPromise);
                p.addLast(EVENT_LOGGER, (ChannelHandler)new NettyHttp2UserEventLogger(this.debugLogging));
            }
            catch (Throwable ex) {
                Utils.log(NettyHttpClientRequestInitializer.class, NettyHttpClientRequestInitializer.class.getSimpleName(), Level.WARNING, "Channel Initializer exception: %s", ex);
                throw ex;
            }
        } else {
            p.addLast(AGGREGATOR_HANDLER, (ChannelHandler)new HttpObjectAggregator(NettyHttpServiceClient.getRequestPayloadSizeLimit()));
        }
        p.addLast(XENON_HANDLER, (ChannelHandler)new NettyHttpServerResponseHandler(this.pool));
    }

    private NettyHttpToHttp2Handler makeHttp2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        InboundHttp2ToHttpAdapter inboundAdapter = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(NettyHttpServiceClient.getRequestPayloadSizeLimit()).propagateSettings(true).build();
        DelegatingDecompressorFrameListener frameListener = new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)inboundAdapter);
        Http2Settings settings = new Http2Settings();
        settings.initialWindowSize(65536);
        NettyHttpToHttp2HandlerBuilder builder = new NettyHttpToHttp2HandlerBuilder().connection((Http2Connection)connection).frameListener((Http2FrameListener)frameListener).initialSettings(settings);
        if (this.debugLogging) {
            Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.INFO, NettyHttpClientRequestInitializer.class);
            builder.frameLogger(frameLogger);
        }
        NettyHttpToHttp2Handler connectionHandler = builder.build();
        return connectionHandler;
    }

    private static class Http2SettingsHandler
    extends SimpleChannelInboundHandler<Http2Settings> {
        private ChannelPromise promise;

        public Http2SettingsHandler(ChannelPromise promise) {
            this.promise = promise;
        }

        protected void channelRead0(ChannelHandlerContext ctx, Http2Settings msg) throws Exception {
            ctx.pipeline().remove((ChannelHandler)this);
            this.promise.setSuccess();
        }
    }

    private static final class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private UpgradeRequestHandler() {
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            context.writeAndFlush((Object)upgradeRequest);
            super.channelActive(context);
            context.pipeline().remove((ChannelHandler)this);
        }
    }
}

