/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeSelectorSynchronizationService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

class ServiceSynchronizationTracker {
    private ServiceHost host;
    private final ConcurrentSkipListMap<String, Long> synchronizationTimes = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, Long> synchronizationRequiredServices = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, Long> synchronizationActiveServices = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, NodeGroupService.NodeGroupState> pendingNodeSelectorsForFactorySynch = new ConcurrentSkipListMap();

    ServiceSynchronizationTracker() {
    }

    public static ServiceSynchronizationTracker create(ServiceHost host) {
        ServiceSynchronizationTracker sst = new ServiceSynchronizationTracker();
        sst.host = host;
        return sst;
    }

    public void addService(String servicePath, long timeMicros) {
        this.synchronizationRequiredServices.put(servicePath, timeMicros);
    }

    public void removeService(String path) {
        this.synchronizationActiveServices.remove(path);
        this.synchronizationRequiredServices.remove(path);
    }

    private void scheduleNodeGroupChangeMaintenance(String nodeSelectorPath, Operation op) {
        OperationContext.setAuthorizationContext(this.host.getSystemAuthorizationContext());
        if (nodeSelectorPath == null) {
            throw new IllegalArgumentException("nodeGroupPath is required");
        }
        NodeSelectorService nss = this.host.findNodeSelectorService(nodeSelectorPath, Operation.createGet(null));
        if (nss == null) {
            throw new IllegalArgumentException("Node selector not found: " + nodeSelectorPath);
        }
        String ngPath = nss.getNodeGroup();
        Operation get = Operation.createGet(UriUtils.buildUri(this.host, ngPath)).setReferer(this.host.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                this.host.log(Level.WARNING, "Failure getting node group state: %s", e.toString());
                if (op != null) {
                    op.fail(e);
                }
                return;
            }
            NodeGroupService.NodeGroupState ngs = o.getBody(NodeGroupService.NodeGroupState.class);
            this.pendingNodeSelectorsForFactorySynch.put(nodeSelectorPath, ngs);
            if (op != null) {
                op.complete();
            }
        });
        this.host.sendRequest(get);
    }

    void startOrSynchService(Operation post, Service child, NodeGroupService.NodeGroupState ngs) {
        String path = post.getUri().getPath();
        Service s = this.host.findService(path);
        boolean skipSynch = false;
        if (ngs != null) {
            NodeState self = ngs.nodes.get(this.host.getId());
            if (self.membershipQuorum == 1 && ngs.nodes.size() == 1) {
                skipSynch = true;
            }
        } else {
            skipSynch = true;
        }
        if (s == null) {
            post.addPragmaDirective("xn-check-version");
            this.host.startService(post, child);
            return;
        }
        if (skipSynch) {
            post.complete();
            return;
        }
        Operation synchPut = Operation.createPut(post.getUri()).setBody(new ServiceDocument()).addPragmaDirective("xn-no-fwd").setReplicationDisabled(true).addPragmaDirective("xn-synch").transferRefererFrom(post).setCompletion((o, e) -> {
            if (e != null) {
                post.setStatusCode(o.getStatusCode()).setBodyNoCloning(o.getBodyRaw()).fail(e);
                return;
            }
            post.complete();
        });
        this.host.sendRequest(synchPut);
    }

    void selectServiceOwnerAndSynchState(Service s, Operation op, boolean isFactorySync) {
        Operation.CompletionHandler c = (o, e) -> {
            if (e != null) {
                this.host.log(Level.WARNING, "Failure partitioning %s: %s", op.getUri(), e.toString());
                op.fail(e);
                return;
            }
            NodeSelectorService.SelectOwnerResponse rsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            if (op.isFromReplication()) {
                if (op.isCommit()) {
                    s.toggleOption(Service.ServiceOption.DOCUMENT_OWNER, rsp.isLocalHostOwner);
                }
                op.complete();
                return;
            }
            s.toggleOption(Service.ServiceOption.DOCUMENT_OWNER, rsp.isLocalHostOwner);
            if (ServiceHost.isServiceCreate(op) || !isFactorySync && !rsp.isLocalHostOwner) {
                op.complete();
                return;
            }
            this.synchronizeWithPeers(s, op, rsp);
        };
        Operation selectOwnerOp = Operation.createPost(null).setExpiration(op.getExpirationMicrosUtc()).setCompletion(c);
        this.host.selectOwner(s.getPeerNodeSelectorPath(), s.getSelfLink(), selectOwnerOp);
    }

    private void synchronizeWithPeers(Service s, Operation op, NodeSelectorService.SelectOwnerResponse rsp) {
        NodeSelectorSynchronizationService.SynchronizePeersRequest t = NodeSelectorSynchronizationService.SynchronizePeersRequest.create();
        t.stateDescription = this.host.buildDocumentDescription(s);
        t.wasOwner = s.hasOption(Service.ServiceOption.DOCUMENT_OWNER);
        t.isOwner = rsp.isLocalHostOwner;
        t.ownerNodeReference = rsp.ownerNodeGroupReference;
        t.ownerNodeId = rsp.ownerNodeId;
        t.options = s.getOptions();
        t.state = op.hasBody() ? op.getBody(s.getStateType()) : null;
        t.factoryLink = UriUtils.getParentPath(s.getSelfLink());
        if (t.factoryLink == null || t.factoryLink.isEmpty()) {
            String error = String.format("Factory not found for %s.If the service is not created through a factory it should not set %s", new Object[]{s.getSelfLink(), Service.ServiceOption.OWNER_SELECTION});
            op.fail(new IllegalStateException(error));
            return;
        }
        if (t.state == null) {
            ServiceDocument template = null;
            try {
                template = s.getStateType().newInstance();
            }
            catch (Throwable e2) {
                this.host.log(Level.SEVERE, "Could not create instance state type: %s", e2.toString());
                op.fail(e2);
                return;
            }
            template.documentSelfLink = s.getSelfLink();
            template.documentEpoch = 0L;
            template.documentVersion = -1L;
            t.state = template;
        }
        Operation.CompletionHandler c = (o, e) -> {
            ServiceDocument selectedState = null;
            if (this.host.isStopping()) {
                op.fail(new CancellationException());
                return;
            }
            if (e != null) {
                op.fail(e);
                return;
            }
            if (!o.hasBody()) {
                op.linkState(null).complete();
                return;
            }
            selectedState = o.getBody(s.getStateType());
            if (ServiceDocument.isDeleted(selectedState)) {
                op.fail(new IllegalStateException("Document marked deleted by peers: " + s.getSelfLink()));
                selectedState.documentSelfLink = s.getSelfLink();
                selectedState.documentUpdateAction = Service.Action.DELETE.toString();
                this.host.saveServiceState(s, Operation.createDelete(UriUtils.buildUri(this.host, s.getSelfLink())).setReferer(s.getUri()), selectedState);
                return;
            }
            op.addPragmaDirective("xn-synch");
            op.setBodyNoCloning(selectedState).complete();
        };
        URI synchServiceForGroup = UriUtils.extendUri(UriUtils.buildUri(this.host, s.getPeerNodeSelectorPath()), "synch");
        Operation synchPost = Operation.createPost(synchServiceForGroup).setBodyNoCloning(t).setReferer(s.getUri()).setCompletion(c);
        this.host.sendRequest(synchPost);
    }

    public void scheduleNodeGroupChangeMaintenance(String nodeSelectorPath) {
        long now = Utils.getNowMicrosUtc();
        this.host.log(Level.INFO, "%s %d", nodeSelectorPath, now);
        this.synchronizationTimes.put(nodeSelectorPath, now);
        this.scheduleNodeGroupChangeMaintenance(nodeSelectorPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performNodeSelectorChangeMaintenance(Operation post, long now, ServiceHost.MaintenanceStage nextStage, boolean isCheckRequired, long deadline) {
        if (isCheckRequired && this.checkAndScheduleNodeSelectorSynch(post, nextStage, deadline)) {
            return;
        }
        try {
            Iterator<Map.Entry<String, NodeGroupService.NodeGroupState>> it = this.pendingNodeSelectorsForFactorySynch.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, NodeGroupService.NodeGroupState> e = it.next();
                it.remove();
                this.performNodeSelectorChangeMaintenance(e);
            }
        }
        finally {
            this.host.performMaintenanceStage(post, nextStage, deadline);
        }
    }

    private boolean checkAndScheduleNodeSelectorSynch(Operation post, ServiceHost.MaintenanceStage nextStage, long deadline) {
        boolean hasSynchOccuredAtLeastOnce = false;
        for (Long l : this.synchronizationTimes.values()) {
            if (l == null || l <= 0L) continue;
            hasSynchOccuredAtLeastOnce = true;
        }
        if (!hasSynchOccuredAtLeastOnce) {
            return false;
        }
        HashSet<String> selectorPathsToSynch = new HashSet<String>();
        for (Map.Entry<String, Long> entry : this.synchronizationRequiredServices.entrySet()) {
            String selectorPath;
            Long selectorSynchTime;
            Long lastSynchTime = entry.getValue();
            String link = entry.getKey();
            Service s = this.host.findService(link, true);
            if (s == null || s.getProcessingStage() != Service.ProcessingStage.AVAILABLE || (selectorSynchTime = this.synchronizationTimes.get(selectorPath = s.getPeerNodeSelectorPath())) == null || lastSynchTime >= selectorSynchTime) continue;
            this.host.log(Level.FINE, "Service %s started at %d, last synch at %d", link, lastSynchTime, selectorSynchTime);
            selectorPathsToSynch.add(s.getPeerNodeSelectorPath());
        }
        if (selectorPathsToSynch.isEmpty()) {
            return false;
        }
        AtomicInteger atomicInteger = new AtomicInteger(selectorPathsToSynch.size());
        Operation.CompletionHandler completionHandler = (o, e) -> {
            if (e != null) {
                if (!this.host.isStopping()) {
                    this.host.log(Level.WARNING, "skipping synchronization, error: %s", Utils.toString(e));
                }
                this.host.performMaintenanceStage(post, nextStage, deadline);
                return;
            }
            int r = pending.decrementAndGet();
            if (r != 0) {
                return;
            }
            this.performNodeSelectorChangeMaintenance(post, Utils.getNowMicrosUtc(), nextStage, false, deadline);
        };
        for (String path : selectorPathsToSynch) {
            Operation synch = Operation.createPost(this.host.getUri()).setCompletion(completionHandler);
            this.scheduleNodeGroupChangeMaintenance(path, synch);
        }
        return true;
    }

    private void performNodeSelectorChangeMaintenance(Map.Entry<String, NodeGroupService.NodeGroupState> entry) {
        String link;
        String nodeSelectorPath = entry.getKey();
        Long selectorSynchTime = this.synchronizationTimes.get(nodeSelectorPath);
        NodeGroupService.NodeGroupState ngs = entry.getValue();
        long now = Utils.getNowMicrosUtc();
        for (Map.Entry<String, Long> en : this.synchronizationActiveServices.entrySet()) {
            link = en.getKey();
            Service s = this.host.findService(link, true);
            if (s == null) continue;
            ServiceHost.ServiceHostState hostState = this.host.getStateNoCloning();
            long delta = now - en.getValue();
            boolean shouldLog = false;
            if (delta > hostState.operationTimeoutMicros) {
                s.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
                s.adjustStat("maintenanceForNodeGroupDelayedCount", 1.0);
                ServiceStats.ServiceStat st = s.getStat("maintenanceForNodeGroupDelayedCount");
                if (st != null && st.latestValue % 10.0 == 0.0) {
                    shouldLog = true;
                }
            }
            long deltaSeconds = TimeUnit.MICROSECONDS.toSeconds(delta);
            if (shouldLog) {
                this.host.log(Level.WARNING, "Service %s has been synchronizing for %d seconds", link, deltaSeconds);
            }
            if ((long)hostState.peerSynchronizationTimeLimitSeconds >= deltaSeconds) continue;
            this.host.log(Level.WARNING, "Service %s has exceeded synchronization limit of %d", link, hostState.peerSynchronizationTimeLimitSeconds);
            this.synchronizationActiveServices.remove(link);
        }
        for (Map.Entry<String, Long> en : this.synchronizationRequiredServices.entrySet()) {
            String serviceSelectorPath;
            now = Utils.getNowMicrosUtc();
            if (this.host.isStopping()) {
                return;
            }
            link = en.getKey();
            Long lastSynchTime = en.getValue();
            if (lastSynchTime >= selectorSynchTime) continue;
            if (this.synchronizationActiveServices.get(link) != null) {
                this.host.log(Level.WARNING, "Skipping synch for service %s, already in progress", link);
                continue;
            }
            Service s = this.host.findService(link, true);
            if (s == null || !s.hasOption(Service.ServiceOption.FACTORY) || !s.hasOption(Service.ServiceOption.REPLICATION) || !nodeSelectorPath.equals(serviceSelectorPath = s.getPeerNodeSelectorPath())) continue;
            Operation maintOp = Operation.createPost(s.getUri()).setCompletion((o, e) -> {
                this.synchronizationActiveServices.remove(link);
                if (e != null) {
                    this.host.log(Level.WARNING, "Node group change maintenance failed for %s: %s", s.getSelfLink(), e.getMessage());
                }
                this.host.log(Level.FINE, "Synch done for selector %s, service %s", nodeSelectorPath, s.getSelfLink());
            });
            this.synchronizationRequiredServices.put(link, now);
            this.synchronizationActiveServices.put(link, now);
            ServiceMaintenanceRequest body = ServiceMaintenanceRequest.create();
            body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE);
            body.nodeGroupState = ngs;
            maintOp.setBodyNoCloning(body);
            long n = now;
            this.host.run(() -> {
                OperationContext.setAuthorizationContext(this.host.getSystemAuthorizationContext());
                this.host.log(Level.FINE, " Synchronizing %s (last:%d, sl: %d now:%d)", link, lastSynchTime, selectorSynchTime, n);
                s.adjustStat("maintenanceForNodeGroupChangeCount", 1.0);
                s.handleMaintenance(maintOp);
            });
        }
    }

    public void close() {
        this.synchronizationTimes.clear();
        this.synchronizationRequiredServices.clear();
        this.synchronizationActiveServices.clear();
        this.pendingNodeSelectorsForFactorySynch.clear();
    }
}

