/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ODataToken;
import com.vmware.xenon.common.ODataTokenList;
import com.vmware.xenon.common.ODataTokenizer;
import com.vmware.xenon.services.common.QueryTask;
import java.util.Collections;
import java.util.Set;

public class ODataQueryVisitor {
    private static final String DEFAULT_COLLECTION_ITEM_SEPARATOR = ";";
    private static final IllegalArgumentException LeftRightTypeException = new IllegalArgumentException("left and right side type mismatch");
    private Set<String> wildcardUnfoldPropertyNames;

    public ODataQueryVisitor() {
        this(Collections.emptySet());
    }

    public ODataQueryVisitor(Set<String> wildcardUnfoldPropertyNames) {
        this.wildcardUnfoldPropertyNames = wildcardUnfoldPropertyNames;
    }

    public QueryTask.Query toQuery(String filterExp) {
        ODataTokenizer tokenizer = new ODataTokenizer(filterExp);
        tokenizer.tokenize();
        if (tokenizer.tokens.hasTokens()) {
            return this.walkTokens(tokenizer.tokens, null);
        }
        return null;
    }

    public QueryTask.Query walkTokens(ODataTokenList tokens, QueryTask.Query left) {
        if (!tokens.hasNext()) {
            return null;
        }
        if (tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.OPENPAREN)) {
            tokens.skip();
            left = this.walkTokens(tokens, left);
        }
        if (tokens.hasNext() && tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.SIMPLE_TYPE)) {
            left = this.parseUnaryTerm(tokens);
        }
        if (tokens.hasNext() && tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.CLOSEPAREN)) {
            tokens.skip();
            return left;
        }
        if (tokens.hasNext() && tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.BINARY_OPERATOR)) {
            left = this.visitBinaryOperator(left, this.stringToVerb(tokens.next().getUriLiteral()), this.walkTokens(tokens, null));
        }
        if (tokens.hasNext()) {
            left = this.walkTokens(tokens, left);
        }
        return left;
    }

    public QueryTask.Query parseUnaryTerm(ODataTokenList tokens) throws IllegalArgumentException {
        if (!tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.SIMPLE_TYPE)) {
            throw new IllegalArgumentException("Term mismatch");
        }
        ODataToken left = tokens.next();
        if (!tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.BINARY_COMPARISON)) {
            throw new IllegalArgumentException("Term mismatch");
        }
        ODataToken verb = tokens.next();
        if (!tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.SIMPLE_TYPE)) {
            throw new IllegalArgumentException("Term mismatch");
        }
        ODataToken right = tokens.next();
        return this.visitBinaryComparator(left.getUriLiteral(), this.stringToVerb(verb.getUriLiteral()), right.getUriLiteral());
    }

    private QueryTask.Query visitBinaryComparator(Object leftSide, BinaryVerb operator, Object rightSide) {
        QueryTask.Query q = new QueryTask.Query();
        q.occurance = ODataQueryVisitor.convertToLuceneOccur(operator);
        if (rightSide instanceof QueryTask.Query) {
            throw LeftRightTypeException;
        }
        if (ODataQueryVisitor.isUnfoldQuery(leftSide, operator, rightSide)) {
            for (String name : this.wildcardUnfoldPropertyNames) {
                QueryTask.Query innerQuery = this.visitBinaryComparator(name, operator, rightSide);
                innerQuery.occurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                q.addBooleanClause(innerQuery);
            }
            return q;
        }
        if (rightSide instanceof String) {
            if (operator == BinaryVerb.ANY || operator == BinaryVerb.ALL) {
                String[] itemNames;
                QueryTask.Query.Occurance itemOccurance = QueryTask.Query.Occurance.MUST_OCCUR;
                if (operator == BinaryVerb.ANY) {
                    itemOccurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                }
                for (String itemName : itemNames = ((String)rightSide).split(DEFAULT_COLLECTION_ITEM_SEPARATOR)) {
                    if (itemName.isEmpty()) continue;
                    QueryTask.Query itemClause = new QueryTask.Query();
                    itemClause.setTermPropertyName((String)leftSide);
                    itemClause.occurance = itemOccurance;
                    itemClause.setTermMatchValue(itemName.replace("'", "").trim());
                    if (itemName.contains("*")) {
                        itemClause.setTermMatchType(QueryTask.QueryTerm.MatchType.WILDCARD);
                    }
                    q.addBooleanClause(itemClause);
                }
            } else {
                q.setTermPropertyName((String)leftSide);
                if (((String)leftSide).contains("*")) {
                    q.setTermMatchType(QueryTask.QueryTerm.MatchType.WILDCARD);
                }
                if (ODataQueryVisitor.isNumeric((String)rightSide)) {
                    QueryTask.NumericRange<?> r = this.createRange(rightSide.toString(), operator);
                    q.setNumericRange(r);
                } else {
                    q.setTermMatchValue(((String)rightSide).replace("'", ""));
                    if (((String)rightSide).contains("*")) {
                        q.setTermMatchType(QueryTask.QueryTerm.MatchType.WILDCARD);
                    }
                }
            }
        } else {
            throw LeftRightTypeException;
        }
        return q;
    }

    private QueryTask.Query visitBinaryOperator(QueryTask.Query leftSide, BinaryVerb operator, QueryTask.Query rightSide) {
        QueryTask.Query q = new QueryTask.Query();
        switch (operator) {
            case AND: {
                if (leftSide.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR) {
                    leftSide.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
                }
                if (rightSide.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR) {
                    rightSide.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
                }
                if (leftSide.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR || rightSide.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR) break;
                q.occurance = QueryTask.Query.Occurance.MUST_NOT_OCCUR;
                leftSide.occurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                rightSide.occurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                break;
            }
            case OR: {
                if (leftSide.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR) {
                    leftSide.occurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                }
                if (rightSide.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR) {
                    rightSide.occurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                }
                if (leftSide.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR || rightSide.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR) break;
                q.occurance = QueryTask.Query.Occurance.MUST_NOT_OCCUR;
                leftSide.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
                rightSide.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
                break;
            }
        }
        q.addBooleanClause(leftSide);
        q.addBooleanClause(rightSide);
        return q;
    }

    private static QueryTask.Query.Occurance convertToLuceneOccur(BinaryVerb binaryOp) {
        if (binaryOp == null) {
            return QueryTask.Query.Occurance.MUST_OCCUR;
        }
        switch (binaryOp) {
            case OR: {
                return QueryTask.Query.Occurance.SHOULD_OCCUR;
            }
            case NE: {
                return QueryTask.Query.Occurance.MUST_NOT_OCCUR;
            }
            case AND: 
            case EQ: 
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case ANY: 
            case ALL: {
                return QueryTask.Query.Occurance.MUST_OCCUR;
            }
        }
        throw new IllegalArgumentException("unsupported operation");
    }

    private static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private QueryTask.NumericRange<?> createRange(String num, BinaryVerb op) {
        Number d = null;
        d = num.contains(".") ? (Number)Double.parseDouble(num) : (Number)Long.parseLong(num);
        if (op.equals((Object)BinaryVerb.LT)) {
            return QueryTask.NumericRange.createLessThanRange(d);
        }
        if (op.equals((Object)BinaryVerb.LE)) {
            return QueryTask.NumericRange.createLessThanOrEqualRange(d);
        }
        if (op.equals((Object)BinaryVerb.GT)) {
            return QueryTask.NumericRange.createGreaterThanRange(d);
        }
        if (op.equals((Object)BinaryVerb.GE)) {
            return QueryTask.NumericRange.createGreaterThanOrEqualRange(d);
        }
        if (op.equals((Object)BinaryVerb.EQ)) {
            return QueryTask.NumericRange.createEqualRange(d);
        }
        return null;
    }

    private BinaryVerb stringToVerb(String s) {
        for (BinaryVerb v : BinaryVerb.values()) {
            if (!v.equals(s)) continue;
            return v;
        }
        return null;
    }

    private static boolean isUnfoldQuery(Object leftSide, BinaryVerb operator, Object rightSide) {
        return "ALL_FIELDS".equals(leftSide) && BinaryVerb.EQ.equals((Object)operator) && rightSide instanceof String && !ODataQueryVisitor.isNumeric((String)rightSide);
    }

    public static enum BinaryVerb {
        AND("and"),
        OR("or"),
        EQ("eq"),
        NE("ne"),
        LT("lt"),
        LE("le"),
        GT("gt"),
        GE("ge"),
        ALL("all"),
        ANY("any"),
        ADD("add"),
        SUB("sub"),
        MUL("mul"),
        DIV("div"),
        MODULO("mod");

        private String operator;

        private BinaryVerb(String op) {
            this.operator = op;
        }

        public boolean equals(String str) {
            return this.operator.equals(str);
        }
    }
}

