/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common.authn;

import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.AuthCredentialsService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.UserService;
import com.vmware.xenon.services.common.authn.AuthenticationRequest;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.concurrent.TimeUnit;

public class BasicAuthenticationService
extends StatelessService {
    public static String SELF_LINK = ServiceUriPaths.CORE_AUTHN_BASIC;
    public static final String WWW_AUTHENTICATE_HEADER_NAME = "WWW-Authenticate";
    public static final String WWW_AUTHENTICATE_HEADER_VALUE = "Basic realm=\"xenon\"";
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String BASIC_AUTH_NAME = "Basic";
    private static final String BASIC_AUTH_SEPERATOR = " ";
    private static final String BASIC_AUTH_USER_SEPERATOR = ":";

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handlePost(Operation op) {
        AuthenticationRequest.AuthenticationRequestType requestType = op.getBody(AuthenticationRequest.class).requestType;
        if (requestType == null) {
            requestType = AuthenticationRequest.AuthenticationRequestType.LOGIN;
        }
        switch (requestType) {
            case LOGIN: {
                this.handleLogin(op);
                break;
            }
            case LOGOUT: {
                this.handleLogout(op);
                break;
            }
        }
    }

    private void handleLogout(Operation op) {
        if (op.getAuthorizationContext() == null) {
            op.complete();
            return;
        }
        String userLink = op.getAuthorizationContext().getClaims().getSubject();
        if (!this.associateAuthorizationContext(op, userLink, 0L)) {
            op.setStatusCode(500).complete();
            return;
        }
        op.complete();
    }

    private void handleLogin(Operation op) {
        String authString;
        String authHeader = op.getRequestHeader(AUTHORIZATION_HEADER_NAME);
        if (authHeader == null) {
            op.addResponseHeader(WWW_AUTHENTICATE_HEADER_NAME, WWW_AUTHENTICATE_HEADER_VALUE);
            op.fail(401);
            return;
        }
        String[] authHeaderParts = authHeader.split(BASIC_AUTH_SEPERATOR);
        if (authHeaderParts.length != 2 || !authHeaderParts[0].equalsIgnoreCase(BASIC_AUTH_NAME)) {
            op.fail(400);
            return;
        }
        try {
            authString = new String(Base64.getDecoder().decode(authHeaderParts[1]), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logWarning("Exception decoding auth header: %s", Utils.toString(e));
            op.setStatusCode(400).complete();
            return;
        }
        String[] userNameAndPassword = authString.split(BASIC_AUTH_USER_SEPERATOR);
        if (userNameAndPassword.length != 2) {
            op.fail(400);
            return;
        }
        this.queryUserService(op, userNameAndPassword[0], userNameAndPassword[1]);
    }

    private void queryUserService(Operation parentOp, String userName, String password) {
        QueryTask q = new QueryTask();
        q.querySpec = new QueryTask.QuerySpecification();
        String kind = Utils.buildKind(UserService.UserState.class);
        QueryTask.Query kindClause = new QueryTask.Query().setTermPropertyName("documentKind").setTermMatchValue(kind);
        q.querySpec.query.addBooleanClause(kindClause);
        QueryTask.Query emailClause = new QueryTask.Query().setTermPropertyName("email").setTermMatchValue(userName);
        emailClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        q.querySpec.query.addBooleanClause(emailClause);
        q.taskInfo.isDirect = true;
        Operation.CompletionHandler userServiceCompletion = (o, ex) -> {
            if (ex != null) {
                this.logWarning("Exception validating user: %s", Utils.toString(ex));
                parentOp.setBodyNoCloning(o.getBodyRaw()).fail(o.getStatusCode());
                return;
            }
            QueryTask rsp = o.getBody(QueryTask.class);
            if (rsp.results.documentLinks.isEmpty()) {
                parentOp.fail(403);
                return;
            }
            String userLink = rsp.results.documentLinks.get(0);
            this.queryAuthStore(parentOp, userLink, userName, password);
        };
        Operation queryOp = Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(q).setCompletion(userServiceCompletion);
        this.setAuthorizationContext(queryOp, this.getSystemAuthorizationContext());
        this.sendRequest(queryOp);
    }

    private void queryAuthStore(Operation parentOp, String userLink, String userName, String password) {
        QueryTask authQuery = new QueryTask();
        authQuery.querySpec = new QueryTask.QuerySpecification();
        String authKind = Utils.buildKind(AuthCredentialsService.AuthCredentialsServiceState.class);
        QueryTask.Query authKindClause = new QueryTask.Query().setTermPropertyName("documentKind").setTermMatchValue(authKind);
        authQuery.querySpec.query.addBooleanClause(authKindClause);
        QueryTask.Query authEmailClause = new QueryTask.Query().setTermPropertyName("userEmail").setTermMatchValue(userName);
        authEmailClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        authQuery.querySpec.query.addBooleanClause(authEmailClause);
        QueryTask.Query authCredentialsClause = new QueryTask.Query().setTermPropertyName("privateKey").setTermMatchValue(password);
        authCredentialsClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        authQuery.querySpec.query.addBooleanClause(authCredentialsClause);
        authQuery.taskInfo.isDirect = true;
        Operation.CompletionHandler authCompletionHandler = (authOp, authEx) -> {
            if (authEx != null) {
                this.logWarning("Exception validating user credentials: %s", Utils.toString(authEx));
                parentOp.setBodyNoCloning(authOp.getBodyRaw()).fail(500);
                return;
            }
            QueryTask authRsp = authOp.getBody(QueryTask.class);
            if (authRsp.results.documentLinks.isEmpty()) {
                parentOp.fail(403);
                return;
            }
            if (!this.associateAuthorizationContext(parentOp, userLink, Utils.getNowMicrosUtc() + TimeUnit.HOURS.toMicros(1L))) {
                parentOp.fail(500);
                return;
            }
            parentOp.complete();
        };
        Operation queryAuth = Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(authQuery).setCompletion(authCompletionHandler);
        this.setAuthorizationContext(queryAuth, this.getSystemAuthorizationContext());
        this.sendRequest(queryAuth);
    }

    private boolean associateAuthorizationContext(Operation op, String userLink, long expirationTime) {
        String token;
        Claims.Builder builder = new Claims.Builder();
        builder.setIssuer("xn");
        builder.setSubject(userLink);
        builder.setExpirationTime(expirationTime);
        Claims claims = (Claims)builder.getResult();
        try {
            token = this.getTokenSigner().sign(claims);
        }
        catch (Exception e) {
            this.logSevere(e);
            return false;
        }
        Operation.AuthorizationContext.Builder ab = Operation.AuthorizationContext.Builder.create();
        ab.setClaims(claims);
        ab.setToken(token);
        ab.setPropagateToClient(true);
        this.setAuthorizationContext(op, ab.getResult());
        return true;
    }
}

