/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.util.Set;

public class UserService
extends StatefulService {
    public static final String FACTORY_LINK = ServiceUriPaths.CORE_AUTHZ_USERS;

    public static Service createFactory() {
        return FactoryService.createIdempotent(UserService.class);
    }

    public UserService() {
        super(UserState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserState state = op.getBody(UserState.class);
        if (!this.validate(op, state)) {
            return;
        }
        op.complete();
    }

    @Override
    public void handlePut(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserState newState = op.getBody(UserState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        UserState currentState = (UserState)this.getState(op);
        if (currentState.email.equals(newState.email) && (currentState.userGroupLinks == null && newState.userGroupLinks == null || currentState.userGroupLinks != null && newState.userGroupLinks != null && currentState.userGroupLinks.equals(newState.userGroupLinks))) {
            op.setStatusCode(304);
        } else {
            this.setState(op, newState);
        }
        op.complete();
    }

    @Override
    public void handlePatch(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserState currentState = (UserState)this.getState(op);
        UserState newState = op.getBody(UserState.class);
        if (newState.email != null) {
            currentState.email = newState.email;
        }
        if (newState.userGroupLinks != null) {
            if (currentState.userGroupLinks == null) {
                currentState.userGroupLinks = newState.userGroupLinks;
            } else {
                currentState.userGroupLinks.addAll(newState.userGroupLinks);
            }
        }
        op.setBody(currentState);
        op.complete();
    }

    private boolean validate(Operation op, UserState state) {
        if (state.email == null) {
            op.fail(new IllegalArgumentException("email is required"));
            return false;
        }
        int firstAtIndex = state.email.indexOf(64);
        int lastAtIndex = state.email.lastIndexOf(64);
        if (firstAtIndex == -1 || firstAtIndex != lastAtIndex) {
            op.fail(new IllegalArgumentException("email is invalid"));
            return false;
        }
        return true;
    }

    public static class UserState
    extends ServiceDocument {
        public static final String FIELD_NAME_EMAIL = "email";
        public static final String FIELD_NAME_USER_GROUP_LINKS = "userGroupLinks";
        public String email;
        public Set<String> userGroupLinks;
    }
}

