/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.TransactionResolutionService;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class TransactionService
extends StatefulService {
    public TransactionService() {
        super(TransactionServiceState.class);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation start) {
        TransactionServiceState s = start.getBody(TransactionServiceState.class);
        s.taskSubStage = s.taskSubStage == null ? SubStage.COLLECTING : s.taskSubStage;
        s.options = s.options == null ? new Options() : s.options;
        s.servicesToCoordinators = s.servicesToCoordinators == null ? new LinkedHashMap<String, Set<String>>() : s.servicesToCoordinators;
        s.readLinks = s.readLinks == null ? new HashSet() : s.readLinks;
        s.modifiedLinks = s.modifiedLinks == null ? new HashSet() : s.modifiedLinks;
        s.createdLinks = s.createdLinks == null ? new HashSet() : s.createdLinks;
        s.deletedLinks = s.deletedLinks == null ? new HashSet() : s.deletedLinks;
        s.dependentLinks = s.dependentLinks == null ? new HashSet() : s.dependentLinks;
        s.failedLinks = new HashSet<String>();
        this.setState(start, s);
        this.allocateResolutionService(start);
    }

    private void allocateResolutionService(Operation op) {
        Operation startResolutionService = Operation.createPost(UriUtils.extendUri(this.getUri(), "/resolve")).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.complete();
        });
        this.getHost().startService(startResolutionService, new TransactionResolutionService(this));
    }

    @Override
    public void handlePut(Operation put) {
        if (!put.hasBody()) {
            put.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        Operation.TransactionContext record = put.getBody(Operation.TransactionContext.class);
        TransactionServiceState existing = (TransactionServiceState)this.getState(put);
        if (record.action == Service.Action.GET) {
            existing.readLinks.add(put.getReferer().getPath());
        } else {
            existing.modifiedLinks.add(put.getReferer().getPath());
        }
        if (record.action == Service.Action.POST) {
            existing.createdLinks.add(put.getReferer().getPath());
        }
        if (record.action == Service.Action.DELETE) {
            existing.deletedLinks.add(put.getReferer().getPath());
        }
        if (record.coordinatorLinks != null) {
            existing.servicesToCoordinators.put(put.getReferer().getPath(), record.coordinatorLinks);
        }
        if (!record.isSuccessful) {
            if (existing.failedLinks == null) {
                existing.failedLinks = new HashSet<String>();
            }
            existing.failedLinks.add(put.getReferer().getPath());
        }
        ++existing.pendingOperationCount;
        this.setState(put, existing);
        put.complete();
        if (existing.taskSubStage == SubStage.RESOLVING && existing.pendingOperationCount == existing.expectedOperationCount) {
            this.selfPatch(ResolutionKind.COMMIT, existing.expectedOperationCount);
        }
    }

    @Override
    public void handlePatch(Operation patch) {
        if (!patch.hasBody()) {
            patch.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        if (patch.getRequestHeader("x-xenon-tx-phase") != null) {
            if (patch.getRequestHeader("x-xenon-tx-phase").equals("try-commit")) {
                this.handleTryCommit(patch);
            } else if (patch.getRequestHeader("x-xenon-tx-phase").equals("ensure-commit")) {
                this.handleEnsureCommit(patch);
            }
            return;
        }
        TransactionServiceState currentState = (TransactionServiceState)this.getState(patch);
        AddDependentCoordinatorRequest addDependentCoordinatorRequest = patch.getBody(AddDependentCoordinatorRequest.class);
        if (addDependentCoordinatorRequest.kind == AddDependentCoordinatorRequest.KIND) {
            currentState.dependentLinks.add(addDependentCoordinatorRequest.coordinatorLink);
            patch.complete();
            return;
        }
        ResolutionRequest resolution = patch.getBody(ResolutionRequest.class);
        if (resolution.kind != ResolutionRequest.KIND) {
            patch.fail(new IllegalArgumentException("Unrecognized request kind: " + resolution.kind));
            return;
        }
        if (resolution.resolutionKind == ResolutionKind.ABORT) {
            if (currentState.taskSubStage == SubStage.COMMITTED) {
                patch.fail(new IllegalStateException("Already committed"));
                return;
            }
            if (currentState.taskSubStage == SubStage.ABORTING || currentState.taskSubStage == SubStage.ABORTED) {
                this.logInfo("Alreading in sub-stage %s. Completing request.", new Object[]{currentState.taskSubStage});
                patch.complete();
                return;
            }
            this.updateStage(patch, SubStage.ABORTING);
            patch.complete();
            this.handleAbort(currentState);
        } else if (resolution.resolutionKind == ResolutionKind.COMMIT) {
            if (currentState.taskSubStage == SubStage.ABORTED || currentState.taskSubStage == SubStage.ABORTING) {
                patch.fail(new IllegalStateException("Already aborted"));
                return;
            }
            if (currentState.taskSubStage == SubStage.COMMITTED) {
                this.logInfo("Alreading in sub-stage %s. Completing request.", new Object[]{currentState.taskSubStage});
                patch.complete();
                return;
            }
            currentState.expectedOperationCount = resolution.pendingOperations;
            this.updateStage(patch, SubStage.RESOLVING);
            patch.complete();
            this.handleCommitIfAllPendingOperationsReceived(currentState);
        } else if (resolution.resolutionKind == ResolutionKind.COMMITTED) {
            this.updateStage(patch, SubStage.COMMITTED);
            patch.complete();
        } else if (resolution.resolutionKind == ResolutionKind.ABORTED) {
            this.updateStage(patch, SubStage.ABORTED);
            patch.complete();
        } else {
            patch.fail(new IllegalArgumentException("Unrecognized resolution kind: " + (Object)((Object)resolution.resolutionKind)));
        }
    }

    private void handleCommitIfAllPendingOperationsReceived(TransactionServiceState currentState) {
        if (currentState.pendingOperationCount == currentState.expectedOperationCount) {
            this.logInfo("All operations have been received, proceeding with commit", new Object[0]);
            this.handleCommit(currentState);
            return;
        }
        if (currentState.pendingOperationCount > currentState.expectedOperationCount) {
            String errorMsg = String.format("Illegal commit request: client provided pending operations %d is less than already received %d", currentState.expectedOperationCount, currentState.pendingOperationCount);
            this.logWarning(errorMsg, new Object[0]);
            this.selfPatch(ResolutionKind.ABORT);
            return;
        }
        this.logInfo("Suspending transaction until all operations have been received", new Object[0]);
    }

    private void handleCommit(TransactionServiceState existing) {
        if (existing.options.allowErrorsCauseAbort && !existing.failedLinks.isEmpty()) {
            this.logWarning("Failed to commit: some transactional operations have failed. Aborting.", new Object[0]);
            this.selfPatch(ResolutionKind.ABORT);
            return;
        }
        this.tryPrecede(existing);
    }

    private void updateStage(Operation op, SubStage stage) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        existing.taskSubStage = stage;
        this.setState(op, existing);
    }

    private void selfPatch(ResolutionKind resolution) {
        this.selfPatch(resolution, 0);
    }

    private void selfPatch(ResolutionKind resolution, int pendingOperations) {
        ResolutionRequest resolve = new ResolutionRequest();
        resolve.resolutionKind = resolution;
        resolve.pendingOperations = pendingOperations;
        Operation operation = Operation.createPatch(this.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Failure self patching: %s", e.getMessage());
            }
        }).setBody(resolve);
        this.sendRequest(operation);
    }

    private void selfPatch(String coordinator) {
        AddDependentCoordinatorRequest body = new AddDependentCoordinatorRequest();
        body.coordinatorLink = coordinator;
        Operation operation = Operation.createPatch(this.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Failure self patching: %s", e.getMessage());
            }
        }).setBody(body);
        this.sendRequest(operation);
    }

    private void handleAbort(TransactionServiceState existing) {
        OperationJoin.create(this.createNotifyServicesToAbort(existing)).setCompletion((operations, failures) -> {
            if (failures != null) {
                this.logWarning("Transaction failed to notify some services to abort: %s", failures.toString());
            }
            this.selfPatch(ResolutionKind.ABORTED);
        }).sendWith(this);
    }

    private void handleTryCommit(Operation op) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        TransactionServiceState exchangeState = new TransactionServiceState();
        if (existing.taskSubStage == SubStage.COMMITTED) {
            exchangeState.taskSubStage = SubStage.COMMITTED;
            op.setBodyNoCloning(exchangeState);
            op.complete();
            return;
        }
        for (Set<String> serviceSet : existing.servicesToCoordinators.values()) {
            if (!serviceSet.contains(op.getReferer().getPath())) continue;
            exchangeState.taskSubStage = SubStage.RESOLVING_CIRCULAR;
            if (this.compareTo(op.getReferer().getPath())) continue;
            this.selfPatch(ResolutionKind.ABORT);
        }
        op.setBodyNoCloning(exchangeState);
        op.complete();
    }

    private void handleEnsureCommit(Operation op) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        TransactionServiceState exchangeState = new TransactionServiceState();
        exchangeState.taskSubStage = existing.taskSubStage;
        existing.dependentLinks.add(op.getReferer().getPath());
        op.setBodyNoCloning(exchangeState);
        op.complete();
    }

    private void tryPrecede(TransactionServiceState state) {
        HashSet<String> cache = new HashSet<String>();
        HashSet<Operation> operations = new HashSet<Operation>();
        boolean[] continueWithCommit = new boolean[]{true};
        for (String service : state.readLinks) {
            if (!state.servicesToCoordinators.containsKey(service)) continue;
            for (String coordinator : state.servicesToCoordinators.get(service)) {
                if (cache.contains(coordinator) || coordinator.equals(this.getSelfLink())) continue;
                cache.add(coordinator);
                operations.add(this.createNotifyOp(coordinator, "try-commit", (o, e) -> {
                    if (e == null) {
                        TransactionServiceState exchangeState = o.getBody(TransactionServiceState.class);
                        SubStage s = exchangeState.taskSubStage;
                        if (s == SubStage.COMMITTED) {
                            this.selfPatch(coordinator);
                        } else if (s == SubStage.RESOLVING_CIRCULAR && !this.compareTo(coordinator)) {
                            continueWithCommit[0] = false;
                            this.selfPatch(ResolutionKind.ABORT);
                        }
                    }
                }));
            }
        }
        if (operations.isEmpty()) {
            this.ensurePrecede(state);
            return;
        }
        OperationJoin.create(operations).setCompletion((ops, failures) -> {
            if (failures != null) {
                this.logWarning("Failed to commit: %s. Aborting.", failures);
                this.selfPatch(ResolutionKind.ABORT);
                return;
            }
            if (continueWithCommit[0]) {
                this.ensurePrecede(state);
            }
        }).sendWith(this.getHost());
    }

    private void ensurePrecede(TransactionServiceState state) {
        HashSet<String> cache = new HashSet<String>();
        HashSet<Operation> operations = new HashSet<Operation>();
        boolean[] continueWithCommit = new boolean[]{true};
        for (String service : state.modifiedLinks) {
            if (!state.servicesToCoordinators.containsKey(service)) continue;
            for (String coordinator : state.servicesToCoordinators.get(service)) {
                if (cache.contains(coordinator) || coordinator.equals(this.getSelfLink())) continue;
                cache.add(coordinator);
                operations.add(this.createNotifyOp(coordinator, "ensure-commit", (o, e) -> {
                    if (e == null) {
                        TransactionServiceState exchangeState = o.getBody(TransactionServiceState.class);
                        SubStage s = exchangeState.taskSubStage;
                        if (s == SubStage.COMMITTED) {
                            continueWithCommit[0] = false;
                            this.selfPatch(ResolutionKind.ABORT);
                        }
                    }
                }));
            }
        }
        if (operations.isEmpty()) {
            this.notifyServicesToCommit(state);
            return;
        }
        OperationJoin.create(operations).setCompletion((ops, failures) -> {
            if (failures != null) {
                this.logWarning("Failed to commit: %s. Aborting.", failures);
                this.selfPatch(ResolutionKind.ABORT);
                return;
            }
            if (continueWithCommit[0]) {
                this.notifyServicesToCommit(state);
            }
        }).sendWith(this.getHost());
    }

    private boolean compareTo(String remote) {
        return this.getSelfLink().compareTo(remote) < 0;
    }

    private Collection<Operation> createNotifyServicesToAbort(TransactionServiceState state) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (String service : state.createdLinks) {
            operations.add(this.createDeleteOp(service));
            state.readLinks.remove(service);
            state.modifiedLinks.remove(service);
        }
        for (String service : state.readLinks) {
            operations.add(this.createNotifyOp(service, "abort"));
        }
        for (String service : state.modifiedLinks) {
            operations.add(this.createNotifyOp(service, "abort"));
        }
        return operations;
    }

    private void notifyServicesToCommit(TransactionServiceState state) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (String service2 : state.deletedLinks) {
            operations.add(this.createDeleteOp(service2));
            state.readLinks.remove(service2);
            state.modifiedLinks.remove(service2);
        }
        operations.addAll(state.readLinks.stream().map(service -> this.createNotifyOp((String)service, "commit")).collect(Collectors.toSet()));
        operations.addAll(state.modifiedLinks.stream().map(service -> this.createNotifyOp((String)service, "commit")).collect(Collectors.toSet()));
        if (operations.isEmpty()) {
            this.selfPatch(ResolutionKind.COMMITTED);
            return;
        }
        OperationJoin.create(operations).setCompletion((ops, failures) -> {
            if (failures != null) {
                this.logWarning("Failed to commit: %s. Aborting.", failures);
                this.selfPatch(ResolutionKind.ABORT);
                return;
            }
            this.selfPatch(ResolutionKind.COMMITTED);
        }).sendWith(this.getHost());
    }

    private Operation createNotifyOp(String service, String header) {
        return Operation.createPatch(this, service).addRequestHeader("x-xenon-tx-phase", header).setBody(new TransactionServiceState()).setReferer(this.getUri());
    }

    private Operation createDeleteOp(String service) {
        return Operation.createDelete(this, service).setReferer(this.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Deletion of service %s failed: %s", service, e);
            } else {
                this.logInfo("Deletion of service %s succeeded", service);
            }
        });
    }

    private Operation createNotifyOp(String coordinator, String header, Operation.CompletionHandler callback) {
        return Operation.createPatch(this, coordinator).addRequestHeader("x-xenon-tx-phase", header).setBody(new TransactionServiceState()).setReferer(this.getUri()).setCompletion(callback);
    }

    public static class TransactionServiceState
    extends ServiceDocument {
        public Set<String> readLinks;
        public Set<String> modifiedLinks;
        public Set<String> createdLinks;
        public Set<String> deletedLinks;
        public LinkedHashMap<String, Set<String>> servicesToCoordinators;
        public TaskState taskInfo = new TaskState();
        public SubStage taskSubStage;
        public Set<String> dependentLinks;
        public Options options;
        public Set<String> failedLinks;
        public int pendingOperationCount;
        public int expectedOperationCount;
    }

    public static class AddDependentCoordinatorRequest {
        public static final String KIND = Utils.buildKind(AddDependentCoordinatorRequest.class);
        public String kind = KIND;
        public String coordinatorLink;
    }

    public static class ResolutionRequest {
        public static final String KIND = Utils.buildKind(ResolutionRequest.class);
        public String kind = KIND;
        public ResolutionKind resolutionKind;
        public int pendingOperations;
    }

    public static class Options {
        public boolean allowErrorsCauseAbort = true;
    }

    public static enum ResolutionKind {
        COMMIT,
        ABORT,
        COMMITTED,
        ABORTED;

    }

    public static enum SubStage {
        COLLECTING,
        RESOLVING,
        RESOLVING_CIRCULAR,
        ABORTING,
        COMMITTED,
        ABORTED;

    }
}

