/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.services.common.QueryTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class QueryFilter {
    public static final QueryFilter TRUE = new QueryFilter(StaticEvaluator.TRUE);
    public static final QueryFilter FALSE = new QueryFilter(StaticEvaluator.FALSE);
    private final Evaluator evaluator;

    public static QueryFilter create(QueryTask.Query q) throws QueryFilterException {
        List<Conjunction> dnf = QueryFilter.createDisjunctiveNormalForm(q);
        Evaluator ev = DisjunctionEvaluator.create(dnf);
        return new QueryFilter(ev);
    }

    private QueryFilter(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public boolean evaluate(ServiceDocument document, ServiceDocumentDescription description) {
        return this.evaluator.evaluate(document, description);
    }

    static List<Conjunction> createDisjunctiveNormalForm(QueryTask.Query q) {
        ArrayList<Conjunction> prefixes = new ArrayList<Conjunction>();
        QueryFilter.createDisjunctiveNormalForm(q, prefixes, false);
        return prefixes;
    }

    static void createDisjunctiveNormalForm(QueryTask.Query q, ArrayList<Conjunction> prefixes, boolean negate) {
        if (q.term != null) {
            Term t = new Term(q.term, negate);
            if (prefixes.isEmpty()) {
                prefixes.add(new Conjunction(null, t));
            } else {
                for (int i = 0; i < prefixes.size(); ++i) {
                    prefixes.set(i, new Conjunction(prefixes.get(i), t));
                }
            }
            return;
        }
        int shouldClauses = 0;
        block6: for (QueryTask.Query clause : q.booleanClauses) {
            QueryTask.Query.Occurance o = clause.occurance;
            if (o == null) {
                o = QueryTask.Query.Occurance.MUST_OCCUR;
            }
            switch (o) {
                case MUST_OCCUR: {
                    QueryFilter.createDisjunctiveNormalForm(clause, prefixes, negate);
                    continue block6;
                }
                case MUST_NOT_OCCUR: {
                    QueryFilter.createDisjunctiveNormalForm(clause, prefixes, !negate);
                    continue block6;
                }
                case SHOULD_OCCUR: {
                    ++shouldClauses;
                    continue block6;
                }
            }
            throw new RuntimeException("Unknown occurance: " + o.toString());
        }
        if (shouldClauses == q.booleanClauses.size()) {
            ArrayList<Conjunction> originalPrefixes = new ArrayList<Conjunction>(prefixes);
            prefixes.clear();
            for (QueryTask.Query clause : q.booleanClauses) {
                ArrayList<Conjunction> clausePrefixes = new ArrayList<Conjunction>(originalPrefixes);
                QueryFilter.createDisjunctiveNormalForm(clause, clausePrefixes, negate);
                prefixes.addAll(clausePrefixes);
            }
        }
    }

    private static String findTopPropertyForDispatch(Collection<Conjunction> dnf) {
        class Elem {
            final String name;
            int count;

            Elem(String name) {
                this.name = name;
            }

            void add() {
                ++this.count;
            }
        }
        HashMap<String, Elem> elemByProperty = new HashMap<String, Elem>();
        for (Conjunction conjunction : dnf) {
            for (Term term : conjunction) {
                if (!QueryFilter.isTermEligibleForDispatch(term)) continue;
                Elem e = (Elem)elemByProperty.get(term.term.propertyName);
                if (e == null) {
                    e = new Elem(term.term.propertyName);
                    elemByProperty.put(term.term.propertyName, e);
                }
                e.add();
            }
        }
        if (elemByProperty.isEmpty()) {
            return null;
        }
        Elem[] elements = elemByProperty.values().toArray(new Elem[elemByProperty.size()]);
        class ElemComparator
        implements Comparator<Elem> {
            ElemComparator() {
            }

            @Override
            public int compare(Elem o1, Elem o2) {
                return o1.count - o2.count;
            }
        }
        Arrays.sort(elements, new ElemComparator());
        return elements[elements.length - 1].name;
    }

    private static boolean isTermNestedProperty(Term term) {
        return term.propertyParts.size() > 1;
    }

    private static boolean isTermEligibleForDispatch(Term term) {
        if (term.negate) {
            return false;
        }
        if (term.term.matchType != QueryTask.QueryTerm.MatchType.TERM) {
            return false;
        }
        return !QueryFilter.isTermNestedProperty(term);
    }

    static class DispatchEvaluator
    implements Evaluator {
        private final String propertyName;
        private final Map<String, Evaluator> table;

        private DispatchEvaluator(String propertyName, Map<String, Evaluator> table) {
            this.propertyName = propertyName;
            this.table = table;
        }

        @Override
        public boolean evaluate(ServiceDocument document, ServiceDocumentDescription description) {
            ServiceDocumentDescription.PropertyDescription pd = description.propertyDescriptions.get(this.propertyName);
            if (pd == null) {
                return false;
            }
            Object propValue = ReflectionUtils.getPropertyValue(pd, document);
            String matchAs = QueryTask.QuerySpecification.toMatchValue(propValue);
            if (matchAs == null) {
                return false;
            }
            Evaluator e = this.table.get(matchAs);
            if (e == null) {
                return false;
            }
            return e.evaluate(document, description);
        }

        static Evaluator create(String propertyName, Collection<Conjunction> dnf) throws QueryFilterException {
            ArrayList<Conjunction> unhandled = new ArrayList<Conjunction>();
            HashMap table = new HashMap();
            for (Conjunction conjunction : dnf) {
                boolean handled = false;
                for (Term term : conjunction) {
                    if (!QueryFilter.isTermEligibleForDispatch(term) || !term.term.propertyName.equals(propertyName)) continue;
                    ArrayList<Conjunction> entry = (ArrayList<Conjunction>)table.get(term.term.matchValue);
                    if (entry == null) {
                        entry = new ArrayList<Conjunction>();
                        table.put(term.term.matchValue, entry);
                    }
                    conjunction.skipTerm(term);
                    entry.add(conjunction);
                    handled = true;
                    break;
                }
                if (handled) continue;
                unhandled.add(conjunction);
            }
            HashMap<String, Evaluator> evaluatorTable = new HashMap<String, Evaluator>();
            for (Map.Entry e : table.entrySet()) {
                evaluatorTable.put((String)e.getKey(), DisjunctionEvaluator.create((Collection)e.getValue()));
            }
            dnf.clear();
            dnf.addAll(unhandled);
            return new DispatchEvaluator(propertyName, evaluatorTable);
        }
    }

    static class DisjunctionEvaluator
    implements Evaluator {
        private final Collection<Evaluator> evaluators;

        private DisjunctionEvaluator(Collection<Evaluator> evaluators) {
            this.evaluators = evaluators;
        }

        @Override
        public boolean evaluate(ServiceDocument document, ServiceDocumentDescription description) {
            for (Evaluator e : this.evaluators) {
                if (!e.evaluate(document, description)) continue;
                return true;
            }
            return false;
        }

        static Evaluator create(Collection<Conjunction> dnf) throws QueryFilterException {
            String key;
            ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
            while (!dnf.isEmpty() && (key = QueryFilter.findTopPropertyForDispatch(dnf)) != null) {
                Evaluator e = DispatchEvaluator.create(key, dnf);
                evaluators.add(e);
            }
            for (Conjunction conjunction : dnf) {
                evaluators.add(ConjunctionEvaluator.create(conjunction));
            }
            return new DisjunctionEvaluator(evaluators);
        }
    }

    static class ConjunctionEvaluator
    implements Evaluator {
        private final Collection<Term> terms;

        private ConjunctionEvaluator(Collection<Term> terms) {
            this.terms = terms;
        }

        @Override
        public boolean evaluate(ServiceDocument document, ServiceDocumentDescription description) {
            for (Term term : this.terms) {
                Object o;
                String propertyName = term.propertyParts.get(0);
                ServiceDocumentDescription.PropertyDescription pd = description.propertyDescriptions.get(propertyName);
                if (!(pd == null ? !term.negate : !this.evaluateTerm(term, o = ReflectionUtils.getPropertyValue(pd, document), pd, 1))) continue;
                return false;
            }
            return true;
        }

        private boolean evaluateString(Term term, String o) {
            if (term.term.matchType == QueryTask.QueryTerm.MatchType.WILDCARD) {
                return term.pattern.matcher(o).matches();
            }
            return o.equals(term.term.matchValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean evaluateTerm(Term term, Object o, ServiceDocumentDescription.PropertyDescription pd, int depth) {
            if (o == null) {
                return term.negate;
            }
            if (pd.typeName == ServiceDocumentDescription.TypeName.STRING) {
                if (!(o instanceof String)) {
                    return term.negate;
                }
                if (!(term.negate ? this.evaluateString(term, (String)o) : !this.evaluateString(term, (String)o))) return true;
                return false;
            }
            if (pd.typeName == ServiceDocumentDescription.TypeName.COLLECTION) {
                if (!(o instanceof Collection)) {
                    return term.negate;
                }
                if (depth >= term.propertyParts.size()) {
                    return term.negate;
                }
                String suffix = term.propertyParts.get(depth);
                if (!suffix.equals("item")) {
                    return false;
                }
                if (pd.elementDescription.typeName != ServiceDocumentDescription.TypeName.STRING) return false;
                Collection cs = (Collection)o;
                if (!(term.negate ? cs.contains(term.term.matchValue) : !cs.contains(term.term.matchValue))) return true;
                return false;
            }
            if (pd.typeName == ServiceDocumentDescription.TypeName.MAP) {
                if (!(o instanceof Map)) {
                    return term.negate;
                }
                if (depth >= term.propertyParts.size()) {
                    return term.negate;
                }
                Map map = (Map)o;
                String key = term.propertyParts.get(depth);
                Object value = map.get(key);
                return this.evaluateTerm(term, value, pd.elementDescription, depth + 1);
            }
            if (pd.typeName != ServiceDocumentDescription.TypeName.PODO) return false;
            if (depth >= term.propertyParts.size()) {
                return term.negate;
            }
            String propertyName = term.propertyParts.get(depth);
            ServiceDocumentDescription.PropertyDescription fd = pd.fieldDescriptions.get(propertyName);
            if (fd == null) {
                return term.negate;
            }
            Object value = ReflectionUtils.getPropertyValue(fd, o);
            return this.evaluateTerm(term, value, fd, depth + 1);
        }

        static Evaluator create(Conjunction conjunction) throws QueryFilterException {
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term term : conjunction) {
                if (term.term.matchType != QueryTask.QueryTerm.MatchType.TERM && term.term.matchType != QueryTask.QueryTerm.MatchType.WILDCARD) {
                    throw new UnsupportedMatchTypeException(term);
                }
                terms.add(term);
            }
            if (terms.isEmpty()) {
                return StaticEvaluator.TRUE;
            }
            return new ConjunctionEvaluator(terms);
        }
    }

    static class StaticEvaluator
    implements Evaluator {
        static final Evaluator TRUE = new StaticEvaluator(true);
        static final Evaluator FALSE = new StaticEvaluator(false);
        private boolean value;

        private StaticEvaluator(boolean value) {
            this.value = value;
        }

        @Override
        public boolean evaluate(ServiceDocument document, ServiceDocumentDescription description) {
            return this.value;
        }
    }

    static interface Evaluator {
        public boolean evaluate(ServiceDocument var1, ServiceDocumentDescription var2);
    }

    static class Conjunction
    implements Iterable<Term> {
        final Term[] terms;
        boolean[] skip = null;

        Conjunction(Conjunction original, Term term) {
            Term[] terms = original != null ? Arrays.copyOf(original.terms, original.terms.length + 1) : new Term[1];
            terms[terms.length - 1] = term;
            this.terms = terms;
        }

        void skipTerm(Term term) {
            if (this.skip == null) {
                this.skip = new boolean[this.terms.length];
            }
            for (int i = 0; i < this.terms.length; ++i) {
                if (this.skip[i] || this.terms[i] != term) continue;
                this.skip[i] = true;
                break;
            }
        }

        @Override
        public Iterator<Term> iterator() {
            if (this.skip == null) {
                return new TermIterator(this);
            }
            return new TermSkipIterator(this);
        }

        public String toString() {
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term t : this) {
                terms.add(t);
            }
            class TermByPropertyNameComparator
            implements Comparator<Term> {
                TermByPropertyNameComparator() {
                }

                @Override
                public int compare(Term o1, Term o2) {
                    return o1.term.propertyName.compareTo(o2.term.propertyName);
                }
            }
            terms.sort(new TermByPropertyNameComparator());
            StringBuilder sb = new StringBuilder();
            for (Term term : terms) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                if (term.negate) {
                    sb.append("NOT(");
                }
                sb.append(term.term.propertyName);
                sb.append("=");
                sb.append(term.term.matchValue);
                if (!term.negate) continue;
                sb.append(")");
            }
            return sb.toString();
        }

        private class TermSkipIterator
        extends TermIterator {
            public TermSkipIterator(Conjunction conjunction2) {
                super(conjunction2);
            }

            @Override
            public boolean hasNext() {
                while (this.i < this.conjunction.terms.length) {
                    if (!this.conjunction.skip[this.i]) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }
        }

        private class TermIterator
        implements Iterator<Term> {
            protected final Conjunction conjunction;
            protected int i = 0;

            public TermIterator(Conjunction conjunction2) {
                this.conjunction = conjunction2;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.conjunction.terms.length;
            }

            @Override
            public Term next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.conjunction.terms[this.i++];
            }
        }
    }

    static class Term {
        final QueryTask.QueryTerm term;
        final boolean negate;
        final Pattern pattern;
        final List<String> propertyParts;

        Term(QueryTask.QueryTerm term, boolean negate) {
            this.term = term;
            this.negate = negate;
            if (term.matchType == QueryTask.QueryTerm.MatchType.WILDCARD) {
                String normalize = term.matchValue.replace("*", ".*").replace("+", ".+");
                String regex = "^(" + normalize + ")$";
                this.pattern = Pattern.compile(regex);
            } else {
                this.pattern = null;
            }
            List<String> tmp = Arrays.asList(this.term.propertyName.split("\\."));
            this.propertyParts = Collections.unmodifiableList(tmp);
        }
    }

    public static class UnsupportedPropertyException
    extends QueryFilterException {
        private static final long serialVersionUID = -7761717288266048287L;
        private static final String FORMAT = "Unsupported property: %s";

        UnsupportedPropertyException(Term term) {
            super(String.format(FORMAT, term.term.propertyName));
        }
    }

    public static class UnsupportedMatchTypeException
    extends QueryFilterException {
        private static final long serialVersionUID = 4125723225019700727L;
        private static final String FORMAT = "Unsupported matchType: %s";

        UnsupportedMatchTypeException(Term term) {
            super(String.format(FORMAT, term.term.matchType.toString()));
        }
    }

    public static class QueryFilterException
    extends Exception {
        private static final long serialVersionUID = -1063270176637734896L;

        QueryFilterException(String message) {
            super(message);
        }
    }
}

