/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;

public class NodeSelectorReplicationService
extends StatelessService {
    private Service parent;

    public NodeSelectorReplicationService(Service parent) {
        this.parent = parent;
        super.setHost(parent.getHost());
        super.setSelfLink(UriUtils.buildUriPath(parent.getSelfLink(), "/replication"));
        super.setProcessingStage(Service.ProcessingStage.AVAILABLE);
    }

    void replicateUpdate(NodeGroupService.NodeGroupState localState, Operation outboundOp, NodeSelectorService.SelectAndForwardRequest req, NodeSelectorService.SelectOwnerResponse rsp) {
        String rplQuorumValue;
        int memberCount = localState.nodes.size();
        NodeState selfNode = localState.nodes.get(this.getHost().getId());
        AtomicInteger successCount = new AtomicInteger(0);
        if (req.serviceOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION) && selfNode.membershipQuorum > memberCount) {
            outboundOp.fail(new IllegalStateException("Not enough peers: " + memberCount));
            return;
        }
        if (memberCount == 1) {
            outboundOp.complete();
            return;
        }
        AtomicInteger failureCount = new AtomicInteger();
        int eligibleMemberCount = rsp.selectedNodes.size();
        int successThreshold = Math.min(2, eligibleMemberCount - 1);
        int failureThreshold = eligibleMemberCount - successThreshold;
        if (req.serviceOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION)) {
            successThreshold = Math.min(eligibleMemberCount, selfNode.membershipQuorum);
            failureThreshold = eligibleMemberCount - successThreshold;
        }
        if ((rplQuorumValue = outboundOp.getRequestHeader("x-xenon-rpl-quorum")) != null) {
            try {
                successThreshold = "x-xenon-all".equals(rplQuorumValue) ? eligibleMemberCount : Integer.parseInt(rplQuorumValue);
                if (successThreshold > eligibleMemberCount) {
                    String errorMsg = String.format("Requested quorum %d is larger than member count %d", successThreshold, eligibleMemberCount);
                    throw new IllegalArgumentException(errorMsg);
                }
                failureThreshold = eligibleMemberCount - successThreshold;
                outboundOp.getRequestHeaders().remove("x-xenon-rpl-quorum");
            }
            catch (Throwable e2) {
                outboundOp.fail(e2);
                return;
            }
        }
        int successThresholdFinal = successThreshold;
        int failureThresholdFinal = failureThreshold;
        Operation.CompletionHandler c = (o, e) -> {
            if (e == null && o != null && o.getStatusCode() >= 400) {
                e = new IllegalStateException("Request failed: " + o.toString());
            }
            int sCount = successCount.get();
            int fCount = failureCount.get();
            if (e != null) {
                this.logInfo("Replication to %s failed: %s", o.getUri(), e.toString());
                fCount = failureCount.incrementAndGet();
            } else {
                sCount = successCount.incrementAndGet();
            }
            if (sCount == successThresholdFinal) {
                outboundOp.complete();
                return;
            }
            if (fCount == 0) {
                return;
            }
            if (fCount > failureThresholdFinal || fCount + sCount == memberCount) {
                String error = String.format("%s to %s failed. Success: %d,  Fail: %d, quorum: %d, threshold: %d", new Object[]{outboundOp.getAction(), outboundOp.getUri().getPath(), sCount, fCount, selfNode.membershipQuorum, failureThresholdFinal});
                this.logWarning("%s", error);
                outboundOp.fail(new IllegalStateException(error));
            }
        };
        String jsonBody = Utils.toJson(req.linkedState);
        Operation update = Operation.createPost(null).setAction(outboundOp.getAction()).setBodyNoCloning(jsonBody).setCompletion(c).setRetryCount(1).setExpiration(outboundOp.getExpirationMicrosUtc()).transferRequestHeadersFrom(outboundOp).removePragmaDirective("xn-fwd").addPragmaDirective("xn-rpl").addPragmaDirective("xn-use-http2").setReferer(outboundOp.getReferer());
        update.removeRequestCallbackLocation();
        if (update.getCookies() != null) {
            update.getCookies().clear();
        }
        ServiceClient cl = this.getHost().getClient();
        String selfId = this.getHost().getId();
        c.handle(null, null);
        rsp.selectedNodes.forEach(m -> {
            if (m.id.equals(selfId)) {
                return;
            }
            if (m.options.contains((Object)NodeState.NodeOption.OBSERVER)) {
                return;
            }
            try {
                URI remotePeerService = new URI(m.groupReference.getScheme(), null, m.groupReference.getHost(), m.groupReference.getPort(), outboundOp.getUri().getPath(), outboundOp.getUri().getQuery(), null);
                update.setUri(remotePeerService);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (NodeState.isUnAvailable(m)) {
                c.handle(update, new IllegalStateException("node is not available"));
                return;
            }
            cl.send(update);
        });
    }

    @Override
    public void sendRequest(Operation op) {
        this.parent.sendRequest(op);
    }

    @Override
    public ServiceHost getHost() {
        return this.parent.getHost();
    }
}

