/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupBroadcastResponse;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.ArrayList;

public class NodeGroupUtils {
    public static void checkServiceAvailability(Operation.CompletionHandler ch, Service s) {
        NodeGroupUtils.checkServiceAvailability(ch, s.getHost(), s.getSelfLink(), s.getPeerNodeSelectorPath());
    }

    public static void checkServiceAvailability(Operation.CompletionHandler ch, ServiceHost host, String link, String selectorPath) {
        if (link == null) {
            throw new IllegalArgumentException("link is required");
        }
        URI service = UriUtils.buildUri(host, link);
        NodeGroupUtils.checkServiceAvailability(ch, host, service, selectorPath);
    }

    public static void checkServiceAvailability(Operation.CompletionHandler ch, ServiceHost host, URI service, String selectorPath) {
        URI available = UriUtils.buildAvailableUri(service);
        if (selectorPath == null) {
            throw new IllegalArgumentException("selectorPath is required");
        }
        available = UriUtils.buildBroadcastRequestUri(available, selectorPath, service.getPath());
        Operation get = Operation.createGet(available).setCompletion((o, e) -> {
            if (e != null) {
                ch.handle(null, e);
                return;
            }
            NodeGroupBroadcastResponse rsp = o.getBody(NodeGroupBroadcastResponse.class);
            if ((long)rsp.failures.size() < rsp.availableNodeCount) {
                ch.handle(o, null);
                return;
            }
            ch.handle(null, new IllegalStateException("All services on all nodes not available"));
        });
        host.sendRequest(get.setReferer(host.getPublicUri()));
    }

    public static void checkConvergenceFromAnyHost(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
    }

    public static void checkConvergence(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        NodeState self = ngs.nodes.get(host.getId());
        if (self == null) {
            parentOp.fail(new IllegalStateException("Self node is required"));
            return;
        }
        if (self.membershipQuorum == 1 && ngs.nodes.size() == 1) {
            parentOp.complete();
            return;
        }
        NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
    }

    private static void checkConvergenceAcrossPeers(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        OperationJoin.JoinedCompletionHandler joinedCompletion = (ops, failures) -> {
            if (failures != null) {
                parentOp.fail(new IllegalStateException("At least one peer failed convergence"));
                return;
            }
            for (Operation peerOp : ops.values()) {
                NodeGroupService.CheckConvergenceResponse r = peerOp.getBody(NodeGroupService.CheckConvergenceResponse.class);
                if (r.isConverged) continue;
                String error = String.format("Peer %s is not converged", peerOp.getUri());
                parentOp.fail(new IllegalStateException(error));
                return;
            }
            parentOp.complete();
        };
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        for (NodeState ns : ngs.nodes.values()) {
            if (NodeState.isUnAvailable(ns)) continue;
            NodeGroupService.CheckConvergenceRequest peerReq = NodeGroupService.CheckConvergenceRequest.create(ngs.membershipUpdateTimeMicros);
            Operation peerOp = Operation.createPost(ns.groupReference).setReferer(parentOp.getReferer()).setExpiration(parentOp.getExpirationMicrosUtc()).setBodyNoCloning(peerReq);
            ops2.add(peerOp);
        }
        if (ops2.isEmpty()) {
            parentOp.fail(new IllegalStateException("no available nodes"));
            return;
        }
        OperationJoin.create(ops2).setCompletion(joinedCompletion).sendWith(host);
    }

    public static void checkConvergence(ServiceHost host, URI nodegroupReference, Operation parentOp) {
        Operation.createGet(nodegroupReference).setReferer(parentOp.getReferer()).setCompletion((o, t) -> {
            if (t != null) {
                parentOp.fail(t);
                return;
            }
            NodeGroupService.NodeGroupState ngs = o.getBody(NodeGroupService.NodeGroupState.class);
            NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
        }).sendWith(host);
    }

    public static boolean isMembershipSettled(ServiceHost host, long maintIntervalMicros, NodeGroupService.NodeGroupState localState) {
        NodeState selfNode = localState.nodes.get(host.getId());
        if (selfNode == null) {
            return false;
        }
        if (localState.nodes.size() == 1 && selfNode.membershipQuorum == 1) {
            return true;
        }
        long threshold = localState.membershipUpdateTimeMicros + localState.config.stableGroupMaintenanceIntervalCount * maintIntervalMicros;
        return Utils.getNowMicrosUtc() - threshold >= 0L;
    }

    public static boolean hasMembershipQuorum(ServiceHost host, NodeGroupService.NodeGroupState ngs) {
        NodeState selfNode = ngs.nodes.get(host.getId());
        if (selfNode == null) {
            return false;
        }
        int availableNodeCount = 0;
        if (ngs.nodes.size() == 1) {
            availableNodeCount = 1;
        } else {
            for (NodeState ns : ngs.nodes.values()) {
                if (!NodeState.isAvailable(ns, selfNode.id, false)) continue;
                ++availableNodeCount;
            }
        }
        return availableNodeCount >= selfNode.membershipQuorum;
    }

    public static boolean isNodeGroupAvailable(ServiceHost host, NodeGroupService.NodeGroupState localState) {
        return NodeGroupUtils.isMembershipSettled(host, host.getMaintenanceIntervalMicros(), localState) && NodeGroupUtils.hasMembershipQuorum(host, localState);
    }
}

