/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeGroupUtils;
import com.vmware.xenon.services.common.NodeState;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MigrationTaskService
extends StatefulService {
    public static final String STAT_NAME_PROCESSED_DOCUMENTS = "processedServiceCount";
    public static final String STAT_NAME_ESTIMATED_TOTAL_SERVICE_COUNT = "estimatedTotalServiceCount";
    public static final String FACTORY_LINK = "/management/migration-tasks";
    private static final Integer DEFAULT_PAGE_SIZE = 500;
    private static final Long DEFAULT_MAINTENANCE_INTERVAL_MILLIS = TimeUnit.MINUTES.toMicros(1L);
    private static final Integer DEFAULT_MAXIMUM_CONVERGENCE_CHECKS = 10;

    public static Service createFactory() {
        FactoryService fs = FactoryService.create(MigrationTaskService.class, State.class, new Service.ServiceOption[0]);
        fs.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
        fs.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        return fs;
    }

    public MigrationTaskService() {
        super(State.class);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
    }

    @Override
    public void handleStart(Operation startPost) {
        State initState = (State)this.getBody(startPost);
        initState = this.initialize(initState);
        if (TaskState.isFinished(initState.taskInfo)) {
            startPost.complete();
            return;
        }
        if (!this.verifyState(initState, startPost)) {
            return;
        }
        startPost.complete();
        State patchState = new State();
        if (initState.taskInfo == null) {
            patchState.taskInfo = TaskState.create();
        }
        if (initState.continuousMigration.booleanValue()) {
            this.setMaintenanceIntervalMicros(initState.maintenanceIntervalMicros);
        }
        Operation.createPatch(this.getUri()).setBody(patchState).sendWith(this);
    }

    private State initialize(State initState) {
        if (initState.querySpec == null) {
            initState.querySpec = new QueryTask.QuerySpecification();
        }
        if (initState.querySpec.resultLimit == null) {
            initState.querySpec.resultLimit = DEFAULT_PAGE_SIZE;
        }
        initState.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        if (initState.querySpec.query == null || initState.querySpec.query.booleanClauses == null || initState.querySpec.query.booleanClauses.isEmpty()) {
            initState.querySpec.query = this.buildFieldClause(initState);
        } else {
            initState.querySpec.query.addBooleanClause(this.buildFieldClause(initState));
        }
        if (initState.taskInfo == null) {
            initState.taskInfo = new TaskState();
        }
        if (initState.taskInfo.stage == null) {
            initState.taskInfo.stage = TaskState.TaskStage.CREATED;
        }
        if (initState.maintenanceIntervalMicros == null) {
            initState.maintenanceIntervalMicros = DEFAULT_MAINTENANCE_INTERVAL_MILLIS;
        }
        if (initState.maximumConvergenceChecks == null) {
            initState.maximumConvergenceChecks = DEFAULT_MAXIMUM_CONVERGENCE_CHECKS;
        }
        if (initState.continuousMigration == null) {
            initState.continuousMigration = Boolean.FALSE;
        }
        return initState;
    }

    private QueryTask.Query buildFieldClause(State initState) {
        QueryTask.Query query = QueryTask.Query.Builder.create().addFieldClause("documentSelfLink", this.addSlash(initState.sourceFactoryLink) + "*", QueryTask.QueryTerm.MatchType.WILDCARD).build();
        return query;
    }

    private boolean verifyState(State state, Operation operation) {
        ArrayList<String> errMsgs = new ArrayList<String>();
        if (state.sourceFactoryLink == null) {
            errMsgs.add("sourceFactory cannot be null.");
        }
        if (state.sourceNodeGroupReference == null) {
            errMsgs.add("sourceNode cannot be null.");
        }
        if (state.destinationFactoryLink == null) {
            errMsgs.add("destinationFactory cannot be null.");
        }
        if (state.destinationNodeGroupReference == null) {
            errMsgs.add("destinationNode cannot be null.");
        }
        if (!errMsgs.isEmpty()) {
            operation.fail(new IllegalArgumentException(String.join((CharSequence)" ", errMsgs)));
        }
        return errMsgs.isEmpty();
    }

    @Override
    public void handlePatch(Operation patchOperation) {
        State patchState = (State)this.getBody(patchOperation);
        State currentState = (State)this.getState(patchOperation);
        this.applyPatch(patchState, currentState);
        if (!this.verifyState(currentState, patchOperation) && !this.verifyPatchedState(currentState, patchOperation)) {
            return;
        }
        patchOperation.complete();
        if (TaskState.isFinished(currentState.taskInfo) || TaskState.isFailed(currentState.taskInfo) || TaskState.isCancelled(currentState.taskInfo)) {
            return;
        }
        if ((patchState.maintenanceIntervalMicros != null || patchState.continuousMigration != null) && currentState.continuousMigration.booleanValue()) {
            this.setMaintenanceIntervalMicros(currentState.maintenanceIntervalMicros);
        }
        this.resolveNodeGroupReferences(currentState);
    }

    private URI extractBaseUri(NodeState state) {
        URI uri = state.groupReference;
        return UriUtils.buildUri(uri.getScheme(), uri.getHost(), uri.getPort(), null, null);
    }

    @Override
    public void handleMaintenance(Operation maintenanceOperation) {
        maintenanceOperation.complete();
        ServiceMaintenanceRequest serviceMaintenanceRequest = maintenanceOperation.getBody(ServiceMaintenanceRequest.class);
        if (!serviceMaintenanceRequest.reasons.contains((Object)ServiceMaintenanceRequest.MaintenanceReason.PERIODIC_SCHEDULE)) {
            return;
        }
        Operation.createGet(this.getUri()).setCompletion((o, t) -> {
            if (t != null) {
                this.logWarning("Error retrieving document %s, %s", this.getUri(), t);
                return;
            }
            State state = o.getBody(State.class);
            if (state.continuousMigration.booleanValue() && state.taskInfo.stage != TaskState.TaskStage.STARTED && state.taskInfo.stage != TaskState.TaskStage.CREATED) {
                State patch = new State();
                if (state.taskInfo.stage == TaskState.TaskStage.FINISHED) {
                    patch.querySpec = state.querySpec;
                    QueryTask.Query q = this.findUpdateTimeMicrosRangeClause(patch.querySpec.query);
                    if (q != null) {
                        q.setNumericRange(QueryTask.NumericRange.createGreaterThanOrEqualRange(state.latestSourceUpdateTimeMicros));
                    } else {
                        QueryTask.Query timeClause = QueryTask.Query.Builder.create().addRangeClause("documentUpdateTimeMicros", QueryTask.NumericRange.createGreaterThanOrEqualRange(state.latestSourceUpdateTimeMicros)).build();
                        patch.querySpec.query.addBooleanClause(timeClause);
                    }
                }
                patch.taskInfo = TaskState.createAsStarted();
                Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
            }
        }).sendWith(this);
    }

    private QueryTask.Query findUpdateTimeMicrosRangeClause(QueryTask.Query query) {
        if (query.term != null && query.term.propertyName != null && query.term.propertyName.equals("documentUpdateTimeMicros") && query.term.range != null) {
            return query;
        }
        if (query.booleanClauses == null) {
            return null;
        }
        for (QueryTask.Query q : query.booleanClauses) {
            QueryTask.Query match = this.findUpdateTimeMicrosRangeClause(q);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private void resolveNodeGroupReferences(State currentState) {
        Operation sourceGet = Operation.createGet(currentState.sourceNodeGroupReference);
        Operation destinationGet = Operation.createGet(currentState.destinationNodeGroupReference);
        OperationJoin.create(sourceGet, destinationGet).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            NodeGroupService.NodeGroupState sourceGroup = ((Operation)os.get(sourceGet.getId())).getBody(NodeGroupService.NodeGroupState.class);
            List sourceURIs = sourceGroup.nodes.entrySet().stream().map(e -> this.extractBaseUri((NodeState)e.getValue())).collect(Collectors.toList());
            NodeGroupService.NodeGroupState destinationGroup = ((Operation)os.get(destinationGet.getId())).getBody(NodeGroupService.NodeGroupState.class);
            List destinationURIs = destinationGroup.nodes.entrySet().stream().map(e -> this.extractBaseUri((NodeState)e.getValue())).collect(Collectors.toList());
            this.waitUntilNodeGroupsAreStable(currentState, currentState.maximumConvergenceChecks, () -> this.computeFirstCurrentPageLinks(currentState, sourceURIs, destinationURIs));
        }).sendWith(this);
    }

    private void waitUntilNodeGroupsAreStable(State currentState, int allowedConvergenceChecks, Runnable onSuccess) {
        Operation.CompletionHandler destinationCheckHandler = (o, t) -> {
            if (t != null) {
                this.scheduleWaitUntilNodeGroupsAreStable(currentState, allowedConvergenceChecks, onSuccess);
                return;
            }
            onSuccess.run();
        };
        Operation.CompletionHandler sourceCheckHandler = (o, t) -> {
            if (t != null) {
                this.scheduleWaitUntilNodeGroupsAreStable(currentState, allowedConvergenceChecks, onSuccess);
                return;
            }
            Operation destinationOp = new Operation().setReferer(this.getUri()).setCompletion(destinationCheckHandler);
            NodeGroupUtils.checkConvergence(this.getHost(), currentState.sourceNodeGroupReference, destinationOp);
        };
        Operation sourceOp = new Operation().setCompletion(sourceCheckHandler).setReferer(this.getUri());
        NodeGroupUtils.checkConvergence(this.getHost(), currentState.sourceNodeGroupReference, sourceOp);
    }

    private void scheduleWaitUntilNodeGroupsAreStable(State currentState, int allowedConvergenceChecks, Runnable onSuccess) {
        if (allowedConvergenceChecks <= 0) {
            this.failTask(new Exception("Nodegroups did not converge after " + currentState.maximumConvergenceChecks + " retries."));
            return;
        }
        this.logInfo("Nodegroups are not convereged scheduling retry.", new Object[0]);
        this.getHost().schedule(() -> this.waitUntilNodeGroupsAreStable(currentState, allowedConvergenceChecks - 1, onSuccess), currentState.maintenanceIntervalMicros, TimeUnit.MICROSECONDS);
    }

    private void computeFirstCurrentPageLinks(State currentState, List<URI> sourceURIs, List<URI> destinationURIs) {
        QueryTask queryTask = QueryTask.create(currentState.querySpec).setDirect(true);
        Collection queryOps = sourceURIs.stream().map(uri -> Operation.createPost(UriUtils.buildUri(uri, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS)).setBody(queryTask)).collect(Collectors.toSet());
        QueryTask resultCountQuery = QueryTask.Builder.createDirectTask().addOption(QueryTask.QuerySpecification.QueryOption.COUNT).setQuery(this.buildFieldClause(currentState)).build();
        Operation resultCountOperation = Operation.createPost(UriUtils.buildUri(this.selectRandomUri(sourceURIs), ServiceUriPaths.CORE_QUERY_TASKS)).setBody(resultCountQuery);
        queryOps.add(resultCountOperation);
        OperationJoin.create(queryOps).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            Set<URI> currentPageLinks = os.values().stream().filter(operation -> operation.getId() != resultCountOperation.getId()).filter(operation -> operation.getBody(QueryTask.class).results.nextPageLink != null).map(operation -> this.getNextPageLinkUri((Operation)operation)).collect(Collectors.toSet());
            Long estimatedTotalServiceCount = ((Operation)os.get((Object)Long.valueOf((long)resultCountOperation.getId()))).getBody(QueryTask.class).results.documentCount;
            this.adjustStat(STAT_NAME_ESTIMATED_TOTAL_SERVICE_COUNT, (double)estimatedTotalServiceCount.longValue());
            if (currentPageLinks.isEmpty()) {
                State patch = new State();
                patch.taskInfo = TaskState.createAsFinished();
                Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
            } else {
                this.migrate(currentState, currentPageLinks, destinationURIs, new HashMap<String, Long>());
            }
        }).sendWith(this);
    }

    private void migrate(State currentState, Set<URI> currentPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        Collection gets = currentPageLinks.stream().map(uri -> Operation.createGet(uri)).collect(Collectors.toSet());
        OperationJoin.create(gets).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            Set<URI> nextPages = os.values().stream().filter(operation -> operation.getBody(QueryTask.class).results.nextPageLink != null).map(operation -> this.getNextPageLinkUri((Operation)operation)).collect(Collectors.toSet());
            ArrayList<Object> results = new ArrayList<Object>();
            for (Operation op : os.values()) {
                QueryTask queryTask = op.getBody(QueryTask.class);
                for (Object doc : queryTask.results.documents.values()) {
                    ServiceDocument document = Utils.fromJson(doc, ServiceDocument.class);
                    String documentOwner = document.documentOwner;
                    if (documentOwner == null) {
                        documentOwner = queryTask.results.documentOwner;
                    }
                    if (!documentOwner.equals(queryTask.results.documentOwner)) continue;
                    Long lastUpdateTime = lastUpdateTimesPerOwner.getOrDefault(documentOwner, 0L);
                    lastUpdateTimesPerOwner.put(document.documentOwner, Math.max(lastUpdateTime, document.documentUpdateTimeMicros));
                    results.add(doc);
                }
            }
            if (nextPages.isEmpty()) {
                State patch = new State();
                patch.taskInfo = TaskState.createAsFinished();
                patch.latestSourceUpdateTimeMicros = lastUpdateTimesPerOwner.values().stream().mapToLong(x -> x).min().orElse(0L);
                Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
            } else if (results.isEmpty()) {
                this.migrate(currentState, nextPages, destinationURIs, lastUpdateTimesPerOwner);
            } else {
                this.transformResults(currentState, results, nextPages, destinationURIs, lastUpdateTimesPerOwner);
            }
        }).sendWith(this);
    }

    private void transformResults(State state, Collection<Object> results, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        Collection cleanJson = results.stream().map(d -> this.removeFactoryPathFromSelfLink(d, state.sourceFactoryLink)).collect(Collectors.toList());
        if (state.transformationServiceLink != null) {
            Collection transformations = cleanJson.stream().map(doc -> Operation.createPost(UriUtils.buildUri(this.selectRandomUri(destinationURIs), state.transformationServiceLink)).setBody(Collections.singletonMap(doc, state.destinationFactoryLink))).collect(Collectors.toList());
            OperationJoin.create(transformations).setCompletion((os, ts) -> {
                if (ts != null && !ts.isEmpty()) {
                    this.failTask(ts.values());
                    return;
                }
                HashMap<Object, String> transformedJson = new HashMap<Object, String>();
                for (Operation o : os.values()) {
                    Map m = o.getBody(Map.class);
                    for (Map.Entry entry : m.entrySet()) {
                        transformedJson.put(entry.getKey(), Utils.fromJson(entry.getValue(), String.class));
                    }
                }
                this.migrateEntities(transformedJson, state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
            }).sendWith(this);
        } else {
            Map<Object, String> jsonMap = cleanJson.stream().collect(Collectors.toMap(e -> e, e -> state.destinationFactoryLink));
            this.migrateEntities(jsonMap, state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        }
    }

    private void migrateEntities(Map<Object, String> json, State state, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        Collection posts = json.entrySet().stream().map(d -> Operation.createPost(UriUtils.buildUri(this.selectRandomUri(destinationURIs), (String)d.getValue())).setBody(d.getKey())).collect(Collectors.toList());
        OperationJoin.create(posts).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)posts.size());
            this.migrate(state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        }).sendWith(this);
    }

    private boolean verifyPatchedState(State state, Operation operation) {
        ArrayList errMsgs = new ArrayList();
        if (!errMsgs.isEmpty()) {
            operation.fail(new IllegalArgumentException(String.join((CharSequence)"\n", errMsgs)));
        }
        return errMsgs.isEmpty();
    }

    private State applyPatch(State patchState, State currentState) {
        Utils.mergeWithState(this.getDocumentTemplate().documentDescription, currentState, patchState);
        currentState.latestSourceUpdateTimeMicros = Math.max(Optional.ofNullable(currentState.latestSourceUpdateTimeMicros).orElse(0L), Optional.ofNullable(patchState.latestSourceUpdateTimeMicros).orElse(0L));
        return currentState;
    }

    private Object removeFactoryPathFromSelfLink(Object jsonObject, String factoryPath) {
        String selfLink = this.extractId(jsonObject, factoryPath);
        return Utils.toJson(Utils.setJsonProperty(jsonObject, "documentSelfLink", selfLink));
    }

    private String extractId(Object jsonObject, String factoryPath) {
        String selfLink = Utils.getJsonMapValue(jsonObject, "documentSelfLink", String.class);
        if (selfLink.startsWith(factoryPath)) {
            selfLink = selfLink.replaceFirst(factoryPath, "");
        }
        return selfLink;
    }

    private URI selectRandomUri(Collection<URI> uris) {
        int num = (int)(Math.random() * (double)uris.size());
        for (URI uri : uris) {
            if (--num >= 0) continue;
            return uri;
        }
        return null;
    }

    private String addSlash(String string) {
        if (string.endsWith("/")) {
            return string;
        }
        return string + "/";
    }

    private URI getNextPageLinkUri(Operation operation) {
        URI queryUri = operation.getUri();
        return UriUtils.buildUri(queryUri.getScheme(), queryUri.getHost(), queryUri.getPort(), operation.getBody(QueryTask.class).results.nextPageLink, null);
    }

    private void failTask(Throwable t) {
        State patch = new State();
        patch.taskInfo = TaskState.createAsFailed();
        patch.taskInfo.failure = Utils.toServiceErrorResponse(t);
        Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
    }

    private void failTask(Collection<Throwable> t) {
        this.failTask(t.iterator().next());
    }

    public static class State
    extends ServiceDocument {
        public URI sourceNodeGroupReference;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String sourceFactoryLink;
        public URI destinationNodeGroupReference;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String destinationFactoryLink;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String transformationServiceLink;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public QueryTask.QuerySpecification querySpec;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public TaskState taskInfo;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Long maintenanceIntervalMicros;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Integer maximumConvergenceChecks;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Boolean continuousMigration;
        public Long latestSourceUpdateTimeMicros = 0L;
    }
}

