/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.VersionFieldSerializer;
import com.vmware.xenon.common.serialization.InstantSerializer;
import com.vmware.xenon.common.serialization.URISerializer;
import com.vmware.xenon.common.serialization.UUIDSerializer;
import com.vmware.xenon.common.serialization.ZoneIdSerializer;
import com.vmware.xenon.common.serialization.ZonedDateTimeSerializer;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public final class KryoSerializers {
    private KryoSerializers() {
    }

    public static Kryo create(boolean isObjectSerializer) {
        Kryo k = new Kryo();
        k.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        k.setDefaultSerializer(VersionFieldSerializer.class);
        k.addDefaultSerializer(ZonedDateTime.class, (Serializer)ZonedDateTimeSerializer.INSTANCE);
        k.addDefaultSerializer(Instant.class, (Serializer)InstantSerializer.INSTANCE);
        k.addDefaultSerializer(ZoneId.class, (Serializer)ZoneIdSerializer.INSTANCE);
        k.addDefaultSerializer(UUID.class, (Serializer)UUIDSerializer.INSTANCE);
        k.addDefaultSerializer(URI.class, (Serializer)URISerializer.INSTANCE);
        if (isObjectSerializer) {
            k.setAutoReset(true);
        } else {
            k.setReferences(false);
        }
        return k;
    }

    public static class KryoForDocumentThreadLocal
    extends ThreadLocal<Kryo> {
        @Override
        protected Kryo initialValue() {
            return KryoSerializers.create(false);
        }
    }

    public static class KryoForObjectThreadLocal
    extends ThreadLocal<Kryo> {
        @Override
        protected Kryo initialValue() {
            return KryoSerializers.create(true);
        }
    }
}

