/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.OperationQueue;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceConfigUpdateRequest;
import com.vmware.xenon.common.ServiceConfiguration;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.TransactionServiceHelper;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.UtilityService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.jwt.Signer;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatefulService
implements Service {
    private final RuntimeContext context = new RuntimeContext();

    public StatefulService(Class<? extends ServiceDocument> stateType) {
        if (stateType == null) {
            throw new IllegalArgumentException("stateType is required");
        }
        this.context.stateType = stateType;
        this.context.operationQueue = this.context.options.contains((Object)Service.ServiceOption.LIFO_QUEUE) ? OperationQueue.createLifo(10000) : OperationQueue.createFifo(10000);
    }

    @Override
    public OperationProcessingChain getOperationProcessingChain() {
        return this.context.opProcessingChain;
    }

    @Override
    public Service.ProcessingStage getProcessingStage() {
        return this.context.processingStage;
    }

    @Override
    public void handleCreate(Operation post) {
        post.complete();
    }

    @Override
    public void handleStart(Operation post) {
        post.complete();
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public boolean queueRequest(Operation op) {
        URI referer;
        if (this.checkServiceStopped(op, false)) {
            return true;
        }
        if (op.getAction() != Service.Action.DELETE && this.context.processingStage != Service.ProcessingStage.AVAILABLE) {
            if (this.context.processingStage == Service.ProcessingStage.PAUSED) {
                this.logWarning("Service in stage %s, retrying request", new Object[]{this.context.processingStage});
                this.getHost().handleRequest(this, op);
                return true;
            }
            this.logWarning("Service in %s stage, cancelling operation", new Object[]{this.context.processingStage});
            op.fail(new CancellationException());
            return true;
        }
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            op.setEnqueueTime(Utils.getNowMicrosUtc());
        }
        if ((referer = op.getReferer()) == null) {
            op.fail(new IllegalArgumentException("Referer is required"));
            return true;
        }
        return !this.hasOption(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING) && this.queueSynchronizedRequest(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkServiceStopped(Operation op, boolean stop) {
        boolean isAlreadyStopped;
        boolean bl = isAlreadyStopped = this.context.processingStage == Service.ProcessingStage.STOPPED;
        if (isAlreadyStopped) {
            if (op.getAction() != Service.Action.DELETE) {
                this.logWarning("Service is stopped, cancelling operation", new Object[0]);
                op.fail(new CancellationException());
            } else {
                op.complete();
            }
        }
        if (!isAlreadyStopped && !stop) {
            return false;
        }
        this.setProcessingStage(Service.ProcessingStage.STOPPED);
        Collection<Operation> opsToCancel = null;
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            opsToCancel = this.context.operationQueue.toCollection();
            this.context.operationQueue.clear();
        }
        for (Operation o : opsToCancel) {
            if (o.isFromReplication() && o.getAction() == Service.Action.DELETE) {
                o.complete();
                continue;
            }
            o.fail(new CancellationException(this.getSelfLink()));
        }
        return isAlreadyStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueSynchronizedRequest(Operation op) {
        boolean isPaused = false;
        if (op.getAction() != Service.Action.GET && op.getAction() != Service.Action.OPTIONS) {
            RuntimeContext runtimeContext = this.context;
            synchronized (runtimeContext) {
                if (this.context.processingStage == Service.ProcessingStage.PAUSED) {
                    isPaused = true;
                } else if (this.context.processingStage != Service.ProcessingStage.STOPPED) {
                    if (this.context.isUpdateActive || this.context.getActiveCount != 0) {
                        if (!this.context.operationQueue.offer(op)) {
                            this.getHost().failRequestLimitExceeded(op);
                        }
                        return true;
                    }
                    this.context.isUpdateActive = true;
                }
            }
        }
        if (op.getAction() == Service.Action.OPTIONS) {
            return false;
        }
        if (this.hasOption(Service.ServiceOption.CONCURRENT_GET_HANDLING)) {
            return false;
        }
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            if (this.context.processingStage == Service.ProcessingStage.PAUSED) {
                isPaused = true;
            } else if (this.context.processingStage != Service.ProcessingStage.STOPPED) {
                if (this.context.isUpdateActive) {
                    if (!this.context.operationQueue.offer(op)) {
                        this.getHost().failRequestLimitExceeded(op);
                    }
                    return true;
                }
                ++this.context.getActiveCount;
            }
        }
        if (isPaused && !this.getHost().isStopping()) {
            this.logWarning("Service in stage %s, retrying request", new Object[]{this.context.processingStage});
            this.getHost().handleRequest(this, op);
            return true;
        }
        return this.checkServiceStopped(op, false);
    }

    @Override
    public void handleRequest(Operation request) {
        this.handleRequest(request, Service.OperationProcessingStage.LOADING_STATE);
    }

    @Override
    public void handleRequest(Operation request, Service.OperationProcessingStage opProcessingStage) {
        boolean isCompletionNested = false;
        try {
            if (opProcessingStage == Service.OperationProcessingStage.LOADING_STATE) {
                if (ServiceHost.isServiceStop(request)) {
                    request.nestCompletion((o, e) -> {
                        this.processPending(request);
                        if (e == null) {
                            this.handleStopCompletion(request);
                        }
                    });
                    if (this.hasOption(Service.ServiceOption.OWNER_SELECTION) && !this.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) {
                        request.complete();
                    } else {
                        this.handleStop(request);
                    }
                    return;
                }
                if (this.handleRequestLoadingAndLinkingState(request)) {
                    return;
                }
                opProcessingStage = Service.OperationProcessingStage.PROCESSING_FILTERS;
            }
            if (opProcessingStage == Service.OperationProcessingStage.PROCESSING_FILTERS) {
                if (request.getAction() != Service.Action.GET && this.validateOwnerSelectedUpdate(request)) {
                    return;
                }
                request.nestCompletion(this::handleRequestCompletion);
                isCompletionNested = true;
                if (TransactionServiceHelper.handleOperationInTransaction(this, this.context.stateType, request)) {
                    return;
                }
                if (request.getAction() != Service.Action.GET && this.validateUpdate(request)) {
                    return;
                }
                if (this.hasOption(Service.ServiceOption.OWNER_SELECTION) && request.isFromReplication()) {
                    request.complete();
                    return;
                }
                OperationProcessingChain opProcessingChain = this.getOperationProcessingChain();
                if (opProcessingChain != null && !opProcessingChain.processRequest(request)) {
                    return;
                }
                opProcessingStage = Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER;
            }
            if (opProcessingStage == Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER) {
                isCompletionNested = true;
                switch (request.getAction()) {
                    case DELETE: {
                        if (ServiceHost.isServiceStop(request)) {
                            this.handleStop(request);
                            break;
                        }
                        request.nestCompletion(o -> this.handleStop(request));
                        this.handleDelete(request);
                        break;
                    }
                    case GET: {
                        this.handleGet(request);
                        break;
                    }
                    case PATCH: {
                        this.handlePatch(request);
                        break;
                    }
                    case POST: {
                        this.handlePost(request);
                        break;
                    }
                    case PUT: {
                        this.handlePut(request);
                        break;
                    }
                    case OPTIONS: {
                        this.handleOptions(request);
                        break;
                    }
                    default: {
                        this.getHost().failRequestActionNotSupported(request);
                    }
                }
            }
        }
        catch (Throwable e2) {
            if (Utils.isValidationError(e2)) {
                this.logFine("Validation Error: %s", Utils.toString(e2));
            } else {
                this.logWarning("Uncaught exception: %s", e2.toString());
                this.logWarning("Exception trace: %s", Utils.toString(e2));
            }
            if (isCompletionNested) {
                request.fail(e2);
            }
            this.handleRequestCompletion(request, e2);
        }
    }

    private boolean handleRequestLoadingAndLinkingState(Operation request) {
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            request.setHandlerInvokeTime(Utils.getNowMicrosUtc());
            this.adjustStat((Object)((Object)request.getAction()) + "requestCount", 1.0);
        }
        if (this.checkServiceStopped(request, false)) {
            return true;
        }
        if (request.isFromReplication()) {
            ServiceDocument state = request.getBody(this.context.stateType);
            request.linkState(state);
            return false;
        }
        this.loadAndLinkState(request);
        return true;
    }

    private boolean validateOwnerSelectedUpdate(Operation request) {
        if (this.hasOption(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING)) {
            return false;
        }
        ServiceDocument stateFromOwner = request.getLinkedState();
        if (!request.isFromReplication()) {
            if (request.isSynchronize()) {
                this.synchronizeWithPeers(request, null);
                return true;
            }
            if (this.hasOption(Service.ServiceOption.OWNER_SELECTION)) {
                if (!this.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) {
                    this.synchronizeWithPeers(request, new IllegalStateException("not marked as owner"));
                    return true;
                }
                return false;
            }
        }
        if (!this.hasOption(Service.ServiceOption.OWNER_SELECTION)) {
            return false;
        }
        if (stateFromOwner == null) {
            this.failRequest(request, new IllegalArgumentException("missing state in replicated op:" + request.toString()), true);
            return true;
        }
        if (stateFromOwner.documentOwner == null) {
            this.failRequest(request, new IllegalArgumentException("documentOwner is required"), false);
            return true;
        }
        if (stateFromOwner.documentEpoch == null || this.context.epoch > stateFromOwner.documentEpoch) {
            String error = String.format("Expected epoch: %d, in update: %d", this.context.epoch, stateFromOwner.documentEpoch);
            if (this.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) {
                this.synchronizeWithPeers(request, new IllegalStateException(error));
            } else {
                this.failRequest(request.setStatusCode(409), new IllegalStateException(error), true);
            }
            return true;
        }
        if (this.hasOption(Service.ServiceOption.DOCUMENT_OWNER) && !stateFromOwner.documentOwner.equals(this.getHost().getId())) {
            this.toggleOption(Service.ServiceOption.DOCUMENT_OWNER, false);
            return false;
        }
        return false;
    }

    private boolean validateUpdate(Operation request) {
        if (this.hasOption(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING)) {
            return false;
        }
        if (request.isFromReplication()) {
            return false;
        }
        if (!this.hasOption(Service.ServiceOption.STRICT_UPDATE_CHECKING)) {
            return false;
        }
        ServiceDocument currentState = request.getLinkedState();
        Object body = request.getBodyRaw();
        if (body instanceof String) {
            body = request.getBody(ServiceDocument.class);
        } else if (!(body instanceof ServiceDocument)) {
            request.fail(new IllegalArgumentException("request body must derive from ServiceDocument"));
            return true;
        }
        ServiceDocument sdBody = (ServiceDocument)body;
        boolean isVersionMatch = this.context.version == sdBody.documentVersion;
        String errorString = null;
        if (!isVersionMatch) {
            errorString = String.format("current version %d, update time %d. Request version %d, update time %d", currentState.documentVersion, currentState.documentUpdateTimeMicros, sdBody.documentVersion, sdBody.documentUpdateTimeMicros);
            request.fail(new IllegalArgumentException(errorString));
            return true;
        }
        return false;
    }

    public void handlePost(Operation post) {
        this.getHost().failRequestActionNotSupported(post);
    }

    public void handleDelete(Operation delete) {
        delete.complete();
    }

    @Override
    public void handleStop(Operation delete) {
        delete.complete();
    }

    public void handlePatch(Operation patch) {
        this.getHost().failRequestActionNotSupported(patch);
    }

    public void handleOptions(Operation options) {
        options.setBody(null).complete();
    }

    public void handlePut(Operation put) {
        ServiceDocument newState = put.getBody(this.context.stateType);
        this.setState(put, newState);
        put.complete();
    }

    public void handleGet(Operation get) {
        if (!this.hasPendingTransactions()) {
            this.handleGetSimple(get);
            return;
        }
        TransactionServiceHelper.handleGetWithinTransaction(this, get, this::handleGetSimple, this::failRequest);
    }

    private void handleGetSimple(Operation get) {
        ServiceDocument d = get.getLinkedState();
        if (d == null) {
            if (this.checkServiceStopped(get, false)) {
                return;
            }
            if (this.context.version > 0L) {
                throw new IllegalStateException("Version is non zero but no state was found");
            }
            d = new ServiceDocument();
            d.documentSelfLink = this.context.selfLink;
            d.documentKind = Utils.buildKind(this.context.stateType);
        }
        get.setBodyNoCloning(d).complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestCompletion(Operation op, Throwable e) {
        boolean isUpdate;
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            op.setHandlerCompletionTime(Utils.getNowMicrosUtc());
        }
        ServiceDocument linkedState = op.getLinkedState();
        boolean isStateUpdated = isUpdate = op.getAction() != Service.Action.GET && op.getAction() != Service.Action.OPTIONS;
        if (op.isFromReplication()) {
            isStateUpdated = true;
        }
        if (op.getStatusCode() == 304) {
            isStateUpdated = false;
        } else if (op.getTransactionId() != null && linkedState != null && op.getTransactionId().equals(linkedState.documentTransactionId)) {
            isStateUpdated = true;
        }
        if (e == null && isStateUpdated) {
            try {
                if (linkedState != null && !op.isFromReplication() && !this.hasOption(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING)) {
                    op.linkState(Utils.clone(op.getLinkedState()));
                }
                this.applyUpdate(op);
                linkedState = op.getLinkedState();
            }
            catch (Throwable e1) {
                this.logSevere(e1);
                e = e1;
            }
        }
        if (op.isWithinTransaction() && this.getHost().getTransactionServiceUri() != null) {
            this.allocatePendingTransactions();
            TransactionServiceHelper.notifyTransactionCoordinator(this, op, e);
        }
        if (e != null) {
            if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                this.adjustStat((Object)((Object)op.getAction()) + "failureCount", 1.0);
            }
            this.failRequest(op, e);
            return;
        }
        boolean processPending = true;
        try {
            if (op.getAction() == Service.Action.DELETE && op.getTransactionId() == null && this.handleDeleteCompletion(op)) {
                processPending = false;
                return;
            }
            if (op.getAction() == Service.Action.OPTIONS) {
                this.handleOptionsCompletion(op);
                return;
            }
            if (isStateUpdated && linkedState != null) {
                if (linkedState.documentDescription != null) {
                    linkedState.documentDescription = null;
                }
                linkedState.documentSelfLink = this.context.selfLink;
                if (linkedState.documentKind == null) {
                    linkedState.documentKind = Utils.buildKind(this.context.stateType);
                }
                if (this.replicateRequest(op)) {
                    processPending = false;
                    return;
                }
                this.saveState(op);
            } else {
                this.completeRequest(op);
            }
        }
        finally {
            if (processPending) {
                this.processPending(op);
            }
        }
    }

    protected void handleOptionsCompletion(Operation options) {
        if (!options.hasBody()) {
            options.setBodyNoCloning(this.getDocumentTemplate());
        }
        this.completeRequest(options);
    }

    private void failRequest(Operation op, Throwable e) {
        this.failRequest(op, e, false);
    }

    private void failRequest(Operation op, Throwable e, boolean shouldRetry) {
        if (shouldRetry) {
            ServiceErrorResponse rsp = ServiceErrorResponse.create(e, op.getStatusCode(), EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY));
            op.setBodyNoCloning(rsp);
        }
        this.processPending(op);
        op.fail(e);
    }

    private boolean isIndexed() {
        return this.context.options.contains((Object)Service.ServiceOption.PERSISTENCE);
    }

    private boolean handleDeleteCompletion(Operation op) {
        if (op.isFromReplication() && this.hasOption(Service.ServiceOption.OWNER_SELECTION) && !op.isCommit()) {
            return false;
        }
        if (this.checkServiceStopped(op, true)) {
            return true;
        }
        this.getHost().stopService(this);
        return false;
    }

    private void handleStopCompletion(Operation op) {
        if (this.checkServiceStopped(op, true)) {
            return;
        }
        this.getHost().stopService(this);
        op.complete();
    }

    private boolean replicateRequest(Operation op) {
        if (!this.hasOption(Service.ServiceOption.REPLICATION)) {
            return false;
        }
        if (op.getAction() == Service.Action.GET || op.isReplicationDisabled() || op.isFromReplication()) {
            return false;
        }
        if (this.hasOption(Service.ServiceOption.OWNER_SELECTION) && !this.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) {
            return false;
        }
        if (op.getAction() == Service.Action.DELETE && !op.hasBody()) {
            ServiceDocument body = op.getLinkedState();
            op.setBodyNoCloning(body);
        }
        if (!op.hasBody()) {
            return false;
        }
        op.nestCompletion((o, e) -> {
            if (e != null) {
                ServiceErrorResponse rsp = o.getBody(ServiceErrorResponse.class);
                if (rsp != null && rsp.details != null && rsp.details.contains((Object)ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)) {
                    this.synchronizeWithPeers(op, e);
                } else {
                    this.failRequest(op, e);
                }
                return;
            }
            op.setReplicationDisabled(true);
            try {
                this.saveState(op);
            }
            finally {
                this.processPending(op);
            }
        });
        this.getHost().replicateRequest(this.context.options, op.getLinkedState(), this.getPeerNodeSelectorPath(), this.getSelfLink(), op);
        return true;
    }

    private void saveState(Operation op) {
        op.nestCompletion((o, e) -> {
            if (e != null) {
                this.failRequest(op, e);
                return;
            }
            this.completeRequest(op);
        });
        ServiceDocument mergedState = op.getLinkedState();
        this.context.host.saveServiceState(this, op, mergedState);
    }

    private void completeRequest(Operation op) {
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            this.updatePerOperationStats(op);
        }
        if (op.getAction() == Service.Action.GET && !this.isIndexed()) {
            op.linkState(null);
            this.getHost().run(op::complete);
            return;
        }
        this.publish(op);
        if (op.isFromReplication() && !op.isSynchronize()) {
            op.setBodyNoCloning(null);
        }
        op.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitLastProposalIfIdle(Operation op) {
        if (op.getStatusCode() >= 400) {
            return;
        }
        if (op.isFromReplication() || op.getAction() == Service.Action.GET) {
            return;
        }
        if (!this.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) {
            return;
        }
        if (op.getAction() != Service.Action.DELETE) {
            RuntimeContext runtimeContext = this.context;
            synchronized (runtimeContext) {
                if (!this.context.operationQueue.isEmpty()) {
                    return;
                }
            }
        } else if (op.hasPragmaDirective("xn-no-index-update")) {
            return;
        }
        if (this.getHost().isStopping()) {
            return;
        }
        ServiceDocument latestState = op.getLinkedState();
        URI u = this.getUri();
        Operation commitOp = Operation.createPut(u).addRequestHeader("x-xenon-rpl-phase", "commit").setReferer(u).setExpiration(this.getHost().getOperationTimeoutMicros() + Utils.getNowMicrosUtc());
        if (op.getAction() == Service.Action.DELETE) {
            commitOp.setAction(op.getAction());
        }
        this.getHost().replicateRequest(this.context.options, latestState, this.getPeerNodeSelectorPath(), this.getSelfLink(), commitOp);
    }

    private void publish(Operation op) {
        if (op.getAction() == Service.Action.GET || op.getAction() == Service.Action.OPTIONS) {
            return;
        }
        if (op.isNotificationDisabled()) {
            return;
        }
        if (this.context.utilityService == null) {
            return;
        }
        if (!this.allocateUtilityService(false)) {
            return;
        }
        if (op.getStatusCode() == 304) {
            return;
        }
        if (!op.hasBody()) {
            return;
        }
        this.context.utilityService.notifySubscribers(op);
    }

    private void updatePerOperationStats(Operation op) {
        ServiceStats.ServiceStat s;
        op.setCompletionTime(Utils.getNowMicrosUtc());
        Operation.InstrumentationContext ctx = op.getInstrumentationContext();
        long queueLatency = ctx.handleInvokeTimeMicrosUtc - ctx.enqueueTimeMicrosUtc;
        long handlerLatency = ctx.handlerCompletionTime - ctx.handleInvokeTimeMicrosUtc;
        long endToEndDuration = ctx.operationCompletionTimeMicrosUtc - ctx.enqueueTimeMicrosUtc;
        if (ctx.documentStoreCompletionTimeMicrosUtc > 0L) {
            s = this.getHistogramStat("statePersistLatencyMicros");
            this.setStat(s, (double)(ctx.documentStoreCompletionTimeMicrosUtc - ctx.handlerCompletionTime));
        }
        s = this.getHistogramStat((Object)((Object)op.getAction()) + "operationQueueingLatencyMicros");
        this.setStat(s, (double)queueLatency);
        s = this.getHistogramStat((Object)((Object)op.getAction()) + "operationHandlerProcessingLatencyMicros");
        this.setStat(s, (double)handlerLatency);
        s = this.getHistogramStat((Object)((Object)op.getAction()) + "operationDuration");
        this.setStat((Object)((Object)op.getAction()) + "operationDuration", (double)endToEndDuration);
    }

    private void loadAndLinkState(Operation op) {
        op.nestCompletion((o, e) -> {
            if (e != null) {
                this.failRequest(op, e);
                return;
            }
            ServiceDocument linkedState = op.getLinkedState();
            if (linkedState == null && this.hasOption(Service.ServiceOption.PERSISTENCE)) {
                this.failRequest(op, new IllegalStateException("Service state permanently deleted from index"), false);
                return;
            }
            if (linkedState != null) {
                if (this.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) {
                    linkedState.documentOwner = this.getHost().getId();
                }
                if (this.hasOption(Service.ServiceOption.OWNER_SELECTION)) {
                    linkedState.documentEpoch = this.context.epoch;
                }
            }
            this.handleRequest(op, Service.OperationProcessingStage.PROCESSING_FILTERS);
        });
        this.getHost().loadServiceState(this, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPending(Operation op) {
        RuntimeContext runtimeContext;
        if (this.hasOption(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING)) {
            return;
        }
        if (op.getAction() == Service.Action.OPTIONS) {
            return;
        }
        if (op.getAction() != Service.Action.GET) {
            runtimeContext = this.context;
            synchronized (runtimeContext) {
                this.context.isUpdateActive = false;
            }
            this.commitLastProposalIfIdle(op);
        }
        if (op.getAction() == Service.Action.GET) {
            if (this.hasOption(Service.ServiceOption.CONCURRENT_GET_HANDLING)) {
                return;
            }
            runtimeContext = this.context;
            synchronized (runtimeContext) {
                --this.context.getActiveCount;
                if (this.context.getActiveCount < 0) {
                    this.logSevere(new IllegalStateException("Synchronization state is invalid: Negative pending gets"));
                    this.context.getActiveCount = 0;
                }
            }
        }
        this.context.host.handleRequest(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Operation dequeueRequest() {
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            return this.context.operationQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdate(Operation op) throws Throwable {
        long time = Utils.getNowMicrosUtc();
        ServiceDocument cachedState = op.getLinkedState();
        if (cachedState == null) {
            cachedState = this.context.stateType.newInstance();
        }
        if (!op.isFromReplication()) {
            if (this.hasOption(Service.ServiceOption.OWNER_SELECTION)) {
                cachedState.documentEpoch = this.context.epoch;
            }
            RuntimeContext runtimeContext = this.context;
            synchronized (runtimeContext) {
                ++this.context.version;
                cachedState.documentVersion = this.context.version;
                cachedState.documentUpdateTimeMicros = time;
            }
            op.linkState(cachedState);
            return;
        }
        this.context.version = Math.max(cachedState.documentVersion, this.context.version);
        cachedState.documentUpdateTimeMicros = Math.max(cachedState.documentUpdateTimeMicros, time);
        if (this.hasOption(Service.ServiceOption.OWNER_SELECTION)) {
            long prevEpoch = this.context.epoch;
            this.context.epoch = Math.max(cachedState.documentEpoch, this.context.epoch);
            if (prevEpoch != this.context.epoch) {
                this.logFine("Epoch updated from %d to %d", prevEpoch, this.context.epoch);
            }
        }
    }

    private void synchronizeWithPeers(Operation request, Throwable failure) {
        if (failure instanceof CancellationException) {
            this.failRequest(request, failure);
            return;
        }
        Operation clonedRequest = request.clone();
        boolean wasOwner = this.hasOption(Service.ServiceOption.DOCUMENT_OWNER);
        clonedRequest.setBody(request.getLinkedState()).setCompletion((o, e) -> this.handleSynchronizeWithPeersCompletion(request, failure, wasOwner, o, e));
        clonedRequest.setRetryCount(0);
        clonedRequest.addPragmaDirective("xn-synch");
        boolean isFactorySync = request.hasPragmaDirective("xn-no-fwd");
        this.getHost().selectServiceOwnerAndSynchState(this, clonedRequest, isFactorySync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSynchronizeWithPeersCompletion(Operation request, Throwable failure, boolean wasOwner, Operation o, Throwable e) {
        if (e != null) {
            this.failRequest(request, e, true);
            return;
        }
        boolean isOwner = this.hasOption(Service.ServiceOption.DOCUMENT_OWNER);
        boolean isStateUpdated = false;
        ServiceDocument state = (ServiceDocument)o.getBodyRaw();
        if (state != null) {
            if (this.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) {
                state.documentOwner = this.getHost().getId();
            }
            RuntimeContext runtimeContext = this.context;
            synchronized (runtimeContext) {
                if (state.documentEpoch != null && state.documentEpoch > this.context.epoch) {
                    this.context.epoch = state.documentEpoch;
                    isStateUpdated = true;
                }
                if (state.documentVersion > this.context.version) {
                    this.context.version = state.documentVersion;
                    isStateUpdated = true;
                }
            }
            request.linkState(state);
        }
        if (!wasOwner && isOwner) {
            isStateUpdated = true;
        }
        if (!isStateUpdated) {
            request.setStatusCode(304);
        }
        this.completeSynchronizationRequest(request, failure, isStateUpdated);
        if (wasOwner) {
            return;
        }
        this.getHost().scheduleServiceOptionToggleMaintenance(this.getSelfLink(), EnumSet.of(Service.ServiceOption.DOCUMENT_OWNER), null);
    }

    private void completeSynchronizationRequest(Operation request, Throwable failure, boolean isStateUpdated) {
        if (failure != null) {
            this.logWarning("isUpdated:%s, e:%d v:%d, cause:%s (%d", isStateUpdated, this.context.epoch, this.context.version, failure, request.getId());
            request.setStatusCode(409);
            this.failRequest(request, new IllegalStateException("Synchronization complete, original failure: " + failure.toString()), true);
            return;
        }
        request.setFromReplication(true);
        if (!isStateUpdated) {
            this.processPending(request);
            request.complete();
            return;
        }
        request.nestCompletion(this::handleRequestCompletion);
        request.complete();
    }

    @Override
    public void setStat(String name, double newValue) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        this.allocateUtilityService(true);
        ServiceStats.ServiceStat s = this.getStat(name);
        this.context.utilityService.setStat(s, newValue);
    }

    @Override
    public void setStat(ServiceStats.ServiceStat s, double newValue) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        this.allocateUtilityService(true);
        this.context.utilityService.setStat(s, newValue);
    }

    @Override
    public void adjustStat(ServiceStats.ServiceStat s, double delta) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        this.allocateUtilityService(true);
        this.context.utilityService.adjustStat(s, delta);
    }

    @Override
    public void adjustStat(String name, double delta) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        this.allocateUtilityService(true);
        ServiceStats.ServiceStat s = this.getStat(name);
        this.context.utilityService.adjustStat(s, delta);
    }

    @Override
    public ServiceStats.ServiceStat getStat(String name) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        if (!this.allocateUtilityService(true)) {
            return null;
        }
        return this.context.utilityService.getStat(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceStats.ServiceStat getHistogramStat(String name) {
        ServiceStats.ServiceStat s;
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        ServiceStats.ServiceStat serviceStat = s = this.getStat(name);
        synchronized (serviceStat) {
            if (s.logHistogram == null) {
                s.logHistogram = new ServiceStats.ServiceStatLogHistogram();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocateUtilityService(boolean forceAllocate) {
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            if (!forceAllocate && this.context.utilityService == null) {
                return false;
            }
            if (this.context.utilityService == null) {
                this.context.utilityService = new UtilityService();
            }
            this.context.utilityService.setParent(this);
        }
        return true;
    }

    @Override
    public String getSelfLink() {
        return this.context.selfLink;
    }

    @Override
    public URI getUri() {
        return UriUtils.buildUri(this.context.host, this.context.selfLink);
    }

    @Override
    public ServiceHost getHost() {
        return this.context.host;
    }

    @Override
    public boolean hasOption(Service.ServiceOption cap) {
        return this.context.options.contains((Object)cap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toggleOption(Service.ServiceOption option, boolean enable) {
        if (option == Service.ServiceOption.IDEMPOTENT_POST) {
            throw new IllegalArgumentException("Option not supported on singleton services. Set this service option on the factory service instead.");
        }
        if (option != Service.ServiceOption.HTML_USER_INTERFACE && option != Service.ServiceOption.DOCUMENT_OWNER && option != Service.ServiceOption.PERIODIC_MAINTENANCE && option != Service.ServiceOption.INSTRUMENTATION && this.getProcessingStage() != Service.ProcessingStage.CREATED) {
            throw new IllegalStateException("Service already started");
        }
        if (option == Service.ServiceOption.PERSISTENCE && enable) {
            this.toggleOption(Service.ServiceOption.CONCURRENT_GET_HANDLING, true);
        }
        if (option == Service.ServiceOption.PERIODIC_MAINTENANCE && this.hasOption(Service.ServiceOption.ON_DEMAND_LOAD) || option == Service.ServiceOption.ON_DEMAND_LOAD && this.hasOption(Service.ServiceOption.PERIODIC_MAINTENANCE)) {
            throw new IllegalArgumentException("Service option PERIODIC_MAINTENANCE and ON_DEMAND_LOAD cannot co-exists.");
        }
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            if (enable) {
                this.context.options.add(option);
            } else {
                this.context.options.remove((Object)option);
            }
        }
    }

    @Override
    public void setSelfLink(String path) {
        if (this.context.processingStage != Service.ProcessingStage.CREATED) {
            throw new IllegalStateException("Self link can not change past initialization");
        }
        this.context.selfLink = path;
    }

    @Override
    public void setHost(ServiceHost serviceHost) {
        this.context.host = serviceHost;
    }

    @Override
    public void setOperationProcessingChain(OperationProcessingChain opProcessingChain) {
        this.context.opProcessingChain = opProcessingChain;
    }

    protected void setOperationQueueLimit(int limit) {
        this.context.operationQueue.setLimit(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void setProcessingStage(Service.ProcessingStage stage) {
        block27: {
            block25: {
                block24: {
                    block22: {
                        block20: {
                            failure = null;
                            statName = null;
                            var4_4 = this.context;
                            synchronized (var4_4) {
                                if (this.context.processingStage != stage) ** break block19
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
                                if (failure == null) break block20;
                            }
                            throw failure;
                        }
                        if (statName != null) {
                            this.adjustStat(statName, 1.0);
                        }
                        return;
                        {
                            if (stage != Service.ProcessingStage.PAUSED) ** GOTO lbl43
                            if (this.context.processingStage == Service.ProcessingStage.AVAILABLE) ** break block21
                            failure = new IllegalStateException("Service can not be paused, in stage: " + (Object)this.context.processingStage);
                            // MONITOREXIT @DISABLED, blocks:[2, 6] lbl18 : MonitorExitStatement: MONITOREXIT : var4_4
                            if (failure == null) break block22;
                        }
                        throw failure;
                    }
                    if (statName != null) {
                        this.adjustStat(statName, 1.0);
                    }
                    return;
                    {
                        if (!this.context.isUpdateActive && this.context.operationQueue.isEmpty()) ** break block23
                        failure = new IllegalStateException("Service has active updates");
                        // MONITOREXIT @DISABLED, blocks:[3, 6] lbl27 : MonitorExitStatement: MONITOREXIT : var4_4
                        if (failure == null) break block24;
                    }
                    throw failure;
                }
                if (statName != null) {
                    this.adjustStat(statName, 1.0);
                }
                return;
                {
                    block26: {
                        statName = "pauseCount";
                        break block26;
lbl43:
                        // 1 sources

                        if (this.context.processingStage == Service.ProcessingStage.PAUSED && stage == Service.ProcessingStage.AVAILABLE) {
                            statName = "resumeCount";
                            this.context.isUpdateActive = false;
                        } else if (this.context.processingStage.ordinal() > stage.ordinal()) {
                            throw new IllegalArgumentException((Object)this.context.processingStage + " can not move to " + (Object)stage);
                        }
                    }
                    this.context.processingStage = stage;
                    // MONITOREXIT @DISABLED, blocks:[4, 5, 6] lbl44 : MonitorExitStatement: MONITOREXIT : var4_4
                    {
                        catch (Throwable var5_5) {
                            throw var5_5;
                        }
                    }
                    if (failure == null) break block25;
                }
                throw failure;
            }
            if (statName != null) {
                this.adjustStat(statName, 1.0);
            }
            break block27;
            {
                catch (Throwable var6_6) {
                    if (failure != null) {
                        throw failure;
                    }
                    if (statName != null) {
                        this.adjustStat(statName, 1.0);
                    }
                    throw var6_6;
                }
            }
        }
        if (stage == Service.ProcessingStage.AVAILABLE) {
            this.getHost().processPendingServiceAvailableOperations(this, null);
        }
    }

    @Override
    public Service getUtilityService(String uriPath) {
        this.allocateUtilityService(true);
        return this.context.utilityService;
    }

    @Override
    public void sendRequest(Operation op) {
        this.prepareRequest(op);
        this.context.host.sendRequest(op);
    }

    private void prepareRequest(Operation op) {
        if (this.hasOption(Service.ServiceOption.REPLICATION)) {
            op.setTargetReplicated(true);
        }
        op.setReferer(UriUtils.buildUri(this.getHost().getPublicUri(), this.getSelfLink()));
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        ServiceDocument d;
        Class<? extends ServiceDocument> type = this.context.stateType;
        try {
            d = type.newInstance();
        }
        catch (Throwable e) {
            this.logSevere(e);
            throw new RuntimeException(e);
        }
        d.documentDescription = this.getHost().buildDocumentDescription(this);
        for (ServiceDocumentDescription.PropertyDescription pd : d.documentDescription.propertyDescriptions.values()) {
            try {
                pd.accessor.set(d, pd.exampleValue);
            }
            catch (IllegalArgumentException e) {
                String msg = String.format("Cannot assign exampleValue: '%s' to field: %s of type: %s", pd.exampleValue, pd.accessor.getName(), pd.accessor.getType());
                this.logSevere(msg, new Object[0]);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable e) {
                this.logSevere(e);
                throw new RuntimeException(e);
            }
        }
        d.documentKind = Utils.buildKind(type);
        return d;
    }

    public void logSevere(Throwable e) {
        this.doLogging(Level.SEVERE, () -> Utils.toString(e));
    }

    public void logSevere(String fmt, Object ... args) {
        this.doLogging(Level.SEVERE, () -> String.format(fmt, args));
    }

    public void logSevere(Supplier<String> messageSupplier) {
        this.doLogging(Level.SEVERE, messageSupplier);
    }

    public void logInfo(String fmt, Object ... args) {
        this.doLogging(Level.INFO, () -> String.format(fmt, args));
    }

    public void logInfo(Supplier<String> messageSupplier) {
        this.doLogging(Level.INFO, messageSupplier);
    }

    public void logFine(String fmt, Object ... args) {
        this.doLogging(Level.FINE, () -> String.format(fmt, args));
    }

    public void logFine(Supplier<String> messageSupplier) {
        this.doLogging(Level.FINE, messageSupplier);
    }

    public void logWarning(String fmt, Object ... args) {
        this.doLogging(Level.WARNING, () -> String.format(fmt, args));
    }

    public void logWarning(Supplier<String> messageSupplier) {
        this.doLogging(Level.WARNING, messageSupplier);
    }

    public void log(Level level, String fmt, Object ... args) {
        this.doLogging(level, () -> String.format(fmt, args));
    }

    public void log(Level level, Supplier<String> messageSupplier) {
        this.doLogging(level, messageSupplier);
    }

    protected void doLogging(Level level, Supplier<String> messageSupplier) {
        String uri = this.context.host != null && this.getUri() != null ? this.getUri().toString() : this.getClass().getSimpleName();
        Logger lg = Logger.getLogger(this.getClass().getName());
        Utils.log(lg, 3, uri, level, messageSupplier);
    }

    @Override
    public void handleMaintenance(Operation post) {
        ServiceMaintenanceRequest request = post.getBody(ServiceMaintenanceRequest.class);
        if (request.reasons.contains((Object)ServiceMaintenanceRequest.MaintenanceReason.PERIODIC_SCHEDULE)) {
            this.handlePeriodicMaintenance(post);
        } else if (request.reasons.contains((Object)ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE)) {
            this.handleNodeGroupMaintenance(post);
        } else {
            post.complete();
        }
    }

    public void handlePeriodicMaintenance(Operation post) {
        post.complete();
    }

    public void handleNodeGroupMaintenance(Operation post) {
        post.complete();
    }

    @Override
    public ServiceDocument setInitialState(String jsonState, Long version) {
        ServiceDocument s = Utils.fromJson(jsonState, this.context.stateType);
        if (version != null) {
            s.documentVersion = this.context.version = version.longValue();
        } else {
            this.context.version = s.documentVersion;
        }
        if (this.hasOption(Service.ServiceOption.OWNER_SELECTION) && s.documentEpoch == null) {
            s.documentEpoch = 0L;
        }
        if (s.documentEpoch != null) {
            this.context.epoch = Math.max(this.context.epoch, s.documentEpoch);
        }
        return s;
    }

    @Override
    public String getPeerNodeSelectorPath() {
        return this.context.nodeSelectorLink;
    }

    @Override
    public void setPeerNodeSelectorPath(String link) {
        if (!this.hasOption(Service.ServiceOption.REPLICATION)) {
            throw new IllegalStateException("Service is not replicated");
        }
        if (link == null) {
            throw new IllegalArgumentException("link is required");
        }
        this.context.nodeSelectorLink = link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumSet<Service.ServiceOption> getOptions() {
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            return this.context.options.clone();
        }
    }

    @Override
    public void setState(Operation op, ServiceDocument newState) {
        op.linkState(newState);
    }

    @Override
    public <T extends ServiceDocument> T getState(Operation op) {
        return (T)op.getLinkedState();
    }

    protected boolean checkForBody(Operation operation) {
        if (!operation.hasBody()) {
            operation.fail(new IllegalArgumentException("body is required"));
            return false;
        }
        return true;
    }

    protected <T extends ServiceDocument> T getBody(Operation op) {
        ServiceDocument body = op.getBody(this.context.stateType);
        return (T)body;
    }

    protected String getSelfId() {
        return Service.getId(this.getSelfLink());
    }

    public void setAvailable(boolean isAvailable) {
        this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        this.setStat("isAvailable", isAvailable ? 1.0 : 0.0);
    }

    public boolean isAvailable() {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return true;
        }
        if (this.getProcessingStage() != Service.ProcessingStage.PAUSED && this.getProcessingStage() != Service.ProcessingStage.AVAILABLE) {
            return false;
        }
        ServiceStats.ServiceStat st = this.getStat("isAvailable");
        return st != null && st.latestValue == 1.0;
    }

    @Override
    public void setMaintenanceIntervalMicros(long micros) {
        if (micros < 0L) {
            throw new IllegalArgumentException("micros must be positive");
        }
        if (micros > 0L && micros < Service.MIN_MAINTENANCE_INTERVAL_MICROS) {
            this.logWarning("Maintenance interval %d is less than the minimum interval %d, reducing to min interval", micros, Service.MIN_MAINTENANCE_INTERVAL_MICROS);
            micros = Service.MIN_MAINTENANCE_INTERVAL_MICROS;
        }
        this.context.maintenanceInterval = micros;
    }

    @Override
    public long getMaintenanceIntervalMicros() {
        return this.context.maintenanceInterval;
    }

    @Override
    public Class<? extends ServiceDocument> getStateType() {
        return this.context.stateType;
    }

    public boolean isConfigurationUpdate(Operation request) {
        if (request.getAction() == Service.Action.GET || request.getAction() == Service.Action.DELETE) {
            return false;
        }
        if (!request.hasBody()) {
            return false;
        }
        ServiceConfigUpdateRequest body = request.getBody(ServiceConfigUpdateRequest.class);
        return ServiceConfigUpdateRequest.KIND.equals(body.kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConfigurationRequest(Operation request) {
        if (request.getAction() == Service.Action.PATCH) {
            this.allocateUtilityService(true);
            ServiceConfigUpdateRequest body = request.getBody(ServiceConfigUpdateRequest.class);
            RuntimeContext runtimeContext = this.context;
            synchronized (runtimeContext) {
                if (body.epoch != null) {
                    if (this.context.epoch >= body.epoch) {
                        request.fail(new IllegalArgumentException("New epoch is less or equal to current epoch: " + this.context.epoch));
                        return;
                    }
                    this.context.epoch = body.epoch;
                    this.logFine("Epoch updated to %d", this.context.epoch);
                }
            }
            if (body.operationQueueLimit != null) {
                this.setOperationQueueLimit(body.operationQueueLimit);
            }
            this.context.utilityService.handlePatchConfiguration(request, body);
            return;
        }
        if (request.getAction() == Service.Action.GET) {
            ServiceConfiguration cfg = new ServiceConfiguration();
            cfg.options = this.getOptions();
            cfg.maintenanceIntervalMicros = this.getMaintenanceIntervalMicros();
            cfg.epoch = this.context.epoch;
            cfg.operationQueueLimit = this.context.operationQueue.getLimit();
            request.setBody(cfg).complete();
            return;
        }
        this.getHost().failRequestActionNotSupported(request);
    }

    public final void setAuthorizationContext(Operation op, Operation.AuthorizationContext ctx) {
        if (!this.getHost().isPrivilegedService(this)) {
            throw new RuntimeException("Service not allowed to set authorization context");
        }
        op.setAuthorizationContext(ctx);
    }

    public final Signer getTokenSigner() {
        if (this.getHost().isPrivilegedService(this)) {
            return this.getHost().getTokenSigner();
        }
        throw new RuntimeException("Service not allowed to get token signer");
    }

    public final Operation.AuthorizationContext getSystemAuthorizationContext() {
        if (this.getHost().isPrivilegedService(this)) {
            return this.getHost().getSystemAuthorizationContext();
        }
        throw new RuntimeException("Service not allowed to get system authorization context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPendingTransaction(String txCoordinatorLink) {
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            if (this.context.txCoordinatorLinks == null) {
                this.context.txCoordinatorLinks = new HashSet<String>();
            }
            this.context.txCoordinatorLinks.add(txCoordinatorLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePendingTransaction(String txCoordinatorLink) {
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            if (this.context.txCoordinatorLinks == null) {
                return;
            }
            this.context.txCoordinatorLinks.remove(txCoordinatorLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getPendingTransactions() {
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            return this.context.txCoordinatorLinks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPendingTransactions() {
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            return this.context.txCoordinatorLinks != null && !this.context.txCoordinatorLinks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocatePendingTransactions() {
        RuntimeContext runtimeContext = this.context;
        synchronized (runtimeContext) {
            if (this.context.txCoordinatorLinks == null) {
                this.context.txCoordinatorLinks = new HashSet<String>();
            }
        }
    }

    private static class RuntimeContext {
        public Service.ProcessingStage processingStage = Service.ProcessingStage.CREATED;
        public String selfLink;
        public long version;
        public long epoch;
        public EnumSet<Service.ServiceOption> options = EnumSet.noneOf(Service.ServiceOption.class);
        public Class<? extends ServiceDocument> stateType;
        public long maintenanceInterval;
        public OperationQueue operationQueue;
        public boolean isUpdateActive;
        public int getActiveCount;
        public transient ServiceHost host;
        public transient OperationProcessingChain opProcessingChain;
        public UtilityService utilityService;
        public String nodeSelectorLink = "/core/node-selectors/default";
        public Set<String> txCoordinatorLinks;

        private RuntimeContext() {
        }
    }
}

