/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.google.gson.JsonSyntaxException;
import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceRequestSender;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.SystemUserService;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import javax.security.cert.X509Certificate;

public class Operation
implements Cloneable {
    private static final int TO_STRING_SERIALIZED_BODY_LIMIT = 256;
    public static final String REFERER_HEADER = "referer";
    public static final String CONTENT_TYPE_HEADER = "content-type";
    public static final String CONTENT_RANGE_HEADER = "content-range";
    public static final String RANGE_HEADER = "range";
    public static final String RETRY_AFTER_HEADER = "retry-after";
    public static final String PRAGMA_HEADER = "pragma";
    public static final String SET_COOKIE_HEADER = "set-cookie";
    public static final String LOCATION_HEADER = "location";
    public static final String USER_AGENT_HEADER = "user-agent";
    public static final String ACCEPT_HEADER = "accept";
    public static final String HEADER_NAME_PREFIX = "x-xenon-";
    public static final String CONTEXT_ID_HEADER = "x-xenon-ctx-id";
    public static final String REQUEST_CALLBACK_LOCATION_HEADER = "x-xenon-req-location";
    public static final String RESPONSE_CALLBACK_STATUS_HEADER = "x-xenon-rsp-status";
    public static final String REQUEST_AUTH_TOKEN_HEADER = "x-xenon-auth-token";
    public static final String REPLICATION_PHASE_HEADER = "x-xenon-rpl-phase";
    public static final String REPLICATION_QUORUM_HEADER = "x-xenon-rpl-quorum";
    public static final String REPLICATION_QUORUM_HEADER_VALUE_ALL = "x-xenon-all";
    public static final String TRANSACTION_HEADER = "x-xenon-tx-phase";
    public static final String TRANSACTION_ID_HEADER = "x-xenon-tx-id";
    public static final String PRAGMA_DIRECTIVE_CREATED = "xn-created";
    public static final String PRAGMA_DIRECTIVE_FORWARDED = "xn-fwd";
    public static final String PRAGMA_DIRECTIVE_REPLICATED = "xn-rpl";
    public static final String PRAGMA_DIRECTIVE_SYNCH = "xn-synch";
    public static final String PRAGMA_DIRECTIVE_QUEUE_FOR_SERVICE_AVAILABILITY = "xn-queue";
    public static final String PRAGMA_DIRECTIVE_NO_FORWARDING = "xn-no-fwd";
    public static final String PRAGMA_DIRECTIVE_NOTIFICATION = "xn-nt";
    public static final String PRAGMA_DIRECTIVE_SKIPPED_NOTIFICATIONS = "xn-nt-skipped";
    public static final String PRAGMA_DIRECTIVE_USE_HTTP2 = "xn-use-http2";
    public static final String PRAGMA_DIRECTIVE_VERSION_CHECK = "xn-check-version";
    public static final String PRAGMA_DIRECTIVE_INDEX_CHECK = "xn-check-index";
    public static final String PRAGMA_DIRECTIVE_FORCE_INDEX_UPDATE = "xn-force-index-update";
    public static final String PRAGMA_DIRECTIVE_NO_INDEX_UPDATE = "xn-no-index-update";
    public static final String PRAGMA_DIRECTIVE_POST_TO_PUT = "xn-post-to-put";
    public static final String TX_TRY_COMMIT = "try-commit";
    public static final String TX_ENSURE_COMMIT = "ensure-commit";
    public static final String TX_COMMIT = "commit";
    public static final String TX_ABORT = "abort";
    public static final String REPLICATION_PHASE_COMMIT = "commit";
    public static final String MEDIA_TYPE_APPLICATION_JSON = "application/json";
    public static final String MEDIA_TYPE_TEXT_YAML = "text/x-yaml";
    public static final String MEDIA_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MEDIA_TYPE_APPLICATION_X_WWW_FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String MEDIA_TYPE_TEXT_HTML = "text/html";
    public static final String MEDIA_TYPE_TEXT_PLAIN = "text/plain";
    public static final String MEDIA_TYPE_TEXT_CSS = "text/css";
    public static final String MEDIA_TYPE_APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String MEDIA_TYPE_IMAGE_SVG_XML = "image/svg+xml";
    public static final String MEDIA_TYPE_APPLICATION_FONT_WOFF2 = "application/font-woff2";
    public static final int STATUS_CODE_SERVER_FAILURE_THRESHOLD = 500;
    public static final int STATUS_CODE_FAILURE_THRESHOLD = 400;
    public static final int STATUS_CODE_UNAUTHORIZED = 401;
    public static final int STATUS_CODE_UNAVAILABLE = 503;
    public static final int STATUS_CODE_FORBIDDEN = 403;
    public static final int STATUS_CODE_TIMEOUT = 408;
    public static final int STATUS_CODE_CONFLICT = 409;
    public static final int STATUS_CODE_NOT_MODIFIED = 304;
    public static final int STATUS_CODE_NOT_FOUND = 404;
    public static final int STATUS_CODE_MOVED_PERM = 301;
    public static final int STATUS_CODE_MOVED_TEMP = 302;
    public static final int STATUS_CODE_OK = 200;
    public static final int STATUS_CODE_CREATED = 201;
    public static final int STATUS_CODE_ACCEPTED = 202;
    public static final int STATUS_CODE_BAD_REQUEST = 400;
    public static final int STATUS_CODE_BAD_METHOD = 405;
    public static final String MEDIA_TYPE_EVERYTHING_WILDCARDS = "*/*";
    public static final String EMPTY_JSON_BODY = "{}";
    public static final String HEADER_FIELD_VALUE_SEPARATOR = ":";
    public static final String CR_LF = "\r\n";
    private static AtomicLong idCounter = new AtomicLong();
    private static AtomicReferenceFieldUpdater<Operation, CompletionHandler> completionUpdater = AtomicReferenceFieldUpdater.newUpdater(Operation.class, CompletionHandler.class, "completion");
    private URI uri;
    private URI referer;
    private final long id = idCounter.incrementAndGet();
    private int statusCode = 200;
    private Service.Action action;
    private ServiceDocument linkedState;
    private volatile CompletionHandler completion;
    private String contextId;
    private String transactionId;
    private long expirationMicrosUtc;
    private Object body;
    private Object serializedBody;
    private String contentType = "application/json";
    private long contentLength;
    private RemoteContext remoteCtx;
    private AuthorizationContext authorizationCtx;
    private InstrumentationContext instrumentationCtx;
    private Map<String, String> cookies;
    private short retryCount;
    private short retriesRemaining;
    public EnumSet<OperationOption> options = EnumSet.noneOf(OperationOption.class);

    public static Operation create(SerializedOperation ctx, ServiceHost host) {
        Operation op = new Operation();
        op.action = ctx.action;
        op.body = ctx.jsonBody;
        op.expirationMicrosUtc = ctx.documentExpirationTimeMicros;
        op.setContextId(ctx.id.toString());
        op.referer = ctx.referer;
        op.uri = UriUtils.buildUri(host, ctx.path, ctx.query);
        op.transactionId = ctx.transactionId;
        return op;
    }

    static Operation createOperation(Service.Action action, URI uri) {
        Operation op = new Operation();
        op.uri = uri;
        op.action = action;
        op.authorizationCtx = OperationContext.getAuthorizationContext();
        return op;
    }

    public static Operation createPost(Service sender, String targetPath) {
        return Operation.createPost(sender.getHost(), targetPath);
    }

    public static Operation createPost(ServiceHost sender, String targetPath) {
        return Operation.createPost(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createPost(URI uri) {
        return Operation.createOperation(Service.Action.POST, uri);
    }

    public static Operation createPatch(Service sender, String targetPath) {
        return Operation.createPatch(sender.getHost(), targetPath);
    }

    public static Operation createPatch(ServiceHost sender, String targetPath) {
        return Operation.createPatch(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createPatch(URI uri) {
        return Operation.createOperation(Service.Action.PATCH, uri);
    }

    public static Operation createPut(Service sender, String targetPath) {
        return Operation.createPut(UriUtils.buildUri(sender.getHost(), targetPath));
    }

    public static Operation createPut(ServiceHost sender, String targetPath) {
        return Operation.createPut(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createPut(URI uri) {
        return Operation.createOperation(Service.Action.PUT, uri);
    }

    public static Operation createOptions(Service sender, String targetPath) {
        return Operation.createOptions(UriUtils.buildUri(sender.getHost(), targetPath));
    }

    public static Operation createOptions(ServiceHost sender, String targetPath) {
        return Operation.createOptions(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createOptions(URI uri) {
        return Operation.createOperation(Service.Action.OPTIONS, uri);
    }

    public static Operation createDelete(Service sender, String targetPath) {
        return Operation.createDelete(UriUtils.buildUri(sender.getHost(), targetPath));
    }

    public static Operation createDelete(ServiceHost sender, String targetPath) {
        return Operation.createDelete(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createDelete(URI uri) {
        return Operation.createOperation(Service.Action.DELETE, uri);
    }

    public static Operation createGet(Service sender, String targetPath) {
        return Operation.createGet(UriUtils.buildUri(sender.getHost(), targetPath));
    }

    public static Operation createGet(ServiceHost sender, String targetPath) {
        return Operation.createGet(UriUtils.buildUri(sender, targetPath));
    }

    public static Operation createGet(URI uri) {
        return Operation.createOperation(Service.Action.GET, uri);
    }

    public void sendWith(ServiceRequestSender sender) {
        sender.sendRequest(this);
    }

    public String toString() {
        SerializedOperation sop = SerializedOperation.create(this);
        if (sop.jsonBody != null && sop.jsonBody.length() > 256) {
            sop.jsonBody = sop.jsonBody.substring(0, 256);
        }
        return Utils.toJsonHtml(sop);
    }

    public Operation clone() {
        Operation clone;
        try {
            clone = (Operation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = new Operation();
        }
        clone.options = EnumSet.copyOf(this.options);
        clone.action = this.action;
        clone.completion = this.completion;
        clone.expirationMicrosUtc = this.expirationMicrosUtc;
        clone.referer = this.referer;
        clone.uri = this.uri;
        clone.contentLength = this.contentLength;
        clone.contentType = this.contentType;
        clone.retriesRemaining = this.retriesRemaining;
        clone.retryCount = this.retryCount;
        if (this.cookies != null) {
            clone.cookies = new HashMap<String, String>(this.cookies);
        }
        if (this.remoteCtx != null) {
            clone.remoteCtx = new RemoteContext();
            clone.remoteCtx.socketCtx = null;
            if (!this.remoteCtx.requestHeaders.isEmpty()) {
                clone.remoteCtx.requestHeaders = new HashMap<String, String>(this.remoteCtx.requestHeaders);
            }
            clone.remoteCtx.peerPrincipal = this.remoteCtx.peerPrincipal;
            if (this.remoteCtx.peerCertificateChain != null) {
                clone.remoteCtx.peerCertificateChain = Arrays.copyOf(this.remoteCtx.peerCertificateChain, this.remoteCtx.peerCertificateChain.length);
            }
        }
        clone.authorizationCtx = this.authorizationCtx;
        clone.transactionId = this.transactionId;
        clone.contextId = this.contextId;
        clone.body = this.body;
        return clone;
    }

    private void allocateRemoteContext() {
        if (this.remoteCtx != null) {
            return;
        }
        this.remoteCtx = new RemoteContext();
    }

    public boolean isRemote() {
        return this.remoteCtx != null && this.remoteCtx.socketCtx != null;
    }

    public Operation forceRemote() {
        this.allocateRemoteContext();
        this.remoteCtx.socketCtx = new SocketContext();
        return this;
    }

    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationCtx;
    }

    Operation setAuthorizationContext(AuthorizationContext ctx) {
        this.authorizationCtx = ctx;
        return this;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Operation setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public boolean isWithinTransaction() {
        return this.transactionId != null;
    }

    public String getContextId() {
        return this.contextId;
    }

    public Operation setContextId(String id) {
        this.contextId = id;
        return this;
    }

    public Operation setBody(Object body) {
        this.body = body != null ? (this.isCloningDisabled() ? body : Utils.clone(body)) : null;
        return this;
    }

    public Operation setStatusCode(int code) {
        this.statusCode = code;
        return this;
    }

    public Operation setBodyNoCloning(Object body) {
        this.body = body;
        return this;
    }

    public <T> T getBody(Class<T> type) {
        if (this.body != null && this.body.getClass() == type) {
            return (T)this.body;
        }
        if (this.body != null && !(this.body instanceof String)) {
            if (this.isRemote() && (this.contentType == null || !this.contentType.contains(MEDIA_TYPE_APPLICATION_JSON))) {
                throw new IllegalStateException("content type is not JSON: " + this.contentType);
            }
            if (this.serializedBody != null) {
                this.body = this.serializedBody;
            } else {
                String json = Utils.toJson(this.body);
                return Utils.fromJson(json, type);
            }
        }
        if (this.body != null) {
            if (this.body instanceof String) {
                this.serializedBody = this.body;
            }
            if (this.contentType != null && this.contentType.contains(MEDIA_TYPE_APPLICATION_JSON)) {
                try {
                    this.body = Utils.fromJson(this.body, type);
                }
                catch (JsonSyntaxException e) {
                    throw new IllegalArgumentException("Unparseable JSON body: " + e.getMessage());
                }
            } else {
                throw new IllegalArgumentException("Unrecognized Content-Type for parsing request body: " + this.contentType);
            }
            return (T)this.body;
        }
        throw new IllegalStateException();
    }

    public Object getBodyRaw() {
        return this.body;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Operation setContentLength(long l) {
        this.contentLength = l;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Operation setContentType(String type) {
        this.contentType = type;
        return this;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public int getRetriesRemaining() {
        return this.retriesRemaining;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int incrementRetryCount() {
        this.retryCount = (short)(this.retryCount + 1);
        return this.retryCount;
    }

    public Operation setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount must be positive");
        }
        if (retryCount > Short.MAX_VALUE) {
            throw new IllegalArgumentException("retryCount must be less than 32767");
        }
        this.retryCount = (short)retryCount;
        this.retriesRemaining = (short)retryCount;
        return this;
    }

    public Operation setCompletion(CompletionHandler completion) {
        this.completion = completion;
        return this;
    }

    public Operation setCompletion(Consumer<Operation> successHandler, CompletionHandler failureHandler) {
        this.setCompletion((op, e) -> {
            if (e != null) {
                failureHandler.handle(op, e);
                return;
            }
            successHandler.accept(op);
        });
        return this;
    }

    public CompletionHandler getCompletion() {
        return this.completion;
    }

    public Operation setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    Operation linkState(ServiceDocument serviceDoc) {
        if (serviceDoc != null && this.linkedState != null && this.linkedState.documentKind != null) {
            serviceDoc.documentKind = this.linkedState.documentKind;
        }
        this.linkedState = serviceDoc;
        return this;
    }

    ServiceDocument getLinkedState() {
        return this.linkedState;
    }

    public Operation setReferer(URI uri) {
        this.referer = uri;
        return this;
    }

    public URI getReferer() {
        return this.referer;
    }

    public Operation setAction(Service.Action action) {
        this.action = action;
        return this;
    }

    public Service.Action getAction() {
        return this.action;
    }

    public long getId() {
        return this.id;
    }

    public Operation setSocketContext(SocketContext socketContext) {
        this.allocateRemoteContext();
        this.remoteCtx.socketCtx = socketContext;
        return this;
    }

    public SocketContext getSocketContext() {
        return this.remoteCtx == null ? null : this.remoteCtx.socketCtx;
    }

    public long getExpirationMicrosUtc() {
        return this.expirationMicrosUtc;
    }

    public Operation setExpiration(long futureMicrosUtc) {
        this.expirationMicrosUtc = futureMicrosUtc;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void complete() {
        this.completeOrFail(null);
    }

    public void fail(Throwable e) {
        this.fail(e, null);
    }

    public void fail(int statusCode) {
        this.setStatusCode(statusCode);
        switch (statusCode) {
            case 403: {
                this.fail(new IllegalAccessError("forbidden"));
                break;
            }
            default: {
                this.fail(new Exception("request failed, no additional details provided"));
            }
        }
    }

    public void fail(Throwable e, Object failureBody) {
        ServiceErrorResponse rsp;
        if (this.statusCode < 400) {
            this.statusCode = 500;
        }
        if (e instanceof TimeoutException) {
            this.statusCode = 408;
        }
        if (failureBody != null) {
            this.setBodyNoCloning(failureBody);
        }
        boolean hasErrorResponseBody = false;
        if (this.body != null && this.body instanceof String) {
            if (MEDIA_TYPE_APPLICATION_JSON.equals(this.contentType)) {
                try {
                    rsp = Utils.fromJson(this.body, ServiceErrorResponse.class);
                    if (rsp.message != null) {
                        hasErrorResponseBody = true;
                    }
                }
                catch (Throwable rsp2) {}
            } else {
                hasErrorResponseBody = true;
            }
        }
        if (this.body != null && this.body instanceof byte[]) {
            hasErrorResponseBody = true;
        }
        if (this.body == null || !hasErrorResponseBody && !(this.body instanceof ServiceErrorResponse)) {
            if (Utils.isValidationError(e)) {
                this.statusCode = 400;
                rsp = Utils.toValidationErrorResponse(e);
            } else {
                rsp = Utils.toServiceErrorResponse(e);
            }
            rsp.statusCode = this.statusCode;
            this.setBodyNoCloning(rsp).setContentType(MEDIA_TYPE_APPLICATION_JSON);
        }
        this.completeOrFail(e);
    }

    private void completeOrFail(Throwable e) {
        CompletionHandler c = this.completion;
        if (c == null) {
            return;
        }
        if (!completionUpdater.compareAndSet(this, c, null)) {
            Utils.logWarning("%s:%s", Utils.toString(new IllegalStateException("double completion")), this.toString());
            return;
        }
        AuthorizationContext originalContext = OperationContext.getAuthorizationContext();
        OperationContext.setAuthorizationContext(this.getAuthorizationContext());
        try {
            OperationContext.setContextId(this.contextId);
            c.handle(this, e);
        }
        catch (Throwable outer) {
            Utils.logWarning("Uncaught failure inside completion: %s", Utils.toString(outer));
        }
        OperationContext.setAuthorizationContext(originalContext);
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public Operation nestCompletion(CompletionHandler h) {
        CompletionHandler existing = this.completion;
        this.setCompletion((o, e) -> {
            this.statusCode = o.statusCode;
            this.completion = existing;
            h.handle(o, e);
        });
        return this;
    }

    public void nestCompletion(Consumer<Operation> successHandler) {
        CompletionHandler existing = this.completion;
        this.setCompletion((o, e) -> {
            this.statusCode = o.statusCode;
            this.completion = existing;
            if (e != null) {
                o.fail(e);
                return;
            }
            try {
                successHandler.accept(o);
            }
            catch (Throwable ex) {
                o.fail(ex);
            }
        });
    }

    Operation addHeader(String headerLine, boolean isResponse) {
        if (headerLine == null) {
            throw new IllegalArgumentException("headerLine is required");
        }
        int idx = headerLine.indexOf(HEADER_FIELD_VALUE_SEPARATOR);
        if (idx == -1 || idx < 3) {
            throw new IllegalArgumentException("headerLine does not appear valid");
        }
        String name = headerLine.substring(0, idx);
        String value = headerLine.substring(idx + 1);
        if (isResponse) {
            this.addResponseHeader(name, value);
        } else {
            this.addRequestHeader(name, value);
        }
        return this;
    }

    public Operation addRequestHeader(String name, String value) {
        this.allocateRemoteContext();
        value = value.replace(CR_LF, "").trim();
        this.remoteCtx.requestHeaders.put(name.toLowerCase(), value);
        return this;
    }

    public Operation addResponseHeader(String name, String value) {
        this.allocateRemoteContext();
        value = value.replace(CR_LF, "");
        this.remoteCtx.responseHeaders.put(name.toLowerCase(), value);
        return this;
    }

    public Operation addResponseCookie(String key, String value) {
        StringBuilder buf = new StringBuilder().append(key).append('=').append(value);
        this.addResponseHeader(SET_COOKIE_HEADER, buf.toString());
        return this;
    }

    public Operation addPragmaDirective(String directive) {
        this.allocateRemoteContext();
        directive = directive.toLowerCase();
        String existingDirectives = this.getRequestHeader(PRAGMA_HEADER);
        if (existingDirectives != null) {
            directive = !existingDirectives.contains(directive) ? existingDirectives + ";" + directive : existingDirectives;
        }
        this.addRequestHeader(PRAGMA_HEADER, directive);
        return this;
    }

    public boolean hasPragmaDirective(String directive) {
        String existingDirectives = this.getRequestHeader(PRAGMA_HEADER);
        return existingDirectives != null && existingDirectives.contains(directive);
    }

    public Operation removePragmaDirective(String directive) {
        this.allocateRemoteContext();
        String existingDirectives = this.getRequestHeader(PRAGMA_HEADER);
        if (existingDirectives != null) {
            directive = existingDirectives.replace(directive, "");
        }
        this.addRequestHeader(PRAGMA_HEADER, directive);
        return this;
    }

    public boolean isKeepAlive() {
        return this.remoteCtx == null ? false : this.remoteCtx.isKeepAlive;
    }

    public Operation setKeepAlive(boolean isKeepAlive) {
        this.allocateRemoteContext();
        this.remoteCtx.isKeepAlive = isKeepAlive;
        return this;
    }

    void setHandlerInvokeTime(long nowMicrosUtc) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.handleInvokeTimeMicrosUtc = nowMicrosUtc;
    }

    void setEnqueueTime(long nowMicrosUtc) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.enqueueTimeMicrosUtc = nowMicrosUtc;
    }

    void setHandlerCompletionTime(long nowMicrosUtc) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.handlerCompletionTime = nowMicrosUtc;
    }

    void setDocumentStoreCompletionTime(long nowMicrosUtc) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.documentStoreCompletionTimeMicrosUtc = nowMicrosUtc;
    }

    void setCompletionTime(long nowMicrosUtc) {
        this.allocateInstrumentationContext();
        this.instrumentationCtx.operationCompletionTimeMicrosUtc = nowMicrosUtc;
    }

    private void allocateInstrumentationContext() {
        if (this.instrumentationCtx != null) {
            return;
        }
        this.instrumentationCtx = new InstrumentationContext();
    }

    InstrumentationContext getInstrumentationContext() {
        return this.instrumentationCtx;
    }

    public Operation setReplicationDisabled(boolean disable) {
        if (disable) {
            this.options.add(OperationOption.REPLICATION_DISABLED);
        } else {
            this.options.remove((Object)OperationOption.REPLICATION_DISABLED);
        }
        return this;
    }

    public boolean isReplicationDisabled() {
        return this.options.contains((Object)OperationOption.REPLICATION_DISABLED);
    }

    public Map<String, String> getRequestHeaders() {
        if (this.remoteCtx == null) {
            return new HashMap<String, String>();
        }
        return this.remoteCtx.requestHeaders;
    }

    public Map<String, String> getResponseHeaders() {
        if (this.remoteCtx == null) {
            return new HashMap<String, String>();
        }
        return this.remoteCtx.responseHeaders;
    }

    public String getRequestHeader(String headerName) {
        if (this.remoteCtx == null) {
            return null;
        }
        if (this.remoteCtx.requestHeaders == null) {
            return null;
        }
        String value = this.remoteCtx.requestHeaders.get(headerName.toLowerCase());
        if (value != null) {
            value = value.trim().replace(CR_LF, "");
        }
        return value;
    }

    public String getResponseHeader(String headerName) {
        if (this.remoteCtx == null) {
            return null;
        }
        if (this.remoteCtx.responseHeaders == null) {
            return null;
        }
        String value = this.remoteCtx.responseHeaders.get(headerName.toLowerCase());
        if (value != null) {
            value = value.trim().replace(CR_LF, "");
        }
        return value;
    }

    public Principal getPeerPrincipal() {
        return this.remoteCtx == null ? null : this.remoteCtx.peerPrincipal;
    }

    public X509Certificate[] getPeerCertificateChain() {
        return this.remoteCtx == null ? null : this.remoteCtx.peerCertificateChain;
    }

    public void setPeerCertificates(Principal peerPrincipal, X509Certificate[] certificates) {
        if (this.remoteCtx != null) {
            this.remoteCtx.peerPrincipal = peerPrincipal;
            this.remoteCtx.peerCertificateChain = certificates;
        }
    }

    public int decrementRetriesRemaining() {
        this.retriesRemaining = (short)(this.retriesRemaining - 1);
        return this.retriesRemaining;
    }

    public Operation setTargetReplicated(boolean enable) {
        if (enable) {
            this.options.add(OperationOption.REPLICATED_TARGET);
        } else {
            this.options.remove((Object)OperationOption.REPLICATED_TARGET);
        }
        return this;
    }

    public boolean isTargetReplicated() {
        return this.options.contains((Object)OperationOption.REPLICATED_TARGET);
    }

    public Operation setFromReplication(boolean isFromReplication) {
        if (isFromReplication) {
            this.options.add(OperationOption.REPLICATED);
        } else {
            this.options.remove((Object)OperationOption.REPLICATED);
        }
        return this;
    }

    public boolean isFromReplication() {
        return this.options.contains((Object)OperationOption.REPLICATED);
    }

    public boolean isForwarded() {
        return this.hasPragmaDirective(PRAGMA_DIRECTIVE_FORWARDED);
    }

    public String getRequestCallbackLocation() {
        if (this.remoteCtx == null) {
            return null;
        }
        return this.remoteCtx.requestHeaders.get(REQUEST_CALLBACK_LOCATION_HEADER);
    }

    public String getResponseCallbackStatus() {
        if (this.remoteCtx == null) {
            return null;
        }
        return this.remoteCtx.requestHeaders.get(RESPONSE_CALLBACK_STATUS_HEADER);
    }

    public Operation removeRequestCallbackLocation() {
        this.allocateRemoteContext();
        this.remoteCtx.requestHeaders.remove(REQUEST_CALLBACK_LOCATION_HEADER);
        return this;
    }

    public Operation setRequestCallbackLocation(URI location) {
        this.allocateRemoteContext();
        this.remoteCtx.requestHeaders.put(REQUEST_CALLBACK_LOCATION_HEADER, location == null ? null : location.toString());
        return this;
    }

    public Operation setResponseCallbackStatus(int status) {
        this.allocateRemoteContext();
        this.remoteCtx.requestHeaders.put(RESPONSE_CALLBACK_STATUS_HEADER, Integer.toString(status));
        return this;
    }

    public Operation transferResponseHeadersFrom(Operation op) {
        if (op.remoteCtx == null || op.remoteCtx.responseHeaders == null || op.remoteCtx.responseHeaders.isEmpty()) {
            return this;
        }
        this.allocateRemoteContext();
        for (Map.Entry<String, String> e : op.getResponseHeaders().entrySet()) {
            this.remoteCtx.responseHeaders.put(e.getKey(), e.getValue());
        }
        return this;
    }

    public Operation transferRequestHeadersFrom(Operation op) {
        if (op.remoteCtx == null || op.remoteCtx.requestHeaders == null || op.remoteCtx.requestHeaders.isEmpty()) {
            return this;
        }
        this.allocateRemoteContext();
        for (Map.Entry<String, String> e : op.getRequestHeaders().entrySet()) {
            this.remoteCtx.requestHeaders.put(e.getKey(), e.getValue());
        }
        return this;
    }

    public Operation transferResponseHeadersToRequestHeadersFrom(Operation op) {
        if (op.remoteCtx == null || op.remoteCtx.responseHeaders == null || op.remoteCtx.responseHeaders.isEmpty()) {
            return this;
        }
        this.allocateRemoteContext();
        for (Map.Entry<String, String> e : op.getResponseHeaders().entrySet()) {
            this.remoteCtx.requestHeaders.put(e.getKey(), e.getValue());
        }
        return this;
    }

    public Operation transferRequestHeadersToResponseHeadersFrom(Operation op) {
        if (op.remoteCtx == null || op.remoteCtx.requestHeaders == null || op.remoteCtx.requestHeaders.isEmpty()) {
            return this;
        }
        this.allocateRemoteContext();
        for (Map.Entry<String, String> e : op.getRequestHeaders().entrySet()) {
            this.remoteCtx.responseHeaders.put(e.getKey(), e.getValue());
        }
        return this;
    }

    public Operation setCloningDisabled(boolean disable) {
        this.options.add(OperationOption.CLONING_DISABLED);
        return this;
    }

    public boolean isCloningDisabled() {
        return this.options.contains((Object)OperationOption.CLONING_DISABLED);
    }

    public boolean isNotification() {
        return this.hasPragmaDirective(PRAGMA_DIRECTIVE_NOTIFICATION);
    }

    public Operation setNotificationDisabled(boolean disable) {
        if (disable) {
            this.options.add(OperationOption.NOTIFICATION_DISABLED);
        } else {
            this.options.remove((Object)OperationOption.NOTIFICATION_DISABLED);
        }
        return this;
    }

    public boolean isNotificationDisabled() {
        return this.options.contains((Object)OperationOption.NOTIFICATION_DISABLED);
    }

    boolean isForwardingDisabled() {
        return this.hasPragmaDirective(PRAGMA_DIRECTIVE_NO_FORWARDING);
    }

    boolean isCommit() {
        String phase = this.getRequestHeader(REPLICATION_PHASE_HEADER);
        return "commit".equals(phase);
    }

    boolean isSynchronize() {
        return this.hasPragmaDirective(PRAGMA_DIRECTIVE_SYNCH);
    }

    public static class SerializedOperation
    extends ServiceDocument {
        public Service.Action action;
        public String host;
        public int port;
        public String path;
        public String query;
        public Long id;
        public URI referer;
        public String jsonBody;
        public int statusCode;
        public EnumSet<OperationOption> options;
        public String contextId;
        public String transactionId;
        public static final ServiceDocumentDescription DESCRIPTION = SerializedOperation.buildDescription();
        public static final String KIND = Utils.buildKind(SerializedOperation.class);

        public static SerializedOperation create(Operation op) {
            Object body;
            SerializedOperation ctx = new SerializedOperation();
            ctx.contextId = op.getContextId();
            ctx.action = op.action;
            ctx.referer = op.referer;
            ctx.id = op.id;
            ctx.options = op.options.clone();
            ctx.transactionId = op.getTransactionId();
            if (op.uri != null) {
                ctx.host = op.uri.getHost();
                ctx.port = op.uri.getPort();
                ctx.path = op.uri.getPath();
                ctx.query = op.uri.getQuery();
            }
            ctx.jsonBody = (body = op.getBodyRaw()) instanceof String ? (String)body : Utils.toJson(body);
            ctx.documentKind = KIND;
            ctx.documentExpirationTimeMicros = op.expirationMicrosUtc;
            return ctx;
        }

        public static boolean isValid(SerializedOperation sop) {
            return sop.action != null && sop.id != null && sop.jsonBody != null && sop.path != null && sop.referer != null;
        }

        public static ServiceDocumentDescription buildDescription() {
            EnumSet<Service.ServiceOption> options = EnumSet.of(Service.ServiceOption.PERSISTENCE);
            return ServiceDocumentDescription.Builder.create().buildDescription(SerializedOperation.class, options);
        }
    }

    public static enum OperationOption {
        REPLICATED,
        REPLICATION_DISABLED,
        CLONING_DISABLED,
        NOTIFICATION_DISABLED,
        REPLICATED_TARGET;

    }

    public static final class AuthorizationContext {
        private Claims claims;
        private String token;
        private boolean propagateToClient = false;
        private Map<Service.Action, QueryTask.Query> resourceQueryMap = null;
        private Map<Service.Action, QueryFilter> resourceQueryFiltersMap = null;

        public Claims getClaims() {
            return this.claims;
        }

        public String getToken() {
            return this.token;
        }

        public boolean shouldPropagateToClient() {
            return this.propagateToClient;
        }

        public QueryTask.Query getResourceQuery(Service.Action action) {
            if (this.resourceQueryMap == null) {
                return null;
            }
            return Utils.clone(this.resourceQueryMap.get((Object)action));
        }

        public QueryFilter getResourceQueryFilter(Service.Action action) {
            if (this.resourceQueryFiltersMap == null) {
                return null;
            }
            return this.resourceQueryFiltersMap.get((Object)action);
        }

        public boolean isSystemUser() {
            Claims claims = this.getClaims();
            if (claims == null) {
                return false;
            }
            String subject = claims.getSubject();
            if (subject == null) {
                return false;
            }
            return subject.equals(SystemUserService.SELF_LINK);
        }

        public static class Builder {
            private AuthorizationContext authorizationContext;

            public static Builder create() {
                return new Builder();
            }

            private Builder() {
                this.initialize();
            }

            protected void initialize() {
                this.authorizationContext = new AuthorizationContext();
            }

            public AuthorizationContext getResult() {
                AuthorizationContext result = this.authorizationContext;
                this.initialize();
                return result;
            }

            public Builder setClaims(Claims claims) {
                this.authorizationContext.claims = claims;
                return this;
            }

            public Builder setToken(String token) {
                this.authorizationContext.token = token;
                return this;
            }

            public Builder setPropagateToClient(boolean propagateToClient) {
                this.authorizationContext.propagateToClient = propagateToClient;
                return this;
            }

            public Builder setResourceQueryMap(Map<Service.Action, QueryTask.Query> resourceQueryMap) {
                this.authorizationContext.resourceQueryMap = resourceQueryMap;
                return this;
            }

            public Builder setResourceQueryFilterMap(Map<Service.Action, QueryFilter> resourceQueryFiltersMap) {
                this.authorizationContext.resourceQueryFiltersMap = resourceQueryFiltersMap;
                return this;
            }
        }
    }

    static class RemoteContext {
        public SocketContext socketCtx;
        public Map<String, String> requestHeaders = new HashMap<String, String>();
        public Map<String, String> responseHeaders = new HashMap<String, String>();
        public Principal peerPrincipal;
        public X509Certificate[] peerCertificateChain;
        public boolean isKeepAlive;

        RemoteContext() {
        }
    }

    public static class TransactionContext {
        public Service.Action action;
        public Set<String> coordinatorLinks;
        public boolean isSuccessful;
    }

    static class InstrumentationContext {
        public long handleInvokeTimeMicrosUtc;
        public long enqueueTimeMicrosUtc;
        public long documentStoreCompletionTimeMicrosUtc;
        public long handlerCompletionTime;
        public long operationCompletionTimeMicrosUtc;

        InstrumentationContext() {
        }
    }

    public static class SocketContext {
        private long lastUseTimeMicros;
        private static int maxRequestSize = 0x1000000;
        private static final int MAX_CLIENT_REQUEST_SIZE = 0x8000000;

        public long getLastUseTimeMicros() {
            return this.lastUseTimeMicros;
        }

        public void updateLastUseTime() {
            this.lastUseTimeMicros = Utils.getNowMicrosUtc();
        }

        public void writeHttpRequest(Object request) {
            throw new IllegalStateException();
        }

        public void close() {
            throw new IllegalStateException();
        }

        public static void setMaxRequestSize(int max) {
            maxRequestSize = max;
        }

        public static int getMaxRequestSize() {
            return maxRequestSize;
        }

        public static int getMaxClientRequestSize() {
            return 0x8000000;
        }
    }

    @FunctionalInterface
    public static interface CompletionHandler {
        public void handle(Operation var1, Throwable var2);
    }
}

