/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ODataToken;
import com.vmware.xenon.common.ODataTokenList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ODataTokenizer {
    private static final Pattern BIN_OP = Pattern.compile("^(and|or) ");
    private static final Pattern BIN_COMP = Pattern.compile("^(eq|ne|lt|gt|le|ge) ");
    private static final Pattern OTHER_LIT = Pattern.compile("(?:\\p{L}|\\p{Digit}|[-._~%!$&*+;:@])+");
    private static final String ODATA_NESTED_SEPARATOR = "/";
    private static final String DEFAULT_NESTED_SEPARATOR = ".";
    int curPosition;
    final String expression;
    final int expressionLength;
    ODataTokenList tokens;

    public ODataTokenizer(String expression) {
        this.expression = expression;
        this.expressionLength = expression.length();
        this.tokens = new ODataTokenList();
    }

    public ODataTokenList tokenize() throws IllegalArgumentException {
        this.curPosition = 0;
        String token = "";
        block8: while (this.curPosition < this.expressionLength) {
            boolean isLiteral;
            boolean isBoolean;
            boolean isAndOr;
            int oldPosition = this.curPosition;
            char curCharacter = this.expression.charAt(this.curPosition);
            switch (curCharacter) {
                case ' ': {
                    this.eatWhiteSpaces(curCharacter);
                    continue block8;
                }
                case '(': {
                    this.tokens.appendODataToken(this.curPosition, ODataToken.ODataTokenKind.OPENPAREN, curCharacter);
                    ++this.curPosition;
                    continue block8;
                }
                case ')': {
                    this.tokens.appendODataToken(this.curPosition, ODataToken.ODataTokenKind.CLOSEPAREN, curCharacter);
                    ++this.curPosition;
                    continue block8;
                }
                case '\'': {
                    token = "";
                    this.readLiteral(curCharacter);
                    continue block8;
                }
                case ',': {
                    this.tokens.appendODataToken(oldPosition, ODataToken.ODataTokenKind.COMMA, curCharacter);
                    ++this.curPosition;
                    continue block8;
                }
                case '=': 
                case '?': {
                    ++this.curPosition;
                    this.tokens.appendODataToken(oldPosition, ODataToken.ODataTokenKind.SYMBOL, curCharacter);
                    continue block8;
                }
            }
            String rem_expr = this.expression.substring(this.curPosition);
            boolean isBinary = this.checkForBinary(oldPosition, rem_expr);
            if (isBinary || (isAndOr = this.checkForAndOrOperator(oldPosition, rem_expr)) || (isBoolean = this.checkForBoolean(oldPosition, rem_expr)) || (isLiteral = this.checkForLiteral(oldPosition, curCharacter, rem_expr))) continue;
            token = Character.toString(curCharacter);
            throw new IllegalArgumentException("Unknown character: " + oldPosition + ' ' + token + ' ' + this.expression);
        }
        return this.tokens;
    }

    private boolean checkForLiteral(int oldPosition, char curCharacter, String rem_expr) {
        String normalizedExpr = rem_expr.replace(ODATA_NESTED_SEPARATOR, DEFAULT_NESTED_SEPARATOR);
        Matcher matcher = OTHER_LIT.matcher(normalizedExpr);
        boolean isLiteral = false;
        if (matcher.lookingAt()) {
            String token = matcher.group();
            this.curPosition += token.length();
            this.tokens.appendODataToken(oldPosition, ODataToken.ODataTokenKind.SIMPLE_TYPE, token);
            isLiteral = true;
        }
        return isLiteral;
    }

    private boolean checkForBoolean(int oldPosition, String rem_expr) {
        boolean isBoolean = false;
        if (rem_expr.equals("true") || rem_expr.equals("false")) {
            this.curPosition += rem_expr.length();
            this.tokens.appendODataToken(oldPosition, ODataToken.ODataTokenKind.SIMPLE_TYPE, rem_expr);
            isBoolean = true;
        }
        return isBoolean;
    }

    private void eatWhiteSpaces(char curCharacter) {
        while (curCharacter == ' ' && this.curPosition < this.expressionLength) {
            ++this.curPosition;
            if (this.curPosition >= this.expressionLength) continue;
            curCharacter = this.expression.charAt(this.curPosition);
        }
    }

    private boolean checkForBinary(int oldPosition, String rem_expr) {
        boolean isBinary = false;
        Matcher matcher1 = BIN_COMP.matcher(rem_expr);
        if (matcher1.find()) {
            String token = matcher1.group(1);
            this.curPosition += token.length();
            this.tokens.appendODataToken(oldPosition, ODataToken.ODataTokenKind.BINARY_COMPARISON, token);
            isBinary = true;
        }
        return isBinary;
    }

    private boolean checkForAndOrOperator(int oldPosition, String rem_expr) {
        boolean isBinary = false;
        Matcher matcher1 = BIN_OP.matcher(rem_expr);
        if (matcher1.find()) {
            String token = matcher1.group(1);
            this.curPosition += token.length();
            this.tokens.appendODataToken(oldPosition, ODataToken.ODataTokenKind.BINARY_OPERATOR, token);
            isBinary = true;
        }
        return isBinary;
    }

    private void readLiteral(char curCharacter) {
        this.readLiteral(curCharacter, "");
    }

    private void readLiteral(char curCharacter, String token) throws IllegalArgumentException {
        int offsetPos = -token.length();
        int oldPosition = this.curPosition++;
        StringBuilder sb = new StringBuilder();
        sb.append(token).append(Character.toString(curCharacter));
        boolean wasApostroph = false;
        while (this.curPosition < this.expressionLength) {
            curCharacter = this.expression.charAt(this.curPosition);
            if (curCharacter != '\'') {
                if (wasApostroph) break;
                wasApostroph = false;
            } else {
                wasApostroph = !wasApostroph;
            }
            sb.append(curCharacter);
            ++this.curPosition;
        }
        if (!wasApostroph) {
            throw new IllegalArgumentException("undetermined string " + this.expression);
        }
        this.tokens.appendODataToken(oldPosition + offsetPos, ODataToken.ODataTokenKind.SIMPLE_TYPE, sb.toString());
    }
}

