/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static URL findResource(List<Path> searchPath, Path resource) throws MalformedURLException {
        for (Path p : searchPath) {
            URI u = p.resolve(resource).toUri();
            File f = new File(p.resolve(resource).toString());
            if (!f.exists()) continue;
            return u.toURL();
        }
        return FileUtils.class.getClassLoader().getResource(resource.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourceEntry> findResources(Class<?> clazz, String prefix) throws URISyntaxException, IllegalArgumentException, IOException {
        File f;
        prefix = prefix.replace('\\', '/');
        URL url = clazz.getClassLoader().getResource(prefix);
        if (url != null && url.getProtocol().equals("file") && (f = new File(url.toURI())).isDirectory()) {
            return FileUtils.findResources(f, Paths.get("", new String[0]), new LinkedList<ResourceEntry>());
        }
        String className = clazz.getName().replace('.', '/');
        className = className + ".class";
        URL classURL = clazz.getClassLoader().getResource(className);
        if (classURL == null) {
            int i = className.lastIndexOf(36);
            if (i > 0) {
                className = className.substring(0, i);
                className = className + ".class";
                classURL = clazz.getClassLoader().getResource(className);
            }
            if (classURL == null) {
                throw new RuntimeException("Expected to find class resource for specified class");
            }
        }
        if (!classURL.getProtocol().equals("jar")) {
            return new LinkedList<ResourceEntry>();
        }
        JarURLConnection jarCon = (JarURLConnection)classURL.openConnection();
        jarCon.setUseCaches(false);
        try (JarFile jar = jarCon.getJarFile();){
            Enumeration<JarEntry> entries = jar.entries();
            LinkedList<ResourceEntry> result = new LinkedList<ResourceEntry>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (name.endsWith("/") || !name.startsWith(prefix)) continue;
                ResourceEntry entry = new ResourceEntry();
                String entryUrl = jarCon.getJarFileURL() + "!/" + name;
                if (entryUrl.startsWith("file:")) {
                    entryUrl = "jar:" + entryUrl;
                }
                entry.url = new URL(entryUrl);
                entry.suffix = Paths.get(name.substring(prefix.length() + 1), new String[0]);
                result.add(entry);
            }
            LinkedList<ResourceEntry> linkedList = result;
            return linkedList;
        }
    }

    private static List<ResourceEntry> findResources(File f, Path suffix, List<ResourceEntry> result) throws MalformedURLException {
        File[] files = f.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileUtils.findResources(file, suffix.resolve(file.getName()), result);
                continue;
            }
            ResourceEntry entry = new ResourceEntry();
            entry.url = file.toURI().toURL();
            entry.suffix = suffix.resolve(file.getName());
            result.add(entry);
        }
        return result;
    }

    public static List<File> findFiles(Path rootPath, Set<String> fileNames, boolean isExactMatch) {
        return FileUtils.findFiles(rootPath, fileNames, new ArrayList<File>(), isExactMatch);
    }

    private static List<File> findFiles(Path rootPath, Set<String> fileNames, List<File> files, boolean isExactMatch) {
        DirectoryStream.Filter<Path> filter = file -> {
            if (file.toFile().isDirectory()) {
                return true;
            }
            if (fileNames.isEmpty()) {
                return true;
            }
            String thisFileName = file.getFileName().toString();
            if (fileNames.contains(thisFileName)) {
                return true;
            }
            if (isExactMatch) {
                return false;
            }
            for (String fileName : fileNames) {
                if (!thisFileName.contains(fileName)) continue;
                return true;
            }
            return false;
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(rootPath, filter);){
            for (Path file2 : stream) {
                File f = file2.toFile();
                if (f.isDirectory()) {
                    FileUtils.findFiles(f.toPath(), fileNames, files, isExactMatch);
                    continue;
                }
                files.add(f);
            }
        }
        catch (Throwable e) {
            Logger.getAnonymousLogger().warning(Utils.toString(e));
        }
        return files;
    }

    public static void deleteFiles(File directory) {
        FileUtils.moveOrDeleteFiles(directory, null);
    }

    public static void moveOrDeleteFiles(File directory, File newDirectory) {
        FileUtils.moveOrDeleteFiles(directory, newDirectory, true);
    }

    public static void moveOrDeleteFiles(File oldDirectory, File newDirectory, final boolean deleteOldDirectory) {
        final Path newDir = newDirectory != null ? newDirectory.toPath() : null;
        try {
            final Path oldPath = oldDirectory.toPath();
            Files.walkFileTree(oldPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (newDir == null) {
                        Files.deleteIfExists(file);
                    } else {
                        Files.move(file, newDir.resolve(file.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (deleteOldDirectory || !dir.equals(oldPath)) {
                        Files.deleteIfExists(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().warning(Utils.toString(e));
        }
    }

    public static void copyFiles(File oldDirectory, File newDirectory) {
        final Path newDir = newDirectory != null ? newDirectory.toPath() : null;
        try {
            Path oldPath = oldDirectory.toPath();
            Files.walkFileTree(oldPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (newDir != null) {
                        Files.copy(file, newDir.resolve(file.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().warning(Utils.toString(e));
        }
    }

    public static String getContentType(URI uri) {
        String uriPathLower = uri.getPath().toLowerCase();
        String mediaType = uriPathLower.endsWith("css") ? "text/css" : (uriPathLower.endsWith("json") ? "application/json" : (uriPathLower.endsWith("js") ? "application/javascript" : (uriPathLower.endsWith("html") || uriPathLower.endsWith("htm") ? "text/html" : (uriPathLower.endsWith("txt") ? "text/plain" : (uriPathLower.endsWith("svg") ? "image/svg+xml" : (uriPathLower.endsWith("woff2") ? "application/font-woff2" : "application/octet-stream"))))));
        return mediaType;
    }

    public static void readFileAndComplete(final Operation op, final File f) throws IOException {
        final AsynchronousFileChannel ch = AsynchronousFileChannel.open(f.toPath(), StandardOpenOption.READ);
        final ByteBuffer bb = ByteBuffer.allocate((int)f.length());
        ch.read(bb, 0L, null, new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer arg0, Void v) {
                try {
                    String body;
                    bb.flip();
                    this.close(bb, ch);
                    String contentType = FileUtils.getContentType(f.toURI());
                    if (contentType != null) {
                        op.setContentType(contentType);
                    }
                    if ((body = Utils.decodeIfText(bb, contentType)) != null) {
                        op.setBody(body);
                    } else {
                        op.setBody(bb.array());
                        op.setContentLength(bb.limit());
                    }
                    op.complete();
                }
                catch (Throwable e) {
                    this.failed(e, v);
                }
            }

            @Override
            public void failed(Throwable arg0, Void v) {
                this.close(null, ch);
                op.fail(arg0);
            }

            private void close(ByteBuffer buffer, AsynchronousFileChannel channel) {
                try {
                    channel.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static void getFile(ServiceClient h, Operation get, File f) throws IOException {
        AsynchronousFileChannel ch = AsynchronousFileChannel.open(f.toPath(), StandardOpenOption.WRITE);
        ch.force(true);
        AtomicInteger bytesWritten = new AtomicInteger(0);
        Operation.CompletionHandler getCompletion = (o, e) -> {
            if (e != null) {
                get.fail(e);
                return;
            }
            try {
                Logger.getAnonymousLogger().log(Level.INFO, String.format("starting download of %s to %s", get.getUri().toString(), f.toString()));
                FileUtils.writeBody(get, o, ch, bytesWritten);
            }
            catch (Throwable ex) {
                get.fail(ex);
            }
            String contentRangeHeader = o.getResponseHeader("content-range");
            if (contentRangeHeader == null) {
                return;
            }
            ContentRange nextRange = new ContentRange(contentRangeHeader);
            FileUtils.getChunks(h, nextRange, get, ch, bytesWritten);
        };
        h.send(Operation.createGet(get.getUri()).setReferer(get.getReferer()).addHeader(new ContentRange().toRangeHeader(), false).setExpiration(get.getExpirationMicrosUtc()).setCompletion(getCompletion));
    }

    private static void getChunks(ServiceClient h, ContentRange nextRange, Operation parentGet, AsynchronousFileChannel ch, AtomicInteger bytesWritten) {
        ContentRange[] range = new ContentRange[]{nextRange};
        for (int chunksInFlight = 0; chunksInFlight < 10 && !range[0].isDone(); ++chunksInFlight) {
            range[0] = range[0].nextChunk();
            boolean getNextSet = chunksInFlight == 9;
            Operation nextGet = Operation.createGet(parentGet.getUri()).setReferer(parentGet.getReferer()).addHeader(range[0].toRangeHeader(), false).setExpiration(parentGet.getExpirationMicrosUtc()).setCompletion((ox, ex) -> {
                if (ex != null) {
                    parentGet.fail(ex);
                    return;
                }
                try {
                    FileUtils.writeBody(parentGet, ox, ch, bytesWritten);
                    if (!range[0].isDone() && getNextSet) {
                        FileUtils.getChunks(h, range[0], parentGet, ch, bytesWritten);
                    }
                }
                catch (Throwable exx) {
                    parentGet.fail(exx);
                }
            });
            h.send(nextGet);
        }
    }

    private static void writeBody(final Operation parentOp, Operation o, final AsynchronousFileChannel ch, AtomicInteger bytesWritten) throws Throwable {
        byte[] b = (byte[])o.getBodyRaw();
        if (b == null || b.length == 0) {
            parentOp.fail(new IllegalStateException("no data"));
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(b);
        String contentRangeHeader = o.getResponseHeader("content-range");
        final ContentRange range = new ContentRange(contentRangeHeader);
        ch.write(buf, range.start, bytesWritten, new CompletionHandler<Integer, AtomicInteger>(){

            @Override
            public void completed(Integer result, AtomicInteger bytesWritten) {
                int total = bytesWritten.addAndGet(result);
                if ((long)total >= range.fileSize) {
                    try {
                        ch.close();
                        Logger.getAnonymousLogger().log(Level.INFO, String.format("done download of %s (bytes %s)", parentOp.getUri().toString(), total));
                        parentOp.complete();
                    }
                    catch (Exception e) {
                        parentOp.fail(e);
                    }
                }
            }

            @Override
            public void failed(Throwable exc, AtomicInteger bytesWritten) {
                parentOp.fail(exc);
            }
        });
    }

    public static void putFile(ServiceClient h, Operation put, File f) throws IOException {
        AsynchronousFileChannel ch = AsynchronousFileChannel.open(f.toPath(), StandardOpenOption.READ);
        AtomicInteger completionCount = new AtomicInteger(0);
        String contentType = FileUtils.getContentType(f.toURI());
        boolean[] fileIsDone = new boolean[]{false};
        FileUtils.putChunks(h, put, ch, contentType, f.length(), 0, completionCount, fileIsDone);
    }

    private static void putChunks(final ServiceClient h, final Operation put, final AsynchronousFileChannel ch, final String contentType, final long fileLength, int off, final AtomicInteger completionCount, final boolean[] fileIsDone) {
        ContentRange range = new ContentRange(off, off + 524288, (int)fileLength);
        int chunksInFlight = 0;
        while (chunksInFlight < 10) {
            completionCount.incrementAndGet();
            final ByteBuffer bb = ByteBuffer.allocate((int)(range.end - range.start));
            fileIsDone[0] = range.isDone();
            final boolean startNextChunk = chunksInFlight == 9;
            final ContentRange rangeToStartNextChunk = range.nextChunk();
            ch.read(bb, range.start, range, new CompletionHandler<Integer, ContentRange>(){

                @Override
                public void completed(Integer arg0, ContentRange r) {
                    try {
                        bb.flip();
                        byte[] buf = bb.array();
                        Operation rangePut = Operation.createPut(put.getUri()).setBodyNoCloning(buf).setContentLength(bb.limit()).setRetryCount(0).setReferer(put.getReferer()).setExpiration(put.getExpirationMicrosUtc()).setCompletion((o, e) -> {
                            if (e != null) {
                                put.fail(e);
                                return;
                            }
                            if (completionCount.decrementAndGet() == 0 && fileIsDone[0]) {
                                this.close(ch);
                                put.complete();
                                return;
                            }
                            if (startNextChunk) {
                                FileUtils.putChunks(h, put, ch, contentType, fileLength, (int)rangeToStartNextChunk2.start, completionCount, fileIsDone);
                            }
                        });
                        rangePut.addHeader(r.toContentRangeHeader(), false);
                        if (contentType != null) {
                            rangePut.setContentType(contentType);
                        }
                        h.send(rangePut);
                    }
                    catch (Throwable e2) {
                        this.failed(e2, r);
                    }
                }

                @Override
                public void failed(Throwable arg0, ContentRange r) {
                    this.close(ch);
                    put.fail(arg0);
                }

                private void close(AsynchronousFileChannel channel) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        Logger.getAnonymousLogger().log(Level.WARNING, String.format("PUT of file failed %s", e.toString()));
                    }
                }
            });
            if (range.isDone()) {
                return;
            }
            ++chunksInFlight;
            range = range.nextChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URI zipFiles(List<URI> inFiles, String outFileName) throws Exception {
        byte[] buffer = new byte[4096];
        File zipFile = File.createTempFile(outFileName, ".zip", null);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        try {
            for (URI file : inFiles) {
                int bytes_read;
                File f = new File(file);
                if (f.isDirectory()) {
                    throw new IllegalArgumentException("can't compress a directory:  " + f);
                }
                FileInputStream in = new FileInputStream(f);
                ZipEntry entry = new ZipEntry(f.getName());
                out.putNextEntry(entry);
                while ((bytes_read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        Logger.getAnonymousLogger().info(String.format("backup written to %s (bytes:%s md5sum:%s)", zipFile, zipFile.length(), FileUtils.md5sum(zipFile)));
        return zipFile.toURI();
    }

    public static void extractZipArchive(File zipFile, final Path destDir) throws IOException, IllegalArgumentException {
        if (!destDir.toFile().exists() || !destDir.toFile().isDirectory()) {
            throw new IllegalArgumentException("can only unzip to directory");
        }
        if (!zipFile.exists()) {
            throw new IllegalArgumentException("zip file not found");
        }
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipFile.toPath(), null);){
            Path root = zipFileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = Paths.get(destDir.toString(), file.toString());
                    Logger.getAnonymousLogger().info("Extracting file " + destFile);
                    Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                    if (Files.notExists(dirToCreate, new LinkOption[0])) {
                        Logger.getAnonymousLogger().info("Creating directory %s" + dirToCreate);
                        Files.createDirectory(dirToCreate, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static String md5sum(File f) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bytes = new byte[8192];
        try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            int numBytes;
            while ((numBytes = is.read(bytes)) != -1) {
                md.update(bytes, 0, numBytes);
            }
        }
        BigInteger bigInt = new BigInteger(1, md.digest());
        return bigInt.toString(16);
    }

    public static Properties readPropertiesFromResource(Class<? extends ServiceHost> typeAssociatedWithResource, String resourceName) throws IOException {
        URL url = typeAssociatedWithResource.getClassLoader().getResource(resourceName);
        if (url == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (Throwable e) {
            String message = String.format("Unable to load properties from %s", url.toString());
            throw new IOException(message, e);
        }
        return properties;
    }

    public static List<URI> filesToUris(String parentDir, Collection<String> files) {
        ArrayList<URI> fileUris = new ArrayList<URI>();
        for (String f : files) {
            fileUris.add(new File(parentDir, f).toURI());
        }
        return fileUris;
    }

    public static class ResourceEntry {
        public URL url;
        public Path suffix;
    }

    public static class ContentRange {
        long start;
        long end;
        long fileSize;
        public static final int CHUNK_SIZE = 524288;
        public static final int MAX_IN_FLIGHT_CHUNKS = 10;
        private static final String CONTENT_RANGE_PATTERN = " (\\d*)[-](\\d*)[/](\\d*)";
        private static final Pattern contentRangePattern = Pattern.compile(" (\\d*)[-](\\d*)[/](\\d*)");
        private static final String RANGE_PATTERN = "=(\\d*)[-](\\d*)";
        private static final Pattern rangePattern = Pattern.compile("=(\\d*)[-](\\d*)");

        ContentRange() {
            this.start = 0L;
            this.end = 524288L;
            this.fileSize = 0L;
        }

        ContentRange(String headerString) {
            if (headerString == null || headerString.isEmpty()) {
                return;
            }
            Matcher m = contentRangePattern.matcher(headerString);
            if (!m.find() || m.groupCount() != 3) {
                throw new IllegalArgumentException("no content-range field found");
            }
            this.start = Long.parseLong(m.group(1));
            this.end = Long.parseLong(m.group(2));
            this.fileSize = Long.parseLong(m.group(3));
        }

        ContentRange(int start, int end, int fileSize) {
            this.start = start;
            this.end = Integer.min(end, fileSize);
            this.fileSize = fileSize;
        }

        ContentRange(int fileSize) {
            this.start = 0L;
            this.end = Integer.min(fileSize, 524288);
            this.fileSize = fileSize;
        }

        public static ContentRange fromRangeHeader(String headerString, long fileSize) {
            if (headerString == null || headerString.isEmpty()) {
                throw new IllegalArgumentException("no header set");
            }
            Matcher m = rangePattern.matcher(headerString);
            if (!m.find() || m.groupCount() != 2) {
                throw new IllegalArgumentException("no range field found");
            }
            ContentRange r = new ContentRange();
            r.fileSize = fileSize;
            r.start = Integer.parseInt(m.group(1));
            r.end = Long.min(Integer.parseInt(m.group(2)), fileSize);
            Logger.getAnonymousLogger().log(Level.INFO, String.format("header=%s start=%d end=%d size=%d", headerString, r.start, r.end, r.fileSize));
            return r;
        }

        public ContentRange nextChunk() {
            return new ContentRange((int)this.end, (int)this.end + 524288, (int)this.fileSize);
        }

        public boolean isDone() {
            return this.end >= this.fileSize;
        }

        public String toContentRangeHeader() {
            return String.format("%s: bytes %d-%d/%d", "content-range", this.start, this.end, this.fileSize);
        }

        public String toRangeHeader() {
            return String.format("%s: bytes=%d-%d", "range", this.start, this.end);
        }
    }
}

