/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.services.common.TenantService;
import java.util.UUID;

public class TenantFactoryService
extends FactoryService {
    public static final String SELF_LINK = "/core/tenants";

    public TenantFactoryService() {
        super(TenantService.TenantState.class);
        super.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
    }

    @Override
    public void handlePost(Operation post) {
        if (!post.hasBody()) {
            post.fail(new IllegalArgumentException("body is required"));
            return;
        }
        TenantService.TenantState tenantState = post.getBody(TenantService.TenantState.class);
        if (tenantState.id == null || tenantState.id.isEmpty()) {
            tenantState.id = UUID.randomUUID().toString();
        }
        tenantState.documentSelfLink = tenantState.id;
        post.setBody(tenantState).complete();
    }

    @Override
    public Service createServiceInstance() throws Throwable {
        return new TenantService();
    }
}

