/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.AlreadyClosedException;

public class LuceneQueryPageService
extends StatelessService {
    public static final String KIND = Utils.buildKind(QueryTask.class);
    private QueryTask.QuerySpecification spec;
    private String documentSelfLink;
    private String indexLink;

    public LuceneQueryPageService(QueryTask.QuerySpecification spec, String indexLink) {
        super(QueryTask.class);
        this.spec = spec;
        this.indexLink = indexLink;
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleStart(Operation post) {
        ServiceDocument initState = post.getBody(ServiceDocument.class);
        this.documentSelfLink = initState.documentSelfLink;
        long interval = initState.documentExpirationTimeMicros - Utils.getNowMicrosUtc();
        if (interval < 0L) {
            this.logWarning("Task expiration is in the past, extending it", new Object[0]);
            interval = TimeUnit.SECONDS.toMicros(this.getHost().getMaintenanceIntervalMicros() * 2L);
        }
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        super.setMaintenanceIntervalMicros(interval);
        post.complete();
    }

    @Override
    public void handleGet(Operation get) {
        QueryTask task = QueryTask.create(this.spec);
        task.documentKind = KIND;
        task.documentSelfLink = this.documentSelfLink;
        task.documentExpirationTimeMicros = this.getMaintenanceIntervalMicros() + Utils.getNowMicrosUtc();
        task.taskInfo.stage = TaskState.TaskStage.CREATED;
        task.taskInfo.isDirect = true;
        task.indexLink = this.indexLink;
        this.forwardToLucene(task, get);
    }

    @Override
    public void handleMaintenance(Operation op) {
        op.complete();
        this.getHost().stopService(this);
    }

    private void forwardToLucene(QueryTask task, Operation get) {
        try {
            Operation localPatch = Operation.createPatch(UriUtils.buildUri(this.getHost(), task.indexLink)).setBodyNoCloning(task).setCompletion((o, e) -> {
                if (e == null) {
                    task.results = (ServiceDocumentQueryResult)o.getBodyRaw();
                }
                this.handleQueryCompletion(task, e, get);
            });
            this.sendRequest(localPatch);
        }
        catch (Throwable e2) {
            this.handleQueryCompletion(task, e2, get);
        }
    }

    private void handleQueryCompletion(QueryTask task, Throwable e, Operation get) {
        if (e != null) {
            LuceneQueryPage ctx = (LuceneQueryPage)task.querySpec.context.nativePage;
            if (ctx.isFirstPage() && e instanceof AlreadyClosedException && !this.getHost().isStopping()) {
                this.logWarning("Retrying query because index context is out of date", new Object[0]);
                task.querySpec.context.nativeSearcher = null;
                this.forwardToLucene(task, get);
                return;
            }
            QueryTask t = new QueryTask();
            t.taskInfo.stage = TaskState.TaskStage.FAILED;
            t.taskInfo.failure = Utils.toServiceErrorResponse(e);
            get.setBody(t).fail(e);
            return;
        }
        task.taskInfo.stage = TaskState.TaskStage.FINISHED;
        get.setBodyNoCloning(task).complete();
    }

    public static class LuceneQueryPage {
        public String previousPageLink;
        public ScoreDoc after;

        public LuceneQueryPage(String link, ScoreDoc after) {
            this.previousPageLink = link;
            this.after = after;
        }

        public boolean isFirstPage() {
            return this.previousPageLink == null;
        }
    }
}

