/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class AuthCredentialsService
extends StatefulService {
    public AuthCredentialsService() {
        super(AuthCredentialsServiceState.class);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handlePatch(Operation patch) {
        AuthCredentialsServiceState currentState = (AuthCredentialsServiceState)this.getState(patch);
        AuthCredentialsServiceState patchBody = patch.getBody(AuthCredentialsServiceState.class);
        this.updateState(patchBody, currentState);
        patch.setBody(currentState).complete();
    }

    private void updateState(AuthCredentialsServiceState newState, AuthCredentialsServiceState currentState) {
        if (newState.userLink != null) {
            currentState.userLink = newState.userLink;
        }
        if (newState.userEmail != null) {
            currentState.userEmail = newState.userEmail;
        }
        if (newState.privateKey != null) {
            currentState.privateKey = newState.privateKey;
        }
        if (newState.publicKey != null) {
            currentState.publicKey = newState.publicKey;
        }
        if (newState.privateKeyId != null) {
            currentState.privateKeyId = newState.privateKeyId;
        }
        if (newState.tokenReference != null) {
            currentState.tokenReference = newState.tokenReference;
        }
        if (newState.type != null) {
            currentState.type = newState.type;
        }
        if (newState.customProperties != null && !newState.customProperties.isEmpty()) {
            if (currentState.customProperties == null || currentState.customProperties.isEmpty()) {
                currentState.customProperties = newState.customProperties;
            } else {
                for (Map.Entry<String, String> e : newState.customProperties.entrySet()) {
                    currentState.customProperties.put(e.getKey(), e.getValue());
                }
            }
        }
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        ServiceDocument td = super.getDocumentTemplate();
        ServiceDocumentDescription.PropertyDescription pdCustomProperties = td.documentDescription.propertyDescriptions.get("customProperties");
        pdCustomProperties.indexingOptions = EnumSet.of(ServiceDocumentDescription.PropertyIndexingOption.EXPAND);
        ServiceDocumentDescription.expandTenantLinks(td.documentDescription);
        AuthCredentialsServiceState template = (AuthCredentialsServiceState)td;
        return template;
    }

    public static class AuthCredentialsServiceState
    extends ServiceDocument {
        public static final String FIELD_NAME_EMAIL = "userEmail";
        public static final String FIELD_NAME_PRIVATE_KEY = "privateKey";
        public static final String FIELD_NAME_CUSTOM_PROPERTIES = "customProperties";
        public String userLink;
        public String userEmail;
        public String privateKey;
        public String privateKeyId;
        public String publicKey;
        public URI tokenReference;
        public String type;
        public List<String> tenantLinks;
        public Map<String, String> customProperties;
    }
}

