/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.EventExecutor;

public class SimpleChannelPromiseAggregator
extends DefaultChannelPromise {
    private final ChannelPromise promise;
    private int expectedCount;
    private int successfulCount;
    private int failureCount;
    private boolean doneAllocating;

    SimpleChannelPromiseAggregator(ChannelPromise promise, Channel c, EventExecutor e) {
        super(c, e);
        assert (promise != null);
        this.promise = promise;
    }

    public ChannelPromise newPromise() {
        if (this.doneAllocating) {
            throw new IllegalStateException("Done allocating. No more promises can be allocated.");
        }
        ++this.expectedCount;
        return this;
    }

    public ChannelPromise doneAllocatingPromises() {
        if (!this.doneAllocating) {
            this.doneAllocating = true;
            if (this.successfulCount == this.expectedCount) {
                this.promise.setSuccess();
                return super.setSuccess(null);
            }
        }
        return this;
    }

    public boolean tryFailure(Throwable cause) {
        if (this.allowFailure()) {
            ++this.failureCount;
            if (this.failureCount == 1) {
                this.promise.tryFailure(cause);
                return super.tryFailure(cause);
            }
            return true;
        }
        return false;
    }

    public ChannelPromise setFailure(Throwable cause) {
        if (this.allowFailure()) {
            ++this.failureCount;
            if (this.failureCount == 1) {
                this.promise.setFailure(cause);
                return super.setFailure(cause);
            }
        }
        return this;
    }

    private boolean allowFailure() {
        return this.awaitingPromises() || this.expectedCount == 0;
    }

    private boolean awaitingPromises() {
        return this.successfulCount + this.failureCount < this.expectedCount;
    }

    public ChannelPromise setSuccess(Void result) {
        if (this.awaitingPromises()) {
            ++this.successfulCount;
            if (this.successfulCount == this.expectedCount && this.doneAllocating) {
                this.promise.setSuccess(result);
                return super.setSuccess(result);
            }
        }
        return this;
    }

    public boolean trySuccess(Void result) {
        if (this.awaitingPromises()) {
            ++this.successfulCount;
            if (this.successfulCount == this.expectedCount && this.doneAllocating) {
                this.promise.trySuccess((Object)result);
                return super.trySuccess((Object)result);
            }
            return true;
        }
        return false;
    }
}

